/*
 * Decompiled with CFR 0.152.
 */
package com.sri.panther.pathway.converter;

import com.sri.panther.pathway.util.Utils;
import java.io.File;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesProperty;
import jp.sbi.celldesigner.sbmlExtension.CompartmentAnnotation;
import jp.sbi.celldesigner.sbmlExtension.ReactionAnnotation;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.sbml.Notes;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.apache.log4j.Logger;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.ListOfCompartments;
import org.sbml.libsbml.ListOfReactions;
import org.sbml.libsbml.ListOfSpecies;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellDesignerInfo {
    protected static final String MSG_INVALID_SPECIES_TYPE_1 = "Encountered invalid species type ";
    protected static final String MSG_INVALID_SPECIES_TYPE_2 = " for species id ";
    protected static final String MSG_INVALID_SPECIES_TYPE_3 = " in file ";
    protected static final String CLASS_PROPERTY_NAME_MONO_SPECIES = "jp.sbi.celldesigner.MonoSpeciesProperty";
    protected static final String CLASS_PROPRETY_NAME_COMPLEX_SPECIES = "jp.sbi.celldesigner.ComplexProperty";
    protected MainWindow mw = MainWindow.getLastInstance();
    protected SBModelFrame currentSBModelFrame;
    protected SBModel currentSBModel;
    protected Model currentModel;
    protected String currentModelName;
    protected String currentModelNotes;
    protected ListOfSpecies currentListOfSpecies;
    protected ListOfCompartments currentListOfCompartments;
    protected ListOfReactions currentListOfReactions;
    protected Hashtable<String, Vector<Species>> monoSpeciesTbl = new Hashtable();
    protected Hashtable<String, Vector<Vector<String>>> monoSpecUniqueStructTbl = new Hashtable();
    protected Hashtable<String, Vector<Vector<String>>> complexSpecUniqueStructTbl = new Hashtable();
    protected Hashtable<String, SpeciesAlias> specIdAliasTbl;
    protected Hashtable<String, String> compartmentTbl;
    protected Hashtable<String, Vector<String>> compartmentAliasTbl;
    protected Hashtable<String, String> reactionsIdTypeTbl = new Hashtable();
    protected Hashtable<String, Boolean> reactionsIdReversibleTbl = new Hashtable();
    protected Hashtable<String, Vector<Vector>> reactionsIdInfo = new Hashtable();
    public static final int REACTION_INDEX_REACTANTS = 0;
    public static final int REACTION_INDEX_PRODUCTS = 1;
    public static final int REACTION_INDEX_MODIFIERS = 2;
    public static final int INDEX_MODIFIER_REACTION_LINK_ID = 0;
    public static final int INDEX_MODIFIER_TYPE = 1;
    public static final int INDEX_MODIFIER_LIST = 2;
    protected File currentFile;
    private static Logger logger = Logger.getLogger((String)CellDesignerInfo.class.getName());
    protected boolean fileProcessed = false;

    public CellDesignerInfo(File currentFile) {
        this.currentFile = currentFile;
        this.generateInfo();
    }

    protected void generateInfo() {
        if (null == this.mw) {
            return;
        }
        this.currentSBModelFrame = this.mw.getCurrentModel();
        if (null == this.currentSBModelFrame) {
            logger.info((Object)("Error - opening file " + this.currentFile.getName()));
            return;
        }
        this.currentSBModel = this.currentSBModelFrame.getSBModel();
        this.currentModel = this.currentSBModel.getModel();
        this.currentListOfSpecies = this.currentModel.getListOfSpecies();
        this.currentListOfCompartments = this.currentModel.getListOfCompartments();
        this.currentListOfReactions = this.currentModel.getListOfReactions();
        this.initModelInfo();
        this.initCompartmentInfo();
        this.initSpeciesInfo();
        this.initReactionsInfo();
        this.fileProcessed = true;
    }

    protected void initModelInfo() {
        this.currentModelName = this.currentSBModel.getModelName();
        this.currentModelNotes = ((Notes)LibSBMLUtil.getNotes((SBase)this.currentModel, null)).getText();
    }

    protected void initCompartmentInfo() {
        long numCompartments = this.currentListOfCompartments.size();
        this.compartmentTbl = new Hashtable((int)numCompartments);
        this.compartmentAliasTbl = new Hashtable((int)numCompartments);
        int i = 0;
        while ((long)i < numCompartments) {
            Compartment compartment = this.currentListOfCompartments.get((long)i);
            String id = compartment.getId();
            this.compartmentTbl.put(id, compartment.getName());
            CompartmentAnnotation compartmentAnnot = (CompartmentAnnotation)LibSBMLUtil.getAnnotation((SBModel)this.currentSBModel, (SBase)compartment, null);
            Vector aliases = compartmentAnnot.getReferingAliases();
            int numAliases = aliases.size();
            Vector<String> aliasList = new Vector<String>(numAliases);
            for (int j = 0; j < numAliases; ++j) {
                CompartmentAlias compartmentAlias = (CompartmentAlias)aliases.get(j);
                aliasList.add(compartmentAlias.getCompartmentName());
            }
            this.compartmentAliasTbl.put(id, aliasList);
            ++i;
        }
    }

    protected void initSpeciesInfo() {
        this.specIdAliasTbl = new Hashtable();
        long numSpecies = this.currentListOfSpecies.size();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while ((long)i < numSpecies) {
            sb.setLength(0);
            Species species = this.currentListOfSpecies.get((long)i);
            SpeciesAnnotation speciesAnnotation = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBModel)this.currentSBModel, (SBase)species, null);
            SpeciesProperty speciesProperty = speciesAnnotation.getSpeciesProperty();
            String name = species.getName();
            String speciesClass = speciesProperty.getClass().getName();
            if (speciesClass.equals(CLASS_PROPERTY_NAME_MONO_SPECIES)) {
                MonoSpeciesProperty monoSpeciesProperty = (MonoSpeciesProperty)speciesProperty;
                String type = monoSpeciesProperty.getType();
                sb.append(type);
                sb.append(name);
                String key = sb.toString();
                Vector<Object> speciesList = this.monoSpeciesTbl.get(key);
                if (null == speciesList) {
                    speciesList = new Vector(1);
                    this.monoSpeciesTbl.put(key, speciesList);
                }
                speciesList.add(species);
                this.updateSpeciesStructureTable(key, this.monoSpecUniqueStructTbl, speciesAnnotation);
            } else if (speciesClass.equals(CLASS_PROPRETY_NAME_COMPLEX_SPECIES)) {
                this.updateSpeciesStructureTable(name, this.complexSpecUniqueStructTbl, speciesAnnotation);
            } else {
                logger.info((Object)(MSG_INVALID_SPECIES_TYPE_1 + speciesProperty.getClass().getName() + MSG_INVALID_SPECIES_TYPE_2 + species.getId() + MSG_INVALID_SPECIES_TYPE_3 + this.currentFile.getAbsolutePath()));
                System.exit(-1);
            }
            ++i;
        }
    }

    protected void updateSpeciesStructureTable(String key, Hashtable<String, Vector<Vector<String>>> uniqueStructTbl, SpeciesAnnotation speciesAnnotation) {
        Vector<Vector<String>> groupedSpecies = uniqueStructTbl.get(key);
        if (null == groupedSpecies) {
            groupedSpecies = new Vector();
            uniqueStructTbl.put(key, groupedSpecies);
        }
        Vector aliases = speciesAnnotation.getReferingAliases();
        for (int i = 0; i < aliases.size(); ++i) {
            SpeciesAlias sAlias = (SpeciesAlias)aliases.elementAt(i);
            boolean matchingAliasFound = false;
            String currentSpeciesIdAliasName = Utils.getSpeciesIdAliasName(sAlias);
            for (int j = 0; j < groupedSpecies.size(); ++j) {
                Vector<String> relatedSpeciesList = groupedSpecies.get(j);
                String speciesIdAliasName = relatedSpeciesList.elementAt(0);
                SpeciesAlias compSpeciesAlias = Utils.getSpeciesAlias(this.currentSBModel, this.currentListOfSpecies, speciesIdAliasName);
                if (!Utils.compareAlias(this.currentSBModel, sAlias, compSpeciesAlias, true)) continue;
                relatedSpeciesList.add(currentSpeciesIdAliasName);
                matchingAliasFound = true;
                break;
            }
            if (matchingAliasFound) continue;
            Vector<String> v1 = new Vector<String>(1);
            v1.add(currentSpeciesIdAliasName);
            groupedSpecies.add(v1);
        }
    }

    protected void initReactionsInfo() {
        int i = 0;
        while ((long)i < this.currentListOfReactions.size()) {
            Reaction reaction = this.currentListOfReactions.get((long)i);
            String id = reaction.getId();
            this.reactionsIdReversibleTbl.put(id, new Boolean(reaction.getReversible()));
            ReactionAnnotation reactionAnnotation = (ReactionAnnotation)LibSBMLUtil.getAnnotation((SBModel)this.currentSBModel, (SBase)reaction, null);
            this.reactionsIdTypeTbl.put(id, reactionAnnotation.getType());
            List modifications = reactionAnnotation.getModificationLinks();
            Vector<Vector<Object>> reactionInfo = new Vector<Vector<Object>>(3);
            reactionInfo.setSize(3);
            reactionInfo.add(0, this.getReactantList(reactionAnnotation));
            reactionInfo.add(1, this.getProductList(reactionAnnotation));
            reactionInfo.add(2, this.getModifierList(modifications));
            this.reactionsIdInfo.put(id, reactionInfo);
            ++i;
        }
    }

    protected Vector<String> getReactantList(ReactionAnnotation ra) {
        Vector<String> returnList = new Vector<String>();
        ReactionLink bl = ra.getBaseLink();
        Vector reactants = bl.getSources();
        for (int i = 0; i < reactants.size(); ++i) {
            Object o = reactants.get(i);
            if (!(o instanceof SpeciesAlias)) continue;
            returnList.add(Utils.getSpeciesIdAliasName((SpeciesAlias)o));
        }
        List l = ra.getAddReactantLinks();
        for (int i = 0; i < l.size(); ++i) {
            ReactionLink rl = (ReactionLink)l.get(i);
            Vector rSources = rl.getSources();
            for (int j = 0; j < rSources.size(); ++j) {
                Object o = rSources.get(j);
                if (!(o instanceof SpeciesAlias)) continue;
                returnList.add(Utils.getSpeciesIdAliasName((SpeciesAlias)o));
            }
            Vector destinations = rl.getDistinations();
            for (int j = 0; j < destinations.size(); ++j) {
                Object o = destinations.get(j);
                if (!(o instanceof SpeciesAlias)) continue;
                returnList.add(Utils.getSpeciesIdAliasName((SpeciesAlias)o));
            }
        }
        return returnList;
    }

    protected Vector<String> getProductList(ReactionAnnotation ra) {
        Vector<String> returnList = new Vector<String>();
        ReactionLink bl = ra.getBaseLink();
        Vector products = bl.getDistinations();
        for (int i = 0; i < products.size(); ++i) {
            Object o = products.get(i);
            if (!(o instanceof SpeciesAlias)) continue;
            returnList.add(Utils.getSpeciesIdAliasName((SpeciesAlias)o));
        }
        List l = ra.getAddProductLinks();
        for (int i = 0; i < l.size(); ++i) {
            ReactionLink rl = (ReactionLink)l.get(i);
            Vector rSources = rl.getSources();
            for (int j = 0; j < rSources.size(); ++j) {
                Object o = rSources.get(j);
                if (!(o instanceof SpeciesAlias)) continue;
                returnList.add(Utils.getSpeciesIdAliasName((SpeciesAlias)o));
            }
            Vector destinations = rl.getDistinations();
            for (int j = 0; j < destinations.size(); ++j) {
                Object o = destinations.get(j);
                if (!(o instanceof SpeciesAlias)) continue;
                returnList.add(Utils.getSpeciesIdAliasName((SpeciesAlias)o));
            }
        }
        return returnList;
    }

    protected Vector<Vector> getModifierList(List modifiers) {
        int num = modifiers.size();
        Vector<Vector> ids = new Vector<Vector>(num);
        for (int i = 0; i < num; ++i) {
            ReactionLink reactionLink = (ReactionLink)modifiers.get(i);
            Vector<Object> info = new Vector<Object>(3);
            info.setSize(3);
            ids.add(info);
            info.add(0, reactionLink.getName());
            info.add(1, reactionLink.getSymbol().getCode());
            Vector sources = reactionLink.getSources();
            int numSources = sources.size();
            Vector<String> modList = new Vector<String>(numSources);
            info.add(2, modList);
            for (int j = 0; j < numSources; ++j) {
                Object o = sources.get(j);
                if (!(o instanceof SpeciesAlias)) continue;
                SpeciesAlias speciesAlias = (SpeciesAlias)o;
                modList.add(Utils.getSpeciesIdAliasName(speciesAlias));
            }
            Vector destinations = reactionLink.getDistinations();
            for (int j = 0; j < destinations.size(); ++j) {
                Object o = destinations.get(j);
                if (!(o instanceof SpeciesAlias)) continue;
                SpeciesAlias speciesAlias = (SpeciesAlias)o;
                modList.add(Utils.getSpeciesIdAliasName(speciesAlias));
            }
        }
        return ids;
    }

    public Hashtable<String, Vector<Vector<String>>> getMonoSpeciesInfo() {
        return this.monoSpecUniqueStructTbl;
    }

    public Hashtable<String, Vector<Vector<String>>> getComplexSpeciesInfo() {
        return this.complexSpecUniqueStructTbl;
    }

    public SBModel getSBModel() {
        return this.currentSBModel;
    }

    public String getModelName() {
        return this.currentModelName;
    }

    public String getModelNotes() {
        return this.currentModelNotes;
    }

    public ListOfSpecies getSpeciesList() {
        return this.currentListOfSpecies;
    }

    public ListOfCompartments getCompartmentList() {
        return this.currentListOfCompartments;
    }

    public ListOfReactions getReactionsList() {
        return this.currentListOfReactions;
    }

    public Hashtable<String, String> getCompartmentIdToName() {
        return this.compartmentTbl;
    }

    public Hashtable<String, Vector<String>> getcompartmentIdToAliases() {
        return this.compartmentAliasTbl;
    }

    public Hashtable<String, String> getReactionsIdTypeTbl() {
        return this.reactionsIdTypeTbl;
    }

    public Hashtable<String, Boolean> getReactionsIdReversibleTbl() {
        return this.reactionsIdReversibleTbl;
    }

    public Hashtable<String, Vector<Vector>> getReactionsInfoTbl() {
        return this.reactionsIdInfo;
    }
}

