/*
 * Decompiled with CFR 0.152.
 */
package com.sri.panther.pathway.converter;

import com.sri.panther.pathway.converter.BioPax3Info;
import com.sri.panther.pathway.converter.CellDesignerInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import jp.fric.graphics.multiwindow.MultiWindowFrame;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MyFileManager;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SBMLFiler;
import org.apache.log4j.Logger;
import org.biopax.paxtools.io.simpleIO.SimpleExporter;
import org.biopax.paxtools.model.Model;

public class CDToBioPax3
implements FileFilter {
    public static final String DIRECTORY_SELECTION_FOR_READING = "Select directory with files to be converted";
    public static final String DIRECTORY_SELECTION_FOR_WRITING = "Select directory with converted files to be written";
    public static final String FILE_EXT_ACCEPT = ".xml";
    public static final String FILE_EXT_OWL = ".owl";
    public static final String FILE_EXT_TXT = ".txt";
    protected static final String MSG_LOADING = "Loading...";
    protected static File openDirectory = new File(Preference.openingPath);
    protected static File saveDirectory = new File(Preference.savingPath);
    protected File[] fileList;
    protected File currentFile;
    protected MainWindow mw = MainWindow.getLastInstance();
    protected MyFileManager fileManager;
    protected SBMLFiler filer;
    CellDesignerInfo cdInfo;
    BioPax3Info bioPax3Info;
    private static Logger logger = Logger.getLogger((String)CDToBioPax3.class.getName());

    public CDToBioPax3() {
        MainWindow.setIgnorAllCheckAndMessageNoticeFlg((boolean)true);
        SBFactory factory = new SBFactory();
        this.filer = new SBMLFiler(factory);
        this.filer.setOwnerFrame(this.mw.getMyFrame());
        if (!this.initDirInfo()) {
            return;
        }
        this.fileManager = this.mw.getMyFileManager();
        this.mw.getFiler().setIgnoreWarning(true);
        for (int i = 0; i < this.fileList.length; ++i) {
            this.currentFile = this.fileList[i];
            logger.info((Object)("Processing file " + this.currentFile.getName()));
            MainWindow.startProgressBarTask((String)MSG_LOADING);
            this.fileManager.getOpenCommand(this.currentFile);
            CDToBioPax3 cDToBioPax3 = this;
            cDToBioPax3.mw.stopProgressBarTask();
            this.generateInfoFromCellDesigner();
            if (this.cdInfo.fileProcessed) {
                this.transferInfoToBioPax();
                this.outputInfo();
            }
            this.mw.closeModelByTab((MultiWindowFrame)this.mw.getCurrentModel());
        }
        logger.info((Object)"Finished processing files");
        System.exit(0);
    }

    protected void generateInfoFromCellDesigner() {
        this.cdInfo = new CellDesignerInfo(this.currentFile);
    }

    protected void transferInfoToBioPax() {
        this.bioPax3Info = new BioPax3Info(this.cdInfo);
    }

    protected void outputInfo() {
        String outputFileName = this.currentFile.getName();
        String saveDirFilePath = saveDirectory.getPath();
        if (outputFileName.endsWith(FILE_EXT_ACCEPT)) {
            outputFileName = outputFileName.substring(0, outputFileName.indexOf(FILE_EXT_ACCEPT));
        }
        String outputCDInfoName = saveDirFilePath + File.separator + outputFileName + FILE_EXT_TXT;
        String pathwayFileName = saveDirFilePath + File.separator + outputFileName + FILE_EXT_ACCEPT;
        outputFileName = saveDirFilePath + File.separator + outputFileName + FILE_EXT_OWL;
        try {
            File f = new File(outputFileName);
            FileOutputStream anOutputStream = new FileOutputStream(f);
            Model m = this.bioPax3Info.getBioPaxModel();
            SimpleExporter exporter = new SimpleExporter(m.getLevel());
            exporter.convertToOWL(m, (OutputStream)anOutputStream);
            anOutputStream.close();
            String speciesInfo = this.bioPax3Info.getSpeciesNotAddedInfo();
            FileWriter fstream = new FileWriter(outputCDInfoName);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(speciesInfo);
            out.close();
            this.filer.write(new File(pathwayFileName), (MultiWindowFrame)this.mw.getCurrentModel());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected boolean initDirInfo() {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(openDirectory);
        chooser.setDialogTitle(DIRECTORY_SELECTION_FOR_READING);
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        JFrame frame = this.mw.getMyFrame();
        if (chooser.showOpenDialog(frame) != 0) {
            return false;
        }
        openDirectory = chooser.getSelectedFile();
        this.fileList = openDirectory.listFiles(this);
        if (null == this.fileList || 0 == this.fileList.length) {
            return false;
        }
        Arrays.sort(this.fileList);
        chooser.setCurrentDirectory(saveDirectory);
        chooser.setDialogTitle(DIRECTORY_SELECTION_FOR_WRITING);
        if (chooser.showOpenDialog(frame) != 0) {
            return false;
        }
        saveDirectory = chooser.getSelectedFile();
        return true;
    }

    public boolean accept(File file) {
        if (null == file) {
            return false;
        }
        String fileName = file.getName();
        return fileName.endsWith(FILE_EXT_ACCEPT);
    }
}

