/*
 * Decompiled with CFR 0.152.
 */
package com.sri.panther.pathway.converter;

import com.sri.panther.pathway.converter.BioPax3Info;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlledVocabulary;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.PhysicalEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BioPax3ToCD {
    protected static Logger logger = Logger.getLogger((String)BioPax3Info.class.getName());
    protected Model model;
    protected Hashtable<String, ControlledVocabulary> controlledVocabTbl = new Hashtable();
    protected Hashtable<String, Conversion> conversionTbl = new Hashtable();
    protected Hashtable<String, Control> controlTbl = new Hashtable();
    protected Hashtable<String, PhysicalEntity> physicalEntitiesTbl = new Hashtable();
    protected Hashtable<String, ReactionParticipants> conversionParticipantsTbl = new Hashtable();
    protected static final String MSG_UNHANDLED_ELEMENT_TYPE = " Encountered unhandled element type ";
    protected static final String MSG_ENCOUNTERED_SPECIES_WITHOUT_COMPARTMENT = " Encountered species without compartment ";

    public BioPax3ToCD(Model model) {
        this.model = model;
        this.initializeInfo();
        this.handleCompartments();
        this.handleSpecies();
        this.handleReactions();
        this.handleCompartmentLayout();
    }

    protected void initializeInfo() {
        if (null == this.model) {
            return;
        }
        Set elems = this.model.getObjects();
        for (BioPAXElement element : elems) {
            if (element instanceof ControlledVocabulary) {
                this.controlledVocabTbl.put(element.getRDFId(), (ControlledVocabulary)element);
                continue;
            }
            if (element instanceof PhysicalEntity) {
                String id = element.getRDFId();
                PhysicalEntity pe = (PhysicalEntity)element;
                this.physicalEntitiesTbl.put(id, pe);
                continue;
            }
            if (element instanceof Conversion) {
                this.conversionTbl.put(element.getRDFId(), (Conversion)element);
                continue;
            }
            if (element instanceof Control) {
                this.controlTbl.put(element.getRDFId(), (Control)element);
                continue;
            }
            logger.info((Object)(element.getRDFId() + MSG_UNHANDLED_ELEMENT_TYPE + element.getClass()));
        }
    }

    protected void handleCompartments() {
    }

    protected void handleSpecies() {
    }

    protected void handleReactions() {
        Enumeration<String> reactionIds = this.conversionTbl.keys();
        while (reactionIds.hasMoreElements()) {
            String reactionId = reactionIds.nextElement();
            Conversion conversion = this.conversionTbl.get(reactionId);
            ReactionParticipants rp = new ReactionParticipants(conversion);
            this.conversionParticipantsTbl.put(reactionId, rp);
        }
    }

    protected void handleCompartmentLayout() {
        Enumeration<String> reactionIds = this.conversionParticipantsTbl.keys();
        Vector<String> multipleCompartmentReactions = new Vector<String>();
        while (reactionIds.hasMoreElements()) {
            String reactionId = reactionIds.nextElement();
            ReactionParticipants rp = this.conversionParticipantsTbl.get(reactionId);
            if (this.participantsInSameCellularLocation(rp)) continue;
            multipleCompartmentReactions.add(reactionId);
        }
    }

    protected boolean participantsInSameCellularLocation(ReactionParticipants rp) {
        Set<CellularLocationVocabulary> reactantLocations = null;
        Set<CellularLocationVocabulary> productLocations = null;
        Set<CellularLocationVocabulary> modifierLocations = null;
        if (null != rp.reactants) {
            reactantLocations = this.getLocations(rp.reactants);
        }
        if (null != rp.products) {
            productLocations = this.getLocations(rp.products);
        }
        if (null != rp.modifiers) {
            modifierLocations = this.getLocations(rp.modifiers);
        }
        HashSet<CellularLocationVocabulary> allLocations = new HashSet<CellularLocationVocabulary>();
        if (null != reactantLocations) {
            allLocations.addAll(new Vector<CellularLocationVocabulary>(reactantLocations));
        }
        if (null != productLocations) {
            allLocations.addAll(new Vector<CellularLocationVocabulary>(productLocations));
        }
        if (null != modifierLocations) {
            allLocations.addAll(new Vector<CellularLocationVocabulary>(modifierLocations));
        }
        return true;
    }

    protected Set<CellularLocationVocabulary> getLocations(Set<PhysicalEntity> peSet) {
        if (null == peSet) {
            return null;
        }
        HashSet<CellularLocationVocabulary> allLocations = new HashSet<CellularLocationVocabulary>();
        for (PhysicalEntity pe : peSet) {
            allLocations.add(pe.getCellularLocation());
        }
        return allLocations;
    }

    private class ReactionParticipants {
        public Conversion conversion;
        public Set<PhysicalEntity> reactants;
        public Set<PhysicalEntity> products;
        public Set<PhysicalEntity> modifiers;

        ReactionParticipants(Conversion c) {
            this.conversion = c;
            this.reactants = this.conversion.getLeft();
            this.products = this.conversion.getRight();
            Set allmodifiers = this.conversion.isControlledOf();
            this.modifiers = new HashSet<PhysicalEntity>();
            Iterator iterator = allmodifiers.iterator();
            while (iterator.hasNext()) {
                this.modifiers.addAll(new Vector(((Control)iterator.next()).getController()));
            }
        }
    }
}

