/*
 * Decompiled with CFR 0.152.
 */
package com.sri.panther.pathway.converter;

import com.sri.panther.pathway.converter.CellDesignerInfo;
import com.sri.panther.pathway.util.Utils;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.ElementSpeciesAlias;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesProperty;
import jp.sbi.celldesigner.sbmlExtension.BindingRegion;
import jp.sbi.celldesigner.sbmlExtension.Modification;
import jp.sbi.celldesigner.sbmlExtension.ModificationRegion;
import jp.sbi.celldesigner.sbmlExtension.ModificationResidue;
import jp.sbi.celldesigner.sbmlExtension.ModificationShape;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import jp.sbi.celldesigner.sbmlExtension.StructuralState;
import org.apache.log4j.Logger;
import org.biopax.paxtools.impl.level3.Level3FactoryImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BindingFeature;
import org.biopax.paxtools.model.level3.BiochemicalReaction;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.ComplexAssembly;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.ControlledVocabulary;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.Degradation;
import org.biopax.paxtools.model.level3.DnaRegion;
import org.biopax.paxtools.model.level3.DnaRegionReference;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.RelationshipTypeVocabulary;
import org.biopax.paxtools.model.level3.RelationshipXref;
import org.biopax.paxtools.model.level3.Rna;
import org.biopax.paxtools.model.level3.RnaReference;
import org.biopax.paxtools.model.level3.SequenceModificationVocabulary;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.Stoichiometry;
import org.biopax.paxtools.model.level3.TransportWithBiochemicalReaction;
import org.biopax.paxtools.model.level3.Xref;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.Species;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BioPax3Info {
    protected CellDesignerInfo cdi;
    protected Level3FactoryImpl level3Factory;
    protected Model biopaxModel;
    protected String modelName;
    protected String translatedModelName;
    protected Pathway pathwayReactions;
    protected Hashtable<String, BioPAXElement> speciesAliasToBioPaxTbl = new Hashtable();
    protected Hashtable<String, String> speciesAliasNotAddedTbl = new Hashtable();
    protected Hashtable<String, String> speciesAliasLookup = new Hashtable();
    public static final String[] BIOPAX_SUPPORTED_TYPES = new String[]{"PROTEIN", "GENE", "RNA", "ANTISENSE_RNA", "SIMPLE_MOLECULE", "ION", "PHENOTYPE", "DRUG", "UNKNOWN", "DEGRADED"};
    public static final String[] BIOPAX_SUPPORTED_COMPLEX_COMPONENTS = BIOPAX_SUPPORTED_TYPES;
    public static final String ENTITY_REFERENCE_ID_SEPARATOR = ".";
    public static final String STATE_ACTIVATION_ACTIVE = "TRUE";
    public static final String STATE_ACTIVATION_INACTIVE = "FALSE";
    public static final String COMMENT_PHYSICAL_ENTITY_SPECIES_TYPE = "SPECIES_TYPE=";
    public static final String COMMENT_ENTITY_REFERENCE_PROTEIN_TYPE = "ENTITY_REFERENCE_PROTEIN_TYPE=";
    public static final String COMMENT_ENTITY_REFERENCE_NOTES = "ENTITY_REFERENCE_NOTES=";
    public static final String COMMENT_PHYSICAL_ENTITY_SNAME = "PHYSICAL_ENTITY_SNAME=";
    public static final String COMMENT_MODEL_TRANSLATED_NAME = "MODEL_TRANSLATED_NAME=";
    public static final String COMMENT_MODEL_NOTES = "MODEL_NOTES=";
    public static final String COMMENT_PHYSICAL_ENTITY_ACTIVATION = "ACTIVATION=";
    public static final String COMMENT_PHYSICAL_ENTITY_STRUCTURAL_STATE = "STRUCTURAL_STATE=";
    public static final String COMMENT_PHYSICAL_ENTITY_HOMODIMER_NUM = "HOMODIMER_NUM=";
    public static final String COMMENT_MODIFICATION_FEATURE_TYPE = "MODIFICATION_RESIDUE_TYPE=";
    public static final String COMMENT_MODIFICATION_FEATURE_SIDE = "MODIFICATION_RESIDUE_SIDE=";
    public static final String COMMENT_MODIFICATION_FEATURE_NAME = "MODIFICATION_RESIDUE_NAME=";
    public static final String COMMENT_MODIFICATION_FEATURE_ANGLE = "MODIFICATION_RESIDUE_ANGLE=";
    public static final String COMMENT_MODIFICATION_FEATURE_MODIFICATION = "MODIFICATION_RESIDUE_MODIFICATION=";
    public static final String COMMENT_STRUCTURAL_STATE = "MODIFICATION_STRUCTURAL_STATE=";
    public static final String COMMENT_BINDING_REGION_NAME = "BINDING_REGION_NAME=";
    public static final String COMMENT_BINDING_REGION_TYPE = "BINDING_REGION_TYPE=";
    public static final String COMMENT_BINDING_REGION_ANGLE = "BINDING_REGION_ANGLE=";
    public static final String COMMENT_MODIFICATION_REGION_NAME = "MODIFICATION_REGION_NAME=";
    public static final String COMMENT_MODIFICATION_REGION_TYPE = "MODIFICATION_REGION_TYPE=";
    public static final String COMMENT_MODIFICATION_REGION_ACTIVATION = "MODIFICATION_REGION_ACTIVATION=";
    public static final String COMMENT_MODIFICATION_REGION_SIZE = "MODIFICATION_REGION_SIZE=";
    public static final String COMMENT_MODIFICATION_REGION_POSITION = "MODIFICATION_REGION_POSITION=";
    public static final String DELIM_MODIFICATION = "_";
    public static final String DELIM_ACTIVATION = "_";
    public static final String DATA_SOURCE = "DATA_SOURCE=CellDesigner";
    public static final String PREFIX_MODIFICATION_FEATURE = "MODIFICATION_FEATURE_";
    public static final String CONTROLLED_VOCABULARY_PREFIX_BINDING_REGION = "BINDING_REGION_";
    public static final String CONTROLLED_VOCABULARY_PREFIX_MODIFICATION_REGION = "MODIFICATION_REGION_";
    public static final String COMMENT_REACTION_MODIFIER_TYPE = "REACTION_MODIFIER_TYPE=";
    public static final String COMMENT_REACTION_TYPE = "REACTION_TYPE=";
    public static final String COMMENT_REACTION_REVERSIBLE = "REACTION_REVERSIBLE=";
    public static final Hashtable<String, String> SUPPORTED_REACTION_TYPES = new Hashtable();
    public static final Hashtable<String, String> SUPPORTED_MODIFIER_TYPES = new Hashtable();
    private static final int INDEX_SPECIES = 0;
    private static final int INDEX_ALIAS = 1;
    private static final String DELIM_SPECIES_INFO_SEPARATOR = "\t";
    private static final String DELIM_SPECIES_INFO = "\n";
    private static final String DELIM_REACTION_STOICHIOMETRY = "_";
    public static final String ID_STOICHIOMETRY_PREFIX = "STOICHIOMETRY_ID_";
    public static final String ID_STOICHIOMETRY_COMPLEX_PREFIX = "STOICHIOMETRY_ID_COMPLEX_";
    public static final String ID_STOICHIOMETRY_REACTION_PREFIX = "STOICHIOMETRY_ID_REACTION_";
    public static final int HOMODIMER_MINIMUM = 1;
    public Hashtable<String, RelationshipXref> relationshipXrefTypesTbl = new Hashtable();
    public static final String PREFIX_CD_REACTION_TYPE = "CELLDESIGNER_REACTION_TYPE=";
    public static final String PREFIX_CD_INTERACTION_VOCABULARY = "CELLDESIGNER_INTERACTION_VOCABULARY=";
    private static Logger logger = Logger.getLogger((String)BioPax3Info.class.getName());
    private static Properties property = null;
    private static final String FILE_NAME_PROPERTY = "converter.properties";
    private static final String PROPERTY_MODIFICATION_PREFIX = "modification_feature_";
    private static final String ACTIVATION_STATE_ACTIVE = "Active";
    public static final String REACTION_MODIFIER_SEPARATOR = "_";
    public static final String REACTION_MODIFIER_LIST_SEPARATOR = ",";

    public BioPax3Info(CellDesignerInfo cdi) {
        BioPax3Info.init();
        this.cdi = cdi;
        this.level3Factory = new Level3FactoryImpl();
        this.generateInfo();
    }

    protected static void init() {
        property = new Properties();
        try {
            property.load(new FileInputStream(FILE_NAME_PROPERTY));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error reading property file - check the classpath");
        }
        SUPPORTED_REACTION_TYPES.put("CATALYSIS", "CATALYSIS");
        SUPPORTED_REACTION_TYPES.put("HETERODIMER_ASSOCIATION", "HETERODIMER_ASSOCIATION");
        SUPPORTED_REACTION_TYPES.put("DISSOCIATION", "DISSOCIATION");
        SUPPORTED_REACTION_TYPES.put("INHIBITION", "INHIBITION");
        SUPPORTED_REACTION_TYPES.put("KNOWN_TRANSITION_OMITTED", "KNOWN_TRANSITION_OMITTED");
        SUPPORTED_REACTION_TYPES.put("STATE_TRANSITION", "STATE_TRANSITION");
        SUPPORTED_REACTION_TYPES.put("TRANSCRIPTION", "TRANSCRIPTION");
        SUPPORTED_REACTION_TYPES.put("TRANSLATION", "TRANSLATION");
        SUPPORTED_REACTION_TYPES.put("TRANSPORT", "TRANSPORT");
        SUPPORTED_REACTION_TYPES.put("TRUNCATION", "TRUNCATION");
        SUPPORTED_REACTION_TYPES.put("UNKNOWN_CATALYSIS", "UNKNOWN_CATALYSIS");
        SUPPORTED_REACTION_TYPES.put("UNKNOWN_INHIBITION", "UNKNOWN_INHIBITION");
        SUPPORTED_REACTION_TYPES.put("UNKNOWN_TRANSITION", "UNKNOWN_TRANSITION");
        SUPPORTED_REACTION_TYPES.put("MODULATION", "MODULATION");
        SUPPORTED_REACTION_TYPES.put("PHYSICAL_STIMULATION", "PHYSICAL_STIMULATION");
        SUPPORTED_REACTION_TYPES.put("TRIGGER", "TRIGGER");
        SUPPORTED_MODIFIER_TYPES.put("CATALYSIS", "CATALYSIS");
        SUPPORTED_MODIFIER_TYPES.put("UNKNOWN_CATALYSIS", "UNKNOWN_CATALYSIS");
        SUPPORTED_MODIFIER_TYPES.put("INHIBITION", "INHIBITION");
        SUPPORTED_MODIFIER_TYPES.put("UNKNOWN_INHIBITION", "UNKNOWN_INHIBITION");
        SUPPORTED_MODIFIER_TYPES.put("MODULATION", "MODULATION");
        SUPPORTED_MODIFIER_TYPES.put("TRIGGER", "TRIGGER");
        SUPPORTED_MODIFIER_TYPES.put("PHYSICAL_STIMULATION", "PHYSICAL_STIMULATION");
        SUPPORTED_MODIFIER_TYPES.put("BOOLEAN_LOGIC_GATE_AND", "BOOLEAN_LOGIC_GATE_AND");
        SUPPORTED_MODIFIER_TYPES.put("BOOLEAN_LOGIC_GATE_NOT", "BOOLEAN_LOGIC_GATE_NOT");
        SUPPORTED_MODIFIER_TYPES.put("BOOLEAN_LOGIC_GATE_OR", "BOOLEAN_LOGIC_GATE_OR");
        SUPPORTED_MODIFIER_TYPES.put("BOOLEAN_LOGIC_GATE_UNKNOWN", "BOOLEAN_LOGIC_GATE_UNKNOWN");
    }

    protected void generateInfo() {
        if (null == this.cdi) {
            return;
        }
        this.biopaxModel = this.level3Factory.createModel();
        this.generateModelDefinitionData();
        this.generateCompartmentData();
        this.generateSpeciesData();
        this.generateReactionsData();
    }

    protected void generateModelDefinitionData() {
        this.translatedModelName = this.modelName = this.cdi.getModelName();
        this.pathwayReactions = (Pathway)this.biopaxModel.addNew(Pathway.class, this.translatedModelName);
        this.pathwayReactions.setStandardName(this.modelName);
        this.pathwayReactions.setDisplayName(this.translatedModelName);
        this.pathwayReactions.addComment(COMMENT_MODEL_NOTES + this.cdi.getModelNotes());
    }

    protected void generateSpeciesData() {
        Hashtable<String, Vector<Vector<String>>> monoSpeciesTbl = this.cdi.getMonoSpeciesInfo();
        Enumeration<Vector<Vector<String>>> monoEnum = monoSpeciesTbl.elements();
        while (monoEnum.hasMoreElements()) {
            Vector<Vector<String>> speciesGroup = monoEnum.nextElement();
            for (int i = 0; i < speciesGroup.size(); ++i) {
                Vector<String> ids = speciesGroup.get(i);
                String spIdAliasName = ids.elementAt(0);
                boolean added = this.addMonoSpeciesAlias(spIdAliasName);
                this.speciesAliasLookup.put(spIdAliasName, spIdAliasName);
                int counter = 1;
                if (!added) {
                    counter = 0;
                }
                for (int j = counter; j < ids.size(); ++j) {
                    String notAdded = ids.get(j);
                    this.speciesAliasNotAddedTbl.put(notAdded, notAdded);
                    this.speciesAliasLookup.put(notAdded, spIdAliasName);
                }
            }
        }
        Hashtable<String, Vector<Vector<String>>> complexSpeciesTbl = this.cdi.getComplexSpeciesInfo();
        Enumeration<Vector<Vector<String>>> complexEnum = complexSpeciesTbl.elements();
        while (complexEnum.hasMoreElements()) {
            Vector<Vector<String>> speciesGroup = complexEnum.nextElement();
            for (int i = 0; i < speciesGroup.size(); ++i) {
                Vector<String> ids = speciesGroup.get(i);
                String spIdAliasName = ids.elementAt(0);
                int addedIndex = this.getAddedIndex(ids);
                if (-1 == addedIndex) {
                    boolean added = this.addComplexSpeciesAlias(spIdAliasName);
                    if (!added) {
                        this.speciesAliasNotAddedTbl.put(spIdAliasName, spIdAliasName);
                    }
                    this.speciesAliasLookup.put(spIdAliasName, spIdAliasName);
                } else {
                    spIdAliasName = ids.elementAt(addedIndex);
                }
                for (int j = 0; j < ids.size(); ++j) {
                    if (j == addedIndex) continue;
                    String other = ids.elementAt(j);
                    this.speciesAliasLookup.put(other, spIdAliasName);
                }
            }
        }
    }

    protected int getAddedIndex(Vector<String> ids) {
        for (int i = 0; i < ids.size(); ++i) {
            if (null == this.speciesAliasToBioPaxTbl.get(ids.elementAt(i))) continue;
            return i;
        }
        return -1;
    }

    protected void generateCompartmentData() {
        Hashtable<String, String> compartmentTbl = this.cdi.getCompartmentIdToName();
        Enumeration<String> idsEnum = compartmentTbl.keys();
        while (idsEnum.hasMoreElements()) {
            String id = idsEnum.nextElement();
            String name = compartmentTbl.get(id);
            CellularLocationVocabulary clv = (CellularLocationVocabulary)this.biopaxModel.addNew(CellularLocationVocabulary.class, id);
            clv.addTerm(name);
        }
    }

    protected boolean addMonoSpeciesAlias(String spIdAliasName) {
        if (null != this.getBioPaxElement(spIdAliasName)) {
            return true;
        }
        ElementSpeciesAlias sAlias = (ElementSpeciesAlias)Utils.getSpeciesAlias(this.cdi.getSBModel(), this.cdi.getSpeciesList(), spIdAliasName);
        CellularLocationVocabulary clv = this.getCellularLocationVocabulary((SpeciesAlias)sAlias);
        Species species = sAlias.getOriginalSpecies();
        String speciesName = species.getName();
        MonoSpeciesProperty monoSpeciesProperty = (MonoSpeciesProperty)Utils.getSpeciesProperty((SpeciesAlias)sAlias);
        int homodimer = monoSpeciesProperty.getHomodimer();
        MonoSpeciesShape monoSpeciesShape = (MonoSpeciesShape)Utils.getSpeciesShape((SpeciesAlias)sAlias);
        String type = monoSpeciesProperty.getType();
        if (!BioPax3Info.isTypeSupported(type, BIOPAX_SUPPORTED_TYPES)) {
            logger.info((Object)("Unsupported type in monospecies " + spIdAliasName + " type = " + type));
            return false;
        }
        EntityReference entityReference = this.getEntityReference(sAlias, monoSpeciesProperty);
        PhysicalEntity bioPaxElem = null;
        if (type.equals("DRUG") || type.equals("UNKNOWN") || type.equals("DEGRADED")) {
            PhysicalEntity aPhysicalEntity;
            bioPaxElem = aPhysicalEntity = (PhysicalEntity)this.biopaxModel.addNew(PhysicalEntity.class, spIdAliasName);
        } else {
            if (type.equals("PHENOTYPE")) {
                Pathway pathway = (Pathway)this.biopaxModel.addNew(Pathway.class, spIdAliasName);
                this.speciesAliasToBioPaxTbl.put(spIdAliasName, (BioPAXElement)pathway);
                return true;
            }
            if (type.equals("PROTEIN")) {
                org.biopax.paxtools.model.level3.Protein protein = (org.biopax.paxtools.model.level3.Protein)this.biopaxModel.addNew(org.biopax.paxtools.model.level3.Protein.class, spIdAliasName);
                bioPaxElem = protein;
                String activeCmt = this.getActiveStateComment((SpeciesAlias)sAlias);
                protein.addComment(activeCmt);
            } else if (type.equals("GENE")) {
                DnaRegion dnaRegion = (DnaRegion)this.biopaxModel.addNew(DnaRegion.class, spIdAliasName);
                bioPaxElem = dnaRegion;
            } else if (type.equals("RNA") || type.equals("ANTISENSE_RNA")) {
                Rna rna = (Rna)this.biopaxModel.addNew(Rna.class, spIdAliasName);
                bioPaxElem = rna;
            } else if (type.equals("SIMPLE_MOLECULE") || type.equals("ION")) {
                SmallMolecule smallMolecule = (SmallMolecule)this.biopaxModel.addNew(SmallMolecule.class, spIdAliasName);
                bioPaxElem = smallMolecule;
            } else {
                logger.info((Object)("Could not create object " + spIdAliasName));
                return false;
            }
        }
        if (null != clv) {
            bioPaxElem.setCellularLocation(clv);
        }
        Stoichiometry stoichiometry = (Stoichiometry)this.biopaxModel.addNew(Stoichiometry.class, ID_STOICHIOMETRY_PREFIX + spIdAliasName);
        stoichiometry.setPhysicalEntity(bioPaxElem);
        stoichiometry.setStoichiometricCoefficient((float)homodimer);
        if (homodimer > 1) {
            bioPaxElem.addComment(COMMENT_PHYSICAL_ENTITY_HOMODIMER_NUM + homodimer);
        }
        if (null != entityReference && bioPaxElem instanceof SimplePhysicalEntity) {
            ((SimplePhysicalEntity)bioPaxElem).setEntityReference(entityReference);
        }
        bioPaxElem.setDisplayName(speciesName);
        bioPaxElem.setStandardName(speciesName);
        bioPaxElem.addComment(COMMENT_PHYSICAL_ENTITY_SPECIES_TYPE + type);
        this.addModificationInfo(spIdAliasName, bioPaxElem, monoSpeciesShape);
        this.addActivationInfo(spIdAliasName, bioPaxElem, sAlias.isActive());
        this.speciesAliasToBioPaxTbl.put(spIdAliasName, (BioPAXElement)bioPaxElem);
        return true;
    }

    public static boolean isTypeSupported(String type, String[] supportedTypes) {
        if (null == type) {
            return false;
        }
        for (int i = 0; i < supportedTypes.length; ++i) {
            if (!type.equals(supportedTypes[i])) continue;
            return true;
        }
        return false;
    }

    public CellularLocationVocabulary getCellularLocationVocabulary(SpeciesAlias speciesAlias) {
        CompartmentAlias compAlias = Utils.getContainer(speciesAlias);
        if (null == compAlias) {
            return null;
        }
        Compartment compartment = compAlias.getOriginalCompartment();
        String id = compartment.getId();
        return (CellularLocationVocabulary)this.biopaxModel.getByID(id);
    }

    public String getActiveStateComment(SpeciesAlias speciesAlias) {
        boolean active = speciesAlias.isActive();
        if (active) {
            return "ACTIVATION=TRUE";
        }
        return "ACTIVATION=FALSE";
    }

    protected void addActivationInfo(String idPrefix, PhysicalEntity physicalEntity, boolean isActive) {
        if (!isActive) {
            return;
        }
        String id = idPrefix + "_" + ACTIVATION_STATE_ACTIVE;
        EntityFeature entityFeature = (EntityFeature)this.biopaxModel.addNew(EntityFeature.class, id);
        physicalEntity.addFeature(entityFeature);
    }

    protected void addModificationInfo(String idPrefix, PhysicalEntity physicalEntity, MonoSpeciesShape monoSpeciesShape) {
        Vector modificationShapes = monoSpeciesShape.getMShapes();
        if (null == modificationShapes) {
            return;
        }
        for (int i = 0; i < modificationShapes.size(); ++i) {
            BindingFeature bf;
            String id;
            ModificationShape ms = (ModificationShape)modificationShapes.elementAt(i);
            Modification modification = ms.getModification();
            ModificationResidue mResidue = ms.getModificationResidue();
            BindingRegion bindingRegion = ms.getBindingRegion();
            StructuralState structuralState = ms.getStructuralState();
            ModificationRegion mRegion = ms.getModificationRegion();
            if (null != mResidue) {
                id = idPrefix + "_" + mResidue.getId();
                ModificationFeature mf = (ModificationFeature)this.biopaxModel.addNew(ModificationFeature.class, id);
                mf.addComment(COMMENT_MODIFICATION_FEATURE_TYPE + mResidue.getType());
                mf.addComment(COMMENT_MODIFICATION_FEATURE_SIDE + mResidue.getSide());
                mf.addComment(COMMENT_MODIFICATION_FEATURE_NAME + mResidue.getName());
                mf.addComment(COMMENT_MODIFICATION_FEATURE_ANGLE + mResidue.getAngle());
                if (null != modification) {
                    SequenceModificationVocabulary smv;
                    String state = modification.getState();
                    String propId = property.getProperty(PROPERTY_MODIFICATION_PREFIX + state);
                    if (null == propId) {
                        propId = PREFIX_MODIFICATION_FEATURE + state;
                    }
                    if (null == (smv = (SequenceModificationVocabulary)this.biopaxModel.getByID(propId))) {
                        smv = (SequenceModificationVocabulary)this.biopaxModel.addNew(SequenceModificationVocabulary.class, propId);
                        smv.addComment(DATA_SOURCE);
                        smv.addTerm(state);
                    }
                    mf.setModificationType(smv);
                }
                if (null != structuralState) {
                    mf.addComment(COMMENT_STRUCTURAL_STATE + structuralState.getState());
                }
                physicalEntity.addFeature((EntityFeature)mf);
            }
            if (null != bindingRegion) {
                id = idPrefix + "_" + bindingRegion.getId();
                bf = (BindingFeature)this.biopaxModel.addNew(BindingFeature.class, id);
                bf.addComment(COMMENT_BINDING_REGION_NAME + bindingRegion.getName());
                bf.addComment(COMMENT_BINDING_REGION_TYPE + bindingRegion.getType());
                bf.addComment(COMMENT_BINDING_REGION_ANGLE + bindingRegion.getAngle());
                physicalEntity.addFeature((EntityFeature)bf);
            }
            if (null == mRegion) continue;
            id = idPrefix + "_" + mRegion.getId();
            bf = (BindingFeature)this.biopaxModel.addNew(BindingFeature.class, id);
            bf.addComment(COMMENT_MODIFICATION_REGION_NAME + mRegion.getName());
            bf.addComment(COMMENT_MODIFICATION_REGION_TYPE + mRegion.getType());
            if (mRegion.getActive()) {
                bf.addComment("MODIFICATION_REGION_ACTIVATION=TRUE");
            } else {
                bf.addComment("MODIFICATION_REGION_ACTIVATION=FALSE");
            }
            bf.addComment(COMMENT_MODIFICATION_REGION_SIZE + mRegion.getName());
            bf.addComment(COMMENT_MODIFICATION_REGION_POSITION + mRegion.getName());
            physicalEntity.addFeature((EntityFeature)bf);
        }
    }

    protected EntityReference getEntityReference(ElementSpeciesAlias speciesAlias, MonoSpeciesProperty monoSpeciesProperty) {
        Species species = speciesAlias.getOriginalSpecies();
        String name = species.getName();
        String notes = Utils.getNotes(species);
        StringBuffer sb = new StringBuffer();
        sb.append(this.translatedModelName);
        sb.append(ENTITY_REFERENCE_ID_SEPARATOR);
        String type = monoSpeciesProperty.getType();
        sb.append(type);
        sb.append(ENTITY_REFERENCE_ID_SEPARATOR);
        if (type.equals("PROTEIN")) {
            Protein protein = monoSpeciesProperty.getProtein();
            String proteinType = protein.getType();
            sb.append(proteinType);
            sb.append(ENTITY_REFERENCE_ID_SEPARATOR);
            sb.append(name);
            String id = sb.toString();
            EntityReference entityReference = (EntityReference)this.biopaxModel.getByID(id);
            if (null != entityReference) {
                return entityReference;
            }
            ProteinReference proteinReference = (ProteinReference)this.biopaxModel.addNew(ProteinReference.class, id);
            proteinReference.setStandardName(name);
            if (notes != null) {
                proteinReference.addComment(COMMENT_ENTITY_REFERENCE_NOTES + notes);
            }
            proteinReference.addComment(COMMENT_ENTITY_REFERENCE_PROTEIN_TYPE + proteinType);
            return proteinReference;
        }
        if (type.equals("GENE")) {
            sb.append(type);
            sb.append(ENTITY_REFERENCE_ID_SEPARATOR);
            sb.append(name);
            String id = sb.toString();
            EntityReference entityReference = (EntityReference)this.biopaxModel.getByID(id);
            if (null != entityReference) {
                return entityReference;
            }
            DnaRegionReference dnaRegionReference = (DnaRegionReference)this.biopaxModel.addNew(DnaRegionReference.class, id);
            dnaRegionReference.setStandardName(name);
            if (notes != null) {
                dnaRegionReference.addComment(COMMENT_ENTITY_REFERENCE_NOTES + notes);
            }
            return dnaRegionReference;
        }
        if (type.equals("RNA") || type.equals("ANTISENSE_RNA")) {
            sb.append(type);
            sb.append(ENTITY_REFERENCE_ID_SEPARATOR);
            sb.append(name);
            String id = sb.toString();
            EntityReference entityReference = (EntityReference)this.biopaxModel.getByID(id);
            if (null != entityReference) {
                return entityReference;
            }
            RnaReference rnaReference = (RnaReference)this.biopaxModel.addNew(RnaReference.class, id);
            rnaReference.setStandardName(name);
            if (notes != null) {
                rnaReference.addComment(COMMENT_ENTITY_REFERENCE_NOTES + notes);
            }
            return rnaReference;
        }
        if (type.equals("SIMPLE_MOLECULE") || type.equals("ION")) {
            sb.append(type);
            sb.append(ENTITY_REFERENCE_ID_SEPARATOR);
            sb.append(name);
            String id = sb.toString();
            EntityReference entityReference = (EntityReference)this.biopaxModel.getByID(id);
            if (null != entityReference) {
                return entityReference;
            }
            SmallMoleculeReference smallMoleculeReference = (SmallMoleculeReference)this.biopaxModel.addNew(SmallMoleculeReference.class, id);
            smallMoleculeReference.setStandardName(name);
            if (notes != null) {
                smallMoleculeReference.addComment(COMMENT_ENTITY_REFERENCE_NOTES + notes);
            }
            return smallMoleculeReference;
        }
        if (type.equals("DRUG") || type.equals("UNKNOWN") || type.equals("DEGRADED")) {
            sb.append(type);
            sb.append(ENTITY_REFERENCE_ID_SEPARATOR);
            sb.append(name);
            String id = sb.toString();
            EntityReference entityReference = (EntityReference)this.biopaxModel.getByID(id);
            if (null != entityReference) {
                return entityReference;
            }
            EntityReference anEntityReference = (EntityReference)this.biopaxModel.addNew(EntityReference.class, id);
            anEntityReference.setStandardName(name);
            if (notes != null) {
                anEntityReference.addComment(COMMENT_ENTITY_REFERENCE_NOTES + notes);
            }
            return anEntityReference;
        }
        return null;
    }

    protected boolean addComplexSpeciesAlias(String speciesIdAliasName) {
        if (null != this.getBioPaxElement(speciesIdAliasName)) {
            return true;
        }
        ComplexSpeciesAlias complexAlias = (ComplexSpeciesAlias)Utils.getSpeciesAlias(this.cdi.getSBModel(), this.cdi.getSpeciesList(), speciesIdAliasName);
        Species species = complexAlias.getOriginalSpecies();
        CellularLocationVocabulary clv = this.getCellularLocationVocabulary((SpeciesAlias)complexAlias);
        SpeciesProperty speciesProperty = Utils.getSpeciesProperty((SpeciesAlias)complexAlias);
        int homodimer = ((MonoSpeciesProperty)speciesProperty).getHomodimer();
        Hashtable<BioPAXElement, Integer> stoichiometryTbl = new Hashtable<BioPAXElement, Integer>();
        Vector<ElementSpeciesAlias> allMonoSpeciesComponents = Utils.getMonoSpeciesListInComplex(complexAlias);
        for (int i = 0; i < allMonoSpeciesComponents.size(); ++i) {
            ElementSpeciesAlias esa = allMonoSpeciesComponents.get(i);
            MonoSpeciesProperty property = (MonoSpeciesProperty)Utils.getSpeciesProperty((SpeciesAlias)esa);
            String type = property.getType();
            if (BioPax3Info.isTypeSupported(type, BIOPAX_SUPPORTED_COMPLEX_COMPONENTS)) continue;
            logger.info((Object)("Unsupported type in complex " + speciesIdAliasName + " type = " + type));
            return false;
        }
        Complex complex = (Complex)this.biopaxModel.addNew(Complex.class, speciesIdAliasName);
        String speciesName = species.getName();
        complex.setDisplayName(speciesName);
        complex.setStandardName(speciesName);
        Stoichiometry stoichiometry = (Stoichiometry)this.biopaxModel.addNew(Stoichiometry.class, ID_STOICHIOMETRY_PREFIX + speciesIdAliasName);
        stoichiometry.setPhysicalEntity((PhysicalEntity)complex);
        stoichiometry.setStoichiometricCoefficient((float)homodimer);
        String activeCmt = this.getActiveStateComment((SpeciesAlias)complexAlias);
        complex.addComment(activeCmt);
        if (null != clv) {
            complex.setCellularLocation(clv);
        }
        Vector compsInComplex = complexAlias.getTargets();
        for (int i = 0; i < compsInComplex.size(); ++i) {
            Integer count;
            SpeciesAlias sa = (SpeciesAlias)compsInComplex.get(i);
            String idName = Utils.getSpeciesIdAliasName(sa);
            BioPAXElement element = this.getBioPaxElement(idName);
            if (null == element) {
                boolean added;
                if (sa instanceof ElementSpeciesAlias) {
                    added = this.addMonoSpeciesAlias(idName);
                    if (!added) {
                        this.speciesAliasNotAddedTbl.put(idName, idName);
                        this.biopaxModel.remove((BioPAXElement)complex);
                        return false;
                    }
                } else {
                    added = this.addComplexSpeciesAlias(idName);
                    if (!added) {
                        this.speciesAliasNotAddedTbl.put(idName, idName);
                        this.biopaxModel.remove((BioPAXElement)complex);
                        return false;
                    }
                }
                if (null == (count = (Integer)stoichiometryTbl.get(element = this.getBioPaxElement(idName)))) {
                    stoichiometryTbl.put(element, new Integer(1));
                } else {
                    stoichiometryTbl.put(element, count + 1);
                }
            } else {
                count = (Integer)stoichiometryTbl.get(element);
                if (null == count) {
                    stoichiometryTbl.put(element, new Integer(1));
                } else {
                    stoichiometryTbl.put(element, count + 1);
                }
                Set compSet = ((PhysicalEntity)element).isComponentOf();
                if (null != compSet) {
                    boolean found = false;
                    Object[] anArray = compSet.toArray();
                    for (int j = 0; j < anArray.length; ++j) {
                        Complex aComplex = (Complex)anArray[j];
                        if (!aComplex.equals(complex)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
            }
            PhysicalEntity pyhsicalEntity = (PhysicalEntity)element;
            complex.addComponent(pyhsicalEntity);
        }
        Enumeration elemEnum = stoichiometryTbl.keys();
        while (elemEnum.hasMoreElements()) {
            BioPAXElement elem = (BioPAXElement)elemEnum.nextElement();
            stoichiometry = (Stoichiometry)this.biopaxModel.addNew(Stoichiometry.class, ID_STOICHIOMETRY_COMPLEX_PREFIX + elem.getRDFId());
            stoichiometry.setPhysicalEntity((PhysicalEntity)elem);
            stoichiometry.setStoichiometricCoefficient((float)((Integer)stoichiometryTbl.get(elem)).intValue());
            complex.addComponentStoichiometry(stoichiometry);
        }
        this.addActivationInfo(speciesIdAliasName, (PhysicalEntity)complex, complexAlias.isActive());
        this.speciesAliasToBioPaxTbl.put(speciesIdAliasName, (BioPAXElement)complex);
        return true;
    }

    public BioPAXElement getBioPaxElement(String idName) {
        BioPAXElement element = this.speciesAliasToBioPaxTbl.get(idName);
        if (null != element) {
            return element;
        }
        String alternateId = this.speciesAliasLookup.get(idName);
        if (null == alternateId) {
            return null;
        }
        element = this.speciesAliasToBioPaxTbl.get(alternateId);
        if (null == element) {
            if (idName.equals(alternateId)) {
                logger.info((Object)("No id found for " + idName));
            } else {
                logger.info((Object)("No id found for " + idName + " or alternate id" + alternateId));
            }
        }
        return element;
    }

    public boolean isSupportedModifierType(BioPAXElement elem) {
        return elem instanceof PhysicalEntity;
    }

    protected void generateReactionsData() {
        Hashtable<String, String> reactionTypesTbl = this.cdi.getReactionsIdTypeTbl();
        Hashtable<String, Vector<Vector>> ractionInfoTbl = this.cdi.getReactionsInfoTbl();
        Hashtable<String, Boolean> reactionsReversibleTbl = this.cdi.getReactionsIdReversibleTbl();
        Enumeration<String> reactionIds = reactionTypesTbl.keys();
        while (reactionIds.hasMoreElements()) {
            HashSet<Stoichiometry> stoichiometrySet;
            Control c;
            Conversion r;
            Interaction interaction = null;
            String id = reactionIds.nextElement();
            String type = reactionTypesTbl.get(id);
            if (null == SUPPORTED_REACTION_TYPES.get(type)) {
                logger.info((Object)("Unsupported reaction type " + id + " " + type));
                continue;
            }
            Boolean reversible = reactionsReversibleTbl.get(id);
            Vector<String> modifierTypes = new Vector<String>();
            Vector<Control> modifiers = this.getModifiers(id, ractionInfoTbl, modifierTypes);
            if (null == modifiers) {
                logger.info((Object)("modifiers null - Reaction " + id + " type " + type + " not handled"));
                continue;
            }
            Vector<BioPAXElement> reactants = this.getReactants(id, ractionInfoTbl);
            if (null == reactants) {
                logger.info((Object)("reactants null - Reaction " + id + " type " + type + " not handled"));
                continue;
            }
            Vector<BioPAXElement> products = this.getProducts(id, ractionInfoTbl);
            if (null == products) {
                logger.info((Object)("products null - Reaction " + id + " type " + type + " not handled"));
                continue;
            }
            Vector<Vector> thisReactionInfo = ractionInfoTbl.get(id);
            boolean allProductsDegraded = this.allDegraded(id, thisReactionInfo.get(1));
            if (this.containsPathway(reactants) || this.containsPathway(products)) {
                RelationshipXref ref;
                if (!this.containsPathway(reactants) && this.allPathways(products)) {
                    int i;
                    Control control = (Control)this.biopaxModel.addNew(Control.class, id);
                    interaction = control;
                    for (i = 0; i < reactants.size(); ++i) {
                        control.addController((PhysicalEntity)reactants.get(i));
                    }
                    for (i = 0; i < products.size(); ++i) {
                        control.addControlled((Process)((Pathway)products.get(i)));
                    }
                } else {
                    int i;
                    interaction = (Interaction)this.biopaxModel.addNew(Interaction.class, id);
                    for (i = 0; i < reactants.size(); ++i) {
                        interaction.addParticipant((Entity)reactants.get(i));
                    }
                    for (i = 0; i < products.size(); ++i) {
                        interaction.addParticipant((Entity)products.get(i));
                    }
                }
                if (null == (ref = this.getRelationshipXref(type))) continue;
                interaction.addXref((Xref)ref);
                continue;
            }
            if (type.equals("STATE_TRANSITION") || type.equals("TRUNCATION") || type.equals("TRANSCRIPTION") || type.equals("TRANSLATION")) {
                int i;
                r = null;
                interaction = r;
                r = true == allProductsDegraded && type.equals("STATE_TRANSITION") ? (Conversion)this.biopaxModel.addNew(Degradation.class, id) : (Conversion)this.biopaxModel.addNew(BiochemicalReaction.class, id);
                interaction = r;
                for (i = 0; i < reactants.size(); ++i) {
                    PhysicalEntity ph = (PhysicalEntity)reactants.elementAt(i);
                    r.addLeft(ph);
                }
                for (i = 0; i < products.size(); ++i) {
                    r.addRight((PhysicalEntity)products.elementAt(i));
                }
                for (i = 0; i < modifiers.size(); ++i) {
                    c = modifiers.elementAt(i);
                    c.addControlled((Process)r);
                }
            } else if (type.equals("KNOWN_TRANSITION_OMITTED") || type.equals("UNKNOWN_TRANSITION")) {
                int i;
                r = (Conversion)this.biopaxModel.addNew(Conversion.class, id);
                interaction = r;
                for (i = 0; i < reactants.size(); ++i) {
                    r.addLeft((PhysicalEntity)reactants.elementAt(i));
                }
                for (i = 0; i < products.size(); ++i) {
                    r.addRight((PhysicalEntity)products.elementAt(i));
                }
                for (i = 0; i < modifiers.size(); ++i) {
                    c = modifiers.elementAt(i);
                    try {
                        c.addControlled((Process)r);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)(c.getRDFId() + " - Did not add controller for reaction " + r.getRDFId()));
                    }
                }
            } else if (type.equals("HETERODIMER_ASSOCIATION") || type.equals("DISSOCIATION")) {
                int i;
                r = (ComplexAssembly)this.biopaxModel.addNew(ComplexAssembly.class, id);
                interaction = r;
                for (i = 0; i < reactants.size(); ++i) {
                    r.addLeft((PhysicalEntity)reactants.elementAt(i));
                }
                for (i = 0; i < products.size(); ++i) {
                    r.addRight((PhysicalEntity)products.elementAt(i));
                }
                for (i = 0; i < modifiers.size(); ++i) {
                    c = modifiers.elementAt(i);
                    c.addControlled((Process)r);
                }
            } else if (type.equals("TRANSPORT")) {
                int i;
                r = (TransportWithBiochemicalReaction)this.biopaxModel.addNew(TransportWithBiochemicalReaction.class, id);
                interaction = r;
                for (i = 0; i < reactants.size(); ++i) {
                    r.addLeft((PhysicalEntity)reactants.elementAt(i));
                }
                for (i = 0; i < products.size(); ++i) {
                    r.addRight((PhysicalEntity)products.elementAt(i));
                }
                for (i = 0; i < modifiers.size(); ++i) {
                    c = modifiers.elementAt(i);
                    c.addControlled((Process)r);
                }
            } else {
                logger.info((Object)("Reaction " + id + " type " + type + " not handled"));
            }
            if (null == interaction) continue;
            this.pathwayReactions.addPathwayComponent((Process)interaction);
            modifierTypes.add(0, type);
            Set<ControlledVocabulary> interactionSet = this.getInteractionTypes(modifierTypes);
            interaction.setInteractionType(interactionSet);
            RelationshipXref ref = this.getRelationshipXref(type);
            if (null != ref) {
                interaction.addXref((Xref)ref);
            }
            if (interaction instanceof Conversion && null != (stoichiometrySet = this.getStoichiometry(id, reactants, products))) {
                ((Conversion)interaction).setParticipantStoichiometry(stoichiometrySet);
            }
            interaction.addComment(COMMENT_REACTION_REVERSIBLE + reversible.toString());
        }
    }

    private RelationshipXref getRelationshipXref(String type) {
        if (null == type) {
            return null;
        }
        RelationshipXref ref = this.relationshipXrefTypesTbl.get(type);
        if (null == ref) {
            ref = (RelationshipXref)this.biopaxModel.addNew(RelationshipXref.class, type);
            this.relationshipXrefTypesTbl.put(type, ref);
            RelationshipTypeVocabulary rtv = (RelationshipTypeVocabulary)this.biopaxModel.addNew(RelationshipTypeVocabulary.class, PREFIX_CD_REACTION_TYPE + type);
            rtv.addTerm(type);
            ref.setRelationshipType(rtv);
        }
        return ref;
    }

    protected Set<ControlledVocabulary> getInteractionTypes(Vector<String> interactions) {
        int size = interactions.size();
        Hashtable<String, ControlledVocabulary> h = new Hashtable<String, ControlledVocabulary>(size);
        for (int i = 0; i < size; ++i) {
            String interaction = interactions.get(i);
            String key = PREFIX_CD_INTERACTION_VOCABULARY + interaction;
            if (null != h.get(key)) continue;
            ControlledVocabulary iv = (ControlledVocabulary)this.biopaxModel.getByID(key);
            if (null == iv) {
                iv = (ControlledVocabulary)this.biopaxModel.addNew(ControlledVocabulary.class, key);
                iv.addTerm(interaction);
            }
            h.put(key, iv);
        }
        return new HashSet<ControlledVocabulary>(new Vector(h.values()));
    }

    protected boolean allPathways(Vector<BioPAXElement> list) {
        for (int i = 0; i < list.size(); ++i) {
            BioPAXElement elem = list.get(i);
            if (elem instanceof Pathway) continue;
            return false;
        }
        return true;
    }

    protected boolean containsPathway(Vector<BioPAXElement> list) {
        for (int i = 0; i < list.size(); ++i) {
            BioPAXElement elem = list.get(i);
            if (!(elem instanceof Pathway)) continue;
            return true;
        }
        return false;
    }

    protected boolean allDegraded(String id, Vector<String> elements) {
        return Utils.allMonoSpeciesSameType(this.cdi.getSBModel(), this.cdi.getSpeciesList(), elements, "DEGRADED");
    }

    protected Catalysis createControl(Vector<BioPAXElement> list, String id, String type) {
        Catalysis c = (Catalysis)this.biopaxModel.addNew(Catalysis.class, id);
        c.addComment(COMMENT_REACTION_MODIFIER_TYPE + type);
        for (int i = 0; i < list.size(); ++i) {
            c.addController((PhysicalEntity)list.elementAt(i));
        }
        return c;
    }

    protected Vector<BioPAXElement> getReactants(String id, Hashtable<String, Vector<Vector>> reactionIfoTbl) {
        Vector<Vector> reactionsInfo = reactionIfoTbl.get(id);
        Vector reactants = reactionsInfo.get(0);
        int size = reactants.size();
        Vector<BioPAXElement> returnList = new Vector<BioPAXElement>(size);
        for (int i = 0; i < size; ++i) {
            String reactant = (String)reactants.elementAt(i);
            BioPAXElement elem = this.getBioPaxElement(reactant);
            if (null == elem) {
                return null;
            }
            returnList.add(elem);
        }
        return returnList;
    }

    protected Vector<BioPAXElement> getProducts(String id, Hashtable<String, Vector<Vector>> reactionIfoTbl) {
        Vector<Vector> reactionsInfo = reactionIfoTbl.get(id);
        Vector products = reactionsInfo.get(1);
        int size = products.size();
        Vector<BioPAXElement> returnList = new Vector<BioPAXElement>(size);
        for (int i = 0; i < size; ++i) {
            String product = (String)products.elementAt(i);
            BioPAXElement elem = this.getBioPaxElement(product);
            if (null == elem) {
                return null;
            }
            returnList.add(elem);
        }
        return returnList;
    }

    protected HashSet<Stoichiometry> getStoichiometry(String id, Vector<BioPAXElement> reactants, Vector<BioPAXElement> products) {
        if (null == reactants || null == products) {
            return null;
        }
        int size = reactants.size() + products.size();
        Vector<BioPAXElement> allParticipants = new Vector<BioPAXElement>(size);
        allParticipants.addAll(reactants);
        allParticipants.addAll(products);
        Hashtable<BioPAXElement, Integer> stoichiometryTbl = new Hashtable<BioPAXElement, Integer>();
        Enumeration<Object> elemEnum = allParticipants.elements();
        while (elemEnum.hasMoreElements()) {
            BioPAXElement elem = (BioPAXElement)elemEnum.nextElement();
            if (!(elem instanceof PhysicalEntity)) continue;
            Integer count = (Integer)stoichiometryTbl.get(elem);
            if (null == count) {
                stoichiometryTbl.put(elem, new Integer(1));
                continue;
            }
            stoichiometryTbl.put(elem, count + 1);
        }
        HashSet<Stoichiometry> rtnTbl = new HashSet<Stoichiometry>(stoichiometryTbl.size());
        elemEnum = stoichiometryTbl.keys();
        while (elemEnum.hasMoreElements()) {
            BioPAXElement elem = (BioPAXElement)elemEnum.nextElement();
            Integer count = (Integer)stoichiometryTbl.get(elem);
            Stoichiometry stoichiometry = (Stoichiometry)this.biopaxModel.addNew(Stoichiometry.class, ID_STOICHIOMETRY_REACTION_PREFIX + id + "_" + elem.getRDFId());
            stoichiometry.setPhysicalEntity((PhysicalEntity)elem);
            stoichiometry.setStoichiometricCoefficient((float)count.intValue());
            rtnTbl.add(stoichiometry);
        }
        return rtnTbl;
    }

    protected Vector<Control> getModifiers(String id, Hashtable<String, Vector<Vector>> reactionIfoTbl, Vector<String> modifierTypes) {
        String type;
        String linkId;
        Vector<Vector> reactionsInfo = reactionIfoTbl.get(id);
        Vector modifications = reactionsInfo.get(2);
        int size = modifications.size();
        Hashtable linkIdToModifiers = new Hashtable(size);
        Hashtable<String, String> linkIdType = new Hashtable<String, String>(size);
        for (int i = 0; i < size; ++i) {
            Vector modifierInfo = (Vector)modifications.elementAt(i);
            linkId = (String)modifierInfo.elementAt(0);
            type = (String)modifierInfo.elementAt(1);
            if (null == SUPPORTED_MODIFIER_TYPES.get(type)) {
                logger.info((Object)("Unsupported modifier type " + type + " encountered."));
                return null;
            }
            linkIdType.put(linkId, type);
            modifierTypes.add(type);
            Vector modifiers = (Vector)modifierInfo.elementAt(2);
            int modSize = modifiers.size();
            Vector<PhysicalEntity> bioElements = new Vector<PhysicalEntity>(modSize);
            linkIdToModifiers.put(linkId, bioElements);
            for (int j = 0; j < modSize; ++j) {
                String modifier = (String)modifiers.elementAt(j);
                BioPAXElement bioElement = this.getBioPaxElement(modifier);
                if (null == bioElement || !(bioElement instanceof PhysicalEntity)) {
                    logger.info((Object)("Modifier " + modifier + " type not supported"));
                    return null;
                }
                bioElements.add((PhysicalEntity)bioElement);
            }
        }
        Vector<Control> returnList = new Vector<Control>(size);
        Enumeration linkIds = linkIdToModifiers.keys();
        while (linkIds.hasMoreElements()) {
            linkId = (String)linkIds.nextElement();
            type = (String)linkIdType.get(linkId);
            Vector v = (Vector)linkIdToModifiers.get(linkId);
            String listId = id + "_" + BioPax3Info.generateListId(v);
            Control c = null;
            if (type == "CATALYSIS" || type == "UNKNOWN_CATALYSIS") {
                c = (Control)this.biopaxModel.addNew(Catalysis.class, listId);
                c.setControlType(ControlType.ACTIVATION);
            } else if (type == "MODULATION") {
                c = (Control)this.biopaxModel.addNew(Control.class, listId);
            } else {
                c = (Control)this.biopaxModel.addNew(Control.class, listId);
                if (type == "INHIBITION" || type == "UNKNOWN_INHIBITION") {
                    c.setControlType(ControlType.INHIBITION);
                }
            }
            RelationshipXref ref = this.getRelationshipXref(type);
            if (null != ref) {
                c.addXref((Xref)ref);
            }
            for (int i = 0; i < v.size(); ++i) {
                c.addController((PhysicalEntity)v.elementAt(i));
            }
            returnList.add(c);
        }
        return returnList;
    }

    private static final String generateListId(Vector<PhysicalEntity> v) {
        if (null == v) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            PhysicalEntity pe = v.get(i);
            sb.append(pe.getRDFId());
            if (i == 0 || i >= size - 1) continue;
            sb.append(REACTION_MODIFIER_LIST_SEPARATOR);
        }
        return sb.toString();
    }

    public String getSpeciesNotAddedInfo() {
        StringBuffer sb = new StringBuffer();
        Enumeration<String> notAddedList = this.speciesAliasNotAddedTbl.keys();
        while (notAddedList.hasMoreElements()) {
            String notAdded = notAddedList.nextElement();
            String added = this.speciesAliasLookup.get(notAdded);
            String[] notAddedInfo = this.separateSpeciesAlias(notAdded);
            String[] addedInfo = this.separateSpeciesAlias(added);
            sb.append(notAddedInfo[0]);
            sb.append(DELIM_SPECIES_INFO_SEPARATOR);
            sb.append(notAddedInfo[1]);
            sb.append(DELIM_SPECIES_INFO_SEPARATOR);
            sb.append(addedInfo[0]);
            sb.append(DELIM_SPECIES_INFO_SEPARATOR);
            sb.append(addedInfo[1]);
            sb.append(DELIM_SPECIES_INFO);
        }
        return sb.toString();
    }

    public String[] separateSpeciesAlias(String s) {
        if (null == s) {
            return null;
        }
        int index = s.indexOf("_");
        if (index <= 0 || index + 1 >= s.length()) {
            return null;
        }
        String[] rtnInfo = new String[]{s.substring(0, index), s.substring(index)};
        return rtnInfo;
    }

    public Model getBioPaxModel() {
        return this.biopaxModel;
    }
}

