/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.autoLayout.y.runtime;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import jp.fric.util.LogFactory;
import jp.sbi.sbml.autoLayout.y.runtime.IProgressMonitor;
import jp.sbi.sbml.autoLayout.y.runtime.IRunnableWithProgress;

public class ProgressMonitorDialog {
    private Logger log = LogFactory.getLogger(ProgressMonitorDialog.class);
    private IProgressMonitor monitor;
    private JLabel taskLabel;
    private JLabel noteLabel;
    private JProgressBar progressBar;
    private JComponent parentComponent;
    private String title;
    private JButton cancelButton;
    private JOptionPane pane;
    private JDialog dialog;

    public ProgressMonitorDialog(JComponent jComponent, String string) {
        this.parentComponent = jComponent;
        this.title = string;
        this.cancelButton = new JButton(UIManager.getString("OptionPane.cancelButtonText"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ProgressMonitorDialog.this.monitor.isDone()) {
                    ProgressMonitorDialog.this.dialog.setVisible(false);
                    ProgressMonitorDialog.this.dialog.dispose();
                } else if (ProgressMonitorDialog.this.monitor != null) {
                    ProgressMonitorDialog.this.monitor.interrupt();
                    ProgressMonitorDialog.this.monitor.setNote("Auto layout cancel.");
                    ProgressMonitorDialog.this.cancelButton.setEnabled(false);
                }
            }
        });
        this.taskLabel = new JLabel(" ");
        this.noteLabel = new JLabel(" ");
        this.progressBar = new JProgressBar(0, 0);
        this.progressBar.setIndeterminate(true);
    }

    public boolean isShowing() {
        if (this.dialog != null) {
            return this.dialog.isShowing();
        }
        return false;
    }

    public void dispose() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    public void run(IRunnableWithProgress iRunnableWithProgress) {
        this.pane = new ProgressOptionPane(new Object[]{this.taskLabel, this.progressBar, this.noteLabel});
        this.dialog = this.pane.createDialog(this.parentComponent, this.title);
        new Thread(this.createRunnable(iRunnableWithProgress)).start();
        this.dialog.show();
    }

    private Runnable createRunnable(final IRunnableWithProgress iRunnableWithProgress) {
        if (this.monitor == null) {
            this.monitor = new DefaultProgressMonitor();
        }
        return new Runnable(){

            @Override
            public void run() {
                iRunnableWithProgress.run(ProgressMonitorDialog.this.monitor);
            }
        };
    }

    public void setTaskName(String string) {
        this.taskLabel.setText(string);
    }

    public void setNote(String string) {
        this.noteLabel.setText(string);
    }

    public void setMaximum(int n) {
        this.progressBar.setMaximum(n);
    }

    public void setProgress(int n) {
        int n2 = this.progressBar.getMaximum();
        if (n2 != 0) {
            int n3 = this.progressBar.getValue() + n;
            String string = String.valueOf((int)((double)n3 / (double)n2 * 100.0)) + "%";
            this.progressBar.setValue(n3);
            this.progressBar.setString(string);
        }
    }

    public void setEnabled(boolean bl) {
        this.cancelButton.setEnabled(bl);
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor iProgressMonitor) {
        this.monitor = iProgressMonitor;
    }

    class DefaultProgressMonitor
    implements IProgressMonitor {
        DefaultProgressMonitor() {
        }

        @Override
        public void startTask(String string) {
        }

        @Override
        public void startTask(String string, int n) {
        }

        @Override
        public void done() {
        }

        @Override
        public boolean isCanceled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public void interrupt() {
        }

        @Override
        public void setCanceled(boolean bl) {
        }

        @Override
        public void setNote(String string) {
        }

        @Override
        public void setProgress(int n) {
        }
    }

    private class ProgressOptionPane
    extends JOptionPane {
        ProgressOptionPane(Object object) {
            super(object, 1, -1, null, new Object[]{ProgressMonitorDialog.this.cancelButton}, null);
        }

        @Override
        public int getMaxCharactersPerLineCount() {
            return 60;
        }

        @Override
        public JDialog createDialog(Component component, String string) throws HeadlessException {
            JDialog jDialog = new JDialog(ProgressOptionPane.getFrameForComponent(component), string, true);
            Container container = jDialog.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)this, "Center");
            jDialog.pack();
            jDialog.setDefaultCloseOperation(0);
            jDialog.setResizable(false);
            jDialog.setLocationRelativeTo(component);
            return jDialog;
        }
    }
}

