/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.autoLayout.y.runtime;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.SwingUtilities;
import jp.fric.graphics.draw.GStructure;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.util.ErrorMessagePane;
import jp.sbi.sbml.autoLayout.AutoLayoutResult;
import jp.sbi.sbml.autoLayout.y.OrganicEdgeRouterModule;
import jp.sbi.sbml.autoLayout.y.OrganicLayoutModule;
import jp.sbi.sbml.autoLayout.y.OrthogonalEdgeRouterModule;
import jp.sbi.sbml.autoLayout.y.YAutoLayout;
import jp.sbi.sbml.autoLayout.y.option.OptionHandler;
import jp.sbi.sbml.autoLayout.y.runtime.AbstractRunnableWithProgress;
import jp.sbi.sbml.autoLayout.y.runtime.IProgressMonitor;

public class LayoutTask
extends AbstractRunnableWithProgress {
    private YAutoLayout layout;
    private OptionHandler optionHandler;
    private SBModelFrame frame;

    public LayoutTask(YAutoLayout yAutoLayout, OptionHandler optionHandler, SBModelFrame sBModelFrame) {
        this.layout = yAutoLayout;
        this.optionHandler = optionHandler;
        this.frame = sBModelFrame;
    }

    @Override
    public void task(IProgressMonitor iProgressMonitor) {
        try {
            AutoLayoutResult autoLayoutResult;
            final SBModel sBModel = this.frame.getSBModel();
            final GStructure gStructure = sBModel.getGStructure();
            this.layout.setMonitor(iProgressMonitor);
            if (this.layout.canLayout(gStructure) && (autoLayoutResult = this.layout.doLayout(this.optionHandler, gStructure)) != null && autoLayoutResult.isLayout()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Dimension dimension = autoLayoutResult.getDocumentSize();
                        Vector vector = autoLayoutResult.getElements();
                        Vector vector2 = autoLayoutResult.getReactions();
                        Vector vector3 = autoLayoutResult.getPrev();
                        Vector vector4 = autoLayoutResult.getNext();
                        sBModel.elementsAutoLayout(dimension, vector, vector2, vector3, vector4);
                        if (LayoutTask.this.layout instanceof OrganicLayoutModule || !(LayoutTask.this.layout instanceof OrganicEdgeRouterModule) && !(LayoutTask.this.layout instanceof OrthogonalEdgeRouterModule)) {
                            LayoutTask.this.frame.zoomFit();
                        }
                        gStructure.reconfirmSameIDAutoTagNeedToPaint();
                        LayoutTask.this.frame.repaintLogicalArea((Rectangle2D)LayoutTask.this.frame.getLogicalViewArea());
                    }
                });
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorMessagePane.showErrorMessage((Component)LayoutTask.this.frame, (Exception)exception);
                }
            });
        }
    }
}

