/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.autoLayout.y.runtime;

import jp.sbi.sbml.autoLayout.y.LayoutException;
import jp.sbi.sbml.autoLayout.y.runtime.IProgressMonitor;
import jp.sbi.sbml.autoLayout.y.runtime.ProgressMonitorDialog;

public class LayoutProgressMonitor
implements IProgressMonitor {
    private ProgressMonitorDialog monitorDialog;
    private boolean canceled;
    private boolean done;
    private Thread layoutThread;
    private boolean layoutError;
    private LayoutException layoutException;

    public LayoutProgressMonitor(ProgressMonitorDialog progressMonitorDialog) {
        this.monitorDialog = progressMonitorDialog;
        this.canceled = false;
        this.done = false;
        this.layoutError = false;
    }

    @Override
    public void startTask(String string) {
        this.startTask(string, 0);
    }

    @Override
    public synchronized void startTask(String string, int n) {
        if (this.monitorDialog != null) {
            this.monitorDialog.setTaskName(string);
            this.monitorDialog.setMaximum(n);
        }
        this.done = false;
    }

    @Override
    public synchronized void done() {
        if (this.monitorDialog != null) {
            this.monitorDialog.dispose();
        }
        this.done = true;
    }

    @Override
    public synchronized boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public synchronized boolean isDone() {
        return this.done;
    }

    @Override
    public synchronized void interrupt() {
        this.setCanceled(true);
    }

    @Override
    public synchronized void setCanceled(boolean bl) {
        this.canceled = bl;
        this.done = true;
        if (this.canceled && this.layoutThread != null) {
            this.layoutThread.interrupt();
        }
    }

    public synchronized void setLayoutThread(Thread thread) {
        this.layoutThread = thread;
    }

    @Override
    public synchronized void setNote(String string) {
        if (this.monitorDialog != null) {
            this.monitorDialog.setNote(string);
        }
    }

    @Override
    public synchronized void setProgress(int n) {
        if (this.monitorDialog != null) {
            this.monitorDialog.setProgress(n);
        }
    }

    public synchronized void setCancelEnabled() {
        if (this.monitorDialog != null) {
            this.monitorDialog.setEnabled(false);
        }
    }

    public boolean isLayoutError() {
        return this.layoutError;
    }

    public void setLayoutError(boolean bl) {
        this.layoutError = bl;
    }

    public LayoutException getLayoutException() {
        return this.layoutException;
    }

    public void setLayoutException(LayoutException layoutException) {
        this.layoutException = layoutException;
    }
}

