/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.autoLayout.y.option;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import jp.fric.util.LogFactory;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.util.ErrorMessagePane;
import jp.sbi.sbml.autoLayout.y.option.LayoutProperties;
import jp.sbi.sbml.autoLayout.y.option.LayoutResourceBundleUtil;
import jp.sbi.sbml.autoLayout.y.option.OptionHandler;

public abstract class YDialog
extends JDialog
implements ActionListener {
    public static final int OK = 1;
    public static final int CANCEL = 2;
    protected static final Dimension PANEL_SIZE = new Dimension(430, 250);
    protected static final Dimension SLIDER_SIZE = new Dimension(80, 0);
    private int status;
    protected JButton okButton;
    protected JButton resetButton;
    protected JButton applyButton;
    protected JButton cancelButton;
    protected JPanel controlPane;
    protected JLabel subTitleLabel;
    protected JPanel mainPanel;
    protected OptionHandler op;
    private Logger log = LogFactory.getLogger(YDialog.class);
    protected static LayoutProperties properties;

    static {
        try {
            properties = LayoutProperties.getInstance();
        }
        catch (IOException iOException) {
            ErrorMessagePane.showErrorMessage(null, (Exception)iOException);
        }
    }

    public YDialog(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.init();
    }

    public YDialog(JDialog jDialog) {
        super((Dialog)jDialog, true);
        this.init();
    }

    private void init() {
        this.setResizable(false);
        this.okButton = new JButton("Ok");
        this.okButton.addActionListener(this);
        this.resetButton = new JButton("Reset");
        this.resetButton.addActionListener(this);
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.controlPane = new JPanel(new FlowLayout(1));
        this.controlPane.add(this.okButton);
        this.controlPane.add(this.resetButton);
        this.controlPane.add(this.applyButton);
        this.controlPane.add(this.cancelButton);
        this.status = 2;
    }

    public abstract OptionHandler getOptionHandler();

    public abstract void setOptionHandler();

    protected abstract void setDefault();

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.okButton)) {
            this.setOptionHandler();
            this.save();
            if (Preference.isDebug && this.op != null) {
                this.log.info(this.op.toString());
            }
            this.status = 1;
            this.dispose();
        } else if (actionEvent.getSource().equals(this.resetButton)) {
            this.setDefault();
        } else if (actionEvent.getSource().equals(this.applyButton)) {
            this.setOptionHandler();
            this.save();
            if (Preference.isDebug && this.op != null) {
                this.log.info(this.op.toString());
            }
        } else if (actionEvent.getSource().equals(this.cancelButton)) {
            this.status = 2;
            this.dispose();
        }
    }

    public int showDialog() {
        this.show();
        return this.status;
    }

    protected JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        return jLabel;
    }

    protected void setLabel(JPanel jPanel, String string, GridBagLayout gridBagLayout, int n, int n2, int n3) {
        jPanel.add(this.setConstraints(this.createLabel(LayoutResourceBundleUtil.getString(string)), gridBagLayout, n, n2, n3));
    }

    protected void setSelectedItem(JComboBox jComboBox, String string) {
        int n = 0;
        while (n < jComboBox.getItemCount()) {
            if (jComboBox.getItemAt(n).equals(properties.getProperty(string))) {
                jComboBox.setSelectedIndex(n);
                break;
            }
            ++n;
        }
    }

    protected void setDefaultSelectedItem(JComboBox jComboBox, String string) {
        int n = 0;
        while (n < jComboBox.getItemCount()) {
            if (jComboBox.getItemAt(n).equals(properties.getDefaultProperty(string))) {
                jComboBox.setSelectedIndex(n);
                break;
            }
            ++n;
        }
    }

    protected JPanel createSliderPanel(final JSlider jSlider, final JTextField jTextField) {
        jSlider.setPaintLabels(true);
        jSlider.setPaintTicks(false);
        jSlider.setPaintTrack(true);
        Dimension dimension = new Dimension(YDialog.SLIDER_SIZE.width, jSlider.getPreferredSize().height);
        jSlider.setPreferredSize(dimension);
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.add(jSlider);
        jPanel.add(jTextField);
        jSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Document document = jTextField.getDocument();
                if (document instanceof IntegerDocument) {
                    int n = jSlider.getValue();
                    jTextField.setText(Integer.toString(n));
                } else if (document instanceof DoubleDocument) {
                    DoubleDocument doubleDocument = (DoubleDocument)document;
                    double d = jSlider.getValue();
                    jTextField.setText(Double.toString(d / (double)doubleDocument.a));
                }
            }
        });
        jTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Document document = jTextField.getDocument();
                if (document instanceof IntegerDocument) {
                    jSlider.setValue(Integer.parseInt(jTextField.getText()));
                } else if (document instanceof DoubleDocument) {
                    DoubleDocument doubleDocument = (DoubleDocument)document;
                    jSlider.setValue((int)(Double.parseDouble(jTextField.getText()) * (double)doubleDocument.a));
                }
            }
        });
        return jPanel;
    }

    protected JSlider createSliderInt(String string, String string2, String string3) {
        return this.createSliderInt(string, string2, string3, string, string2);
    }

    protected JSlider createSliderInt(String string, String string2, String string3, String string4, String string5) {
        int n = LayoutResourceBundleUtil.getInt(string);
        int n2 = LayoutResourceBundleUtil.getInt(string2);
        int n3 = properties.getPropertyInt(string3);
        final JLabel jLabel = new JLabel(LayoutResourceBundleUtil.getString(string4));
        final JLabel jLabel2 = new JLabel(LayoutResourceBundleUtil.getString(string5));
        Font font = jLabel.getFont();
        Font font2 = new Font(font.getName(), 0, font.getSize() - 1);
        jLabel.setFont(font2);
        jLabel2.setFont(font2);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(n), jLabel);
        hashtable.put(new Integer(n2), jLabel2);
        JSlider jSlider = new JSlider(n, n2, n3){

            @Override
            public void setEnabled(boolean bl) {
                super.setEnabled(bl);
                if (jLabel != null) {
                    jLabel.setEnabled(bl);
                }
                if (jLabel2 != null) {
                    jLabel2.setEnabled(bl);
                }
            }
        };
        jSlider.setLabelTable(hashtable);
        return jSlider;
    }

    protected JSlider createSliderDouble(String string, String string2, String string3) {
        return this.createSliderDouble(string, string2, string3, string, string2, 10);
    }

    protected JSlider createSliderDouble(String string, String string2, String string3, int n) {
        return this.createSliderDouble(string, string2, string3, string, string2, n);
    }

    protected JSlider createSliderDouble(String string, String string2, String string3, String string4, String string5) {
        return this.createSliderDouble(string, string2, string3, string4, string5, 10);
    }

    protected JSlider createSliderDouble(String string, String string2, String string3, String string4, String string5, int n) {
        int n2 = (int)(LayoutResourceBundleUtil.getDouble(string) * (double)n);
        int n3 = (int)(LayoutResourceBundleUtil.getDouble(string2) * (double)n);
        int n4 = (int)(properties.getPropertyDouble(string3) * (double)n);
        final JLabel jLabel = new JLabel(LayoutResourceBundleUtil.getString(string4));
        final JLabel jLabel2 = new JLabel(LayoutResourceBundleUtil.getString(string5));
        if ("smartorganic.quality_time_ratio.quality".equals(string5)) {
            jLabel2.setText(String.valueOf(jLabel2.getText()) + "  ");
        }
        Font font = jLabel.getFont();
        Font font2 = new Font(font.getName(), 0, font.getSize() - 1);
        jLabel.setFont(font2);
        jLabel2.setFont(font2);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(n2), jLabel);
        hashtable.put(new Integer(n3), jLabel2);
        JSlider jSlider = new JSlider(n2, n3, n4){

            @Override
            public void setEnabled(boolean bl) {
                super.setEnabled(bl);
                if (jLabel != null) {
                    jLabel.setEnabled(bl);
                }
                if (jLabel2 != null) {
                    jLabel2.setEnabled(bl);
                }
            }
        };
        jSlider.setLabelTable(hashtable);
        return jSlider;
    }

    protected JComponent setConstraints(JComponent jComponent, GridBagLayout gridBagLayout, int n, int n2, int n3) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.anchor = n3;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        return jComponent;
    }

    protected JComponent setConstraints(JComponent jComponent, GridBagLayout gridBagLayout, int n, int n2, int n3, int n4, int n5) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        return jComponent;
    }

    protected JPanel resizePanel(JPanel jPanel) {
        jPanel.setPreferredSize(new Dimension(YDialog.PANEL_SIZE.width, jPanel.getPreferredSize().height));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jPanel);
        return jPanel2;
    }

    protected void save() {
        try {
            properties.store();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    abstract class AbstractItem {
        String item;

        public AbstractItem(String string) {
            this.item = LayoutResourceBundleUtil.getString(string);
        }

        public boolean equals(Object object) {
            return this.toString().equals(object.toString());
        }

        public String toString() {
            return this.item;
        }
    }

    class DefaultItem
    extends AbstractItem {
        public DefaultItem(String string) {
            super(string);
        }
    }

    class DoubleDocument
    extends PlainDocument {
        int a = 10;

        public DoubleDocument() {
        }

        public DoubleDocument(int n) {
            this.a = n;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2 = super.getText(0, super.getLength());
            char[] cArray = string.toCharArray();
            int n2 = 0;
            while (n2 < cArray.length) {
                if (!Character.isDigit(cArray[n2])) {
                    if (cArray[n2] == '-') {
                        if (string2.startsWith("-") || n != 0) {
                            return;
                        }
                    } else if (cArray[n2] == '.') {
                        if (string2.indexOf(".") >= 0) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
                ++n2;
            }
            super.insertString(n, string, attributeSet);
        }
    }

    class GroupingPolicyItem
    extends DefaultItem {
        public GroupingPolicyItem(String string) {
            super(string);
        }
    }

    class IntegerDocument
    extends PlainDocument {
        IntegerDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2 = super.getText(0, super.getLength());
            char[] cArray = string.toCharArray();
            int n2 = 0;
            while (n2 < cArray.length) {
                if (!Character.isDigit(cArray[n2])) {
                    if (cArray[n2] == '-') {
                        if (string2.startsWith("-") || n != 0) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
                ++n2;
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

