/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.autoLayout.y.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jp.sbi.sbml.autoLayout.y.option.LayoutResourceBundleUtil;
import jp.sbi.sbml.autoLayout.y.option.OptionHandler;
import jp.sbi.sbml.autoLayout.y.option.YDialog;

public class TreeLayoutDialog
extends YDialog {
    private JComboBox layoutStyle;
    private JCheckBox allowGeneralGraphs;
    private JLabel edgesRoutingStyleLabel;
    private JComboBox edgesRoutingSytle;
    private JCheckBox selectionOnly;
    private JSlider nodeDistance;
    private JTextField nodeDistanceText;
    private JSlider layerDistance;
    private JTextField layerDistanceText;
    private JComboBox orientation;
    private JComboBox portStyle;
    private JCheckBox orthogonalEdgeRouting;
    private JLabel edgeBusAlignmentLabel;
    private JSlider edgeBusAlignment;
    private JTextField edgeBusAlignmentText;
    private JSlider childAlignment;
    private JTextField childAlignmentText;
    private JComboBox rootNodePolicy;
    private JSlider childWedge;
    private JTextField childWedgeText;
    private JSlider rootWedge;
    private JTextField rootWedgeText;
    private JSlider edgeLength;
    private JTextField edgeLengthText;
    private JSlider compactness;
    private JTextField compactnessText;
    private JCheckBox allowOverlaps;
    private JCheckBox sketch;
    private JTextField horizontalSpacing;
    private JTextField verticalSpacing;
    private JTextField cHorizontalSpacing;
    private JTextField cVerticalSpacing;
    private JTextField bendDistance;
    private JTextField aspectRatio;
    private JCheckBox aspectRatioOfView;

    public TreeLayoutDialog(JFrame jFrame) {
        super(jFrame);
        this.init();
    }

    public TreeLayoutDialog(JDialog jDialog) {
        super(jDialog);
        this.init();
    }

    private void init() {
        this.setTitle(LayoutResourceBundleUtil.getString("tree.title"));
        this.subTitleLabel = new JLabel(LayoutResourceBundleUtil.getString("tree.subtitle"));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(LayoutResourceBundleUtil.getString("tree.general"), this.createGeneralPanle());
        jTabbedPane.add(LayoutResourceBundleUtil.getString("tree.directed"), this.createDirectedPanel());
        jTabbedPane.add(LayoutResourceBundleUtil.getString("tree.balloon"), this.createBalloonPanel());
        jTabbedPane.add(LayoutResourceBundleUtil.getString("tree.horizontal_vertical"), this.createHorizontalVerticalPanel());
        jTabbedPane.add(LayoutResourceBundleUtil.getString("tree.compact"), this.createCompactPanel());
        this.mainPanel = new JPanel(new BorderLayout(5, 5));
        this.mainPanel.add((Component)this.subTitleLabel, "North");
        this.mainPanel.add((Component)jTabbedPane, "Center");
        this.mainPanel.add((Component)this.controlPane, "South");
        this.getContentPane().setLayout(new FlowLayout(1, 10, 10));
        this.getContentPane().add(this.mainPanel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    public OptionHandler getOptionHandler() {
        if (this.op == null) {
            this.op = new OptionHandler("TREE_LAYOUT");
        }
        return this.op;
    }

    @Override
    public void setOptionHandler() {
        StyleItem styleItem = (StyleItem)this.layoutStyle.getSelectedItem();
        boolean bl = this.allowGeneralGraphs.isSelected();
        StyleItem styleItem2 = (StyleItem)this.edgesRoutingSytle.getSelectedItem();
        boolean bl2 = this.selectionOnly.isSelected();
        int n = Integer.parseInt(this.nodeDistanceText.getText());
        int n2 = Integer.parseInt(this.layerDistanceText.getText());
        OrientationItem orientationItem = (OrientationItem)this.orientation.getSelectedItem();
        PortStyleItem portStyleItem = (PortStyleItem)this.portStyle.getSelectedItem();
        boolean bl3 = this.orthogonalEdgeRouting.isSelected();
        double d = Double.parseDouble(this.edgeBusAlignmentText.getText());
        double d2 = Double.parseDouble(this.childAlignmentText.getText());
        RootNodePolicyItem rootNodePolicyItem = (RootNodePolicyItem)this.rootNodePolicy.getSelectedItem();
        int n3 = Integer.parseInt(this.childWedgeText.getText());
        int n4 = Integer.parseInt(this.rootWedgeText.getText());
        int n5 = Integer.parseInt(this.edgeLengthText.getText());
        double d3 = Double.parseDouble(this.compactnessText.getText());
        boolean bl4 = this.allowOverlaps.isSelected();
        boolean bl5 = this.sketch.isSelected();
        int n6 = Integer.parseInt(this.horizontalSpacing.getText());
        int n7 = Integer.parseInt(this.verticalSpacing.getText());
        int n8 = Integer.parseInt(this.cHorizontalSpacing.getText());
        int n9 = Integer.parseInt(this.cVerticalSpacing.getText());
        int n10 = Integer.parseInt(this.bendDistance.getText());
        double d4 = Double.parseDouble(this.aspectRatio.getText());
        boolean bl6 = this.aspectRatioOfView.isSelected();
        this.op = new OptionHandler("TREE_LAYOUT");
        this.op.addString("LAYOUT_STYLE", styleItem.style);
        this.op.addBool("GENERAL", bl);
        this.op.addString("ROUTING_STYLE_FOR_NON_TREE_EDGES", styleItem2.style);
        this.op.addBool("ACT_ON_SELECTION_ONLY", bl2);
        if (styleItem.style.equals("DIRECTED")) {
            this.op.addInt("MINIMAL_NODE_DISTANCE", n);
            this.op.addInt("MINIMAL_LAYER_DISTANCE", n2);
            this.op.addByte("ORIENTATION", orientationItem.orientation);
            this.op.addInt("PORT_STYLE", portStyleItem.style);
            this.op.addBool("ORTHOGONAL_EDGE_ROUTING", bl3);
            this.op.addDouble("EDGE_BUS_ALIGNMENT", d);
            this.op.addDouble("CHILD_ALIGNMENT", d2);
        } else if (styleItem.style.equals("BALLOON")) {
            this.op.addByte("ROOT_NODE_POLICY", rootNodePolicyItem.policy);
            this.op.addInt("PREFERRED_CHILD_WEDGE", n3);
            this.op.addInt("PREFERRED_ROOT_WEDGE", n4);
            this.op.addInt("MINIMAL_EDGE_LENGTH", n5);
            this.op.addDouble("COMPACTNESS_FACTOR", d3);
            this.op.addBool("ALLOW_OVERLAPS", bl4);
            this.op.addBool("USE_DRAWING_AS_SKETCH", bl5);
        } else if (styleItem.style.equals("HV")) {
            this.op.addInt("HORIZONTAL_SPACING", n6);
            this.op.addInt("VERTICAL_SPACING", n7);
        } else if (styleItem.style.equals("AR")) {
            this.op.addInt("HORIZONTAL_SPACING", n8);
            this.op.addInt("VERTICAL_SPACING", n9);
            this.op.addInt("BEND_DISTANCE", n10);
            this.op.addDouble("PREFERRED_ASPECT_RATIO", d4);
            this.op.addBool("USE_ASPECT_RATIOI_OF_VIEW", bl6);
        }
        properties.setProperty("tree.layout_style", styleItem.item);
        properties.setProperty("tree.allow_general_graphs", bl);
        properties.setProperty("tree.routing_style", styleItem2.item);
        properties.setProperty("tree.act_on_selection_only", bl2);
        properties.setProperty("tree.minimal_node_distance", n);
        properties.setProperty("tree.minimal_layer_distance", n2);
        properties.setProperty("tree.orientation", orientationItem.item);
        properties.setProperty("tree.port_style", portStyleItem.item);
        properties.setProperty("tree.orthogonal_edge_routing", bl3);
        properties.setProperty("tree.edge_bus_alignment", d);
        properties.setProperty("tree.child_alignment", d2);
        properties.setProperty("tree.root_node_policy", rootNodePolicyItem.item);
        properties.setProperty("tree.preferred_child_wedge", n3);
        properties.setProperty("tree.preferred_root_wedge", n4);
        properties.setProperty("tree.minimal_edge_length", n5);
        properties.setProperty("tree.compactness_factor", d3);
        properties.setProperty("tree.allow_overlaps", bl4);
        properties.setProperty("tree.use_drawing_as_sketch", bl5);
        properties.setProperty("tree.horizontal_spacing", n6);
        properties.setProperty("tree.vertical_spacing", n7);
        properties.setProperty("tree.compact.horizontal_spacing", n8);
        properties.setProperty("tree.compact.vertical_spacing", n9);
        properties.setProperty("tree.bend_distance", n10);
        properties.setProperty("tree.preferred_aspect_ratio", d4);
        properties.setProperty("tree.use_aspect_ratio_of_view", bl6);
    }

    @Override
    protected void setDefault() {
        this.setDefaultSelectedItem(this.layoutStyle, "tree.layout_style");
        this.allowGeneralGraphs.setSelected(properties.getDefaultPropertyBoolean("tree.allow_general_graphs"));
        this.setDefaultSelectedItem(this.edgesRoutingSytle, "tree.routing_style");
        this.selectionOnly.setSelected(properties.getDefaultPropertyBoolean("tree.act_on_selection_only"));
        this.nodeDistance.setValue(properties.getDefaultPropertyInt("tree.minimal_node_distance"));
        this.layerDistance.setValue(properties.getDefaultPropertyInt("tree.minimal_layer_distance"));
        this.setDefaultSelectedItem(this.orientation, "tree.orientation");
        this.setDefaultSelectedItem(this.portStyle, "tree.port_style");
        this.orthogonalEdgeRouting.setSelected(properties.getDefaultPropertyBoolean("tree.orthogonal_edge_routing"));
        this.edgeBusAlignment.setValue((int)(properties.getDefaultPropertyDouble("tree.edge_bus_alignment") * 10.0));
        this.childAlignment.setValue((int)(properties.getDefaultPropertyDouble("tree.child_alignment") * 10.0));
        this.setDefaultSelectedItem(this.rootNodePolicy, "tree.root_node_policy");
        this.childWedge.setValue(properties.getDefaultPropertyInt("tree.preferred_child_wedge"));
        this.rootWedge.setValue(properties.getDefaultPropertyInt("tree.preferred_root_wedge"));
        this.edgeLength.setValue(properties.getDefaultPropertyInt("tree.minimal_edge_length"));
        this.compactness.setValue((int)(properties.getDefaultPropertyDouble("tree.compactness_factor") * 10.0));
        this.allowOverlaps.setSelected(properties.getDefaultPropertyBoolean("tree.allow_overlaps"));
        this.sketch.setSelected(properties.getDefaultPropertyBoolean("tree.use_drawing_as_sketch"));
        this.horizontalSpacing.setText(properties.getDefaultProperty("tree.horizontal_spacing"));
        this.verticalSpacing.setText(properties.getDefaultProperty("tree.vertical_spacing"));
        this.cHorizontalSpacing.setText(properties.getDefaultProperty("tree.compact.horizontal_spacing"));
        this.cVerticalSpacing.setText(properties.getDefaultProperty("tree.compact.vertical_spacing"));
        this.bendDistance.setText(properties.getDefaultProperty("tree.bend_distance"));
        this.aspectRatio.setText(properties.getDefaultProperty("tree.preferred_aspect_ratio"));
        this.aspectRatioOfView.setSelected(properties.getDefaultPropertyBoolean("tree.use_aspect_ratio_of_view"));
        this.edgesRoutingStyleLabel.setEnabled(this.allowGeneralGraphs.isSelected());
        this.edgesRoutingSytle.setEnabled(this.allowGeneralGraphs.isSelected());
        this.edgeBusAlignmentLabel.setEnabled(this.orthogonalEdgeRouting.isSelected());
        this.edgeBusAlignment.setEnabled(this.orthogonalEdgeRouting.isSelected());
        this.edgeBusAlignmentText.setEnabled(this.orthogonalEdgeRouting.isSelected());
    }

    private JPanel createGeneralPanle() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        int n = -1;
        this.setLabel(jPanel, "tree.layout_style", gridBagLayout, 0, ++n, 17);
        Object[] objectArray = new Object[]{new StyleItem("tree.layout_style.directed", "DIRECTED"), new StyleItem("tree.layout_style.balloon", "BALLOON"), new StyleItem("tree.layout_style.horizontal_vertical", "HV"), new StyleItem("tree.layout_style.compact", "AR")};
        this.layoutStyle = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.layoutStyle, "tree.layout_style");
        jPanel.add(this.setConstraints(this.layoutStyle, gridBagLayout, 1, n, 17));
        this.setLabel(jPanel, "tree.allow_general_graphs", gridBagLayout, 0, ++n, 17);
        this.allowGeneralGraphs = new JCheckBox();
        this.allowGeneralGraphs.setSelected(properties.getPropertyBoolean("tree.allow_general_graphs"));
        jPanel.add(this.setConstraints(this.allowGeneralGraphs, gridBagLayout, 1, n, 17));
        this.edgesRoutingStyleLabel = this.createLabel(LayoutResourceBundleUtil.getString("tree.routing_style"));
        jPanel.add(this.setConstraints(this.edgesRoutingStyleLabel, gridBagLayout, 0, ++n, 17));
        objectArray = new Object[]{new StyleItem("tree.routing_style.organic", "ROUTE_ORGANIC"), new StyleItem("tree.routing_style.orthogonal", "ROUTE_ORTHOGONAL"), new StyleItem("tree.routing_style.straight_line", "ROUTE_STRAIGHTLINE")};
        this.edgesRoutingSytle = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.edgesRoutingSytle, "tree.routing_style");
        jPanel.add(this.setConstraints(this.edgesRoutingSytle, gridBagLayout, 1, n, 17));
        this.edgesRoutingStyleLabel.setEnabled(this.allowGeneralGraphs.isSelected());
        this.edgesRoutingSytle.setEnabled(this.allowGeneralGraphs.isSelected());
        this.allowGeneralGraphs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeLayoutDialog.this.edgesRoutingStyleLabel.setEnabled(TreeLayoutDialog.this.allowGeneralGraphs.isSelected());
                TreeLayoutDialog.this.edgesRoutingSytle.setEnabled(TreeLayoutDialog.this.allowGeneralGraphs.isSelected());
            }
        });
        this.setLabel(jPanel, "tree.act_on_selection_only", gridBagLayout, 0, ++n, 17);
        this.selectionOnly = new JCheckBox();
        this.selectionOnly.setSelected(properties.getPropertyBoolean("tree.act_on_selection_only"));
        jPanel.add(this.setConstraints(this.selectionOnly, gridBagLayout, 1, n, 17));
        return this.resizePanel(jPanel);
    }

    private JPanel createDirectedPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        int n = -1;
        this.setLabel(jPanel, "tree.minimal_node_distance", gridBagLayout, 0, ++n, 18);
        this.nodeDistance = this.createSliderInt("tree.minimal_node_distance.min", "tree.minimal_node_distance.max", "tree.minimal_node_distance");
        this.nodeDistanceText = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("tree.minimal_node_distance"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.nodeDistance, this.nodeDistanceText), gridBagLayout, 1, n, 17));
        this.setLabel(jPanel, "tree.minimal_layer_distance", gridBagLayout, 0, ++n, 18);
        this.layerDistance = this.createSliderInt("tree.minimal_layer_distance.min", "tree.minimal_layer_distance.max", "tree.minimal_layer_distance");
        this.layerDistanceText = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("tree.minimal_layer_distance"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.layerDistance, this.layerDistanceText), gridBagLayout, 1, n, 17));
        this.setLabel(jPanel, "tree.orientation", gridBagLayout, 0, ++n, 17);
        Object[] objectArray = new Object[]{new OrientationItem("tree.orientation.top_to_bottom", 0), new OrientationItem("tree.orientation.left_to_right", 1), new OrientationItem("tree.orientation.botoom_to_top", 2), new OrientationItem("tree.orientation.right_to_left", 3)};
        this.orientation = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.orientation, "tree.orientation");
        jPanel.add(this.setConstraints(this.orientation, gridBagLayout, 1, n, 17));
        this.setLabel(jPanel, "tree.port_style", gridBagLayout, 0, ++n, 17);
        objectArray = new Object[]{new PortStyleItem("tree.port_style.node_centered", 0), new PortStyleItem("tree.port_style.border_centered", 1), new PortStyleItem("tree.port_style.border_distributed", 2)};
        this.portStyle = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.portStyle, "tree.port_style");
        jPanel.add(this.setConstraints(this.portStyle, gridBagLayout, 1, n, 17));
        this.setLabel(jPanel, "tree.orthogonal_edge_routing", gridBagLayout, 0, ++n, 17);
        this.orthogonalEdgeRouting = new JCheckBox();
        this.orthogonalEdgeRouting.setSelected(properties.getPropertyBoolean("tree.orthogonal_edge_routing"));
        jPanel.add(this.setConstraints(this.orthogonalEdgeRouting, gridBagLayout, 1, n, 17));
        this.edgeBusAlignmentLabel = this.createLabel(LayoutResourceBundleUtil.getString("tree.edge_bus_alignment"));
        jPanel.add(this.setConstraints(this.edgeBusAlignmentLabel, gridBagLayout, 0, ++n, 18));
        this.edgeBusAlignment = this.createSliderDouble("tree.edge_bus_alignment.min", "tree.edge_bus_alignment.max", "tree.edge_bus_alignment", "tree.edge_bus_alignment.top", "tree.edge_bus_alignment.bottom");
        this.edgeBusAlignmentText = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("tree.edge_bus_alignment"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.edgeBusAlignment, this.edgeBusAlignmentText), gridBagLayout, 1, n, 17));
        this.edgeBusAlignmentLabel.setEnabled(this.orthogonalEdgeRouting.isSelected());
        this.edgeBusAlignment.setEnabled(this.orthogonalEdgeRouting.isSelected());
        this.edgeBusAlignmentText.setEnabled(this.orthogonalEdgeRouting.isSelected());
        this.orthogonalEdgeRouting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeLayoutDialog.this.edgeBusAlignmentLabel.setEnabled(TreeLayoutDialog.this.orthogonalEdgeRouting.isSelected());
                TreeLayoutDialog.this.edgeBusAlignment.setEnabled(TreeLayoutDialog.this.orthogonalEdgeRouting.isSelected());
                TreeLayoutDialog.this.edgeBusAlignmentText.setEnabled(TreeLayoutDialog.this.orthogonalEdgeRouting.isSelected());
            }
        });
        this.setLabel(jPanel, "tree.child_alignment", gridBagLayout, 0, ++n, 18);
        this.childAlignment = this.createSliderDouble("tree.child_alignment.min", "tree.child_alignment.max", "tree.child_alignment", "tree.child_alignment.top", "tree.child_alignment.bottom");
        this.childAlignmentText = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("tree.child_alignment"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.childAlignment, this.childAlignmentText), gridBagLayout, 1, n, 17));
        return this.resizePanel(jPanel);
    }

    private JPanel createBalloonPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        int n = -1;
        this.setLabel(jPanel, "tree.root_node_policy", gridBagLayout, 0, ++n, 17);
        Object[] objectArray = new Object[]{new RootNodePolicyItem("tree.root_node_policy.directed_root", 0), new RootNodePolicyItem("tree.root_node_policy.center_root", 1), new RootNodePolicyItem("tree.root_node_policy.weighted_center_root", 2)};
        this.rootNodePolicy = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.rootNodePolicy, "tree.root_node_policy");
        jPanel.add(this.setConstraints(this.rootNodePolicy, gridBagLayout, 1, n, 17));
        this.setLabel(jPanel, "tree.preferred_child_wedge", gridBagLayout, 0, ++n, 18);
        this.childWedge = this.createSliderInt("tree.preferred_child_wedge.min", "tree.preferred_child_wedge.max", "tree.preferred_child_wedge");
        this.childWedgeText = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("tree.preferred_child_wedge"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.childWedge, this.childWedgeText), gridBagLayout, 1, n, 17));
        this.setLabel(jPanel, "tree.preferred_root_wedge", gridBagLayout, 0, ++n, 18);
        this.rootWedge = this.createSliderInt("tree.preferred_root_wedge.min", "tree.preferred_root_wedge.max", "tree.preferred_root_wedge");
        this.rootWedgeText = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("tree.preferred_root_wedge"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.rootWedge, this.rootWedgeText), gridBagLayout, 1, n, 17));
        this.setLabel(jPanel, "tree.minimal_edge_length", gridBagLayout, 0, ++n, 18);
        this.edgeLength = this.createSliderInt("tree.minimal_edge_length.min", "tree.minimal_edge_length.max", "tree.minimal_edge_length");
        this.edgeLengthText = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("tree.minimal_edge_length"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.edgeLength, this.edgeLengthText), gridBagLayout, 1, n, 17));
        this.setLabel(jPanel, "tree.compactness_factor", gridBagLayout, 0, ++n, 18);
        this.compactness = this.createSliderDouble("tree.compactness_factor.min", "tree.compactness_factor.max", "tree.compactness_factor");
        this.compactnessText = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("tree.compactness_factor"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.compactness, this.compactnessText), gridBagLayout, 1, n, 17));
        this.setLabel(jPanel, "tree.allow_overlaps", gridBagLayout, 0, ++n, 17);
        this.allowOverlaps = new JCheckBox();
        this.allowOverlaps.setSelected(properties.getPropertyBoolean("tree.allow_overlaps"));
        jPanel.add(this.setConstraints(this.allowOverlaps, gridBagLayout, 1, n, 17));
        this.setLabel(jPanel, "tree.use_drawing_as_sketch", gridBagLayout, 0, ++n, 17);
        this.sketch = new JCheckBox();
        this.sketch.setSelected(properties.getPropertyBoolean("tree.use_drawing_as_sketch"));
        jPanel.add(this.setConstraints(this.sketch, gridBagLayout, 1, n, 17));
        return this.resizePanel(jPanel);
    }

    private JPanel createHorizontalVerticalPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        int n = -1;
        this.setLabel(jPanel, "tree.horizontal_spacing", gridBagLayout, 0, ++n, 17);
        this.horizontalSpacing = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("tree.horizontal_spacing"), 10);
        jPanel.add(this.setConstraints(this.horizontalSpacing, gridBagLayout, 1, n, 17));
        this.setLabel(jPanel, "tree.vertical_spacing", gridBagLayout, 0, ++n, 17);
        this.verticalSpacing = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("tree.vertical_spacing"), 10);
        jPanel.add(this.setConstraints(this.verticalSpacing, gridBagLayout, 1, n, 17));
        return this.resizePanel(jPanel);
    }

    private JPanel createCompactPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        int n = -1;
        this.setLabel(jPanel, "tree.compact.horizontal_spacing", gridBagLayout, 0, ++n, 17);
        this.cHorizontalSpacing = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("tree.compact.horizontal_spacing"), 10);
        jPanel.add(this.setConstraints(this.cHorizontalSpacing, gridBagLayout, 1, n, 17));
        this.setLabel(jPanel, "tree.compact.vertical_spacing", gridBagLayout, 0, ++n, 17);
        this.cVerticalSpacing = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("tree.compact.vertical_spacing"), 10);
        jPanel.add(this.setConstraints(this.cVerticalSpacing, gridBagLayout, 1, n, 17));
        this.setLabel(jPanel, "tree.bend_distance", gridBagLayout, 0, ++n, 17);
        this.bendDistance = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("tree.bend_distance"), 10);
        jPanel.add(this.setConstraints(this.bendDistance, gridBagLayout, 1, n, 17));
        this.setLabel(jPanel, "tree.preferred_aspect_ratio", gridBagLayout, 0, ++n, 17);
        this.aspectRatio = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("tree.preferred_aspect_ratio"), 10);
        jPanel.add(this.setConstraints(this.aspectRatio, gridBagLayout, 1, n, 17));
        this.setLabel(jPanel, "tree.use_aspect_ratio_of_view", gridBagLayout, 0, ++n, 17);
        this.aspectRatioOfView = new JCheckBox();
        this.aspectRatioOfView.setSelected(properties.getPropertyBoolean("tree.use_aspect_ratio_of_view"));
        jPanel.add(this.setConstraints(this.aspectRatioOfView, gridBagLayout, 1, n, 17));
        return this.resizePanel(jPanel);
    }

    private class OrientationItem
    extends YDialog.AbstractItem {
        byte orientation;

        public OrientationItem(String string, byte by) {
            super(TreeLayoutDialog.this, string);
            this.orientation = by;
        }
    }

    private class PortStyleItem
    extends YDialog.AbstractItem {
        int style;

        public PortStyleItem(String string, int n) {
            super(TreeLayoutDialog.this, string);
            this.style = n;
        }
    }

    private class RootNodePolicyItem
    extends YDialog.AbstractItem {
        byte policy;

        public RootNodePolicyItem(String string, byte by) {
            super(TreeLayoutDialog.this, string);
            this.policy = by;
        }
    }

    private class StyleItem
    extends YDialog.AbstractItem {
        String style;

        public StyleItem(String string, String string2) {
            super(TreeLayoutDialog.this, string);
            this.style = string2;
        }
    }
}

