/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.autoLayout.y.option;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jp.sbi.sbml.autoLayout.y.option.LayoutResourceBundleUtil;
import jp.sbi.sbml.autoLayout.y.option.OptionHandler;
import jp.sbi.sbml.autoLayout.y.option.YDialog;

public class SmartOrganicLayoutDialog
extends YDialog {
    private JComboBox scope;
    private JSlider edgeLengthSlider;
    private JTextField edgeLengthText;
    private JCheckBox sizes;
    private JCheckBox overlapping;
    private JSlider distanceSlider;
    private JTextField distanceText;
    private JSlider compactnessSlider;
    private JTextField compactnessText;
    private JComboBox restrict;
    private JPanel restrictOption;
    private Rectangular rectangular;
    private Circular circular;
    private AspectRatio aspectRatio;
    private Elliptical elliptical;
    private JComboBox layoutPolicy;
    private JSlider qualitySlider;
    private JTextField qualityText;
    private JTextField durationText;
    private JCheckBox deterministic;

    public SmartOrganicLayoutDialog(JFrame jFrame) {
        super(jFrame);
        this.init();
    }

    public SmartOrganicLayoutDialog(JDialog jDialog) {
        super(jDialog);
        this.init();
    }

    private void init() {
        this.setTitle(LayoutResourceBundleUtil.getString("smartorganic.title"));
        this.subTitleLabel = new JLabel(LayoutResourceBundleUtil.getString("smartorganic.subtitle"));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(LayoutResourceBundleUtil.getString("smartorganic.visual"), this.getVisualPanel());
        jTabbedPane.addTab(LayoutResourceBundleUtil.getString("smartorganic.restrictions"), this.getRestrictPanel());
        jTabbedPane.addTab(LayoutResourceBundleUtil.getString("smartorganic.grouping"), this.createGroupingPanel());
        jTabbedPane.addTab(LayoutResourceBundleUtil.getString("smartorganic.algorithm"), this.createAlgorithmPanel());
        this.mainPanel = new JPanel(new BorderLayout(5, 5));
        this.mainPanel.add((Component)this.subTitleLabel, "North");
        this.mainPanel.add((Component)jTabbedPane, "Center");
        this.mainPanel.add((Component)this.controlPane, "South");
        this.getContentPane().setLayout(new FlowLayout(1, 10, 10));
        this.getContentPane().add(this.mainPanel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    public OptionHandler getOptionHandler() {
        if (this.op == null) {
            this.op = new OptionHandler("ORGANIC_LAYOUTER");
        }
        return this.op;
    }

    @Override
    public void setOptionHandler() {
        String string = ((ScopeItem)this.scope.getSelectedItem()).item;
        int n = Integer.parseInt(this.edgeLengthText.getText());
        boolean bl = this.sizes.isSelected();
        boolean bl2 = this.overlapping.isSelected();
        double d = Double.parseDouble(this.distanceText.getText());
        double d2 = Double.parseDouble(this.compactnessText.getText());
        String string2 = this.restrict.getSelectedItem().toString();
        String string3 = this.layoutPolicy.getSelectedItem().toString();
        double d3 = Double.parseDouble(this.qualityText.getText());
        long l = Long.parseLong(this.durationText.getText());
        boolean bl3 = this.deterministic.isSelected();
        this.op = new OptionHandler("ORGANIC_LAYOUTER");
        this.op.addString("LAYOUTER", "SMART_ORGANIC");
        this.op.addByte("SCOPE", ((ScopeItem)this.scope.getSelectedItem()).scope);
        this.op.addInt("PREFERRED_EDGE_LENGTH", n);
        this.op.addBool("OBEY_NODE_SIZES", bl);
        this.op.addBool("ALLOW_OVERLAPPING_NODES", bl2);
        this.op.addDouble("MINIMAL_NODE_DISTTANCE", d);
        this.op.addDouble("COMPACTNESS", d2);
        if (string2.equals(this.rectangular.NAME)) {
            this.op.addString("RESTRICT", "RECTANGULAR");
        } else if (string2.equals(this.circular.NAME)) {
            this.op.addString("RESTRICT", "CIRCULAR");
        } else if (string2.equals(this.aspectRatio.NAME)) {
            this.op.addString("RESTRICT", "ASPECT_RATIO");
        } else if (string2.equals(this.elliptical.NAME)) {
            this.op.addString("RESTRICT", "ELLIPTICAL");
        } else {
            this.op.addString("RESTRICT", "UNRESTRICTED");
        }
        this.op.addString("GROUP_LAYOUT_POLICY", string3);
        String string4 = LayoutResourceBundleUtil.getString("smartorganic.grouping.group_layout_policy.fix_contents_of_groups");
        String string5 = LayoutResourceBundleUtil.getString("smartorganic.grouping.group_layout_policy.fix_bounds_of_groups");
        if (string3.equals(string4)) {
            this.op.addBool("FIX_GROUPS", true);
        } else if (string3.equals(string5)) {
            this.op.addBool("FIX_BOUNDS", true);
        } else {
            this.op.addBool("LAYOUT_GROUPS", true);
        }
        this.op.addDouble("QUALITY_TIME_RATIO", d3);
        this.op.addLong("MAXIMAL_DURATION", l);
        this.op.addBool("ACTIVATE_DETERMINISTIC_MODE", bl3);
        properties.setProperty("smartorganic.scope", string);
        properties.setProperty("smartorganic.preferred_edge_length", n);
        properties.setProperty("smartorganic.obey_node_sizes", bl);
        properties.setProperty("smartorganic.allow_overlapping_nodes", bl2);
        properties.setProperty("smartorganic.minimal_node_distance", d);
        properties.setProperty("smartorganic.compactness", d2);
        properties.setProperty("smartorganic.restrictions.output_area", string2);
        properties.setProperty("smartorganic.grouping.group_layout_policy", string3);
        properties.setProperty("smartorganic.quality_time_ratio", d3);
        properties.setProperty("smartorganic.maximal_duration", l);
        properties.setProperty("smartorganic.activate_deterministic_mode", bl3);
        this.rectangular.setOptionHandler(this.op);
        this.circular.setOptionHandler(this.op);
        this.aspectRatio.setOptionHandler(this.op);
        this.elliptical.setOptionHandler(this.op);
    }

    @Override
    protected void setDefault() {
        this.setDefaultSelectedItem(this.scope, "smartorganic.scope");
        this.edgeLengthSlider.setValue(properties.getDefaultPropertyInt("smartorganic.preferred_edge_length"));
        this.sizes.setSelected(properties.getDefaultPropertyBoolean("smartorganic.obey_node_sizes"));
        this.overlapping.setSelected(properties.getDefaultPropertyBoolean("smartorganic.allow_overlapping_nodes"));
        this.distanceSlider.setValue((int)properties.getDefaultPropertyDouble("smartorganic.minimal_node_distance"));
        this.compactnessSlider.setValue((int)(properties.getDefaultPropertyDouble("smartorganic.compactness") * 10.0));
        this.qualitySlider.setValue((int)(properties.getDefaultPropertyDouble("smartorganic.quality_time_ratio") * 10.0));
        this.durationText.setText(properties.getDefaultProperty("smartorganic.maximal_duration"));
        this.deterministic.setSelected(properties.getDefaultPropertyBoolean("smartorganic.activate_deterministic_mode"));
        this.setDefaultSelectedItem(this.restrict, "smartorganic.restrictions.output_area");
        this.rectangular.setDefault();
        this.circular.setDefault();
        this.aspectRatio.setDefault();
        this.elliptical.setDefault();
        this.setDefaultSelectedItem(this.layoutPolicy, "smartorganic.grouping.group_layout_policy");
        this.distanceSlider.setEnabled(true);
        this.distanceText.setEnabled(true);
    }

    private JPanel getVisualPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.setLabel(jPanel, "smartorganic.scope", gridBagLayout, 0, 0, 17);
        Object[] objectArray = new Object[]{new ScopeItem("smartorganic.scope.all", 0), new ScopeItem("smartorganic.scope.mainly_selection", 1), new ScopeItem("smartorganic.scope.only_selection", 2)};
        this.scope = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.scope, "smartorganic.scope");
        jPanel.add(this.setConstraints(this.scope, gridBagLayout, 1, 0, 13));
        this.setLabel(jPanel, "smartorganic.preferred_edge_length", gridBagLayout, 0, 1, 18);
        this.edgeLengthSlider = this.createSliderInt("smartorganic.preferred_edge_length.min", "smartorganic.preferred_edge_length.max", "smartorganic.preferred_edge_length");
        this.edgeLengthText = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("smartorganic.preferred_edge_length"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.edgeLengthSlider, this.edgeLengthText), gridBagLayout, 1, 1, 13));
        this.setLabel(jPanel, "smartorganic.obey_node_sizes", gridBagLayout, 0, 2, 17);
        this.sizes = new JCheckBox();
        this.sizes.setSelected(properties.getPropertyBoolean("smartorganic.obey_node_sizes"));
        jPanel.add(this.setConstraints(this.sizes, gridBagLayout, 1, 2, 17));
        this.setLabel(jPanel, "smartorganic.allow_overlapping_nodes", gridBagLayout, 0, 3, 17);
        this.overlapping = new JCheckBox();
        this.overlapping.setSelected(properties.getPropertyBoolean("smartorganic.allow_overlapping_nodes"));
        this.overlapping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SmartOrganicLayoutDialog.this.distanceSlider.setEnabled(!SmartOrganicLayoutDialog.this.overlapping.isSelected());
                SmartOrganicLayoutDialog.this.distanceText.setEnabled(!SmartOrganicLayoutDialog.this.overlapping.isSelected());
            }
        });
        jPanel.add(this.setConstraints(this.overlapping, gridBagLayout, 1, 3, 17));
        this.setLabel(jPanel, "smartorganic.minimal_node_distance", gridBagLayout, 0, 4, 18);
        this.distanceSlider = this.createSliderDouble("smartorganic.minimal_node_distance.min", "smartorganic.minimal_node_distance.max", "smartorganic.minimal_node_distance");
        this.distanceText = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("smartorganic.minimal_node_distance"), 4);
        this.distanceText.setEnabled(!this.overlapping.isSelected());
        jPanel.add(this.setConstraints(this.createSliderPanel(this.distanceSlider, this.distanceText), gridBagLayout, 1, 4, 13));
        this.setLabel(jPanel, "smartorganic.compactness", gridBagLayout, 0, 5, 18);
        this.compactnessSlider = this.createSliderDouble("smartorganic.compactness.min", "smartorganic.compactness.max", "smartorganic.compactness");
        this.compactnessText = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("smartorganic.compactness"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.compactnessSlider, this.compactnessText), gridBagLayout, 1, 5, 13));
        return this.resizePanel(jPanel);
    }

    private JPanel getRestrictPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.setLabel(jPanel, "smartorganic.restrictions.output_area", gridBagLayout, 0, 0, 17);
        final YDialog.DefaultItem[] defaultItemArray = new YDialog.DefaultItem[]{new YDialog.DefaultItem(this, "smartorganic.restrictions.output_area.unrestricted"), new YDialog.DefaultItem(this, "smartorganic.restrictions.output_area.rectangular"), new YDialog.DefaultItem(this, "smartorganic.restrictions.output_area.circular"), new YDialog.DefaultItem(this, "smartorganic.restrictions.output_area.aspect_raito"), new YDialog.DefaultItem(this, "smartorganic.restrictions.output_area.elliptical")};
        this.restrict = new JComboBox<YDialog.DefaultItem>(defaultItemArray);
        jPanel.add(this.setConstraints(this.restrict, gridBagLayout, 1, 0, 13));
        this.rectangular = new Rectangular();
        this.circular = new Circular();
        this.aspectRatio = new AspectRatio();
        this.elliptical = new Elliptical();
        final JPanel jPanel2 = new JPanel();
        final CardLayout cardLayout = new CardLayout();
        jPanel2.setLayout(cardLayout);
        jPanel2.add((Component)this.rectangular, defaultItemArray[1].item);
        jPanel2.add((Component)this.circular, defaultItemArray[2].item);
        jPanel2.add((Component)this.aspectRatio, defaultItemArray[3].item);
        jPanel2.add((Component)this.elliptical, defaultItemArray[4].item);
        this.restrict.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                YDialog.DefaultItem defaultItem = (YDialog.DefaultItem)itemEvent.getItem();
                if (defaultItem.equals(defaultItemArray[0])) {
                    SmartOrganicLayoutDialog.this.rectangular.setEnabled(false);
                    SmartOrganicLayoutDialog.this.circular.setEnabled(false);
                    SmartOrganicLayoutDialog.this.aspectRatio.setEnabled(false);
                    SmartOrganicLayoutDialog.this.elliptical.setEnabled(false);
                } else {
                    SmartOrganicLayoutDialog.this.rectangular.setEnabled(true);
                    SmartOrganicLayoutDialog.this.circular.setEnabled(true);
                    SmartOrganicLayoutDialog.this.aspectRatio.setEnabled(true);
                    SmartOrganicLayoutDialog.this.elliptical.setEnabled(true);
                }
                cardLayout.show(jPanel2, defaultItem.item);
            }
        });
        int n = 0;
        while (n < defaultItemArray.length) {
            if (defaultItemArray[n].equals(properties.getProperty("smartorganic.restrictions.output_area"))) {
                this.restrict.setSelectedIndex(n);
                if (!this.restrict.getSelectedItem().equals(defaultItemArray[0])) break;
                this.rectangular.setEnabled(false);
                this.circular.setEnabled(false);
                this.aspectRatio.setEnabled(false);
                this.elliptical.setEnabled(false);
                break;
            }
            ++n;
        }
        jPanel.add(this.setConstraints(jPanel2, gridBagLayout, 0, 1, 2, 1, 10));
        return this.resizePanel(jPanel);
    }

    private JPanel createGroupingPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.setLabel(jPanel, "smartorganic.grouping.group_layout_policy", gridBagLayout, 0, 0, 18);
        Object[] objectArray = new Object[]{new YDialog.GroupingPolicyItem(this, "smartorganic.grouping.group_layout_policy.layout_groups"), new YDialog.GroupingPolicyItem(this, "smartorganic.grouping.group_layout_policy.fix_contents_of_groups"), new YDialog.GroupingPolicyItem(this, "smartorganic.grouping.group_layout_policy.fix_bounds_of_groups")};
        this.layoutPolicy = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.layoutPolicy, "smartorganic.grouping.group_layout_policy");
        jPanel.add(this.setConstraints(this.layoutPolicy, gridBagLayout, 1, 0, 13));
        return this.resizePanel(jPanel);
    }

    private JPanel createAlgorithmPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.setLabel(jPanel, "smartorganic.quality_time_ratio", gridBagLayout, 0, 0, 18);
        this.qualitySlider = this.createSliderDouble("smartorganic.quality_time_ratio.min", "smartorganic.quality_time_ratio.max", "smartorganic.quality_time_ratio", "smartorganic.quality_time_ratio.speed", "smartorganic.quality_time_ratio.quality");
        this.qualityText = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("smartorganic.quality_time_ratio"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.qualitySlider, this.qualityText), gridBagLayout, 1, 0, 13));
        this.qualitySlider.setPreferredSize(new Dimension(this.qualitySlider.getPreferredSize().width + 15, this.qualitySlider.getPreferredSize().height));
        this.setLabel(jPanel, "smartorganic.maximal_duration", gridBagLayout, 0, 1, 17);
        this.durationText = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("smartorganic.maximal_duration"), 10);
        jPanel.add(this.setConstraints(this.durationText, gridBagLayout, 1, 1, 17));
        this.setLabel(jPanel, "smartorganic.activate_deterministic_mode", gridBagLayout, 0, 2, 17);
        this.deterministic = new JCheckBox();
        this.deterministic.setSelected(properties.getPropertyBoolean("smartorganic.activate_deterministic_mode"));
        jPanel.add(this.setConstraints(this.deterministic, gridBagLayout, 1, 2, 17));
        return this.resizePanel(jPanel);
    }

    @Override
    protected JPanel resizePanel(JPanel jPanel) {
        jPanel.setPreferredSize(new Dimension(460, jPanel.getPreferredSize().height));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jPanel);
        return jPanel2;
    }

    class AspectRatio
    extends OptionPanel {
        final String NAME;
        final String KEY_USE = "smartorganic.restrictions.output_area.aspect_raito.use";
        final String KEY_ASPECT_RATIO = "smartorganic.restrictions.output_area.aspect_raito.ratio";
        JTextField ratio;

        AspectRatio() {
            this.NAME = LayoutResourceBundleUtil.getString("smartorganic.restrictions.output_area.aspect_raito");
            this.KEY_USE = "smartorganic.restrictions.output_area.aspect_raito.use";
            this.KEY_ASPECT_RATIO = "smartorganic.restrictions.output_area.aspect_raito.ratio";
            this.setBorder(BorderFactory.createTitledBorder(this.NAME));
            boolean bl = properties.getPropertyBoolean("smartorganic.restrictions.output_area.aspect_raito.use");
            this.use = new JCheckBox(this.useAction);
            this.use.setSelected(bl);
            this.ratio = new JTextField(new YDialog.DoubleDocument(SmartOrganicLayoutDialog.this), properties.getProperty("smartorganic.restrictions.output_area.aspect_raito.ratio"), 10);
            this.setOptionEnabled(!bl);
            this.panel = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.panel.setLayout(gridBagLayout);
            SmartOrganicLayoutDialog.this.setLabel(this.panel, "smartorganic.restrictions.output_area.aspect_raito.use", gridBagLayout, 0, 0, 17);
            this.panel.add(SmartOrganicLayoutDialog.this.setConstraints(this.use, gridBagLayout, 1, 0, 17));
            SmartOrganicLayoutDialog.this.setLabel(this.panel, "smartorganic.restrictions.output_area.aspect_raito.ratio", gridBagLayout, 0, 1, 17);
            this.panel.add(SmartOrganicLayoutDialog.this.setConstraints(this.ratio, gridBagLayout, 1, 1, 13));
            this.add((Component)this.panel, "North");
        }

        @Override
        void setOptionEnabled(boolean bl) {
            this.ratio.setEnabled(bl);
        }

        @Override
        void setDefault() {
            this.use.setSelected(properties.getDefaultPropertyBoolean("smartorganic.restrictions.output_area.aspect_raito.use"));
            this.ratio.setText(properties.getDefaultProperty("smartorganic.restrictions.output_area.aspect_raito.ratio"));
            this.setOptionEnabled(!this.use.isSelected());
        }

        @Override
        void setOptionHandler(OptionHandler optionHandler) {
            boolean bl = this.use.isSelected();
            double d = Double.parseDouble(this.ratio.getText());
            optionHandler.addBool("ASPECT_RATIO_USE", bl);
            if (!bl) {
                optionHandler.addDouble("ASPECT_RATIO_RATIO", d);
            } else {
                optionHandler.addDouble("ASPECT_RATIO_RATIO", properties.getDefaultPropertyDouble("smartorganic.restrictions.output_area.aspect_raito.ratio"));
            }
            properties.setProperty("smartorganic.restrictions.output_area.aspect_raito.use", bl);
            properties.setProperty("smartorganic.restrictions.output_area.aspect_raito.ratio", d);
        }
    }

    class Circular
    extends OptionPanel {
        final String NAME;
        final String KEY_USE = "smartorganic.restrictions.output_area.circular.use";
        final String KEY_CENTER_X = "smartorganic.restrictions.output_area.circular.center_x";
        final String KEY_CENTER_Y = "smartorganic.restrictions.output_area.circular.center_y";
        final String KEY_RADIUS = "smartorganic.restrictions.output_area.circular.radius";
        JTextField centerX;
        JTextField centerY;
        JTextField radius;

        Circular() {
            this.NAME = LayoutResourceBundleUtil.getString("smartorganic.restrictions.output_area.circular");
            this.KEY_USE = "smartorganic.restrictions.output_area.circular.use";
            this.KEY_CENTER_X = "smartorganic.restrictions.output_area.circular.center_x";
            this.KEY_CENTER_Y = "smartorganic.restrictions.output_area.circular.center_y";
            this.KEY_RADIUS = "smartorganic.restrictions.output_area.circular.radius";
            this.setBorder(BorderFactory.createTitledBorder(this.NAME));
            boolean bl = properties.getPropertyBoolean("smartorganic.restrictions.output_area.circular.use");
            this.use = new JCheckBox(this.useAction);
            this.use.setSelected(bl);
            this.centerX = new JTextField(new YDialog.DoubleDocument(SmartOrganicLayoutDialog.this), properties.getProperty("smartorganic.restrictions.output_area.circular.center_x"), 10);
            this.centerY = new JTextField(new YDialog.DoubleDocument(SmartOrganicLayoutDialog.this), properties.getProperty("smartorganic.restrictions.output_area.circular.center_y"), 10);
            this.radius = new JTextField(new YDialog.DoubleDocument(SmartOrganicLayoutDialog.this), properties.getProperty("smartorganic.restrictions.output_area.circular.radius"), 10);
            this.setOptionEnabled(!bl);
            this.panel = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.panel.setLayout(gridBagLayout);
            SmartOrganicLayoutDialog.this.setLabel(this.panel, "smartorganic.restrictions.output_area.circular.use", gridBagLayout, 0, 0, 17);
            this.panel.add(SmartOrganicLayoutDialog.this.setConstraints(this.use, gridBagLayout, 1, 0, 17));
            SmartOrganicLayoutDialog.this.setLabel(this.panel, "smartorganic.restrictions.output_area.circular.center_x", gridBagLayout, 0, 1, 17);
            this.panel.add(SmartOrganicLayoutDialog.this.setConstraints(this.centerX, gridBagLayout, 1, 1, 13));
            SmartOrganicLayoutDialog.this.setLabel(this.panel, "smartorganic.restrictions.output_area.circular.center_y", gridBagLayout, 0, 2, 17);
            this.panel.add(SmartOrganicLayoutDialog.this.setConstraints(this.centerY, gridBagLayout, 1, 2, 13));
            SmartOrganicLayoutDialog.this.setLabel(this.panel, "smartorganic.restrictions.output_area.circular.radius", gridBagLayout, 0, 3, 17);
            this.panel.add(SmartOrganicLayoutDialog.this.setConstraints(this.radius, gridBagLayout, 1, 3, 13));
            this.add((Component)this.panel, "North");
        }

        @Override
        void setOptionEnabled(boolean bl) {
            this.centerX.setEnabled(bl);
            this.centerY.setEnabled(bl);
            this.radius.setEnabled(bl);
        }

        @Override
        void setDefault() {
            this.use.setSelected(properties.getDefaultPropertyBoolean("smartorganic.restrictions.output_area.circular.use"));
            this.centerX.setText(properties.getDefaultProperty("smartorganic.restrictions.output_area.circular.center_x"));
            this.centerY.setText(properties.getDefaultProperty("smartorganic.restrictions.output_area.circular.center_y"));
            this.radius.setText(properties.getDefaultProperty("smartorganic.restrictions.output_area.circular.radius"));
            this.setOptionEnabled(!this.use.isSelected());
        }

        @Override
        void setOptionHandler(OptionHandler optionHandler) {
            boolean bl = this.use.isSelected();
            double d = Double.parseDouble(this.centerX.getText());
            double d2 = Double.parseDouble(this.centerY.getText());
            double d3 = Double.parseDouble(this.radius.getText());
            optionHandler.addBool("CIRCULAR_USE", bl);
            if (!bl) {
                optionHandler.addDouble("CIRCULAR_CENTER_X", d);
                optionHandler.addDouble("CIRCULAR_CENTER_Y", d2);
                optionHandler.addDouble("CIRCULAR_RADIUS", d3);
            } else {
                optionHandler.addDouble("CIRCULAR_CENTER_X", properties.getDefaultPropertyDouble("smartorganic.restrictions.output_area.circular.center_x"));
                optionHandler.addDouble("CIRCULAR_CENTER_Y", properties.getDefaultPropertyDouble("smartorganic.restrictions.output_area.circular.center_y"));
                optionHandler.addDouble("CIRCULAR_RADIUS", properties.getDefaultPropertyDouble("smartorganic.restrictions.output_area.circular.radius"));
            }
            properties.setProperty("smartorganic.restrictions.output_area.circular.use", bl);
            properties.setProperty("smartorganic.restrictions.output_area.circular.center_x", d);
            properties.setProperty("smartorganic.restrictions.output_area.circular.center_y", d2);
            properties.setProperty("smartorganic.restrictions.output_area.circular.radius", d3);
        }
    }

    class Elliptical
    extends OptionPanel {
        final String NAME;
        final String KEY_USE = "smartorganic.restrictions.output_area.elliptical.use";
        final String KEY_TOP_LEFT_X = "smartorganic.restrictions.output_area.elliptical.top_left_x";
        final String KEY_TOP_LEFT_Y = "smartorganic.restrictions.output_area.elliptical.top_left_y";
        final String KEY_WIDTH = "smartorganic.restrictions.output_area.elliptical.width";
        final String KEY_HEIGHT = "smartorganic.restrictions.output_area.elliptical.height";
        JTextField topLeftX;
        JTextField topLeftY;
        JTextField width;
        JTextField height;

        Elliptical() {
            this.NAME = LayoutResourceBundleUtil.getString("smartorganic.restrictions.output_area.elliptical");
            this.KEY_USE = "smartorganic.restrictions.output_area.elliptical.use";
            this.KEY_TOP_LEFT_X = "smartorganic.restrictions.output_area.elliptical.top_left_x";
            this.KEY_TOP_LEFT_Y = "smartorganic.restrictions.output_area.elliptical.top_left_y";
            this.KEY_WIDTH = "smartorganic.restrictions.output_area.elliptical.width";
            this.KEY_HEIGHT = "smartorganic.restrictions.output_area.elliptical.height";
            this.setBorder(BorderFactory.createTitledBorder(this.NAME));
            boolean bl = properties.getPropertyBoolean("smartorganic.restrictions.output_area.elliptical.use");
            this.use = new JCheckBox(this.useAction);
            this.use.setSelected(bl);
            this.topLeftX = new JTextField(new YDialog.DoubleDocument(SmartOrganicLayoutDialog.this), properties.getProperty("smartorganic.restrictions.output_area.elliptical.top_left_x"), 10);
            this.topLeftY = new JTextField(new YDialog.DoubleDocument(SmartOrganicLayoutDialog.this), properties.getProperty("smartorganic.restrictions.output_area.elliptical.top_left_y"), 10);
            this.topLeftY.setEnabled(bl);
            this.width = new JTextField(new YDialog.DoubleDocument(SmartOrganicLayoutDialog.this), properties.getProperty("smartorganic.restrictions.output_area.elliptical.width"), 10);
            this.height = new JTextField(new YDialog.DoubleDocument(SmartOrganicLayoutDialog.this), properties.getProperty("smartorganic.restrictions.output_area.elliptical.height"), 10);
            this.setOptionEnabled(!bl);
            this.panel = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.panel.setLayout(gridBagLayout);
            SmartOrganicLayoutDialog.this.setLabel(this.panel, "smartorganic.restrictions.output_area.elliptical.use", gridBagLayout, 0, 0, 17);
            this.panel.add(SmartOrganicLayoutDialog.this.setConstraints(this.use, gridBagLayout, 1, 0, 17));
            SmartOrganicLayoutDialog.this.setLabel(this.panel, "smartorganic.restrictions.output_area.elliptical.top_left_x", gridBagLayout, 0, 1, 17);
            this.panel.add(SmartOrganicLayoutDialog.this.setConstraints(this.topLeftX, gridBagLayout, 1, 1, 13));
            SmartOrganicLayoutDialog.this.setLabel(this.panel, "smartorganic.restrictions.output_area.elliptical.top_left_y", gridBagLayout, 0, 2, 17);
            this.panel.add(SmartOrganicLayoutDialog.this.setConstraints(this.topLeftY, gridBagLayout, 1, 2, 13));
            SmartOrganicLayoutDialog.this.setLabel(this.panel, "smartorganic.restrictions.output_area.elliptical.width", gridBagLayout, 0, 3, 17);
            this.panel.add(SmartOrganicLayoutDialog.this.setConstraints(this.width, gridBagLayout, 1, 3, 13));
            SmartOrganicLayoutDialog.this.setLabel(this.panel, "smartorganic.restrictions.output_area.elliptical.height", gridBagLayout, 0, 4, 17);
            this.panel.add(SmartOrganicLayoutDialog.this.setConstraints(this.height, gridBagLayout, 1, 4, 13));
            this.add((Component)this.panel, "North");
        }

        @Override
        void setOptionEnabled(boolean bl) {
            this.topLeftX.setEnabled(bl);
            this.topLeftY.setEnabled(bl);
            this.width.setEnabled(bl);
            this.height.setEnabled(bl);
        }

        @Override
        void setDefault() {
            this.use.setSelected(properties.getDefaultPropertyBoolean("smartorganic.restrictions.output_area.elliptical.use"));
            this.topLeftX.setText(properties.getDefaultProperty("smartorganic.restrictions.output_area.elliptical.top_left_x"));
            this.topLeftY.setText(properties.getDefaultProperty("smartorganic.restrictions.output_area.elliptical.top_left_y"));
            this.width.setText(properties.getDefaultProperty("smartorganic.restrictions.output_area.elliptical.width"));
            this.height.setText(properties.getDefaultProperty("smartorganic.restrictions.output_area.elliptical.height"));
            this.setOptionEnabled(!this.use.isSelected());
        }

        @Override
        void setOptionHandler(OptionHandler optionHandler) {
            boolean bl = this.use.isSelected();
            double d = Double.parseDouble(this.topLeftX.getText());
            double d2 = Double.parseDouble(this.topLeftY.getText());
            double d3 = Double.parseDouble(this.width.getText());
            double d4 = Double.parseDouble(this.height.getText());
            optionHandler.addBool("ELLIPTICAL_USE", bl);
            if (!bl) {
                optionHandler.addDouble("ELLIPTICAL_TOP_LEFT_X", d);
                optionHandler.addDouble("ELLIPTICAL_TOP_LEFT_Y", d2);
                optionHandler.addDouble("ELLIPTICAL_WIDTH", d3);
                optionHandler.addDouble("ELLIPTICAL_HEIGHT", d4);
            } else {
                optionHandler.addDouble("ELLIPTICAL_TOP_LEFT_X", properties.getDefaultPropertyDouble("smartorganic.restrictions.output_area.elliptical.top_left_x"));
                optionHandler.addDouble("ELLIPTICAL_TOP_LEFT_Y", properties.getDefaultPropertyDouble("smartorganic.restrictions.output_area.elliptical.top_left_y"));
                optionHandler.addDouble("ELLIPTICAL_WIDTH", properties.getDefaultPropertyDouble("smartorganic.restrictions.output_area.elliptical.width"));
                optionHandler.addDouble("ELLIPTICAL_HEIGHT", properties.getDefaultPropertyDouble("smartorganic.restrictions.output_area.elliptical.height"));
            }
            properties.setProperty("smartorganic.restrictions.output_area.elliptical.use", bl);
            properties.setProperty("smartorganic.restrictions.output_area.elliptical.top_left_x", d);
            properties.setProperty("smartorganic.restrictions.output_area.elliptical.top_left_y", d2);
            properties.setProperty("smartorganic.restrictions.output_area.elliptical.width", d3);
            properties.setProperty("smartorganic.restrictions.output_area.elliptical.height", d4);
        }
    }

    abstract class OptionPanel
    extends JPanel {
        JPanel panel;
        JCheckBox use;
        AbstractAction useAction;

        public OptionPanel() {
            super(new BorderLayout());
            this.useAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionPanel.this.setLabelEnabled(!OptionPanel.this.use.isSelected());
                    OptionPanel.this.setOptionEnabled(!OptionPanel.this.use.isSelected());
                }
            };
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            boolean bl2 = this.use.isSelected();
            if (!bl || bl2) {
                bl2 = false;
            } else if (bl && !bl2) {
                bl2 = true;
            }
            this.use.setEnabled(bl);
            Component[] componentArray = this.panel.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof JLabel || componentArray[n] instanceof JTextField) {
                    componentArray[n].setEnabled(bl2);
                }
                ++n;
            }
        }

        void setLabelEnabled(boolean bl) {
            Component[] componentArray = this.panel.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof JLabel) {
                    componentArray[n].setEnabled(bl);
                }
                ++n;
            }
        }

        abstract void setOptionEnabled(boolean var1);

        abstract void setDefault();

        abstract void setOptionHandler(OptionHandler var1);
    }

    class Rectangular
    extends OptionPanel {
        final String NAME = LayoutResourceBundleUtil.getString("smartorganic.restrictions.output_area.rectangular");
        final String KEY_USE = "smartorganic.restrictions.output_area.rectangular.use";
        final String KEY_TOP_LEFT_X = "smartorganic.restrictions.output_area.rectangular.top_left_x";
        final String KEY_TOP_LEFT_Y = "smartorganic.restrictions.output_area.rectangular.top_left_y";
        final String KEY_WIDTH = "smartorganic.restrictions.output_area.rectangular.width";
        final String KEY_HEIGHT = "smartorganic.restrictions.output_area.rectangular.height";
        JTextField topLeftX;
        JTextField topLeftY;
        JTextField width;
        JTextField height;

        Rectangular() {
            this.setBorder(BorderFactory.createTitledBorder(this.NAME));
            boolean bl = properties.getPropertyBoolean("smartorganic.restrictions.output_area.rectangular.use");
            this.use = new JCheckBox(this.useAction);
            this.use.setSelected(bl);
            this.topLeftX = new JTextField(new YDialog.DoubleDocument(SmartOrganicLayoutDialog.this), properties.getProperty("smartorganic.restrictions.output_area.rectangular.top_left_x"), 10);
            this.topLeftY = new JTextField(new YDialog.DoubleDocument(SmartOrganicLayoutDialog.this), properties.getProperty("smartorganic.restrictions.output_area.rectangular.top_left_y"), 10);
            this.topLeftY.setEnabled(bl);
            this.width = new JTextField(new YDialog.DoubleDocument(SmartOrganicLayoutDialog.this), properties.getProperty("smartorganic.restrictions.output_area.rectangular.width"), 10);
            this.height = new JTextField(new YDialog.DoubleDocument(SmartOrganicLayoutDialog.this), properties.getProperty("smartorganic.restrictions.output_area.rectangular.height"), 10);
            this.setOptionEnabled(!bl);
            this.panel = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.panel.setLayout(gridBagLayout);
            SmartOrganicLayoutDialog.this.setLabel(this.panel, "smartorganic.restrictions.output_area.rectangular.use", gridBagLayout, 0, 0, 17);
            this.panel.add(SmartOrganicLayoutDialog.this.setConstraints(this.use, gridBagLayout, 1, 0, 17));
            SmartOrganicLayoutDialog.this.setLabel(this.panel, "smartorganic.restrictions.output_area.rectangular.top_left_x", gridBagLayout, 0, 1, 17);
            this.panel.add(SmartOrganicLayoutDialog.this.setConstraints(this.topLeftX, gridBagLayout, 1, 1, 13));
            SmartOrganicLayoutDialog.this.setLabel(this.panel, "smartorganic.restrictions.output_area.rectangular.top_left_y", gridBagLayout, 0, 2, 17);
            this.panel.add(SmartOrganicLayoutDialog.this.setConstraints(this.topLeftY, gridBagLayout, 1, 2, 13));
            SmartOrganicLayoutDialog.this.setLabel(this.panel, "smartorganic.restrictions.output_area.rectangular.width", gridBagLayout, 0, 3, 17);
            this.panel.add(SmartOrganicLayoutDialog.this.setConstraints(this.width, gridBagLayout, 1, 3, 13));
            this.panel.add(SmartOrganicLayoutDialog.this.setConstraints(SmartOrganicLayoutDialog.this.createLabel(LayoutResourceBundleUtil.getString("smartorganic.restrictions.output_area.rectangular.height")), gridBagLayout, 0, 4, 17));
            this.panel.add(SmartOrganicLayoutDialog.this.setConstraints(this.height, gridBagLayout, 1, 4, 13));
            this.add((Component)this.panel, "North");
        }

        @Override
        void setOptionEnabled(boolean bl) {
            this.topLeftX.setEnabled(bl);
            this.topLeftY.setEnabled(bl);
            this.width.setEnabled(bl);
            this.height.setEnabled(bl);
        }

        @Override
        void setDefault() {
            this.use.setSelected(properties.getDefaultPropertyBoolean("smartorganic.restrictions.output_area.rectangular.use"));
            this.topLeftX.setText(properties.getDefaultProperty("smartorganic.restrictions.output_area.rectangular.top_left_x"));
            this.topLeftY.setText(properties.getDefaultProperty("smartorganic.restrictions.output_area.rectangular.top_left_y"));
            this.width.setText(properties.getDefaultProperty("smartorganic.restrictions.output_area.rectangular.width"));
            this.height.setText(properties.getDefaultProperty("smartorganic.restrictions.output_area.rectangular.height"));
            this.setOptionEnabled(!this.use.isSelected());
        }

        @Override
        void setOptionHandler(OptionHandler optionHandler) {
            boolean bl = this.use.isSelected();
            double d = Double.parseDouble(this.topLeftX.getText());
            double d2 = Double.parseDouble(this.topLeftY.getText());
            double d3 = Double.parseDouble(this.width.getText());
            double d4 = Double.parseDouble(this.height.getText());
            optionHandler.addBool("RECTANGULAR_USE", bl);
            if (!bl) {
                optionHandler.addDouble("RECTANGULAR_TOP_LEFT_X", d);
                optionHandler.addDouble("RECTANGULAR_TOP_LEFT_Y", d2);
                optionHandler.addDouble("RECTANGULAR_WIDTH", d3);
                optionHandler.addDouble("RECTANGULAR_HEIGHT", d4);
            } else {
                optionHandler.addDouble("RECTANGULAR_TOP_LEFT_X", properties.getDefaultPropertyDouble("smartorganic.restrictions.output_area.rectangular.top_left_x"));
                optionHandler.addDouble("RECTANGULAR_TOP_LEFT_Y", properties.getDefaultPropertyDouble("smartorganic.restrictions.output_area.rectangular.top_left_y"));
                optionHandler.addDouble("RECTANGULAR_WIDTH", properties.getDefaultPropertyDouble("smartorganic.restrictions.output_area.rectangular.width"));
                optionHandler.addDouble("RECTANGULAR_HEIGHT", properties.getDefaultPropertyDouble("smartorganic.restrictions.output_area.rectangular.height"));
            }
            properties.setProperty("smartorganic.restrictions.output_area.rectangular.use", bl);
            properties.setProperty("smartorganic.restrictions.output_area.rectangular.top_left_x", d);
            properties.setProperty("smartorganic.restrictions.output_area.rectangular.top_left_y", d2);
            properties.setProperty("smartorganic.restrictions.output_area.rectangular.width", d3);
            properties.setProperty("smartorganic.restrictions.output_area.rectangular.height", d4);
        }
    }

    private class ScopeItem
    extends YDialog.AbstractItem {
        byte scope;

        public ScopeItem(String string, byte by) {
            super(SmartOrganicLayoutDialog.this, string);
            this.scope = by;
        }
    }
}

