/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.autoLayout.y.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jp.fric.graphics.draw.GStructure;
import jp.sbi.sbml.autoLayout.y.option.LayoutResourceBundleUtil;
import jp.sbi.sbml.autoLayout.y.option.OptionHandler;
import jp.sbi.sbml.autoLayout.y.option.YDialog;

public class OrthogonalLayoutDialog
extends YDialog {
    private JComboBox layoutStyle;
    private JTextField grid;
    private JCheckBox lengthReduction;
    private JCheckBox existingDrawing;
    private JCheckBox crossing;
    private JCheckBox bends;
    private JCheckBox randomization;
    private JComboBox policy;
    private JSlider quality;
    private JTextField qualityText;
    private GStructure structure;

    public OrthogonalLayoutDialog(JFrame jFrame, GStructure gStructure) {
        super(jFrame);
        this.structure = gStructure;
        this.init();
    }

    public OrthogonalLayoutDialog(JDialog jDialog, GStructure gStructure) {
        super(jDialog);
        this.structure = gStructure;
        this.init();
    }

    private void init() {
        this.setTitle(LayoutResourceBundleUtil.getString("orthogonal.title"));
        this.subTitleLabel = new JLabel(LayoutResourceBundleUtil.getString("orthogonal.subtitle"));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(LayoutResourceBundleUtil.getString("orthogonal.layout"), this.createLayoutPanle());
        jTabbedPane.addTab(LayoutResourceBundleUtil.getString("orthogonal.grouping"), this.createGroupingPanel());
        this.mainPanel = new JPanel(new BorderLayout(5, 5));
        this.mainPanel.add((Component)this.subTitleLabel, "North");
        this.mainPanel.add((Component)jTabbedPane, "Center");
        this.mainPanel.add((Component)this.controlPane, "South");
        this.getContentPane().setLayout(new FlowLayout(1, 10, 10));
        this.getContentPane().add(this.mainPanel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    public OptionHandler getOptionHandler() {
        if (this.op == null) {
            this.op = new OptionHandler("ORTHOGONAL_LAYOUTER");
        }
        return this.op;
    }

    @Override
    public void setOptionHandler() {
        StyleItem styleItem = (StyleItem)this.layoutStyle.getSelectedItem();
        int n = Integer.parseInt(this.grid.getText());
        boolean bl = this.lengthReduction.isSelected();
        boolean bl2 = this.existingDrawing.isSelected();
        boolean bl3 = this.crossing.isSelected();
        boolean bl4 = this.bends.isSelected();
        boolean bl5 = this.randomization.isSelected();
        YDialog.GroupingPolicyItem groupingPolicyItem = (YDialog.GroupingPolicyItem)this.policy.getSelectedItem();
        double d = Double.parseDouble(this.qualityText.getText());
        this.op = new OptionHandler("ORTHOGONAL_LAYOUTER");
        this.op.addInt("STYLE", styleItem.style);
        this.op.addInt("GRID", n);
        this.op.addBool("USE_LENGTH_REDUCTION", bl);
        this.op.addBool("USE_SKETCH_DRAWING", bl2);
        this.op.addBool("USE_CROSSING_POSTPROCESSING", bl3);
        this.op.addBool("PERCEIVED_BENDS_OPTIMIZATION_ENABLED", bl4);
        this.op.addBool("USE_RANDOMIZATION", bl5);
        this.op.addString("GROUP_LAYOUT_POLICY", groupingPolicyItem.item);
        this.op.addDouble("GROUP_LAYOUT_QUALITY", d);
        String string = LayoutResourceBundleUtil.getString("orthogonal.group_layout_policy.fix_contents_of_groups");
        String string2 = LayoutResourceBundleUtil.getString("orthogonal.group_layout_policy.layout_groups");
        if (groupingPolicyItem.equals(string)) {
            this.op.addBool("FIX_GROUPS", true);
        } else if (groupingPolicyItem.equals(string2) && this.structure != null && this.structure.getContainers().size() > 0) {
            this.op.addBool("LAYOUT_GROUPS", true);
        }
        properties.setProperty("orthogonal.layout_style", styleItem.item);
        properties.setProperty("orthogonal.grid", n);
        properties.setProperty("orthogonal.length_reduction", bl);
        properties.setProperty("orthogonal.use_existing_drawing_as_sketch", bl2);
        properties.setProperty("orthogonal.crossing_postprocessing", bl3);
        properties.setProperty("orthogonal.minimize_perceived_bends", bl4);
        properties.setProperty("orthogonal.use_randomization", bl5);
        properties.setProperty("orthogonal.group_layout_policy", groupingPolicyItem.item);
        properties.setProperty("orthogonal.group_layout_quality", d);
    }

    @Override
    protected void setDefault() {
        this.setDefaultSelectedItem(this.layoutStyle, "orthogonal.layout_style");
        this.grid.setText(properties.getDefaultProperty("orthogonal.grid"));
        this.lengthReduction.setSelected(properties.getDefaultPropertyBoolean("orthogonal.length_reduction"));
        this.existingDrawing.setSelected(properties.getDefaultPropertyBoolean("orthogonal.use_existing_drawing_as_sketch"));
        this.crossing.setSelected(properties.getDefaultPropertyBoolean("orthogonal.crossing_postprocessing"));
        this.bends.setSelected(properties.getDefaultPropertyBoolean("orthogonal.minimize_perceived_bends"));
        this.randomization.setSelected(properties.getDefaultPropertyBoolean("orthogonal.use_randomization"));
        this.setDefaultSelectedItem(this.policy, "orthogonal.group_layout_policy");
        this.quality.setValue((int)properties.getDefaultPropertyDouble("orthogonal.group_layout_quality") * 10);
    }

    private JPanel createLayoutPanle() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        int n = 0;
        this.setLabel(jPanel, "orthogonal.layout_style", gridBagLayout, 0, n, 17);
        Object[] objectArray = new Object[]{new StyleItem("orthogonal.layout_style.normal", 0), new StyleItem("orthogonal.layout_style.normal_trees", 4), new StyleItem("orthogonal.layout_style.uniform_nodesizes", 1), new StyleItem("orthogonal.layout_style.node_boxes", 2), new StyleItem("orthogonal.layout_style.mixed", 3), new StyleItem("orthogonal.layout_style.mixed_size_fixed", 5), new StyleItem("orthogonal.layout_style.node_boxes_size_fixed", 6)};
        this.layoutStyle = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.layoutStyle, "orthogonal.layout_style");
        jPanel.add(this.setConstraints(this.layoutStyle, gridBagLayout, 1, n++, 13));
        this.setLabel(jPanel, "orthogonal.grid", gridBagLayout, 0, n, 17);
        this.grid = new JTextField(new YDialog.IntegerDocument(this), properties.getDefaultProperty("orthogonal.grid"), 5);
        jPanel.add(this.setConstraints(this.grid, gridBagLayout, 1, n++, 17));
        this.setLabel(jPanel, "orthogonal.length_reduction", gridBagLayout, 0, n, 17);
        this.lengthReduction = new JCheckBox();
        this.lengthReduction.setSelected(properties.getPropertyBoolean("orthogonal.length_reduction"));
        jPanel.add(this.setConstraints(this.lengthReduction, gridBagLayout, 1, n++, 17));
        this.setLabel(jPanel, "orthogonal.use_existing_drawing_as_sketch", gridBagLayout, 0, n, 17);
        this.existingDrawing = new JCheckBox();
        this.existingDrawing.setSelected(properties.getPropertyBoolean("orthogonal.use_existing_drawing_as_sketch"));
        jPanel.add(this.setConstraints(this.existingDrawing, gridBagLayout, 1, n++, 17));
        this.setLabel(jPanel, "orthogonal.crossing_postprocessing", gridBagLayout, 0, n, 17);
        this.crossing = new JCheckBox();
        this.crossing.setSelected(properties.getPropertyBoolean("orthogonal.crossing_postprocessing"));
        jPanel.add(this.setConstraints(this.crossing, gridBagLayout, 1, n++, 17));
        this.setLabel(jPanel, "orthogonal.minimize_perceived_bends", gridBagLayout, 0, n, 17);
        this.bends = new JCheckBox();
        this.bends.setSelected(properties.getPropertyBoolean("orthogonal.minimize_perceived_bends"));
        jPanel.add(this.setConstraints(this.bends, gridBagLayout, 1, n++, 17));
        this.setLabel(jPanel, "orthogonal.use_randomization", gridBagLayout, 0, n, 17);
        this.randomization = new JCheckBox();
        this.randomization.setSelected(properties.getPropertyBoolean("orthogonal.use_randomization"));
        jPanel.add(this.setConstraints(this.randomization, gridBagLayout, 1, n++, 17));
        return this.resizePanel(jPanel);
    }

    private JPanel createGroupingPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.setLabel(jPanel, "orthogonal.group_layout_policy", gridBagLayout, 0, 0, 17);
        Object[] objectArray = new Object[]{new YDialog.GroupingPolicyItem(this, "orthogonal.group_layout_policy.layout_groups"), new YDialog.GroupingPolicyItem(this, "orthogonal.group_layout_policy.fix_contents_of_groups")};
        this.policy = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.policy, "orthogonal.group_layout_policy");
        jPanel.add(this.setConstraints(this.policy, gridBagLayout, 1, 0, 13));
        this.setLabel(jPanel, "orthogonal.group_layout_quality", gridBagLayout, 0, 1, 18);
        this.quality = this.createSliderDouble("orthogonal.group_layout_quality.min", "orthogonal.group_layout_quality.max", "orthogonal.group_layout_quality");
        this.qualityText = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("orthogonal.group_layout_quality"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.quality, this.qualityText), gridBagLayout, 1, 1, 13));
        return this.resizePanel(jPanel);
    }

    private class StyleItem
    extends YDialog.AbstractItem {
        int style;

        public StyleItem(String string) {
            this(string, 0);
        }

        public StyleItem(String string, int n) {
            super(OrthogonalLayoutDialog.this, string);
            this.style = n;
        }
    }
}

