/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.autoLayout.y.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import jp.sbi.sbml.autoLayout.y.option.LayoutResourceBundleUtil;
import jp.sbi.sbml.autoLayout.y.option.OptionHandler;
import jp.sbi.sbml.autoLayout.y.option.YDialog;

public class OrthogonalEdgeRouterDialog
extends YDialog {
    private JComboBox scope;
    private JTextField edgeDistance;
    private JCheckBox useCustomNodeDistance;
    private JLabel customNodeDistanceLabel;
    private JTextField customNodeDistance;
    private JCheckBox routeOnGrid;
    private JLabel gridSpacingLabel;
    private JTextField gridSpacing;
    private JSlider driven;
    private JTextField drivenText;
    private JCheckBox crossingMin;
    private JTextField crossingCost;
    private JCheckBox crossingEdges;

    public OrthogonalEdgeRouterDialog(JFrame jFrame) {
        super(jFrame);
        this.setTitle(LayoutResourceBundleUtil.getString("orthogonal_edge_router.title"));
        this.subTitleLabel = new JLabel(LayoutResourceBundleUtil.getString("orthogonal_edge_router.subtitle"));
        this.mainPanel = new JPanel(new BorderLayout(5, 5));
        this.mainPanel.add((Component)this.subTitleLabel, "North");
        this.mainPanel.add((Component)this.createSettingPanel(), "Center");
        this.mainPanel.add((Component)this.controlPane, "South");
        this.getContentPane().setLayout(new FlowLayout(1, 10, 10));
        this.getContentPane().add(this.mainPanel);
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    @Override
    public OptionHandler getOptionHandler() {
        if (this.op == null) {
            this.op = new OptionHandler("ORTHOGONAL_EDGE_ROUTER");
        }
        return this.op;
    }

    @Override
    public void setOptionHandler() {
        ScopeItem scopeItem = (ScopeItem)this.scope.getSelectedItem();
        int n = Integer.parseInt(this.edgeDistance.getText());
        boolean bl = this.useCustomNodeDistance.isSelected();
        int n2 = Integer.parseInt(this.customNodeDistance.getText());
        boolean bl2 = this.routeOnGrid.isSelected();
        int n3 = Integer.parseInt(this.gridSpacing.getText());
        double d = Double.parseDouble(this.drivenText.getText());
        boolean bl3 = this.crossingMin.isSelected();
        double d2 = Double.parseDouble(this.crossingCost.getText());
        boolean bl4 = this.crossingEdges.isSelected();
        this.op = new OptionHandler("ORTHOGONAL_EDGE_ROUTER");
        this.op.addByte("SCOPE", scopeItem.scope);
        this.op.addInt("MINIMUM_DISTANCE_TO_EDGE", n);
        this.op.addBool("USE_CUSTOM_MINIMUM_DISTANCE_TO_NODE", bl);
        this.op.addInt("CUSTOM_MINIMUM_DISTANCE_TO_NODE", n2);
        this.op.addBool("ROUTE_ON_GRID", bl2);
        this.op.addInt("GRID_SPACING", n3);
        this.op.addDouble("SPACE_DRIVEN_VS_CENTER_DRIVEN_SEARCH", d);
        this.op.addBool("LOCAL_CROSSING_MINIMIZATION", bl3);
        this.op.addDouble("CROSSING_COST", d2);
        this.op.addBool("REROUTING_ENABLED", bl4);
        properties.setProperty("orthogonal_edge_router.scope", scopeItem.item);
        properties.setProperty("orthogonal_edge_router.minimum_edge_distance", n);
        properties.setProperty("orthogonal_edge_router.use_custom_minimum_distance_to_node", bl);
        properties.setProperty("orthogonal_edge_router.custom_minimum_distance_to_nodes", n2);
        properties.setProperty("orthogonal_edge_router.route_on_grid", bl2);
        properties.setProperty("orthogonal_edge_router.grid_spacing", n3);
        properties.setProperty("orthogonal_edge_router.driven", d);
        properties.setProperty("orthogonal_edge_router.local_crossing_minimization", bl3);
        properties.setProperty("orthogonal_edge_router.crossing_cost", d2);
        properties.setProperty("orthogonal_edge_router.reroute_crossing_edges", bl4);
    }

    @Override
    protected void setDefault() {
        this.setDefaultSelectedItem(this.scope, "orthogonal_edge_router.scope");
        this.edgeDistance.setText(properties.getDefaultProperty("orthogonal_edge_router.minimum_edge_distance"));
        this.useCustomNodeDistance.setSelected(properties.getDefaultPropertyBoolean("orthogonal_edge_router.use_custom_minimum_distance_to_node"));
        this.customNodeDistance.setText(properties.getDefaultProperty("orthogonal_edge_router.custom_minimum_distance_to_nodes"));
        this.routeOnGrid.setSelected(properties.getDefaultPropertyBoolean("orthogonal_edge_router.route_on_grid"));
        this.gridSpacing.setText(properties.getDefaultProperty("orthogonal_edge_router.grid_spacing"));
        this.driven.setValue((int)(properties.getDefaultPropertyDouble("orthogonal_edge_router.driven") * 10.0));
        this.crossingMin.setSelected(properties.getDefaultPropertyBoolean("orthogonal_edge_router.local_crossing_minimization"));
        this.crossingCost.setText(properties.getDefaultProperty("orthogonal_edge_router.crossing_cost"));
        this.crossingEdges.setSelected(properties.getDefaultPropertyBoolean("orthogonal_edge_router.reroute_crossing_edges"));
        this.customNodeDistanceLabel.setEnabled(this.useCustomNodeDistance.isSelected());
        this.customNodeDistance.setEnabled(this.useCustomNodeDistance.isSelected());
        this.gridSpacingLabel.setEnabled(this.routeOnGrid.isSelected());
        this.gridSpacing.setEnabled(this.routeOnGrid.isSelected());
    }

    private JPanel createSettingPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.add(this.setConstraints(this.createLayoutPanel(), gridBagLayout, 0, 0, 3, 1, 10));
        jPanel.add(this.setConstraints(this.createCrossingMinimizationPanel(), gridBagLayout, 0, 1, 3, 1, 10));
        return this.resizePanel(jPanel);
    }

    private JPanel createLayoutPanel() {
        String string = LayoutResourceBundleUtil.getString("orthogonal_edge_router.layout_settings");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.setLabel(jPanel, "orthogonal_edge_router.scope", gridBagLayout, 0, 0, 17);
        Object[] objectArray = new Object[]{new ScopeItem("orthogonal_edge_router.scope.all", 0), new ScopeItem("orthogonal_edge_router.scope.selected", 2), new ScopeItem("orthogonal_edge_router.scope.edges_at_selected_nodes", 4)};
        this.scope = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.scope, "orthogonal_edge_router.scope");
        jPanel.add(this.setConstraints(this.scope, gridBagLayout, 1, 0, 17));
        this.setLabel(jPanel, "orthogonal_edge_router.minimum_edge_distance", gridBagLayout, 0, 1, 17);
        this.edgeDistance = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("orthogonal_edge_router.minimum_edge_distance"), 10);
        jPanel.add(this.setConstraints(this.edgeDistance, gridBagLayout, 1, 1, 17));
        this.setLabel(jPanel, "orthogonal_edge_router.use_custom_minimum_distance_to_node", gridBagLayout, 0, 2, 17);
        this.useCustomNodeDistance = new JCheckBox();
        this.useCustomNodeDistance.setSelected(properties.getPropertyBoolean("orthogonal_edge_router.use_custom_minimum_distance_to_node"));
        jPanel.add(this.setConstraints(this.useCustomNodeDistance, gridBagLayout, 1, 2, 17));
        this.customNodeDistanceLabel = this.createLabel(LayoutResourceBundleUtil.getString("orthogonal_edge_router.custom_minimum_distance_to_nodes"));
        jPanel.add(this.setConstraints(this.customNodeDistanceLabel, gridBagLayout, 0, 3, 17));
        this.customNodeDistance = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("orthogonal_edge_router.custom_minimum_distance_to_nodes"), 10);
        jPanel.add(this.setConstraints(this.customNodeDistance, gridBagLayout, 1, 3, 17));
        this.customNodeDistanceLabel.setEnabled(this.useCustomNodeDistance.isSelected());
        this.customNodeDistance.setEnabled(this.useCustomNodeDistance.isSelected());
        this.useCustomNodeDistance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrthogonalEdgeRouterDialog.this.customNodeDistanceLabel.setEnabled(OrthogonalEdgeRouterDialog.this.useCustomNodeDistance.isSelected());
                OrthogonalEdgeRouterDialog.this.customNodeDistance.setEnabled(OrthogonalEdgeRouterDialog.this.useCustomNodeDistance.isSelected());
            }
        });
        this.setLabel(jPanel, "orthogonal_edge_router.route_on_grid", gridBagLayout, 0, 4, 17);
        this.routeOnGrid = new JCheckBox();
        this.routeOnGrid.setSelected(properties.getPropertyBoolean("orthogonal_edge_router.route_on_grid"));
        jPanel.add(this.setConstraints(this.routeOnGrid, gridBagLayout, 1, 4, 17));
        this.gridSpacingLabel = this.createLabel(LayoutResourceBundleUtil.getString("orthogonal_edge_router.grid_spacing"));
        jPanel.add(this.setConstraints(this.gridSpacingLabel, gridBagLayout, 0, 5, 17));
        this.gridSpacing = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("orthogonal_edge_router.grid_spacing"), 10);
        jPanel.add(this.setConstraints(this.gridSpacing, gridBagLayout, 1, 5, 17));
        this.gridSpacingLabel.setEnabled(this.routeOnGrid.isSelected());
        this.gridSpacing.setEnabled(this.routeOnGrid.isSelected());
        this.routeOnGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrthogonalEdgeRouterDialog.this.gridSpacingLabel.setEnabled(OrthogonalEdgeRouterDialog.this.routeOnGrid.isSelected());
                OrthogonalEdgeRouterDialog.this.gridSpacing.setEnabled(OrthogonalEdgeRouterDialog.this.routeOnGrid.isSelected());
            }
        });
        this.setLabel(jPanel, "orthogonal_edge_router.driven", gridBagLayout, 0, 6, 18);
        this.driven = this.createSliderDouble("orthogonal_edge_router.driven.min", "orthogonal_edge_router.driven.max", "orthogonal_edge_router.driven");
        this.drivenText = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("orthogonal_edge_router.driven"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.driven, this.drivenText), gridBagLayout, 1, 6, 17));
        return jPanel;
    }

    private JPanel createCrossingMinimizationPanel() {
        String string = LayoutResourceBundleUtil.getString("orthogonal_edge_router.crossing_minimization");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.setLabel(jPanel, "orthogonal_edge_router.local_crossing_minimization", gridBagLayout, 0, 0, 17);
        this.crossingMin = new JCheckBox();
        this.crossingMin.setSelected(properties.getPropertyBoolean("orthogonal_edge_router.local_crossing_minimization"));
        jPanel.add(this.setConstraints(this.crossingMin, gridBagLayout, 1, 0, 17));
        this.setLabel(jPanel, "orthogonal_edge_router.crossing_cost", gridBagLayout, 0, 1, 17);
        this.crossingCost = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("orthogonal_edge_router.crossing_cost"), 10);
        jPanel.add(this.setConstraints(this.crossingCost, gridBagLayout, 1, 1, 17));
        this.setLabel(jPanel, "orthogonal_edge_router.reroute_crossing_edges", gridBagLayout, 0, 2, 17);
        this.crossingEdges = new JCheckBox();
        this.crossingEdges.setSelected(properties.getPropertyBoolean("orthogonal_edge_router.reroute_crossing_edges"));
        jPanel.add(this.setConstraints(this.crossingEdges, gridBagLayout, 1, 2, 17));
        return jPanel;
    }

    @Override
    protected JPanel resizePanel(JPanel jPanel) {
        jPanel.setPreferredSize(new Dimension(500, jPanel.getPreferredSize().height + 10));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private class ScopeItem
    extends YDialog.AbstractItem {
        byte scope;

        ScopeItem(String string, byte by) {
            super(OrthogonalEdgeRouterDialog.this, string);
            this.scope = by;
        }
    }
}

