/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.autoLayout.y.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import jp.sbi.sbml.autoLayout.y.option.LayoutResourceBundleUtil;
import jp.sbi.sbml.autoLayout.y.option.OptionHandler;
import jp.sbi.sbml.autoLayout.y.option.YDialog;

public class OrganicEdgeRouterDialog
extends YDialog {
    private JCheckBox selectedOnly;
    private JSlider minimalDistance;
    private JTextField minimalDistanceText;
    private JCheckBox useExistingBends;
    private JCheckBox routeOnlyNecessary;

    public OrganicEdgeRouterDialog(JFrame jFrame) {
        super(jFrame);
        this.setTitle(LayoutResourceBundleUtil.getString("organic_edge_router.title"));
        this.subTitleLabel = new JLabel(LayoutResourceBundleUtil.getString("organic_edge_router.subtitle"));
        this.mainPanel = new JPanel(new BorderLayout(5, 5));
        this.mainPanel.add((Component)this.subTitleLabel, "North");
        this.mainPanel.add((Component)this.createLayoutSettingPanel(), "Center");
        this.mainPanel.add((Component)this.controlPane, "South");
        this.getContentPane().setLayout(new FlowLayout(1, 10, 10));
        this.getContentPane().add(this.mainPanel);
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    @Override
    public OptionHandler getOptionHandler() {
        if (this.op == null) {
            this.op = new OptionHandler("ORGANIC_EDGE_ROUTER");
        }
        return this.op;
    }

    @Override
    public void setOptionHandler() {
        boolean bl = this.selectedOnly.isSelected();
        int n = Integer.parseInt(this.minimalDistanceText.getText());
        boolean bl2 = this.useExistingBends.isSelected();
        boolean bl3 = this.routeOnlyNecessary.isSelected();
        this.op = new OptionHandler("ORGANIC_EDGE_ROUTER");
        this.op.addBool("ROUTE_SELECTED_EDGES_ONLY", bl);
        this.op.addInt("MINIMAL_DISTANCE", n);
        this.op.addBool("USE_EXISTING_BENDS", bl2);
        this.op.addBool("ROUTE_ONLY_NECESSARY", bl3);
        properties.setProperty("organic_edge_router.route_selected_edges_only", bl);
        properties.setProperty("organic_edge_router.minimal_distance", n);
        properties.setProperty("organic_edge_router.use_existing_bends", bl2);
        properties.setProperty("organic_edge_router.route_only_necessary", bl3);
    }

    @Override
    protected void setDefault() {
        this.selectedOnly.setSelected(properties.getDefaultPropertyBoolean("organic_edge_router.route_selected_edges_only"));
        this.minimalDistance.setValue(properties.getDefaultPropertyInt("organic_edge_router.minimal_distance"));
        this.useExistingBends.setSelected(properties.getDefaultPropertyBoolean("organic_edge_router.use_existing_bends"));
        this.routeOnlyNecessary.setSelected(properties.getDefaultPropertyBoolean("organic_edge_router.route_only_necessary"));
    }

    private JPanel createLayoutSettingPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        JPanel jPanel2 = new JPanel();
        String string = LayoutResourceBundleUtil.getString("organic_edge_router.layout_settings");
        jPanel2.setBorder(BorderFactory.createTitledBorder(string));
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout2);
        this.setLabel(jPanel2, "organic_edge_router.route_selected_edges_only", gridBagLayout2, 0, 0, 17);
        this.selectedOnly = new JCheckBox();
        this.selectedOnly.setSelected(properties.getPropertyBoolean("organic_edge_router.route_selected_edges_only"));
        jPanel2.add(this.setConstraints(this.selectedOnly, gridBagLayout2, 1, 0, 17));
        this.setLabel(jPanel2, "organic_edge_router.minimal_distance", gridBagLayout2, 0, 1, 18);
        this.minimalDistance = this.createSliderInt("organic_edge_router.minimal_distance.min", "organic_edge_router.minimal_distance.max", "organic_edge_router.minimal_distance");
        this.minimalDistanceText = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("organic_edge_router.minimal_distance"), 4);
        jPanel2.add(this.setConstraints(this.createSliderPanel(this.minimalDistance, this.minimalDistanceText), gridBagLayout2, 1, 1, 13));
        this.setLabel(jPanel2, "organic_edge_router.use_existing_bends", gridBagLayout2, 0, 2, 17);
        this.useExistingBends = new JCheckBox();
        this.useExistingBends.setSelected(properties.getPropertyBoolean("organic_edge_router.use_existing_bends"));
        jPanel2.add(this.setConstraints(this.useExistingBends, gridBagLayout2, 1, 2, 17));
        this.setLabel(jPanel2, "organic_edge_router.route_only_necessary", gridBagLayout2, 0, 3, 17);
        this.routeOnlyNecessary = new JCheckBox();
        this.routeOnlyNecessary.setSelected(properties.getPropertyBoolean("organic_edge_router.route_only_necessary"));
        jPanel2.add(this.setConstraints(this.routeOnlyNecessary, gridBagLayout2, 1, 3, 17));
        jPanel.add(this.setConstraints(jPanel2, gridBagLayout, 0, 0, 2, 1, 10));
        return this.resizePanel(jPanel);
    }
}

