/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.autoLayout.y.option;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import jp.sbi.celldesigner.Preference;

public class LayoutProperties {
    public static final String AUTO_LAYOUT_PROPERTIES = "autolayout.properties";
    public static final String propertiesFilePath = String.valueOf(Preference.prefDirPath) + System.getProperty("file.separator") + "autolayout-" + Preference.cdVersion + ".properties";
    protected static final String HEADER = "Auto Layout Parameter";
    private static LayoutProperties layoutProperties;
    private Properties properties = new Properties();
    private Properties defaultProperties = new Properties();

    public static LayoutProperties getInstance() throws IOException {
        if (layoutProperties == null) {
            layoutProperties = new LayoutProperties();
            layoutProperties.load();
        }
        return layoutProperties;
    }

    private LayoutProperties() {
    }

    public String getProperty(String string) {
        return this.getProperty(string, this.defaultProperties.getProperty(string));
    }

    public String getProperty(String string, String string2) {
        return this.properties.getProperty(string, string2);
    }

    public int getPropertyInt(String string) {
        String string2 = this.getProperty(string, this.defaultProperties.getProperty(string));
        return Integer.parseInt(string2);
    }

    public long getPropertyLong(String string) {
        String string2 = this.getProperty(string, this.defaultProperties.getProperty(string));
        return Long.parseLong(string2);
    }

    public double getPropertyDouble(String string) {
        String string2 = this.getProperty(string, this.defaultProperties.getProperty(string));
        return Double.parseDouble(string2);
    }

    public boolean getPropertyBoolean(String string) {
        String string2 = this.getProperty(string, this.defaultProperties.getProperty(string));
        return Boolean.valueOf(string2);
    }

    public String getDefaultProperty(String string) {
        return this.defaultProperties.getProperty(string, "");
    }

    public int getDefaultPropertyInt(String string) {
        String string2 = this.getDefaultProperty(string);
        return Integer.parseInt(string2);
    }

    public long getDefaultPropertyLong(String string) {
        String string2 = this.getDefaultProperty(string);
        return Long.parseLong(string2);
    }

    public double getDefaultPropertyDouble(String string) {
        String string2 = this.getDefaultProperty(string);
        return Double.parseDouble(string2);
    }

    public boolean getDefaultPropertyBoolean(String string) {
        String string2 = this.getDefaultProperty(string);
        return Boolean.valueOf(string2);
    }

    public void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    public void setProperty(String string, int n) {
        this.setProperty(string, Integer.toString(n));
    }

    public void setProperty(String string, long l) {
        this.setProperty(string, Long.toString(l));
    }

    public void setProperty(String string, double d) {
        this.setProperty(string, Double.toString(d));
    }

    public void setProperty(String string, boolean bl) {
        this.setProperty(string, Boolean.toString(bl));
    }

    public LayoutProperties subset(String string) {
        String string2;
        LayoutProperties layoutProperties = new LayoutProperties();
        for (String string3 : this.properties.keySet()) {
            if (!string3.startsWith(string)) continue;
            string2 = null;
            string2 = string3.equals(string) ? string : string3.substring(string.length() + 1);
            layoutProperties.properties.setProperty(string2, this.getProperty(string3));
        }
        for (String string3 : this.defaultProperties.keySet()) {
            if (!string3.startsWith(string)) continue;
            string2 = null;
            string2 = string3.equals(string) ? string : string3.substring(string.length() + 1);
            layoutProperties.defaultProperties.setProperty(string2, this.getDefaultProperty(string3));
        }
        return layoutProperties;
    }

    public void load() throws IOException {
        block11: {
            File file = new File(propertiesFilePath);
            if (file.exists()) {
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    this.properties.load(fileInputStream);
                    break block11;
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            this.loadDefault(this.properties);
            this.store();
        }
        this.loadDefault(this.defaultProperties);
    }

    private void loadDefault(Properties properties) throws IOException {
        String string = this.getClass().getPackage().getName();
        string = string.replaceAll("\\.", "/");
        String string2 = String.valueOf(string) + "/" + AUTO_LAYOUT_PROPERTIES;
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(string2);
            properties.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void store() throws IOException {
        this.store(new File(propertiesFilePath));
    }

    public void store(File file) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            this.properties.store(outputStream, HEADER);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

