/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.autoLayout.y.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jp.sbi.sbml.autoLayout.y.option.LayoutResourceBundleUtil;
import jp.sbi.sbml.autoLayout.y.option.OptionHandler;
import jp.sbi.sbml.autoLayout.y.option.YDialog;

public class IncrementalHierarchicLayoutDialog
extends YDialog {
    private JCheckBox selected;
    private JCheckBox sketch;
    private JComboBox orientation;
    private JCheckBox separately;
    private JCheckBox symmetricPlacement;
    private JTextField nodeToNodeDistance;
    private JTextField nodeToEdgeDistance;
    private JTextField edgeToEdgeDistance;
    private JTextField layerToLayerDistance;
    private JRadioButton orthogonal;
    private JRadioButton polyline;
    private JCheckBox backloopRouting;
    private JTextField firstSegment;
    private JTextField lastSegment;
    private JTextField length;
    private JTextField edgeDistance;
    private JLabel slopeLabel;
    private JSlider slope;
    private JTextField slopeText;
    private JCheckBox port;
    private JComboBox assignmentPolicy;
    private JComboBox alignment;
    private JSlider scale;
    private JTextField scaleText;
    private JTextField halo;
    private JTextField minimumSize;
    private JTextField maximumSize;

    public IncrementalHierarchicLayoutDialog(JFrame jFrame) {
        super(jFrame);
        this.init();
    }

    public IncrementalHierarchicLayoutDialog(JDialog jDialog) {
        super(jDialog);
        this.init();
    }

    private void init() {
        this.setTitle(LayoutResourceBundleUtil.getString("incremental.title"));
        this.subTitleLabel = new JLabel(LayoutResourceBundleUtil.getString("incremental.subtitle"));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(LayoutResourceBundleUtil.getString("incremental.general"), this.createGeneralPanel());
        jTabbedPane.add(LayoutResourceBundleUtil.getString("incremental.edges"), this.createEdgesPanel());
        jTabbedPane.add(LayoutResourceBundleUtil.getString("incremental.layers"), this.createLayersPanel());
        this.mainPanel = new JPanel(new BorderLayout(5, 5));
        this.mainPanel.add((Component)this.subTitleLabel, "North");
        this.mainPanel.add((Component)jTabbedPane, "Center");
        this.mainPanel.add((Component)this.controlPane, "South");
        this.getContentPane().setLayout(new FlowLayout(1, 10, 10));
        this.getContentPane().add(this.mainPanel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    public OptionHandler getOptionHandler() {
        if (this.op == null) {
            this.op = new OptionHandler("INCREMENTAL_HIERARCHIC_LAYOUT");
        }
        return this.op;
    }

    @Override
    public void setOptionHandler() {
        boolean bl = this.selected.isSelected();
        boolean bl2 = this.sketch.isSelected();
        OrientationItem orientationItem = (OrientationItem)this.orientation.getSelectedItem();
        byte by = orientationItem.orientation;
        boolean bl3 = this.separately.isSelected();
        boolean bl4 = this.symmetricPlacement.isSelected();
        double d = Double.parseDouble(this.nodeToNodeDistance.getText());
        double d2 = Double.parseDouble(this.nodeToEdgeDistance.getText());
        double d3 = Double.parseDouble(this.edgeToEdgeDistance.getText());
        double d4 = Double.parseDouble(this.layerToLayerDistance.getText());
        boolean bl5 = this.orthogonal.isSelected();
        boolean bl6 = this.polyline.isSelected();
        boolean bl7 = this.backloopRouting.isSelected();
        double d5 = Double.parseDouble(this.firstSegment.getText());
        double d6 = Double.parseDouble(this.lastSegment.getText());
        double d7 = Double.parseDouble(this.length.getText());
        double d8 = Double.parseDouble(this.edgeDistance.getText());
        double d9 = Double.parseDouble(this.slopeText.getText());
        boolean bl8 = this.port.isSelected();
        LayerAssignmentPolicyItem layerAssignmentPolicyItem = (LayerAssignmentPolicyItem)this.assignmentPolicy.getSelectedItem();
        byte by2 = layerAssignmentPolicyItem.policy;
        AlignmentItem alignmentItem = (AlignmentItem)this.alignment.getSelectedItem();
        String string = alignmentItem.alignment;
        double d10 = Double.parseDouble(this.scaleText.getText());
        double d11 = Double.parseDouble(this.halo.getText());
        double d12 = Double.parseDouble(this.minimumSize.getText());
        double d13 = Double.parseDouble(this.maximumSize.getText());
        this.op = new OptionHandler("INCREMENTAL_HIERARCHIC_LAYOUT");
        this.op.addBool("SELECTED_ELEMENTS_INCREMENTALLY", bl);
        this.op.addBool("USE_DRAWING_AS_SKETCH", bl2);
        this.op.addByte("ORIENTATION", by);
        this.op.addBool("LAYOUT_COMPONENTS_SEPARATELY", bl3);
        this.op.addBool("SYMMETRIC_PLACEMENT", bl4);
        this.op.addDouble("NODE_TO_NODE_DISTANCE", d);
        this.op.addDouble("NODE_TO_EDGE_DISTANCE", d2);
        this.op.addDouble("EDGE_TO_EDGE_DISTANCE", d3);
        this.op.addDouble("LAYER_TO_LAYER_DISTANCE", d4);
        this.op.addBool("EDGE_ROUTING_ORTHOGONAL", bl5);
        this.op.addBool("EDGE_ROUTING_POLYLINE", bl6);
        this.op.addBool("BACKLOOP_ROUTING", bl7);
        this.op.addDouble("MINIMUM_FIRST_SEGMENT_LENGTH", d5);
        this.op.addDouble("MINIMUM_LAST_SEGMENT_LENGTH", d6);
        this.op.addDouble("MINIMUM_EDGE_LENGTH", d7);
        this.op.addDouble("MINIMUM_EDGE_DISTANCE", d8);
        if (bl6) {
            this.op.addDouble("MINIMUM_SLOPE", d9);
        }
        this.op.addBool("PC_OPTIMIZATION_ENABLED", bl8);
        this.op.addByte("LAYER_ASSIGNMENT_POLICY", by2);
        this.op.addString("LAYER_ALIGNMENT", string);
        this.op.addDouble("SCALE", d10);
        this.op.addDouble("HALO", d11);
        this.op.addDouble("MINIMUM_SIZE", d12);
        this.op.addDouble("MAXIMUM_SIZE", d13);
        properties.setProperty("incremental.selected_elements_incrementally", bl);
        properties.setProperty("incremental.use_drawing_as_sketch", bl2);
        properties.setProperty("incremental.orientation", orientationItem.item);
        properties.setProperty("incremental.layout_components_separately", bl3);
        properties.setProperty("incremental.symmetric_placement", bl4);
        properties.setProperty("incremental.node_to_node_distance", d);
        properties.setProperty("incremental.node_to_edge_distance", d2);
        properties.setProperty("incremental.edge_to_edge_distance", d3);
        properties.setProperty("incremental.layer_to_layer_distance", d4);
        properties.setProperty("incremental.routing_style.orthogonal", bl5);
        properties.setProperty("incremental.routing_style.polyline", bl6);
        properties.setProperty("incremental.backloop_routing", bl7);
        properties.setProperty("incremental.minimum_first_segment_length", d5);
        properties.setProperty("incremental.minimum_last_segment_length", d6);
        properties.setProperty("incremental.minimum_length", d7);
        properties.setProperty("incremental.minimum_edge_distance", d8);
        properties.setProperty("incremental.minimum_slope", d9);
        properties.setProperty("incremental.port_constraint_optimization", bl8);
        properties.setProperty("incremental.layer_assignment_policy", layerAssignmentPolicyItem.item);
        properties.setProperty("incremental.alignment_within_layer", alignmentItem.item);
        properties.setProperty("incremental.from_sketch_settings.scale", d10);
        properties.setProperty("incremental.from_sketch_settings.halo", d11);
        properties.setProperty("incremental.from_sketch_settings.minimum_size", d12);
        properties.setProperty("incremental.from_sketch_settings.maximum_size", d13);
    }

    @Override
    protected void setDefault() {
        this.selected.setSelected(properties.getDefaultPropertyBoolean("incremental.selected_elements_incrementally"));
        this.sketch.setSelected(properties.getDefaultPropertyBoolean("incremental.use_drawing_as_sketch"));
        this.setDefaultSelectedItem(this.orientation, "incremental.orientation");
        this.separately.setSelected(properties.getDefaultPropertyBoolean("incremental.layout_components_separately"));
        this.symmetricPlacement.setSelected(properties.getDefaultPropertyBoolean("incremental.symmetric_placement"));
        this.nodeToNodeDistance.setText(properties.getDefaultProperty("incremental.node_to_node_distance"));
        this.nodeToEdgeDistance.setText(properties.getDefaultProperty("incremental.node_to_edge_distance"));
        this.edgeToEdgeDistance.setText(properties.getDefaultProperty("incremental.edge_to_edge_distance"));
        this.layerToLayerDistance.setText(properties.getDefaultProperty("incremental.layer_to_layer_distance"));
        if (properties.getDefaultPropertyBoolean("incremental.routing_style.orthogonal")) {
            this.orthogonal.doClick();
        } else {
            this.polyline.doClick();
        }
        this.backloopRouting.setSelected(properties.getDefaultPropertyBoolean("incremental.backloop_routing"));
        this.firstSegment.setText(properties.getDefaultProperty("incremental.minimum_first_segment_length"));
        this.lastSegment.setText(properties.getDefaultProperty("incremental.minimum_last_segment_length"));
        this.length.setText(properties.getDefaultProperty("incremental.minimum_length"));
        this.edgeDistance.setText(properties.getDefaultProperty("incremental.minimum_edge_distance"));
        this.slope.setValue((int)(properties.getDefaultPropertyDouble("incremental.minimum_slope") * 100.0));
        this.port.setSelected(properties.getDefaultPropertyBoolean("incremental.port_constraint_optimization"));
        this.setDefaultSelectedItem(this.assignmentPolicy, "incremental.layer_assignment_policy");
        this.setDefaultSelectedItem(this.alignment, "incremental.alignment_within_layer");
        this.scale.setValue((int)(properties.getDefaultPropertyDouble("incremental.from_sketch_settings.scale") * 10.0));
        this.halo.setText(properties.getDefaultProperty("incremental.from_sketch_settings.halo"));
        this.minimumSize.setText(properties.getDefaultProperty("incremental.from_sketch_settings.minimum_size"));
        this.maximumSize.setText(properties.getDefaultProperty("incremental.from_sketch_settings.maximum_size"));
    }

    private JPanel createGeneralPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.add(this.setConstraints(this.createInteractivePanel(), gridBagLayout, 0, 0, 2, 1, 10));
        this.setLabel(jPanel, "incremental.orientation", gridBagLayout, 0, 1, 17);
        Object[] objectArray = new Object[]{new OrientationItem("incremental.orientation.top_to_bottom", 0), new OrientationItem("incremental.orientation.left_to_right", 1), new OrientationItem("incremental.orientation.bottom_to_top", 2), new OrientationItem("incremental.orientation.right_to_left", 3)};
        this.orientation = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.orientation, "incremental.orientation");
        jPanel.add(this.setConstraints(this.orientation, gridBagLayout, 1, 1, 13));
        this.setLabel(jPanel, "incremental.layout_components_separately", gridBagLayout, 0, 2, 17);
        this.separately = new JCheckBox();
        this.separately.setSelected(properties.getPropertyBoolean("incremental.layout_components_separately"));
        jPanel.add(this.setConstraints(this.separately, gridBagLayout, 1, 2, 17));
        this.setLabel(jPanel, "incremental.symmetric_placement", gridBagLayout, 0, 3, 17);
        this.symmetricPlacement = new JCheckBox();
        this.symmetricPlacement.setSelected(properties.getPropertyBoolean("incremental.symmetric_placement"));
        jPanel.add(this.setConstraints(this.symmetricPlacement, gridBagLayout, 1, 3, 17));
        jPanel.add(this.setConstraints(this.createMinimuDistances(), gridBagLayout, 0, 4, 2, 1, 10));
        return this.resizePanel(jPanel);
    }

    private JPanel createInteractivePanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        String string = LayoutResourceBundleUtil.getString("incremental.interactive_settings");
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        this.setLabel(jPanel, "incremental.selected_elements_incrementally", gridBagLayout, 0, 0, 17);
        this.selected = new JCheckBox();
        this.selected.setSelected(properties.getPropertyBoolean("incremental.selected_elements_incrementally"));
        jPanel.add(this.setConstraints(this.selected, gridBagLayout, 1, 0, 17));
        this.setLabel(jPanel, "incremental.use_drawing_as_sketch", gridBagLayout, 0, 1, 17);
        this.sketch = new JCheckBox();
        this.sketch.setSelected(properties.getPropertyBoolean("incremental.use_drawing_as_sketch"));
        jPanel.add(this.setConstraints(this.sketch, gridBagLayout, 1, 1, 17));
        return jPanel;
    }

    private JPanel createMinimuDistances() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        String string = LayoutResourceBundleUtil.getString("incremental.minimum_distances");
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        this.setLabel(jPanel, "incremental.node_to_node_distance", gridBagLayout, 0, 0, 17);
        this.nodeToNodeDistance = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("incremental.node_to_node_distance"), 10);
        jPanel.add(this.setConstraints(this.nodeToNodeDistance, gridBagLayout, 1, 0, 17));
        this.setLabel(jPanel, "incremental.node_to_edge_distance", gridBagLayout, 0, 1, 17);
        this.nodeToEdgeDistance = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("incremental.node_to_edge_distance"), 10);
        jPanel.add(this.setConstraints(this.nodeToEdgeDistance, gridBagLayout, 1, 1, 17));
        this.setLabel(jPanel, "incremental.edge_to_edge_distance", gridBagLayout, 0, 2, 17);
        this.edgeToEdgeDistance = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("incremental.edge_to_edge_distance"), 10);
        jPanel.add(this.setConstraints(this.edgeToEdgeDistance, gridBagLayout, 1, 2, 17));
        this.setLabel(jPanel, "incremental.layer_to_layer_distance", gridBagLayout, 0, 3, 17);
        this.layerToLayerDistance = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("incremental.layer_to_layer_distance"), 10);
        jPanel.add(this.setConstraints(this.layerToLayerDistance, gridBagLayout, 1, 3, 17));
        return jPanel;
    }

    private JPanel createEdgesPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.setLabel(jPanel, "incremental.routing_style", gridBagLayout, 0, 0, 18);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.orthogonal = new JRadioButton(LayoutResourceBundleUtil.getString("incremental.routing_style.orthogonal"), properties.getPropertyBoolean("incremental.routing_style.orthogonal"));
        this.polyline = new JRadioButton(LayoutResourceBundleUtil.getString("incremental.routing_style.polyline"), properties.getPropertyBoolean("incremental.routing_style.polyline"));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = actionEvent.getSource().equals(IncrementalHierarchicLayoutDialog.this.polyline);
                IncrementalHierarchicLayoutDialog.this.slopeLabel.setEnabled(bl);
                IncrementalHierarchicLayoutDialog.this.slope.setEnabled(bl);
                IncrementalHierarchicLayoutDialog.this.slopeText.setEnabled(bl);
            }
        };
        this.orthogonal.addActionListener(actionListener);
        this.polyline.addActionListener(actionListener);
        buttonGroup.add(this.orthogonal);
        buttonGroup.add(this.polyline);
        jPanel2.add(this.orthogonal);
        jPanel2.add(this.polyline);
        jPanel.add(this.setConstraints(jPanel2, gridBagLayout, 1, 0, 18));
        this.setLabel(jPanel, "incremental.backloop_routing", gridBagLayout, 0, 1, 17);
        this.backloopRouting = new JCheckBox();
        this.backloopRouting.setSelected(properties.getPropertyBoolean("incremental.backloop_routing"));
        jPanel.add(this.setConstraints(this.backloopRouting, gridBagLayout, 1, 1, 17));
        this.setLabel(jPanel, "incremental.minimum_first_segment_length", gridBagLayout, 0, 2, 17);
        this.firstSegment = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("incremental.minimum_first_segment_length"), 10);
        jPanel.add(this.setConstraints(this.firstSegment, gridBagLayout, 1, 2, 17));
        this.setLabel(jPanel, "incremental.minimum_last_segment_length", gridBagLayout, 0, 3, 17);
        this.lastSegment = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("incremental.minimum_last_segment_length"), 10);
        jPanel.add(this.setConstraints(this.lastSegment, gridBagLayout, 1, 3, 17));
        this.setLabel(jPanel, "incremental.minimum_length", gridBagLayout, 0, 4, 17);
        this.length = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("incremental.minimum_length"), 10);
        jPanel.add(this.setConstraints(this.length, gridBagLayout, 1, 4, 17));
        this.setLabel(jPanel, "incremental.minimum_edge_distance", gridBagLayout, 0, 5, 17);
        this.edgeDistance = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("incremental.minimum_edge_distance"), 10);
        jPanel.add(this.setConstraints(this.edgeDistance, gridBagLayout, 1, 5, 17));
        this.slopeLabel = this.createLabel(LayoutResourceBundleUtil.getString("incremental.minimum_slope"));
        jPanel.add(this.setConstraints(this.slopeLabel, gridBagLayout, 0, 6, 18));
        this.slope = this.createSliderDouble("incremental.minimum_slope_min", "incremental.minimum_slope_max", "incremental.minimum_slope", 100);
        this.slopeText = new JTextField(new YDialog.DoubleDocument(this, 100), properties.getProperty("incremental.minimum_slope"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.slope, this.slopeText), gridBagLayout, 1, 6, 13));
        this.setLabel(jPanel, "incremental.port_constraint_optimization", gridBagLayout, 0, 7, 17);
        this.port = new JCheckBox();
        this.port.setSelected(properties.getPropertyBoolean("incremental.port_constraint_optimization"));
        jPanel.add(this.setConstraints(this.port, gridBagLayout, 1, 7, 17));
        if (this.orthogonal.isSelected()) {
            this.orthogonal.doClick();
        } else {
            this.polyline.doClick();
        }
        return this.resizePanel(jPanel);
    }

    private JPanel createLayersPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.setLabel(jPanel, "incremental.layer_assignment_policy", gridBagLayout, 0, 0, 17);
        Object[] objectArray = new Object[]{new LayerAssignmentPolicyItem("incremental.layer_assignment_policy.hierarchic_optimal", 1), new LayerAssignmentPolicyItem("incremental.layer_assignment_policy.hierarchical_tight_tree_heuristic", 2), new LayerAssignmentPolicyItem("incremental.layer_assignment_policy.bfs_laytering", 4), new LayerAssignmentPolicyItem("incremental.layer_assignment_policy.from_sketch", 5), new LayerAssignmentPolicyItem("incremental.layer_assignment_policy.hierarchical_topmost", 0)};
        this.assignmentPolicy = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.assignmentPolicy, "incremental.layer_assignment_policy");
        jPanel.add(this.setConstraints(this.assignmentPolicy, gridBagLayout, 1, 0, 13));
        this.setLabel(jPanel, "incremental.alignment_within_layer", gridBagLayout, 0, 1, 17);
        objectArray = new Object[]{new AlignmentItem("incremental.alignment_within_layer.top_border_of_nodes", "TOP"), new AlignmentItem("incremental.alignment_within_layer.center_of_nodes", "CENTER"), new AlignmentItem("incremental.alignment_within_layer.bottom_border_of_nodes", "BOTTOM")};
        this.alignment = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.alignment, "incremental.alignment_within_layer");
        jPanel.add(this.setConstraints(this.alignment, gridBagLayout, 1, 1, 13));
        final JPanel jPanel2 = this.createFromSketchSettingPanel();
        this.assignmentPolicy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                LayerAssignmentPolicyItem layerAssignmentPolicyItem = (LayerAssignmentPolicyItem)itemEvent.getItem();
                if (layerAssignmentPolicyItem.policy == 5) {
                    jPanel2.setEnabled(true);
                } else {
                    jPanel2.setEnabled(false);
                }
            }
        });
        LayerAssignmentPolicyItem layerAssignmentPolicyItem = (LayerAssignmentPolicyItem)this.assignmentPolicy.getSelectedItem();
        if (layerAssignmentPolicyItem.policy == 5) {
            jPanel2.setEnabled(true);
        } else {
            jPanel2.setEnabled(false);
        }
        jPanel.add(this.setConstraints(jPanel2, gridBagLayout, 0, 2, 2, 1, 10));
        return this.resizePanel(jPanel);
    }

    private JPanel createFromSketchSettingPanel() {
        JPanel jPanel = new JPanel(){

            @Override
            public void setEnabled(boolean bl) {
                super.setEnabled(bl);
                IncrementalHierarchicLayoutDialog.this.scale.setEnabled(bl);
                IncrementalHierarchicLayoutDialog.this.scaleText.setEnabled(bl);
                IncrementalHierarchicLayoutDialog.this.halo.setEnabled(bl);
                IncrementalHierarchicLayoutDialog.this.minimumSize.setEnabled(bl);
                IncrementalHierarchicLayoutDialog.this.maximumSize.setEnabled(bl);
                Component[] componentArray = this.getComponents();
                int n = 0;
                while (n < componentArray.length) {
                    if (componentArray[n] instanceof JLabel) {
                        componentArray[n].setEnabled(bl);
                    }
                    ++n;
                }
            }
        };
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        String string = LayoutResourceBundleUtil.getString("incremental.from_sketch_settings");
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        this.setLabel(jPanel, "incremental.from_sketch_settings.scale", gridBagLayout, 0, 0, 18);
        this.scale = this.createSliderDouble("incremental.from_sketch_settings.scal.min", "incremental.from_sketch_settings.scal.max", "incremental.from_sketch_settings.scale");
        this.scaleText = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("incremental.from_sketch_settings.scale"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.scale, this.scaleText), gridBagLayout, 1, 0, 13));
        this.setLabel(jPanel, "incremental.from_sketch_settings.halo", gridBagLayout, 0, 1, 17);
        this.halo = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("incremental.from_sketch_settings.halo"), 10);
        jPanel.add(this.setConstraints(this.halo, gridBagLayout, 1, 1, 17));
        this.setLabel(jPanel, "incremental.from_sketch_settings.minimum_size", gridBagLayout, 0, 2, 17);
        this.minimumSize = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("incremental.from_sketch_settings.minimum_size"), 10);
        jPanel.add(this.setConstraints(this.minimumSize, gridBagLayout, 1, 2, 17));
        this.setLabel(jPanel, "incremental.from_sketch_settings.maximum_size", gridBagLayout, 0, 3, 17);
        this.maximumSize = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("incremental.from_sketch_settings.maximum_size"), 10);
        jPanel.add(this.setConstraints(this.maximumSize, gridBagLayout, 1, 3, 17));
        return jPanel;
    }

    @Override
    protected JPanel resizePanel(JPanel jPanel) {
        jPanel.setPreferredSize(new Dimension(IncrementalHierarchicLayoutDialog.PANEL_SIZE.width + 10, jPanel.getPreferredSize().height + 10));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private class AlignmentItem
    extends YDialog.AbstractItem {
        String alignment;

        public AlignmentItem(String string, String string2) {
            super(IncrementalHierarchicLayoutDialog.this, string);
            this.alignment = string2;
        }
    }

    private class LayerAssignmentPolicyItem
    extends YDialog.AbstractItem {
        byte policy;

        public LayerAssignmentPolicyItem(String string, byte by) {
            super(IncrementalHierarchicLayoutDialog.this, string);
            this.policy = by;
        }
    }

    private class OrientationItem
    extends YDialog.AbstractItem {
        byte orientation;

        public OrientationItem(String string, byte by) {
            super(IncrementalHierarchicLayoutDialog.this, string);
            this.orientation = by;
        }
    }
}

