/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.autoLayout.y.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jp.sbi.sbml.autoLayout.y.option.LayoutResourceBundleUtil;
import jp.sbi.sbml.autoLayout.y.option.OptionHandler;
import jp.sbi.sbml.autoLayout.y.option.YDialog;

public class HierarchicLayoutDialog
extends YDialog {
    private JTextField layerDistance;
    private JTextField nodeDistance;
    private JTextField edgeDistance;
    private JTextField firstSegmentLength;
    private JTextField duration;
    private JComboBox orientation;
    private JComboBox nodePlacement;
    private JComboBox edgeRouting;
    private JCheckBox backloopRoutin;
    private JCheckBox selectionOnly;
    private JComboBox ranking;
    private JComboBox weightHeuristic;
    private JCheckBox useTransposition;
    private JCheckBox crossings;
    private JTextField randomization;
    private JComboBox groupLayout;
    private JCheckBox globalSequencing;

    public HierarchicLayoutDialog(JFrame jFrame) {
        super(jFrame);
        this.init();
    }

    public HierarchicLayoutDialog(JDialog jDialog) {
        super(jDialog);
        this.init();
    }

    private void init() {
        this.setTitle(LayoutResourceBundleUtil.getString("hierarchic.title"));
        this.subTitleLabel = new JLabel(LayoutResourceBundleUtil.getString("hierarchic.subtitle"));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(LayoutResourceBundleUtil.getString("hierarchic.layout"), this.createLayoutPanel());
        jTabbedPane.add(LayoutResourceBundleUtil.getString("hierarchic.node_rank"), this.createNodeRank());
        jTabbedPane.add(LayoutResourceBundleUtil.getString("hierarchic.node_order"), this.createNodeOrder());
        jTabbedPane.add(LayoutResourceBundleUtil.getString("hierarchic.grouping"), this.createGroupingPanel());
        this.mainPanel = new JPanel(new BorderLayout(5, 5));
        this.mainPanel.add((Component)this.subTitleLabel, "North");
        this.mainPanel.add((Component)jTabbedPane, "Center");
        this.mainPanel.add((Component)this.controlPane, "South");
        this.getContentPane().setLayout(new FlowLayout(1, 10, 10));
        this.getContentPane().add(this.mainPanel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    public OptionHandler getOptionHandler() {
        if (this.op == null) {
            this.op = new OptionHandler("HIERARCHIC_LAYOUT");
        }
        return this.op;
    }

    @Override
    public void setOptionHandler() {
        int n = Integer.parseInt(this.layerDistance.getText());
        int n2 = Integer.parseInt(this.nodeDistance.getText());
        int n3 = Integer.parseInt(this.edgeDistance.getText());
        int n4 = Integer.parseInt(this.firstSegmentLength.getText());
        int n5 = Integer.parseInt(this.duration.getText());
        Item item = (Item)this.orientation.getSelectedItem();
        Item item2 = (Item)this.nodePlacement.getSelectedItem();
        Item item3 = (Item)this.edgeRouting.getSelectedItem();
        boolean bl = this.backloopRoutin.isSelected();
        boolean bl2 = this.selectionOnly.isSelected();
        Item item4 = (Item)this.ranking.getSelectedItem();
        Item item5 = (Item)this.weightHeuristic.getSelectedItem();
        boolean bl3 = this.useTransposition.isSelected();
        boolean bl4 = this.crossings.isSelected();
        int n6 = Integer.parseInt(this.randomization.getText());
        boolean bl5 = this.globalSequencing.isSelected();
        this.op = new OptionHandler("HIERARCHIC_LAYOUT");
        this.op.addInt("MINIMAL_LAYER_DISTANCE", n);
        this.op.addInt("MINIMAL_NODE_DISTANCE", n2);
        this.op.addInt("MINIMAL_EDGE_DISTANCE", n3);
        this.op.addInt("MINIMAL_FIRST_SEGMENT_LENGTH", n4);
        this.op.addInt("MAXIMAL_DURATION", n5);
        this.op.addByte("ORIENTATION", item.b);
        this.op.addByte("NODE_PLACEMENT", item2.b);
        this.op.addByte("EDGE_ROUTING", item3.b);
        this.op.addBool("BACKLOOP_ROUTING", bl);
        this.op.addBool("ACT_ON_SELECTION_ONLY", bl2);
        this.op.addByte("RANKING", item4.b);
        this.op.addByte("WEIGHT_HEURISTIC", item5.b);
        this.op.addBool("USE_TRANSPOSITION", bl3);
        this.op.addBool("REMOVE_FALSE_CROSSINGS", bl4);
        this.op.addInt("RANDOMIZATION_ROUNDS", n6);
        String string = LayoutResourceBundleUtil.getString("hierarchic.group_layout_policy.fix_groups");
        YDialog.GroupingPolicyItem groupingPolicyItem = (YDialog.GroupingPolicyItem)this.groupLayout.getSelectedItem();
        if (groupingPolicyItem.equals(string)) {
            this.op.addBool("FIX_GROUPS", true);
        } else {
            this.op.addBool("LAYOUT_GROUPS", true);
        }
        this.op.addBool("ENABLE_GLOBAL_SEQUENCING", bl5);
        properties.setProperty("hierarchic.minimal_layer_distance", n);
        properties.setProperty("hierarchic.minimal_node_distance", n2);
        properties.setProperty("hierarchic.minimal_edge_distance", n3);
        properties.setProperty("hierarchic.minimal_first_segment_length", n4);
        properties.setProperty("hierarchic.maximal_duration", n5);
        properties.setProperty("hierarchic.orientation", item.item);
        properties.setProperty("hierarchic.node_placement", item2.item);
        properties.setProperty("hierarchic.edge_routing", item3.item);
        properties.setProperty("hierarchic.backloop_routing", bl);
        properties.setProperty("hierarchic.act_on_selection_only", bl2);
        properties.setProperty("hierarchic.ranking_policy", item4.item);
        properties.setProperty("hierarchic.weight_heuristic", item5.item);
        properties.setProperty("hierarchic.use_transposition", bl3);
        properties.setProperty("hierarchic.remove_false_crossings", bl4);
        properties.setProperty("hierarchic.randomization_rounds", n6);
        properties.setProperty("hierarchic.group_layout_policy", groupingPolicyItem.item);
        properties.setProperty("hierarchic.enable_global_sequencing", bl5);
    }

    @Override
    protected void setDefault() {
        this.layerDistance.setText(properties.getDefaultProperty("hierarchic.minimal_layer_distance"));
        this.nodeDistance.setText(properties.getDefaultProperty("hierarchic.minimal_node_distance"));
        this.edgeDistance.setText(properties.getDefaultProperty("hierarchic.minimal_edge_distance"));
        this.firstSegmentLength.setText(properties.getDefaultProperty("hierarchic.minimal_first_segment_length"));
        this.duration.setText(properties.getDefaultProperty("hierarchic.maximal_duration"));
        this.setDefaultSelectedItem(this.orientation, "hierarchic.orientation");
        this.setDefaultSelectedItem(this.nodePlacement, "hierarchic.node_placement");
        this.setDefaultSelectedItem(this.edgeRouting, "hierarchic.edge_routing");
        this.backloopRoutin.setSelected(properties.getDefaultPropertyBoolean("hierarchic.backloop_routing"));
        this.selectionOnly.setSelected(properties.getDefaultPropertyBoolean("hierarchic.act_on_selection_only"));
        this.setDefaultSelectedItem(this.ranking, "hierarchic.ranking_policy");
        this.setDefaultSelectedItem(this.weightHeuristic, "hierarchic.weight_heuristic");
        this.useTransposition.setSelected(properties.getDefaultPropertyBoolean("hierarchic.use_transposition"));
        this.crossings.setSelected(properties.getDefaultPropertyBoolean("hierarchic.remove_false_crossings"));
        this.randomization.setText(properties.getDefaultProperty("hierarchic.randomization_rounds"));
        this.setDefaultSelectedItem(this.groupLayout, "hierarchic.group_layout_policy");
        this.globalSequencing.setSelected(properties.getDefaultPropertyBoolean("hierarchic.enable_global_sequencing"));
    }

    private JPanel createLayoutPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.setLabel(jPanel, "hierarchic.minimal_layer_distance", gridBagLayout, 0, 0, 17);
        this.layerDistance = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("hierarchic.minimal_layer_distance"), 10);
        jPanel.add(this.setConstraints(this.layerDistance, gridBagLayout, 1, 0, 17));
        this.setLabel(jPanel, "hierarchic.minimal_node_distance", gridBagLayout, 0, 1, 17);
        this.nodeDistance = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("hierarchic.minimal_node_distance"), 10);
        jPanel.add(this.setConstraints(this.nodeDistance, gridBagLayout, 1, 1, 17));
        this.setLabel(jPanel, "hierarchic.minimal_edge_distance", gridBagLayout, 0, 2, 17);
        this.edgeDistance = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("hierarchic.minimal_edge_distance"), 10);
        jPanel.add(this.setConstraints(this.edgeDistance, gridBagLayout, 1, 2, 17));
        this.setLabel(jPanel, "hierarchic.minimal_first_segment_length", gridBagLayout, 0, 3, 17);
        this.firstSegmentLength = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("hierarchic.minimal_first_segment_length"), 10);
        jPanel.add(this.setConstraints(this.firstSegmentLength, gridBagLayout, 1, 3, 17));
        this.setLabel(jPanel, "hierarchic.maximal_duration", gridBagLayout, 0, 4, 17);
        this.duration = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("hierarchic.maximal_duration"), 10);
        jPanel.add(this.setConstraints(this.duration, gridBagLayout, 1, 4, 17));
        this.setLabel(jPanel, "hierarchic.orientation", gridBagLayout, 0, 5, 17);
        Object[] objectArray = new Object[]{new Item("hierarchic.orientation.top_to_bottom", 0), new Item("hierarchic.orientation.left_to_right", 1), new Item("hierarchic.orientation.bottom_to_top", 2), new Item("hierarchic.orientation.right_to_left", 3)};
        this.orientation = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.orientation, "hierarchic.orientation");
        jPanel.add(this.setConstraints(this.orientation, gridBagLayout, 1, 5, 17));
        this.setLabel(jPanel, "hierarchic.node_placement", gridBagLayout, 0, 6, 17);
        objectArray = new Object[]{new Item("hierarchic.node_placement.pendulum", 0), new Item("hierarchic.node_placement.linear_segments", 1), new Item("hierarchic.node_placement.polyline", 2), new Item("hierarchic.node_placement.tree", 3), new Item("hierarchic.node_placement.simplex", 4), new Item("hierarchic.node_placement.median_simplex", 5)};
        this.nodePlacement = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.nodePlacement, "hierarchic.node_placement");
        jPanel.add(this.setConstraints(this.nodePlacement, gridBagLayout, 1, 6, 17));
        this.setLabel(jPanel, "hierarchic.edge_routing", gridBagLayout, 0, 7, 17);
        objectArray = new Object[]{new Item("hierarchic.edge_routing.polyline", 0), new Item("hierarchic.edge_routing.orthogonal", 1)};
        this.edgeRouting = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.edgeRouting, "hierarchic.edge_routing");
        jPanel.add(this.setConstraints(this.edgeRouting, gridBagLayout, 1, 7, 17));
        this.setLabel(jPanel, "hierarchic.backloop_routing", gridBagLayout, 0, 8, 17);
        this.backloopRoutin = new JCheckBox();
        this.backloopRoutin.setSelected(properties.getPropertyBoolean("hierarchic.backloop_routing"));
        jPanel.add(this.setConstraints(this.backloopRoutin, gridBagLayout, 1, 8, 17));
        this.setLabel(jPanel, "hierarchic.act_on_selection_only", gridBagLayout, 0, 9, 17);
        this.selectionOnly = new JCheckBox();
        this.selectionOnly.setSelected(properties.getPropertyBoolean("hierarchic.act_on_selection_only"));
        jPanel.add(this.setConstraints(this.selectionOnly, gridBagLayout, 1, 9, 17));
        return this.resizePanel(jPanel);
    }

    private JPanel createNodeRank() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.setLabel(jPanel, "hierarchic.ranking_policy", gridBagLayout, 0, 0, 17);
        Object[] objectArray = new Object[]{new Item("hierarchic.ranking_policy.topmost", 0), new Item("hierarchic.ranking_policy.downshift_heuristic", 3), new Item("hierarchic.ranking_policy.tight_tree_heuristic", 2), new Item("hierarchic.ranking_policy.optimal", 1), new Item("hierarchic.ranking_policy.from_sketch", 5), new Item("hierarchic.ranking_policy.bfs_layering", 4)};
        this.ranking = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.ranking, "hierarchic.ranking_policy");
        jPanel.add(this.setConstraints(this.ranking, gridBagLayout, 1, 0, 17));
        return this.resizePanel(jPanel);
    }

    private JPanel createNodeOrder() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.setLabel(jPanel, "hierarchic.weight_heuristic", gridBagLayout, 0, 0, 17);
        Object[] objectArray = new Object[]{new Item("hierarchic.weight_heuristic.barycenter", 0), new Item("hierarchic.weight_heuristic.median", 1)};
        this.weightHeuristic = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.weightHeuristic, "hierarchic.weight_heuristic");
        jPanel.add(this.setConstraints(this.weightHeuristic, gridBagLayout, 1, 0, 17));
        this.setLabel(jPanel, "hierarchic.use_transposition", gridBagLayout, 0, 1, 17);
        this.useTransposition = new JCheckBox();
        this.useTransposition.setSelected(properties.getPropertyBoolean("hierarchic.use_transposition"));
        jPanel.add(this.setConstraints(this.useTransposition, gridBagLayout, 1, 1, 17));
        this.setLabel(jPanel, "hierarchic.remove_false_crossings", gridBagLayout, 0, 2, 17);
        this.crossings = new JCheckBox();
        this.crossings.setSelected(properties.getPropertyBoolean("hierarchic.remove_false_crossings"));
        jPanel.add(this.setConstraints(this.crossings, gridBagLayout, 1, 2, 17));
        this.setLabel(jPanel, "hierarchic.randomization_rounds", gridBagLayout, 0, 3, 17);
        this.randomization = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("hierarchic.randomization_rounds"), 10);
        jPanel.add(this.setConstraints(this.randomization, gridBagLayout, 1, 3, 17));
        return this.resizePanel(jPanel);
    }

    private JPanel createGroupingPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.setLabel(jPanel, "hierarchic.group_layout_policy", gridBagLayout, 0, 0, 17);
        Object[] objectArray = new Object[]{new YDialog.GroupingPolicyItem(this, "hierarchic.group_layout_policy.layout_groups"), new YDialog.GroupingPolicyItem(this, "hierarchic.group_layout_policy.fix_groups")};
        this.groupLayout = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.groupLayout, "hierarchic.group_layout_policy");
        jPanel.add(this.setConstraints(this.groupLayout, gridBagLayout, 1, 0, 17));
        this.setLabel(jPanel, "hierarchic.enable_global_sequencing", gridBagLayout, 0, 1, 17);
        this.globalSequencing = new JCheckBox();
        this.globalSequencing.setSelected(properties.getPropertyBoolean("hierarchic.enable_global_sequencing"));
        jPanel.add(this.setConstraints(this.globalSequencing, gridBagLayout, 1, 1, 17));
        return this.resizePanel(jPanel);
    }

    private class Item
    extends YDialog.AbstractItem {
        byte b;

        public Item(String string, byte by) {
            super(HierarchicLayoutDialog.this, string);
            this.b = by;
        }
    }
}

