/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.autoLayout.y.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jp.fric.graphics.draw.GStructure;
import jp.sbi.sbml.autoLayout.AutoLayout;
import jp.sbi.sbml.autoLayout.GraphLayout;
import jp.sbi.sbml.autoLayout.y.CircularLayoutModule;
import jp.sbi.sbml.autoLayout.y.HierarchicLayoutModule;
import jp.sbi.sbml.autoLayout.y.IncrementalHierarchicLayoutModule;
import jp.sbi.sbml.autoLayout.y.LayoutModule;
import jp.sbi.sbml.autoLayout.y.OrganicLayoutModule;
import jp.sbi.sbml.autoLayout.y.OrthogonalLayoutModule;
import jp.sbi.sbml.autoLayout.y.TreeLayoutModule;
import jp.sbi.sbml.autoLayout.y.option.CircularLayoutDialog;
import jp.sbi.sbml.autoLayout.y.option.ClassicOrganicLayoutDialog;
import jp.sbi.sbml.autoLayout.y.option.HierarchicLayoutDialog;
import jp.sbi.sbml.autoLayout.y.option.IncrementalHierarchicLayoutDialog;
import jp.sbi.sbml.autoLayout.y.option.LayoutResourceBundleUtil;
import jp.sbi.sbml.autoLayout.y.option.OptionHandler;
import jp.sbi.sbml.autoLayout.y.option.OrthogonalLayoutDialog;
import jp.sbi.sbml.autoLayout.y.option.SmartOrganicLayoutDialog;
import jp.sbi.sbml.autoLayout.y.option.TreeLayoutDialog;
import jp.sbi.sbml.autoLayout.y.option.YDialog;

public class DefaultAutoLayoutDialog
extends YDialog
implements ActionListener {
    private static final String[] KEYS = new String[]{"default.orthogonal_layout", "default.organic_layout", "default.smart_organic_layout", "default.hierarchic_layout", "default.incremental_hierarchic_layout", "default.circular_layout", "default.treelike_layout", "default.old_layout"};
    private HashMap keyMap;
    private GStructure structure;

    public DefaultAutoLayoutDialog(JFrame jFrame, GStructure gStructure) {
        super(jFrame);
        this.structure = gStructure;
        this.setTitle(LayoutResourceBundleUtil.getString("default.title"));
        this.subTitleLabel = new JLabel(LayoutResourceBundleUtil.getString("default.subtitle"));
        this.mainPanel = new JPanel(new BorderLayout(5, 5));
        this.mainPanel.add((Component)this.subTitleLabel, "North");
        this.mainPanel.add((Component)this.createPanel(), "Center");
        this.mainPanel.add((Component)this.controlPane, "South");
        this.getContentPane().setLayout(new FlowLayout(1, 10, 10));
        this.getContentPane().add(this.mainPanel);
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    public static boolean isOldVersionLayout() {
        return properties.getPropertyBoolean("default.old_layout");
    }

    public static AutoLayout createLayoutModule() {
        HashMap hashMap = DefaultAutoLayoutDialog.getModuleMap();
        int n = 0;
        while (n < KEYS.length) {
            if (properties.getPropertyBoolean(KEYS[n])) {
                return (AutoLayout)hashMap.get(KEYS[n]);
            }
            ++n;
        }
        return new OrthogonalLayoutModule();
    }

    private static HashMap getModuleMap() {
        HashMap<String, LayoutModule> hashMap = new HashMap<String, LayoutModule>();
        hashMap.put(KEYS[0], new OrthogonalLayoutModule());
        hashMap.put(KEYS[1], new OrganicLayoutModule("ORGANIC"));
        hashMap.put(KEYS[2], new OrganicLayoutModule("SMART_ORGANIC"));
        hashMap.put(KEYS[3], new HierarchicLayoutModule());
        hashMap.put(KEYS[4], new IncrementalHierarchicLayoutModule());
        hashMap.put(KEYS[5], new CircularLayoutModule());
        hashMap.put(KEYS[6], new TreeLayoutModule());
        hashMap.put(KEYS[7], (LayoutModule)new GraphLayout());
        return hashMap;
    }

    @Override
    public OptionHandler getOptionHandler() {
        return null;
    }

    @Override
    public void setOptionHandler() {
        int n = 0;
        while (n < KEYS.length) {
            JRadioButton jRadioButton = (JRadioButton)this.keyMap.get(KEYS[n]);
            properties.setProperty(KEYS[n], jRadioButton.isSelected());
            ++n;
        }
    }

    @Override
    protected void setDefault() {
        int n = 0;
        while (n < KEYS.length) {
            JRadioButton jRadioButton = (JRadioButton)this.keyMap.get(KEYS[n]);
            jRadioButton.setSelected(properties.getDefaultPropertyBoolean(KEYS[n]));
            ++n;
        }
    }

    private JPanel createPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(LayoutResourceBundleUtil.getString("default.layout_style")));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.keyMap = new HashMap();
        int n = 0;
        while (n < KEYS.length) {
            String string = LayoutResourceBundleUtil.getString(KEYS[n]);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JPanel jPanel3 = new JPanel();
            JPanel jPanel4 = new JPanel();
            JRadioButton jRadioButton = new JRadioButton(string, properties.getPropertyBoolean(KEYS[n]));
            buttonGroup.add(jRadioButton);
            this.keyMap.put(KEYS[n], jRadioButton);
            jPanel3.add(jRadioButton);
            if (!KEYS[n].equals("default.old_layout")) {
                JButton jButton = new JButton(LayoutResourceBundleUtil.getString("default.edit"));
                jButton.setActionCommand(KEYS[n]);
                jButton.addActionListener(this);
                jPanel4.add(jButton);
            }
            jPanel2.add((Component)jPanel3, "West");
            jPanel2.add((Component)jPanel4, "East");
            jPanel.add(jPanel2);
            ++n;
        }
        return this.resizePanel(jPanel);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(KEYS[0])) {
            new OrthogonalLayoutDialog(this, this.structure).show();
        } else if (string.equals(KEYS[1])) {
            new ClassicOrganicLayoutDialog(this).show();
        } else if (string.equals(KEYS[2])) {
            new SmartOrganicLayoutDialog(this).show();
        } else if (string.equals(KEYS[3])) {
            new HierarchicLayoutDialog(this).show();
        } else if (string.equals(KEYS[4])) {
            new IncrementalHierarchicLayoutDialog(this).show();
        } else if (string.equals(KEYS[5])) {
            new CircularLayoutDialog(this).show();
        } else if (string.equals(KEYS[6])) {
            new TreeLayoutDialog(this).show();
        } else {
            string.equals(KEYS[7]);
        }
        super.actionPerformed(actionEvent);
    }
}

