/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.autoLayout.y.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jp.sbi.sbml.autoLayout.y.option.LayoutResourceBundleUtil;
import jp.sbi.sbml.autoLayout.y.option.OptionHandler;
import jp.sbi.sbml.autoLayout.y.option.YDialog;

public class ClassicOrganicLayoutDialog
extends YDialog {
    private JComboBox sphereOfAction;
    private JComboBox initialPlacement;
    private JSlider edgeLength;
    private JTextField edgeLengthText;
    private JCheckBox obeyNodeSizes;
    private JSlider edgeAttraction;
    private JTextField edgeAttractionText;
    private JSlider nodeRepulsion;
    private JTextField nodeRepulsionText;
    private JSlider gravityFactor;
    private JTextField gravityFactorText;
    private JCheckBox treeBeautifier;
    private JTextField iteratorFactor;
    private JTextField maximalDuration;
    private JCheckBox deterministicMode;
    private JComboBox layoutPolicy;
    private JSlider nodeCompactness;
    private JTextField nodeCompactnessText;

    public ClassicOrganicLayoutDialog(JFrame jFrame) {
        super(jFrame);
        this.init();
    }

    public ClassicOrganicLayoutDialog(JDialog jDialog) {
        super(jDialog);
        this.init();
    }

    private void init() {
        this.setTitle(LayoutResourceBundleUtil.getString("organic.title"));
        this.subTitleLabel = new JLabel(LayoutResourceBundleUtil.getString("organic.subtitle"));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(LayoutResourceBundleUtil.getString("organic.visual"), this.createVisualPanel());
        jTabbedPane.add(LayoutResourceBundleUtil.getString("organic.algorithm"), this.createAlgorithmPanel());
        jTabbedPane.add(LayoutResourceBundleUtil.getString("organic.grouping"), this.createGroupingPanel());
        this.mainPanel = new JPanel(new BorderLayout(5, 5));
        this.mainPanel.add((Component)this.subTitleLabel, "North");
        this.mainPanel.add((Component)jTabbedPane, "Center");
        this.mainPanel.add((Component)this.controlPane, "South");
        this.getContentPane().setLayout(new FlowLayout(1, 10, 10));
        this.getContentPane().add(this.mainPanel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    public OptionHandler getOptionHandler() {
        if (this.op == null) {
            this.op = new OptionHandler("ORGANIC_LAYOUTER");
        }
        return this.op;
    }

    @Override
    public void setOptionHandler() {
        SphereOfActionItem sphereOfActionItem = (SphereOfActionItem)this.sphereOfAction.getSelectedItem();
        InitialPlacementItem initialPlacementItem = (InitialPlacementItem)this.initialPlacement.getSelectedItem();
        YDialog.GroupingPolicyItem groupingPolicyItem = (YDialog.GroupingPolicyItem)this.layoutPolicy.getSelectedItem();
        String string = sphereOfActionItem.item;
        String string2 = initialPlacementItem.item;
        int n = Integer.parseInt(this.edgeLengthText.getText());
        boolean bl = this.obeyNodeSizes.isSelected();
        int n2 = Integer.parseInt(this.edgeAttractionText.getText());
        int n3 = Integer.parseInt(this.nodeRepulsionText.getText());
        double d = Double.parseDouble(this.gravityFactorText.getText());
        boolean bl2 = this.treeBeautifier.isSelected();
        double d2 = Double.parseDouble(this.iteratorFactor.getText());
        long l = Long.parseLong(this.maximalDuration.getText());
        boolean bl3 = this.deterministicMode.isSelected();
        String string3 = groupingPolicyItem.item;
        double d3 = Double.parseDouble(this.nodeCompactnessText.getText());
        this.op = new OptionHandler("ORGANIC_LAYOUTER");
        this.op.addString("LAYOUTER", "ORGANIC");
        this.op.addByte("SPHERE_OF_ACTION", sphereOfActionItem.action);
        this.op.addByte("INITIAL_PLACEMENT", initialPlacementItem.initialPlacement);
        this.op.addInt("PREFERRED_EDGE_LENGTH", n);
        this.op.addBool("OBEY_NODE_SIZES", bl);
        this.op.addInt("EDGE_ATTRACTION", n2);
        this.op.addInt("NODE_REPULSION", n3);
        this.op.addDouble("GRAVITY_FACTOR", d);
        this.op.addBool("ACTIVATE_TREE_BEAUTIFIER", bl2);
        this.op.addDouble("ITERATION_FACTOR", d2);
        this.op.addLong("MAXIMAL_DURATION", l);
        this.op.addBool("ACTIVATE_DETERMINISTIC_MODE", bl3);
        this.op.addString("GROUP_LAYOUT_POLICY", string3);
        String string4 = LayoutResourceBundleUtil.getString("organic.group_layout_policy.layout_groups");
        String string5 = LayoutResourceBundleUtil.getString("organic.group_layout_policy.fix_contents_of_groups");
        if (this.layoutPolicy.equals(string5)) {
            this.op.addBool("FIX_GROUPS", true);
        } else if (this.layoutPolicy.equals(string4)) {
            this.op.addBool("LAYOUT_GROUPS", true);
        }
        this.op.addDouble("COMPACTNESS", d3);
        properties.setProperty("organic.sphere_of_action", string);
        properties.setProperty("organic.initial_placement", string2);
        properties.setProperty("organic.edge_length", n);
        properties.setProperty("organic.obey_node_sizes", bl);
        properties.setProperty("organic.edge_attraction", n2);
        properties.setProperty("organic.node_repulsion", n3);
        properties.setProperty("organic.gravity_factor", d);
        properties.setProperty("organic.activate_tree_beautifier", bl2);
        properties.setProperty("organic.iteration_factor", d2);
        properties.setProperty("organic.maximal_duration", l);
        properties.setProperty("organic.activate_deterministic_mode", bl3);
        properties.setProperty("organic.group_layout_policy", string3);
        properties.setProperty("organic.group_node_compactness", d3);
    }

    @Override
    protected void setDefault() {
        this.setDefaultSelectedItem(this.sphereOfAction, "organic.sphere_of_action");
        this.setDefaultSelectedItem(this.initialPlacement, "organic.initial_placement");
        this.edgeLength.setValue(properties.getDefaultPropertyInt("organic.edge_length"));
        this.obeyNodeSizes.setSelected(properties.getDefaultPropertyBoolean("organic.obey_node_sizes"));
        this.edgeAttraction.setValue(properties.getDefaultPropertyInt("organic.edge_attraction"));
        this.nodeRepulsion.setValue(properties.getDefaultPropertyInt("organic.node_repulsion"));
        this.gravityFactor.setValue((int)(properties.getDefaultPropertyDouble("organic.gravity_factor") * 10.0));
        this.treeBeautifier.setSelected(properties.getDefaultPropertyBoolean("organic.activate_tree_beautifier"));
        this.iteratorFactor.setText(properties.getDefaultProperty("organic.iteration_factor"));
        this.maximalDuration.setText(properties.getDefaultProperty("organic.maximal_duration"));
        this.deterministicMode.setSelected(properties.getDefaultPropertyBoolean("organic.activate_deterministic_mode"));
        this.setDefaultSelectedItem(this.layoutPolicy, "organic.group_layout_policy");
        this.nodeCompactness.setValue((int)(properties.getDefaultPropertyDouble("organic.group_node_compactness") * 10.0));
    }

    private JPanel createVisualPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.setLabel(jPanel, "organic.sphere_of_action", gridBagLayout, 0, 0, 17);
        Object[] objectArray = new Object[]{new SphereOfActionItem("organic.sphere_of_action.all", 0), new SphereOfActionItem("organic.sphere_of_action.mainly_selection", 1), new SphereOfActionItem("organic.sphere_of_action.only_selection", 2)};
        this.sphereOfAction = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.sphereOfAction, "organic.sphere_of_action");
        jPanel.add(this.setConstraints(this.sphereOfAction, gridBagLayout, 1, 0, 13));
        this.setLabel(jPanel, "organic.initial_placement", gridBagLayout, 0, 1, 17);
        objectArray = new Object[]{new InitialPlacementItem("organic.initial_placement.random", 0), new InitialPlacementItem("organic.initial_placement.at", 1), new InitialPlacementItem("organic.initial_placement.as", 2)};
        this.initialPlacement = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.initialPlacement, "organic.initial_placement");
        jPanel.add(this.setConstraints(this.initialPlacement, gridBagLayout, 1, 1, 13));
        this.setLabel(jPanel, "organic.edge_length", gridBagLayout, 0, 2, 18);
        this.edgeLength = this.createSliderInt("organic.edge_length.min", "organic.edge_length.max", "organic.edge_length");
        this.edgeLengthText = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("organic.edge_length"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.edgeLength, this.edgeLengthText), gridBagLayout, 1, 2, 13));
        this.setLabel(jPanel, "organic.obey_node_sizes", gridBagLayout, 0, 3, 17);
        this.obeyNodeSizes = new JCheckBox();
        this.obeyNodeSizes.setSelected(properties.getPropertyBoolean("organic.obey_node_sizes"));
        jPanel.add(this.setConstraints(this.obeyNodeSizes, gridBagLayout, 1, 3, 17));
        this.setLabel(jPanel, "organic.edge_attraction", gridBagLayout, 0, 4, 18);
        this.edgeAttraction = this.createSliderInt("organic.edge_attraction.min", "organic.edge_attraction.max", "organic.edge_attraction");
        this.edgeAttractionText = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("organic.edge_attraction"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.edgeAttraction, this.edgeAttractionText), gridBagLayout, 1, 4, 13));
        this.setLabel(jPanel, "organic.node_repulsion", gridBagLayout, 0, 5, 18);
        this.nodeRepulsion = this.createSliderInt("organic.edge_attraction.min", "organic.edge_attraction.max", "organic.node_repulsion");
        this.nodeRepulsionText = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("organic.node_repulsion"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.nodeRepulsion, this.nodeRepulsionText), gridBagLayout, 1, 5, 13));
        this.setLabel(jPanel, "organic.gravity_factor", gridBagLayout, 0, 6, 18);
        this.gravityFactor = this.createSliderDouble("organic.gravity_factor.min", "organic.gravity_factor.max", "organic.gravity_factor");
        this.gravityFactorText = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("organic.gravity_factor"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.gravityFactor, this.gravityFactorText), gridBagLayout, 1, 6, 13));
        this.setLabel(jPanel, "organic.activate_tree_beautifier", gridBagLayout, 0, 7, 17);
        this.treeBeautifier = new JCheckBox();
        this.treeBeautifier.setSelected(properties.getPropertyBoolean("organic.activate_tree_beautifier"));
        jPanel.add(this.setConstraints(this.treeBeautifier, gridBagLayout, 1, 7, 17));
        return this.resizePanel(jPanel);
    }

    private JPanel createAlgorithmPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.setLabel(jPanel, "organic.iteration_factor", gridBagLayout, 0, 0, 17);
        this.iteratorFactor = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("organic.iteration_factor"), 10);
        jPanel.add(this.setConstraints(this.iteratorFactor, gridBagLayout, 1, 0, 17));
        this.setLabel(jPanel, "organic.maximal_duration", gridBagLayout, 0, 1, 17);
        this.maximalDuration = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("organic.maximal_duration"), 10);
        jPanel.add(this.setConstraints(this.maximalDuration, gridBagLayout, 1, 1, 17));
        this.setLabel(jPanel, "organic.activate_deterministic_mode", gridBagLayout, 0, 2, 17);
        this.deterministicMode = new JCheckBox();
        this.deterministicMode.setSelected(properties.getPropertyBoolean("organic.activate_deterministic_mode"));
        jPanel.add(this.setConstraints(this.deterministicMode, gridBagLayout, 1, 2, 17));
        return this.resizePanel(jPanel);
    }

    private JPanel createGroupingPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.setLabel(jPanel, "organic.group_layout_policy", gridBagLayout, 0, 0, 17);
        Object[] objectArray = new Object[]{new YDialog.GroupingPolicyItem(this, "organic.group_layout_policy.layout_groups"), new YDialog.GroupingPolicyItem(this, "organic.group_layout_policy.fix_contents_of_groups")};
        this.layoutPolicy = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.layoutPolicy, "organic.group_layout_policy");
        jPanel.add(this.setConstraints(this.layoutPolicy, gridBagLayout, 1, 0, 17));
        this.setLabel(jPanel, "organic.group_node_compactness", gridBagLayout, 0, 1, 18);
        this.nodeCompactness = this.createSliderDouble("organic.group_node_compactness.min", "organic.group_node_compactness.max", "organic.group_node_compactness");
        this.nodeCompactnessText = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("organic.group_node_compactness"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.nodeCompactness, this.nodeCompactnessText), gridBagLayout, 1, 1, 13));
        return this.resizePanel(jPanel);
    }

    private class InitialPlacementItem
    extends YDialog.AbstractItem {
        byte initialPlacement;

        public InitialPlacementItem(String string, byte by) {
            super(ClassicOrganicLayoutDialog.this, string);
            this.initialPlacement = by;
        }
    }

    private class SphereOfActionItem
    extends YDialog.AbstractItem {
        byte action;

        public SphereOfActionItem(String string, byte by) {
            super(ClassicOrganicLayoutDialog.this, string);
            this.action = by;
        }
    }
}

