/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.sbml.autoLayout.y.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jp.sbi.sbml.autoLayout.y.option.LayoutResourceBundleUtil;
import jp.sbi.sbml.autoLayout.y.option.OptionHandler;
import jp.sbi.sbml.autoLayout.y.option.YDialog;

public class CircularLayoutDialog
extends YDialog {
    private JComboBox layoutStyle;
    private JCheckBox actOnSelectionOnly;
    private JCheckBox useDrawingAsSketch;
    private JComboBox partitionLayoutStyle;
    private JSlider nodeDistance;
    private JTextField nodeDistanceText;
    private JCheckBox radiusAutomatically;
    private JSlider fixedRadius;
    private JTextField fixedRadiusText;
    private JSlider childWedge;
    private JTextField childWedgeText;
    private JSlider edgeLength;
    private JTextField edgeLengthText;
    private JSlider deviationAngle;
    private JTextField deviationAngleText;
    private JSlider compactnessFactor;
    private JTextField compactnessFactorText;
    private JCheckBox allowOverlaps;

    public CircularLayoutDialog(JFrame jFrame) {
        super(jFrame);
        this.init();
    }

    public CircularLayoutDialog(JDialog jDialog) {
        super(jDialog);
        this.init();
    }

    private void init() {
        this.setTitle(LayoutResourceBundleUtil.getString("circular.title"));
        this.subTitleLabel = new JLabel(LayoutResourceBundleUtil.getString("circular.subtitle"));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(LayoutResourceBundleUtil.getString("circular.general"), this.createGeneralPanel());
        jTabbedPane.add(LayoutResourceBundleUtil.getString("circular.partition"), this.createPartitionPanel());
        jTabbedPane.add(LayoutResourceBundleUtil.getString("circular.tree"), this.createTreePanel());
        this.mainPanel = new JPanel(new BorderLayout(5, 5));
        this.mainPanel.add((Component)this.subTitleLabel, "North");
        this.mainPanel.add((Component)jTabbedPane, "Center");
        this.mainPanel.add((Component)this.controlPane, "South");
        this.getContentPane().setLayout(new FlowLayout(1, 10, 10));
        this.getContentPane().add(this.mainPanel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    public OptionHandler getOptionHandler() {
        if (this.op == null) {
            this.op = new OptionHandler("CIRCULAR_LAYOUTER");
        }
        return this.op;
    }

    @Override
    public void setOptionHandler() {
        LayoutStyleItem layoutStyleItem = (LayoutStyleItem)this.layoutStyle.getSelectedItem();
        LayoutStyleItem layoutStyleItem2 = (LayoutStyleItem)this.partitionLayoutStyle.getSelectedItem();
        String string = layoutStyleItem.item;
        boolean bl = this.actOnSelectionOnly.isSelected();
        boolean bl2 = this.useDrawingAsSketch.isSelected();
        String string2 = layoutStyleItem2.item;
        int n = Integer.parseInt(this.nodeDistanceText.getText());
        boolean bl3 = this.radiusAutomatically.isSelected();
        int n2 = Integer.parseInt(this.fixedRadiusText.getText());
        int n3 = Integer.parseInt(this.childWedgeText.getText());
        int n4 = Integer.parseInt(this.edgeLengthText.getText());
        int n5 = Integer.parseInt(this.deviationAngleText.getText());
        double d = Double.parseDouble(this.compactnessFactorText.getText());
        boolean bl4 = this.allowOverlaps.isSelected();
        this.op = new OptionHandler("CIRCULAR_LAYOUTER");
        this.op.addByte("LAYOUT_STYLE", layoutStyleItem.style);
        this.op.addBool("ACT_ON_SELECTION_ONLY", bl);
        this.op.addBool("USE_DRAWING_AS_SKETCH", bl2);
        this.op.addByte("PARTITION_LAYOUT_STYLE", layoutStyleItem2.style);
        this.op.addInt("MINIMAL_NODE_DISTANCE", n);
        this.op.addBool("CHOOSE_RADIUS_AUTOMATICALLY", bl3);
        this.op.addInt("FIXED_RADIUS", n2);
        this.op.addInt("PREFERRED_CHILD_WEDGE", n3);
        this.op.addInt("MINIMAL_EDGE_LENGTH", n4);
        this.op.addInt("MAXIMAL_DEVIATION_ANGLE", n5);
        this.op.addDouble("COMPACTNESS_FACTOR", d);
        this.op.addBool("ALLOW_OVERLAPS", bl4);
        properties.setProperty("circular.general.layout_style", string);
        properties.setProperty("circular.general.act_on_selection_only", bl);
        properties.setProperty("circular.general.use_drawing_as_Sketch", bl2);
        properties.setProperty("circular.partition.layout_style", string2);
        properties.setProperty("circular.partition.minimal_node_distance", n);
        properties.setProperty("circular.partition.choose_radius_automatically", bl3);
        properties.setProperty("circular.partition.fixed_radius", n2);
        properties.setProperty("circular.tree.preferred_child_wedge", n3);
        properties.setProperty("circular.tree.minimal_edge_length", n4);
        properties.setProperty("circular.tree.maximal_deviation_angle", n5);
        properties.setProperty("circular.tree.compactness_factor", d);
        properties.setProperty("circular.tree.allow_overlaps", bl4);
    }

    @Override
    protected void setDefault() {
        this.setDefaultSelectedItem(this.layoutStyle, "circular.general.layout_style");
        this.actOnSelectionOnly.setSelected(properties.getDefaultPropertyBoolean("circular.general.act_on_selection_only"));
        this.useDrawingAsSketch.setSelected(properties.getDefaultPropertyBoolean("circular.general.use_drawing_as_Sketch"));
        this.setDefaultSelectedItem(this.partitionLayoutStyle, "circular.partition.layout_style");
        this.nodeDistance.setValue(properties.getDefaultPropertyInt("circular.partition.minimal_node_distance"));
        this.radiusAutomatically.setSelected(properties.getDefaultPropertyBoolean("circular.partition.choose_radius_automatically"));
        this.fixedRadius.setValue(properties.getDefaultPropertyInt("circular.partition.fixed_radius"));
        this.childWedge.setValue(properties.getDefaultPropertyInt("circular.tree.preferred_child_wedge"));
        this.edgeLength.setValue(properties.getDefaultPropertyInt("circular.tree.minimal_edge_length"));
        this.deviationAngle.setValue(properties.getDefaultPropertyInt("circular.tree.maximal_deviation_angle"));
        this.compactnessFactor.setValue((int)properties.getDefaultPropertyDouble("circular.tree.compactness_factor") * 10);
        this.allowOverlaps.setSelected(properties.getDefaultPropertyBoolean("circular.tree.allow_overlaps"));
    }

    private JPanel createGeneralPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.setLabel(jPanel, "circular.general.layout_style", gridBagLayout, 0, 0, 17);
        Object[] objectArray = new Object[]{new LayoutStyleItem("circular.general.layout_style.bcc_compact", 0), new LayoutStyleItem("circular.general.layout_style.bcc_Isolated", 1), new LayoutStyleItem("circular.general.layout_style.custom_groups", 2), new LayoutStyleItem("circular.general.layout_style.single_cycle", 3)};
        this.layoutStyle = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.layoutStyle, "circular.general.layout_style");
        jPanel.add(this.setConstraints(this.layoutStyle, gridBagLayout, 1, 0, 13));
        this.setLabel(jPanel, "circular.general.act_on_selection_only", gridBagLayout, 0, 1, 17);
        this.actOnSelectionOnly = new JCheckBox();
        this.actOnSelectionOnly.setSelected(properties.getPropertyBoolean("circular.general.act_on_selection_only"));
        jPanel.add(this.setConstraints(this.actOnSelectionOnly, gridBagLayout, 1, 1, 17));
        this.setLabel(jPanel, "circular.general.use_drawing_as_Sketch", gridBagLayout, 0, 2, 17);
        this.useDrawingAsSketch = new JCheckBox();
        this.useDrawingAsSketch.setSelected(properties.getPropertyBoolean("circular.general.use_drawing_as_Sketch"));
        jPanel.add(this.setConstraints(this.useDrawingAsSketch, gridBagLayout, 1, 2, 17));
        return this.resizePanel(jPanel);
    }

    private JPanel createPartitionPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.setLabel(jPanel, "circular.partition.layout_style", gridBagLayout, 0, 0, 17);
        Object[] objectArray = new Object[]{new LayoutStyleItem("circular.partition.layout_style.circle", 0), new LayoutStyleItem("circular.partition.layout_style.disk", 1), new LayoutStyleItem("circular.partition.layout_style.organic_disk", 2)};
        this.partitionLayoutStyle = new JComboBox<Object>(objectArray);
        this.setSelectedItem(this.partitionLayoutStyle, "circular.partition.layout_style");
        jPanel.add(this.setConstraints(this.partitionLayoutStyle, gridBagLayout, 1, 0, 13));
        this.setLabel(jPanel, "circular.partition.minimal_node_distance", gridBagLayout, 0, 1, 18);
        this.nodeDistance = this.createSliderInt("circular.partition.minimal_node_distance.min", "circular.partition.minimal_node_distance.max", "circular.partition.minimal_node_distance");
        this.nodeDistanceText = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("circular.partition.minimal_node_distance"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.nodeDistance, this.nodeDistanceText), gridBagLayout, 1, 1, 13));
        this.setLabel(jPanel, "circular.partition.choose_radius_automatically", gridBagLayout, 0, 2, 17);
        this.radiusAutomatically = new JCheckBox();
        this.radiusAutomatically.setSelected(properties.getPropertyBoolean("circular.partition.choose_radius_automatically"));
        jPanel.add(this.setConstraints(this.radiusAutomatically, gridBagLayout, 1, 2, 17));
        this.setLabel(jPanel, "circular.partition.fixed_radius", gridBagLayout, 0, 3, 18);
        this.fixedRadius = this.createSliderInt("circular.partition.fixed_radius.min", "circular.partition.fixed_radius.max", "circular.partition.fixed_radius");
        this.fixedRadiusText = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("circular.partition.fixed_radius"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.fixedRadius, this.fixedRadiusText), gridBagLayout, 1, 3, 13));
        return this.resizePanel(jPanel);
    }

    private JPanel createTreePanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.setLabel(jPanel, "circular.tree.preferred_child_wedge", gridBagLayout, 0, 0, 18);
        this.childWedge = this.createSliderInt("circular.tree.preferred_child_wedge.min", "circular.tree.preferred_child_wedge.max", "circular.tree.preferred_child_wedge");
        this.childWedgeText = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("circular.tree.preferred_child_wedge"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.childWedge, this.childWedgeText), gridBagLayout, 1, 0, 13));
        this.setLabel(jPanel, "circular.tree.minimal_edge_length", gridBagLayout, 0, 1, 18);
        this.edgeLength = this.createSliderInt("circular.tree.minimal_edge_length.min", "circular.tree.minimal_edge_length.max", "circular.tree.minimal_edge_length");
        this.edgeLengthText = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("circular.tree.minimal_edge_length"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.edgeLength, this.edgeLengthText), gridBagLayout, 1, 1, 13));
        this.setLabel(jPanel, "circular.tree.maximal_deviation_angle", gridBagLayout, 0, 2, 18);
        this.deviationAngle = this.createSliderInt("circular.tree.maximal_deviation_angle.min", "circular.tree.maximal_deviation_angle.max", "circular.tree.maximal_deviation_angle");
        this.deviationAngleText = new JTextField(new YDialog.IntegerDocument(this), properties.getProperty("circular.tree.maximal_deviation_angle"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.deviationAngle, this.deviationAngleText), gridBagLayout, 1, 2, 13));
        this.setLabel(jPanel, "circular.tree.compactness_factor", gridBagLayout, 0, 3, 18);
        this.compactnessFactor = this.createSliderDouble("circular.tree.compactness_factor.min", "circular.tree.compactness_factor.max", "circular.tree.compactness_factor");
        this.compactnessFactorText = new JTextField(new YDialog.DoubleDocument(this), properties.getProperty("circular.tree.compactness_factor"), 4);
        jPanel.add(this.setConstraints(this.createSliderPanel(this.compactnessFactor, this.compactnessFactorText), gridBagLayout, 1, 3, 13));
        this.setLabel(jPanel, "circular.tree.allow_overlaps", gridBagLayout, 0, 4, 17);
        this.allowOverlaps = new JCheckBox();
        this.allowOverlaps.setSelected(properties.getPropertyBoolean("circular.tree.allow_overlaps"));
        jPanel.add(this.setConstraints(this.allowOverlaps, gridBagLayout, 1, 4, 17));
        return this.resizePanel(jPanel);
    }

    private class LayoutStyleItem
    extends YDialog.AbstractItem {
        byte style;

        public LayoutStyleItem(String string, byte by) {
            super(CircularLayoutDialog.this, string);
            this.style = by;
        }
    }
}

