/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri.impl;

import com.hp.hpl.jena.iri.impl.IRIExamples;
import com.hp.hpl.jena.iri.impl.ViolationCodeInfo;
import java.util.HashMap;
import java.util.Map;

public class Specification
extends IRIExamples {
    public static final Map iris = new HashMap();
    public static final Map schemes = new HashMap();
    private static final Map other = new HashMap();
    public static final Map all = new HashMap();
    private final String uri;
    private final String name;
    private final String title;
    private final String section;
    private final String rfc;
    private final boolean isScheme;
    private final boolean isIri;
    protected long[] violations = new long[5];
    private int required;
    private int prohibited;

    public Specification(String name, String type, String rfc, String uri, String title, String section, String[] bad, String[] good) {
        super(bad, good);
        this.rfc = rfc;
        if (type.equals("iri")) {
            this.isScheme = false;
            this.isIri = true;
            iris.put(name, this);
        } else if (type.equals("scheme")) {
            this.isScheme = true;
            this.isIri = false;
            schemes.put(name, this);
        } else if (type.equals("other")) {
            this.isScheme = false;
            this.isIri = false;
            other.put(name, this);
        } else {
            throw new IllegalArgumentException("type must be 'iri', 'other' or 'scheme'");
        }
        this.uri = uri;
        this.name = name;
        this.section = section.equals("") ? null : section;
        this.title = title;
        if (all.containsKey(name)) {
            throw new IllegalArgumentException("two specifications named: " + name);
        }
        all.put(name, this);
    }

    public static Specification get(String name) {
        Specification rslt = (Specification)all.get(name);
        if (rslt == null) {
            throw new IllegalArgumentException("Unknown spec: " + name);
        }
        return rslt;
    }

    public String getUri() {
        return this.uri;
    }

    public void add(ViolationCodeInfo.InSpec spec, ViolationCodeInfo info) {
        long mask = 1L << info.getCode();
        int force = info.getForce();
        for (int i = 0; i < 5; ++i) {
            if ((force & 1 << i) == 0) continue;
            int n = i;
            this.violations[n] = this.violations[n] | mask;
        }
    }

    public long getErrors(int i) {
        return this.violations[i];
    }

    public String name() {
        return this.name;
    }

    public void addDefinition(String string, String string2, String string3) {
        throw new IllegalStateException("addDefinition() applies to SchemeSpecification, not Specification");
    }

    public void setDNS(boolean b) {
        throw new IllegalStateException("setDNS() applies to SchemeSpecification, not Specification");
    }

    public void port(int i) {
        throw new IllegalStateException("port() applies to SchemeSpecification, not Specification");
    }

    public void prohibit(int component) {
        this.prohibited |= 1 << component;
    }

    public void require(int component) {
        this.required |= 1 << component;
    }

    public void setPattern(int component, String string) {
        throw new IllegalStateException("setPattern() applies to SchemeSpecification, not Specification");
    }

    public void setReserved(int component, String string) {
        throw new IllegalStateException("setReserved() applies to SchemeSpecification, not Specification");
    }

    public int getProhibited() {
        return this.prohibited;
    }

    public int getRequired() {
        return this.required;
    }

    public boolean isIRISpec() {
        return this.isIri;
    }

    public boolean isSchemeSpec() {
        return this.isScheme;
    }
}

