/*
 * Decompiled with CFR 0.152.
 */
package grace.util;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import grace.io.PrintWriter;
import grace.log.Log;
import grace.util.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Tokenizer {
    private String source;
    private int position = 0;
    private int lastPosition = 0;

    public Tokenizer(String string) {
        this.source = string;
    }

    public void injectNewlines(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.source.length() + 100);
        int n2 = 0;
        while (n2 < this.source.length()) {
            int n3 = n2 + n;
            if (n3 > this.source.length()) {
                n3 = this.source.length();
            }
            stringBuffer.append(this.source.substring(n2, n3));
            stringBuffer.append('\n');
            n2 = n3;
        }
        this.source = stringBuffer.toString();
    }

    public Object clone() {
        return this.clone();
    }

    public void skipWhiteSpace() {
        while (Character.isWhitespace(this.source.charAt(this.position))) {
            ++this.position;
        }
    }

    protected String getMatch(RE rE) {
        String string = null;
        REMatch rEMatch = rE.getMatch(this.source, this.position);
        if (rEMatch != null) {
            string = rEMatch.toString();
            this.position = rEMatch.getEndIndex();
        }
        return string;
    }

    protected String getSubstitutedMatch(RE rE, String string) {
        String string2 = null;
        REMatch rEMatch = rE.getMatch(this.source, this.position);
        if (rEMatch != null) {
            string2 = rEMatch.substituteInto(string);
            this.position = rEMatch.getEndIndex();
        }
        return string2;
    }

    public void advance(int n) {
        this.position += n;
    }

    public void advance(String string) throws REException {
        this.advance(new RE(string));
    }

    public void advance(RE rE) {
        this.lastPosition = this.position;
        REMatch rEMatch = rE.getMatch(this.source, this.position);
        if (rEMatch != null) {
            this.position = rEMatch.getStartIndex();
        }
    }

    public void advance(String string, int n) throws REException {
        this.advance(new RE(string), n);
    }

    public void advance(RE rE, int n) {
        this.lastPosition = this.position;
        REMatch rEMatch = rE.getMatch(this.source, this.position);
        if (rEMatch != null) {
            int n2 = rEMatch.getSubStartIndex(n);
            this.position = n2 == -1 ? rEMatch.getStartIndex() : n2;
            Log.trace("advanced to", this);
        }
    }

    public String find(String string) throws REException {
        return this.find(new RE(string));
    }

    public String find(RE rE) {
        this.lastPosition = this.position;
        return this.getMatch(rE);
    }

    public String findAndSubstitute(String string, String string2) throws REException {
        return this.findAndSubstitute(new RE(string), string2);
    }

    public String findAndSubstitute(RE rE, String string) {
        this.lastPosition = this.position;
        return this.getSubstitutedMatch(rE, string);
    }

    public void retreat(int n) {
        this.position -= n;
    }

    public void retreat(String string) throws REException {
        this.retreat(new RE(string));
    }

    public void retreat(RE rE) {
        this.lastPosition = this.position;
        REMatch rEMatch = rE.getMatch(this.source, this.position);
        if (rEMatch != null) {
            this.position = rEMatch.getStartIndex();
        }
    }

    public String get(String string) throws REException {
        return this.get(new RE(string), 0);
    }

    public String get(RE rE) {
        return this.get(rE, 0);
    }

    public String get(String string, int n) throws REException {
        return this.get(new RE(string, n));
    }

    public String get(RE rE, int n) {
        this.lastPosition = this.position;
        try {
            REMatch rEMatch = rE.getMatch(this.source, this.position);
            if (rEMatch.getStartIndex() <= this.position + n) {
                this.position = rEMatch.getEndIndex();
                return rEMatch.toString();
            }
            return "";
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getToken() {
        this.lastPosition = this.position;
        try {
            return this.getMatch(new RE("\\S+"));
        }
        catch (REException rEException) {
            return null;
        }
    }

    public String getToken(int n) {
        this.lastPosition = this.position;
        try {
            RE rE = new RE("\\S+");
            REMatch rEMatch = rE.getMatch(this.source, this.position);
            if (rEMatch.getStartIndex() <= this.position + n) {
                this.position = rEMatch.getEndIndex();
                return rEMatch.toString();
            }
            return "";
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getLine() {
        try {
            this.lastPosition = this.position;
            int n = this.position;
            if (this.source.charAt(this.position) == '\n') {
                ++this.position;
            }
            n = this.position;
            while (n < this.source.length() && this.source.charAt(n) != '\n') {
                ++n;
            }
            if (this.position == n) {
                return null;
            }
            String string = this.source.substring(this.position, n);
            this.position = n + 1;
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getInt() throws NumberFormatException {
        return Integer.parseInt(this.getToken());
    }

    public int getInt(int n) throws NumberFormatException {
        try {
            return Integer.parseInt(this.get("\\s*\\d{1," + n + "}"));
        }
        catch (REException rEException) {
            return Integer.MIN_VALUE;
        }
    }

    public int getInt(String string, String string2) throws NumberFormatException, REException {
        return this.getInt(new RE(string), string2);
    }

    public int getInt(RE rE, String string) throws NumberFormatException {
        this.skipWhiteSpace();
        REMatch rEMatch = rE.getMatch(this.source, this.position);
        if (rEMatch != null && rEMatch.getStartIndex() == 0) {
            String string2 = rEMatch.substituteInto(string);
            return Integer.parseInt(string2);
        }
        throw new NumberFormatException();
    }

    public int getPrefixedInt(String string) throws NumberFormatException, REException {
        this.lastPosition = this.position;
        String string2 = this.getMatch(new RE(string));
        return this.getInt();
    }

    public int getNextInt() throws ParseException {
        this.lastPosition = this.position;
        String string = null;
        try {
            string = this.getMatch(new RE("\\d+"));
        }
        catch (REException rEException) {
            // empty catch block
        }
        if (string == null) {
            throw new ParseException("can't find an int", this.position);
        }
        return Integer.parseInt(string);
    }

    public Date getDate(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(Time.gmt());
        return this.getDate(simpleDateFormat);
    }

    public Date getDate(DateFormat dateFormat) throws ParseException {
        this.lastPosition = this.position;
        this.skipWhiteSpace();
        ParsePosition parsePosition = new ParsePosition(this.position);
        Date date = dateFormat.parse(this.source, parsePosition);
        if (date == null) {
            throw new ParseException("can't parse date", this.position);
        }
        this.position = parsePosition.getIndex();
        return date;
    }

    public Date getTime(String string, Date date) throws ParseException {
        return this.getTime(new SimpleDateFormat(string), date);
    }

    public Date getTime(DateFormat dateFormat, Date date) throws ParseException {
        this.lastPosition = this.position;
        this.skipWhiteSpace();
        ParsePosition parsePosition = new ParsePosition(this.position);
        Date date2 = dateFormat.parse(this.source, parsePosition);
        if (date2 == null) {
            throw new ParseException("can't parse date", this.position);
        }
        date2 = Time.mergedDateAndTime(date, date2);
        this.position = parsePosition.getIndex();
        return date2;
    }

    public Date getPrefixedDate(String string, String string2) throws ParseException, REException {
        return this.getPrefixedDate(new RE(string), string2);
    }

    public Date getPrefixedDate(RE rE, String string) throws ParseException {
        String string2 = this.getMatch(rE);
        return this.getDate(string);
    }

    public Date getPrefixedDate(String string, DateFormat dateFormat) throws ParseException, REException {
        return this.getPrefixedDate(new RE(string), dateFormat);
    }

    public Date getPrefixedDate(RE rE, DateFormat dateFormat) throws ParseException {
        String string = this.getMatch(rE);
        return this.getDate(dateFormat);
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.lastPosition = this.position;
        this.position = n;
    }

    public String getSource() {
        return this.source;
    }

    public void undoLast() {
        this.position = this.lastPosition;
    }

    public boolean isAt(String string) throws REException {
        return this.isAt(new RE(string));
    }

    public boolean isAt(RE rE) {
        REMatch rEMatch = rE.getMatch(this.source, this.position);
        return rEMatch != null && rEMatch.getStartIndex() == this.position;
    }

    protected String toPrintable(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void printTo(PrintWriter printWriter) {
        printWriter.print("context", this.toString());
    }

    public String toString() {
        int n = this.position - 10;
        int n2 = this.position + 10;
        return this.toPrintable(this.source.substring(n > 0 ? n : 0, this.position) + '[' + this.source.charAt(this.position) + ']' + this.source.substring(this.position + 1, n2 < this.source.length() ? n2 : this.source.length()));
    }

    public static void main(String[] stringArray) {
        try {
            TimeZone.setDefault(Time.gmt());
            Tokenizer tokenizer = new Tokenizer("12:34:56");
            Date date = new Date();
            Log.trace("base", date);
            Log.trace("parsed", tokenizer.getTime("HH:mm:ss", date));
        }
        catch (Exception exception) {
            Log.error(exception);
        }
    }
}

