/*
 * Decompiled with CFR 0.152.
 */
package grace.util;

import java.text.DecimalFormat;
import java.util.Date;

public class Timer {
    private Date start;
    private long duration = 0L;
    private static DecimalFormat hoursFormat;
    private static DecimalFormat minutesFormat;
    private static DecimalFormat secondsFormat;

    public Timer() {
    }

    public Timer(Timer timer) {
        if (timer != null) {
            this.start = timer.start == null ? null : new Date(timer.start.getTime());
            this.duration = timer.duration;
        }
    }

    public void start() {
        if (this.start == null) {
            this.start = new Date();
        }
    }

    public void stop() {
        if (this.start != null) {
            Date date = new Date();
            this.duration += date.getTime() - this.start.getTime();
            this.start = null;
        }
    }

    public boolean isStopped() {
        return this.start == null;
    }

    public void zero() {
        this.duration = 0L;
        if (this.start != null) {
            this.start = new Date();
        }
    }

    public long durationInMilliSeconds() {
        if (this.start == null) {
            return this.duration;
        }
        Date date = new Date();
        return date.getTime() - this.start.getTime() + this.duration;
    }

    public double duration() {
        return (double)this.durationInMilliSeconds() / 1000.0;
    }

    public String toString() {
        double d = this.duration();
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isStopped()) {
            stringBuffer.append("*");
        }
        if (d > 60.0) {
            long l = (long)(d / 60.0);
            if (l > 60L) {
                long l2 = l / 60L;
                stringBuffer.append(hoursFormat.format(l2) + ":");
            }
            stringBuffer.append(minutesFormat.format(l) + ":");
            stringBuffer.append(secondsFormat.format(d));
        } else {
            stringBuffer.append("" + d);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Timer timer = new Timer();
        timer.start();
        try {
            Thread.sleep(1230L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("should be about 1.23 :" + timer);
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        timer.stop();
        System.out.println("should be about 1.33 : " + timer);
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("should still be about 1.33 : " + timer);
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("should still be about 1.33 : " + timer);
        timer.start();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("should be about 1.43 : " + timer);
        timer.zero();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("should be about 0.1 : " + timer);
    }

    static {
        minutesFormat = hoursFormat = new DecimalFormat("00");
        secondsFormat = new DecimalFormat("00.###");
    }
}

