/*
 * Decompiled with CFR 0.152.
 */
package grace.log;

import grace.log.Writer;
import java.io.Serializable;

public class StackTrace
implements Serializable {
    public static final String rcsid = "$Id: StackTrace.java,v 0.7.3.1 2001/07/04 19:10:16 mhucka Exp $";
    private static Writer writer = new Writer();
    private Throwable stackTrace = new Throwable();
    private Throwable exception;
    private String classname = "";
    private String function = "";
    private String filename = "";
    private int lineNumber = -1;
    private int currentLevel = 0;

    public static synchronized String currentStackLine(Throwable throwable, int n) {
        writer.clear();
        writer.setDesiredLineNum(n);
        throwable.printStackTrace(writer);
        return writer.toString();
    }

    public StackTrace() {
        this.setLevel(0);
    }

    public StackTrace(int n) {
        this.setLevel(n);
    }

    public StackTrace(Exception exception) {
        this.exception = exception;
        this.setLevel(-1);
    }

    public StackTrace(Exception exception, int n) {
        this.exception = exception;
        this.setLevel(n - 1);
    }

    public void setLevel(int n) {
        this.currentLevel = n + 2;
        Throwable throwable = this.exception == null ? this.stackTrace : this.exception;
        String string = StackTrace.currentStackLine(throwable, this.currentLevel);
        if (string.equals("")) {
            string = StackTrace.currentStackLine(this.stackTrace, 1);
        }
        this.parse(string);
    }

    public void setClassname(String string) {
        this.classname = string;
    }

    public String getClassname() {
        return this.classname;
    }

    public String getShortClassname() {
        try {
            return this.classname.substring(this.classname.lastIndexOf(46) + 1, this.classname.length());
        }
        catch (Exception exception) {
            return this.classname;
        }
    }

    public String getFunction() {
        return this.function;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getLineNumberString() {
        return this.lineNumber >= 0 ? "" + this.lineNumber : "";
    }

    protected void parse(String string) {
        this.lineNumber = 0;
        this.filename = "";
        this.function = "";
        this.classname = "";
        int n = 0;
        try {
            n = string.lastIndexOf(58);
            String string2 = string.substring(n + 1, string.length() - 1);
            this.lineNumber = Integer.valueOf(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = 0;
        try {
            n2 = string.lastIndexOf(40);
            if (n <= 0 && (n = string.indexOf(41, n2)) <= 0) {
                n = string.length() - 1;
            }
            this.filename = string.substring(n2 + 1, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n3 = 0;
        try {
            n3 = string.lastIndexOf(46, n2);
            this.function = string.substring(n3 + 1, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n4 = string.lastIndexOf(32, n3);
            n4 = n4 == -1 ? 0 : ++n4;
            this.classname = string.substring(n4, n3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return "class=" + this.getClassname() + " function=" + this.getFunction() + " file=" + this.getFilename() + " line=" + this.getLineNumberString();
    }
}

