/*
 * Decompiled with CFR 0.152.
 */
package grace.log;

import grace.log.Event;
import grace.log.EventFormat;
import grace.log.Handler;
import grace.log.Log;
import grace.log.PrintCatcher;
import grace.util.Properties;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Enumeration;

public class PrintHandler
implements Handler {
    public static final String rcsid = "$Id: PrintHandler.java,v 0.7.3.1 2001/07/04 19:10:16 mhucka Exp $";
    private PrintWriter out;
    protected EventFormat format = new EventFormat();

    public PrintHandler(String string, String string2) throws RemoteException {
        this(System.out);
        this.loadProperties(string + string2);
    }

    public PrintHandler(PrintWriter printWriter) throws RemoteException {
        this.out = printWriter;
    }

    public PrintHandler(PrintStream printStream) throws RemoteException {
        this.setOut(printStream);
    }

    public void loadProperties(String string) {
        String string2;
        String string3;
        Enumeration enumeration;
        Object object;
        Properties properties = new Properties();
        properties.loadSystem();
        String string4 = properties.get(string + ".color");
        if (string4 != null) {
            this.format.useColors(string4.equals("true"));
        }
        try {
            object = properties.subset(string + "\\.event\\.(.+)\\.color$", "$1");
            enumeration = ((Properties)object).names();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                string2 = ((Properties)object).get(string3);
                this.format.setEventColor(string3, this.format.colorListToColor(string2));
            }
        }
        catch (Exception exception) {
            Log.internal(exception);
        }
        try {
            object = properties.subset(string + "\\.line\\.(.+)\\.color$", "$1");
            enumeration = ((Properties)object).names();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                string2 = ((Properties)object).get(string3);
                this.format.setLineColor(string3, this.format.colorListToColor(string2));
            }
        }
        catch (Exception exception) {
            Log.internal(exception);
        }
        object = null;
        object = properties.get(string + ".time.color");
        if (object != null) {
            this.format.setTimeColor(this.format.colorListToColor((String)object));
        }
        if ((object = properties.get(string + ".time.relative.color")) != null) {
            this.format.setRelativeTimeColor(this.format.colorListToColor((String)object));
        }
        if ((object = properties.get(string + ".exception.color")) != null) {
            this.format.setExceptionColor(this.format.colorListToColor((String)object));
        }
        if ((object = properties.get(string + ".message.color")) != null) {
            this.format.setMessageColor(this.format.colorListToColor((String)object));
        }
        if ((object = properties.get(string + ".object.color")) != null) {
            this.format.setObjectColor(this.format.colorListToColor((String)object));
        }
        if ((object = properties.get(string + ".thread.color")) != null) {
            this.format.setThreadColor(this.format.colorListToColor((String)object));
        }
        if ((object = properties.get(string + ".classname.color")) != null) {
            this.format.setClassnameColor(this.format.colorListToColor((String)object));
        }
        if ((object = properties.get(string + ".function.color")) != null) {
            this.format.setFunctionColor(this.format.colorListToColor((String)object));
        }
    }

    public void setOut(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public void setOut(PrintStream printStream) {
        if (printStream instanceof PrintCatcher) {
            printStream = ((PrintCatcher)printStream).getOriginalStream();
        }
        this.out = new PrintWriter(printStream);
    }

    public PrintWriter getOut() {
        return this.out;
    }

    public synchronized void handle(Event event) {
        this.out.print(this.format.format(event));
        this.out.flush();
    }
}

