/*
 * Decompiled with CFR 0.152.
 */
package grace.log;

import grace.log.Event;
import grace.log.Log;
import grace.log.StackTrace;
import java.io.PrintStream;

public class PrintCatcher
extends PrintStream {
    public static final String rcsid = "$Id: PrintCatcher.java,v 0.7.3.1 2001/07/04 19:10:16 mhucka Exp $";
    private PrintStream original;
    private String eventType = "notice";
    private boolean bufferPrints = true;
    private StringBuffer buffer = new StringBuffer();

    public static void install() {
        PrintCatcher.installOut();
        PrintCatcher.installErr();
    }

    public static void uninstall() {
        if (System.out instanceof PrintCatcher) {
            System.setOut(((PrintCatcher)System.out).getOriginalStream());
        }
        if (System.err instanceof PrintCatcher) {
            System.setErr(((PrintCatcher)System.err).getOriginalStream());
        }
    }

    public static void installOut() {
        PrintCatcher.installOut("notice");
    }

    public static void installOut(String string) {
        if (!(System.out instanceof PrintCatcher)) {
            Log.internal("installed PrintCatcher on System.out");
            System.setOut(new PrintCatcher(string, System.out));
        }
    }

    public static void installErr() {
        PrintCatcher.installErr("error");
    }

    public static void installErr(String string) {
        if (!(System.err instanceof PrintCatcher)) {
            Log.internal("installed PrintCatcher on System.err");
            System.setErr(new PrintCatcher(string, System.err));
        }
    }

    public PrintCatcher() {
        super(System.out);
        this.original = System.out;
    }

    public PrintCatcher(String string) {
        this(string, System.out);
        this.original = System.out;
    }

    public PrintCatcher(String string, PrintStream printStream) {
        super(printStream);
        this.original = printStream;
    }

    public PrintStream getOriginalStream() {
        return this.original;
    }

    public void setBufferedPrints(boolean bl) {
        this.bufferPrints = bl;
    }

    public void print(char c) {
        this.print("" + c, 2);
    }

    public void println(char c) {
        this.println("" + c, 2);
    }

    public void print(char[] cArray) {
        this.print("" + cArray, 2);
    }

    public void println(char[] cArray) {
        this.println("" + cArray, 2);
    }

    public void print(boolean bl) {
        this.print("" + bl, 2);
    }

    public void println(boolean bl) {
        this.println("" + bl, 2);
    }

    public void print(int n) {
        this.print("" + n, 2);
    }

    public void println(int n) {
        this.println("" + n, 2);
    }

    public void print(long l) {
        this.print("" + l, 2);
    }

    public void println(long l) {
        this.println("" + l, 2);
    }

    public void print(float f) {
        this.print("" + f, 2);
    }

    public void println(float f) {
        this.println("" + f, 2);
    }

    public void print(double d) {
        this.print("" + d, 2);
    }

    public void println(double d) {
        this.println("" + d, 2);
    }

    public void print(String string) {
        this.print(string, 2);
    }

    public void println(String string) {
        this.println(string, 2);
    }

    protected void print(String string, int n) {
        if (this.bufferPrints) {
            this.buffer.append(string);
        } else {
            Event event = new Event(this.eventType);
            event.setMessage(string);
            event.setPosition(new StackTrace(n));
            Log.getInstance().distribute(event);
        }
    }

    protected void println(String string, int n) {
        if (this.bufferPrints) {
            this.buffer.append(string);
            string = this.buffer.toString();
            this.buffer.setLength(0);
        }
        Event event = new Event(this.eventType);
        event.setMessage(string);
        event.setPosition(new StackTrace(n));
        Log.getInstance().distribute(event);
    }

    public void print(Object object) {
        Event event = new Event(this.eventType);
        event.setObject(object);
        event.setPosition(new StackTrace(1));
        Log.getInstance().distribute(event);
    }

    public void print(Exception exception) {
        Event event = new Event("error");
        event.setObject(exception);
        event.setPosition(new StackTrace(exception));
        Log.getInstance().distribute(event);
    }
}

