/*
 * Decompiled with CFR 0.152.
 */
package grace.log;

import gnu.regexp.RE;
import gnu.regexp.REException;
import grace.log.Distributer;
import grace.log.Event;
import grace.log.EventFormat;
import grace.log.Handler;
import grace.log.ProxyHandler;
import grace.log.StackTrace;
import grace.log.StandardOutHandler;
import grace.log.test.GeneralTest;
import java.io.NotSerializableException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.rmi.MarshalException;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.dgc.VMID;
import java.rmi.server.UnicastRemoteObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Log
implements Distributer {
    public static final String rcsid = "$Id: Log.java,v 0.7.3.1 2001/07/04 19:10:16 mhucka Exp $";
    public static final String ERROR = "error";
    public static final String WARNING = "warning";
    public static final String NOTICE = "notice";
    public static final String TRACE = "trace";
    private static final String handlerPropertyPrefix = "log.handler.";
    private static final String defaultHandlerPackage = "grace.log";
    private static final String defaultHandlerClassname = "grace.log.StandardOutputHandler";
    private static final String standardOutName = "out";
    private static final SimpleDateFormat internalDateFormat = new SimpleDateFormat("MM/dd/yy hh:mm:ss");
    private static final String rawVirtualMachineId = new VMID().toString();
    private static grace.util.Properties properties = new grace.util.Properties();
    private static String hostname = "localhost";
    private static int numInstantiatedDistributers = 0;
    private String name = properties.get("log.name", ++numInstantiatedDistributers == 1 ? this.virtualMachineId() : this.virtualMachineId() + numInstantiatedDistributers);
    private boolean enablesInitialized = false;
    private boolean errorsEnabled = true;
    private boolean warningsEnabled = true;
    private boolean noticesEnabled = true;
    private boolean tracesEnabled = true;
    private static boolean internalLogEnabled = false;
    private Hashtable allHandlers = new Hashtable();
    private Hashtable eventHandlers = new Hashtable();
    private Vector functionNamesToInclude = new Vector();
    private Vector functionNamesToExclude = new Vector();
    private Vector eventTypesToInclude = new Vector();
    private Vector eventTypesToExclude = new Vector();
    private EventFormat defaultObjectFormat = new EventFormat("%(%j)o");
    private boolean initialized = false;
    private static Log instance;
    static /* synthetic */ Class class$grace$log$FileHandler;
    static /* synthetic */ Class class$grace$log$JDBCHandler;
    static /* synthetic */ Class class$grace$log$StandardOutHandler;
    static /* synthetic */ Class class$java$lang$String;

    public static Log getInstance() {
        return instance;
    }

    public static void log(String string, String string2) {
        if (instance.eventTypeEnabled(string)) {
            Event event = new Event(string);
            event.setMessage(string2);
            event.setPosition(new StackTrace(1));
            instance.distribute(event);
        }
    }

    public static void log(String string, Object object) {
        if (instance.eventTypeEnabled(string)) {
            Event event = new Event(string);
            event.setObject(object);
            event.setPosition(new StackTrace(1));
            instance.distribute(event);
        }
    }

    public static void log(String string, String string2, Object object) {
        if (instance.eventTypeEnabled(string)) {
            Event event = new Event(string);
            event.setMessage(string2);
            event.setObject(object);
            event.setPosition(new StackTrace(1));
            instance.distribute(event);
        }
    }

    public static void error(String string) {
        if (instance.eventTypeEnabled(ERROR)) {
            Event event = new Event(ERROR);
            event.setMessage(string);
            event.setPosition(new StackTrace(1));
            instance.distribute(event);
        }
    }

    public static void error(String string, Object object) {
        if (instance.eventTypeEnabled(ERROR)) {
            Event event = new Event(ERROR);
            event.setMessage(string);
            event.setObject(object);
            event.setPosition(new StackTrace(1));
            instance.distribute(event);
        }
    }

    public static void error(Exception exception) {
        if (instance.eventTypeEnabled(ERROR)) {
            Event event = new Event(ERROR);
            event.setObject(exception);
            event.setPosition(new StackTrace(exception));
            instance.distribute(event);
        }
    }

    public static void error(String string, Exception exception) {
        if (instance.eventTypeEnabled(ERROR)) {
            Event event = new Event(ERROR);
            event.setMessage(string);
            event.setObject(exception);
            event.setPosition(new StackTrace(exception));
            instance.distribute(event);
        }
    }

    public static void warning(String string) {
        if (instance.eventTypeEnabled(WARNING)) {
            Event event = new Event(WARNING);
            event.setMessage(string);
            event.setPosition(new StackTrace(1));
            instance.distribute(event);
        }
    }

    public static void warning(String string, Object object) {
        if (instance.eventTypeEnabled(WARNING)) {
            Event event = new Event(WARNING);
            event.setMessage(string);
            event.setObject(object);
            event.setPosition(new StackTrace(1));
            instance.distribute(event);
        }
    }

    public static void warning(String string, Exception exception) {
        if (instance.eventTypeEnabled(WARNING)) {
            Event event = new Event(WARNING);
            event.setMessage(string);
            event.setObject(exception);
            event.setPosition(new StackTrace(exception));
            instance.distribute(event);
        }
    }

    public static void notice(String string) {
        if (instance.eventTypeEnabled(NOTICE)) {
            Event event = new Event(NOTICE);
            event.setMessage(string);
            event.setPosition(new StackTrace(1));
            instance.distribute(event);
        }
    }

    public static void notice(String string, Object object) {
        if (instance.eventTypeEnabled(NOTICE)) {
            Event event = new Event(NOTICE);
            event.setMessage(string);
            event.setObject(object);
            event.setPosition(new StackTrace(1));
            instance.distribute(event);
        }
    }

    public static void trace() {
        if (instance.eventTypeEnabled(TRACE)) {
            Event event = new Event(TRACE);
            event.setPosition(new StackTrace(1));
            instance.distribute(event);
        }
    }

    public static void trace(String string) {
        if (instance.eventTypeEnabled(TRACE)) {
            Event event = new Event(TRACE);
            event.setMessage(string);
            event.setPosition(new StackTrace(1));
            instance.distribute(event);
        }
    }

    public static void trace(Object object) {
        if (instance.eventTypeEnabled(TRACE)) {
            Event event = new Event(TRACE);
            event.setObject(object);
            event.setPosition(new StackTrace(1));
            instance.distribute(event);
        }
    }

    public static void trace(String string, Object object) {
        if (instance.eventTypeEnabled(TRACE)) {
            Event event = new Event(TRACE);
            event.setMessage(string);
            event.setObject(object);
            event.setPosition(new StackTrace(1));
            instance.distribute(event);
        }
    }

    public static synchronized void internal(String string) {
        if (internalLogEnabled) {
            System.out.print(internalDateFormat.format(new Date()));
            StackTrace stackTrace = new StackTrace(1);
            System.out.print(": ");
            System.out.print(stackTrace.getShortClassname());
            System.out.print('.');
            System.out.print(stackTrace.getFunction());
            System.out.print(':');
            System.out.print(stackTrace.getLineNumber());
            System.out.print(": internal: ");
            System.out.println(string);
        }
    }

    public static synchronized void internal(Exception exception) {
        System.out.print(internalDateFormat.format(new Date()));
        StackTrace stackTrace = new StackTrace(1);
        System.out.print(": ");
        System.out.print(stackTrace.getShortClassname());
        System.out.print('.');
        System.out.print(stackTrace.getFunction());
        System.out.print(':');
        System.out.print(stackTrace.getLineNumber());
        System.out.print(": internal: ");
        exception.printStackTrace();
        System.out.println();
    }

    public Log() {
        try {
            this.initialize();
        }
        catch (Exception exception) {
            Log.internal(exception);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = Log.replaceBadPunctuation(string);
    }

    protected String virtualMachineId() {
        return Log.replaceBadPunctuation(rawVirtualMachineId);
    }

    protected static String replaceBadPunctuation(String string) {
        return string.replace(':', '.');
    }

    protected void dispatch(Handler handler, Event event) {
        try {
            handler.handle(event);
        }
        catch (MarshalException marshalException) {
            if (marshalException.detail instanceof NotSerializableException && event.object != null) {
                try {
                    event.object = this.defaultObjectFormat.format(event);
                    handler.handle(event);
                }
                catch (Exception exception) {
                    Log.internal("bad connection to handler; removing: " + exception.getMessage());
                    this.removeHandler(handler);
                }
            }
        }
        catch (Exception exception) {
            Log.internal(exception);
            Log.internal("bad connection to handler; removing...");
            this.removeHandler(handler);
        }
    }

    protected void removeHandler(Handler handler) {
        Log.internal("removing handler " + handler);
        this.removeObjectFrom(this.allHandlers, handler);
        this.removeObjectFrom(this.eventHandlers, handler);
    }

    protected void removeObjectFrom(Hashtable hashtable, Object object) {
        Enumeration enumeration = hashtable.keys();
        Enumeration enumeration2 = hashtable.elements();
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = enumeration2.nextElement();
            if (!v.equals(object)) continue;
            hashtable.remove(k);
        }
    }

    public void distribute(Event event) {
        if (this.eventIsInteresting(event)) {
            Enumeration enumeration;
            event.setHostname(hostname);
            event.setVirtualMachineName(this.name);
            Hashtable hashtable = (Hashtable)this.eventHandlers.get(event.type);
            if (hashtable != null) {
                enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    this.dispatch((Handler)enumeration.nextElement(), event);
                }
            }
            enumeration = this.allHandlers.elements();
            while (enumeration.hasMoreElements()) {
                this.dispatch((Handler)enumeration.nextElement(), event);
            }
        }
    }

    protected boolean eventIsInteresting(Event event) {
        String string = event.position.getClassname() + '.' + event.position.getFunction();
        return this.eventFieldIsInteresting(string, this.functionNamesToInclude, this.functionNamesToExclude);
    }

    protected boolean eventFieldIsInteresting(String string, Vector vector, Vector vector2) {
        boolean bl = false;
        int n = 0;
        while (n < vector.size()) {
            RE rE = (RE)vector.elementAt(n);
            if (rE.isMatch(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            int n2 = 0;
            while (n2 < vector2.size()) {
                RE rE = (RE)vector2.elementAt(n2);
                if (rE.isMatch(string)) {
                    bl = false;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    public static void enableErrors(boolean bl) {
        instance.enableEventType(ERROR, bl);
    }

    public static boolean errorsEnabled() {
        return Log.instance.errorsEnabled;
    }

    public static void enableWarnings(boolean bl) {
        instance.enableEventType(WARNING, bl);
    }

    public static boolean warningsEnabled() {
        return Log.instance.warningsEnabled;
    }

    public static void enableNotices(boolean bl) {
        instance.enableEventType(NOTICE, bl);
    }

    public static boolean noticesEnabled() {
        return Log.instance.noticesEnabled;
    }

    public static void enableTraces(boolean bl) {
        instance.enableEventType(TRACE, bl);
    }

    public static boolean tracesEnabled() {
        return Log.instance.tracesEnabled;
    }

    public void enableEventType(String string, boolean bl) {
        try {
            RE rE = new RE(string);
            if (this.eventTypesToInclude.contains(rE)) {
                this.eventTypesToInclude.removeElement(rE);
            }
            if (this.eventTypesToExclude.contains(rE)) {
                this.eventTypesToExclude.removeElement(rE);
            }
            if (bl) {
                this.eventTypesToInclude.addElement(rE);
            } else {
                this.eventTypesToExclude.addElement(rE);
            }
        }
        catch (REException rEException) {
            rEException.printStackTrace();
        }
    }

    public boolean eventTypeEnabled(String string) {
        return this.eventFieldIsInteresting(string, this.eventTypesToInclude, this.eventTypesToExclude);
    }

    public void addHandler(Handler handler) {
        Log.internal("");
        this.allHandlers.put(handler, handler);
    }

    public void addHandler(Handler handler, String string) {
        Log.internal("");
        Hashtable<Handler, Handler> hashtable = (Hashtable<Handler, Handler>)this.eventHandlers.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<Handler, Handler>();
            this.eventHandlers.put(string, hashtable);
        }
        hashtable.put(handler, handler);
    }

    protected void addToEventHandlers(Handler handler, String string, String string2) {
        if (string2.equals("")) {
            this.allHandlers.put(string, handler);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                Hashtable<String, Handler> hashtable = (Hashtable<String, Handler>)this.eventHandlers.get(string3);
                if (hashtable == null) {
                    hashtable = new Hashtable<String, Handler>();
                    this.eventHandlers.put(string3, hashtable);
                }
                hashtable.put(string, handler);
            }
        }
    }

    protected void addHandler(String string) {
        Log.internal("name=" + string);
        if (!this.allHandlers.contains(string)) {
            String string2 = handlerPropertyPrefix + string;
            Class clazz = class$grace$log$FileHandler == null ? (class$grace$log$FileHandler = Log.class$("grace.log.FileHandler")) : class$grace$log$FileHandler;
            String string3 = properties.get(string2 + ".url");
            if (string3 != null) {
                if (string3.startsWith("jdbc:")) {
                    this.addLocalHandler(string, class$grace$log$JDBCHandler == null ? (class$grace$log$JDBCHandler = Log.class$("grace.log.JDBCHandler")) : class$grace$log$JDBCHandler);
                } else if (string3.startsWith("file:")) {
                    if (string3.endsWith("-")) {
                        this.addLocalHandler(string, class$grace$log$StandardOutHandler == null ? (class$grace$log$StandardOutHandler = Log.class$("grace.log.StandardOutHandler")) : class$grace$log$StandardOutHandler);
                    } else {
                        this.addLocalHandler(string, class$grace$log$FileHandler == null ? (class$grace$log$FileHandler = Log.class$("grace.log.FileHandler")) : class$grace$log$FileHandler);
                    }
                } else if (string3.startsWith("rmi:")) {
                    this.addRemoteObject(string, string3);
                }
            } else {
                this.addLocalHandler(string, class$grace$log$FileHandler == null ? (class$grace$log$FileHandler = Log.class$("grace.log.FileHandler")) : class$grace$log$FileHandler);
            }
        }
    }

    protected void addLocalHandler(String string, Class clazz) {
        String string2 = properties.get(handlerPropertyPrefix + string + ".class");
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName(string2);
        }
        catch (Exception exception) {
            try {
                clazz2 = Class.forName(defaultHandlerPackage + string2);
            }
            catch (Exception exception2) {
                clazz2 = clazz;
            }
        }
        try {
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Log.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Log.class$("java.lang.String")) : class$java$lang$String};
            Constructor<?> constructor = clazz2.getConstructor(classArray);
            Object[] objectArray = new Object[]{handlerPropertyPrefix, string};
            Handler handler = (Handler)constructor.newInstance(objectArray);
            this.lookupFilterAndAddHandler(handler, string);
            this.checkAndBindHandler(string, handler);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void checkAndBindHandler(String string, Handler handler) {
        String string2 = handlerPropertyPrefix + string + "." + this.getName();
        String string3 = properties.get(string2 + ".server", "false");
        if (string3.equals("true")) {
            try {
                Naming.rebind(string2, UnicastRemoteObject.exportObject(handler));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void checkAndBindDistributer() {
        if (properties.get("log.server", "false").equals("true")) {
            String string = "log.distributer." + this.getName();
            try {
                Log.internal("trying to bind distributer under name '" + string + "'");
                Naming.rebind(string, UnicastRemoteObject.exportObject(this));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void addRemoteObject(String string, String string2) {
        try {
            Remote remote = Naming.lookup(string2);
            if (remote != null) {
                if (remote instanceof Handler) {
                    this.lookupFilterAndAddHandler((Handler)remote, string);
                } else if (remote instanceof Distributer) {
                    Distributer distributer = (Distributer)remote;
                    try {
                        distributer.getName();
                        this.lookupFilterAndAddHandler(new ProxyHandler(distributer), string);
                    }
                    catch (Exception exception) {}
                }
            } else {
                Log.internal("null handler");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void lookupFilterAndAddHandler(Handler handler, String string) {
        String string2 = properties.get(handlerPropertyPrefix + string + ".events", "");
        this.addToEventHandlers(handler, string, string2);
    }

    private void setupFilters(String string, Vector vector) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                RE rE = new RE(string2);
                vector.addElement(rE);
            }
            catch (Exception exception) {
                System.out.println("Log warning: bad filter '" + string2 + "'");
            }
        }
    }

    public void setFunctionNamesToInclude(String string) {
        properties.put("log.function.include", string);
        this.initializeFilters();
    }

    public void setFunctionNamesToExclude(String string) {
        properties.put("log.function.exclude", string);
        this.initializeFilters();
    }

    public void setEventTypesToInclude(String string) {
        properties.put("log.event.include", string);
        this.initializeFilters();
    }

    public void setEventTypesToExclude(String string) {
        properties.put("log.event.exclude", string);
        this.initializeFilters();
    }

    public grace.util.Properties getProperties() {
        return properties;
    }

    public void loadProperties(Properties properties) {
        grace.util.Properties properties2 = Log.properties;
        Log.properties = new grace.util.Properties(properties2);
        Log.properties.load(properties);
        this.initializeFilters();
        Log.properties = properties2;
    }

    public void initializeFilters() {
        Log.internal("initializing filters");
        String string = properties.get("log", "true");
        String string2 = string.equals("true") ? ".*" : "";
        String string3 = "";
        this.functionNamesToInclude.removeAllElements();
        this.functionNamesToExclude.removeAllElements();
        this.eventTypesToInclude.removeAllElements();
        this.eventTypesToExclude.removeAllElements();
        this.setupFilters(properties.get(new String[]{"log.function.include", "log.functions.include", "log.include.functions"}, ".*"), this.functionNamesToInclude);
        Log.internal("function include filter '" + this.functionNamesToInclude + "'");
        this.setupFilters(properties.get(new String[]{"log.function.exclude", "log.functions.exclude", "log.exclude.functions"}, ""), this.functionNamesToExclude);
        Log.internal("function exclude filter '" + this.functionNamesToExclude + "'");
        this.setupFilters(properties.get(new String[]{"log.event.include", "log.events.include", "log.events"}, string2), this.eventTypesToInclude);
        Log.internal("event include filter '" + this.functionNamesToExclude + "'");
        this.setupFilters(properties.get(new String[]{"log.event.exclude", "log.events.exclude"}, string3), this.eventTypesToExclude);
        Log.internal("event exclude filter '" + this.functionNamesToExclude + "'");
        String string4 = properties.get(new String[]{"log.errors", "log.error"}, null);
        if (string4 != null) {
            this.enableEventType(ERROR, string4.equals("true"));
        }
        if ((string4 = properties.get(new String[]{"log.warnings", "log.warning"}, null)) != null) {
            this.enableEventType(WARNING, string4.equals("true"));
        }
        if ((string4 = properties.get(new String[]{"log.notices", "log.notice"}, null)) != null) {
            this.enableEventType(NOTICE, string4.equals("true"));
        }
        if ((string4 = properties.get(new String[]{"log.traces", "log.trace"}, null)) != null) {
            this.enableEventType(TRACE, string4.equals("true"));
        }
    }

    protected void initialize() {
        Log.internal("initializing");
        try {
            if (!this.allHandlers.containsKey(standardOutName) && properties.get("log.handler.out", "true").equals("true")) {
                this.addToEventHandlers(new StandardOutHandler(handlerPropertyPrefix, standardOutName), standardOutName, "");
            }
        }
        catch (Exception exception) {
            Log.internal(exception);
        }
        try {
            Vector vector = properties.names("^log.handler..*");
            int n = 0;
            while (n < vector.size()) {
                String string = (String)vector.elementAt(n);
                int n2 = handlerPropertyPrefix.length();
                int n3 = string.indexOf(".", n2);
                String string2 = null;
                if (n3 == -1) {
                    if (string.length() > n2) {
                        string2 = string.substring(n2, string.length());
                    }
                } else {
                    string2 = string.substring(n2, n3);
                }
                if (!this.allHandlers.containsKey(string2)) {
                    this.addHandler(string.substring(n2, n3));
                }
                ++n;
            }
        }
        catch (Exception exception) {
            Log.internal(exception);
        }
        this.initializeFilters();
        this.checkAndBindDistributer();
        Log.internal("done initializing");
    }

    public static void main(String[] stringArray) {
        int n = 1;
        if (stringArray.length > 0) {
            n = Integer.parseInt(stringArray[0]);
        }
        new GeneralTest(n).run();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            properties.loadSystem();
            String string = properties.get("log.rc", ".logrc");
            properties.loadHomeFile(".logrc");
            properties.loadFile(string);
            properties.loadSystem();
            properties.integrateWithSystemProperties();
        }
        catch (Exception exception) {
            Log.internal("warning: can't load properties");
        }
        internalLogEnabled = properties.get("log.internal", "false").equals("true");
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            hostname = "localhost";
        }
        Log.internal("initialized statics");
        instance = new Log();
    }
}

