/*
 * Decompiled with CFR 0.152.
 */
package grace.log;

import grace.log.Event;
import grace.log.Handler;
import grace.log.Log;
import grace.log.PrintHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Date;

public class FileHandler
extends PrintHandler
implements Handler {
    public static final String rcsid = "$Id: FileHandler.java,v 0.7.3.1 2001/07/04 19:10:16 mhucka Exp $";
    private File logFile;
    private long maxBytes = 0L;
    private static URL contextURL;

    public FileHandler(String string, String string2) throws RemoteException {
        super(string, string2);
        Object object;
        String string3 = string + string2;
        String string4 = string2 + ".log";
        String string5 = System.getProperty(string3 + ".url", "file:" + string2 + ".log");
        if (string5.startsWith("file:")) {
            try {
                object = new URL(contextURL, string5);
                string4 = ((URL)object).getFile();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.establishWriter(string4);
        object = System.getProperty(string3 + ".maxsize");
        if (object != null) {
            ((String)object).trim();
            object = ((String)object).toLowerCase();
            int n = 1;
            if (((String)object).endsWith("k")) {
                n = 1000;
            } else if (((String)object).endsWith("m")) {
                n = 1000000;
            }
            try {
                this.maxBytes = Integer.parseInt((String)object) * n;
            }
            catch (Exception exception) {
                this.maxBytes = 0L;
            }
        }
    }

    public FileHandler(String string) throws RemoteException {
        super(System.out);
        this.establishWriter(string);
    }

    public FileHandler(String string, int n) throws RemoteException {
        this(string);
        this.maxBytes = n * 1024;
    }

    protected void establishWriter(String string) {
        if (string.endsWith("-")) {
            this.logFile = null;
            this.setOut(System.out);
        } else {
            try {
                this.logFile = new File(string);
                this.setOut(new PrintWriter((Writer)new FileWriter(this.logFile.getAbsolutePath(), true), false));
            }
            catch (Exception exception) {
                this.logFile = null;
                this.setOut(System.out);
            }
        }
    }

    public synchronized void handle(Event event) {
        super.handle(event);
        if (this.maxBytes > 0L && this.logFile != null && this.logFile.length() > this.maxBytes) {
            this.cutFileInHalf();
        }
    }

    protected synchronized void cutFileInHalf() {
        if (this.logFile != null) {
            try {
                String string;
                this.getOut().close();
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.logFile));
                bufferedReader.skip(this.logFile.length() - this.maxBytes / 2L);
                while (bufferedReader.read() != 10) {
                }
                File file = new File(".temp.log." + new Date().getTime());
                FileWriter fileWriter = new FileWriter(file);
                while ((string = bufferedReader.readLine()) != null) {
                    fileWriter.write(string);
                    fileWriter.write(10);
                }
                fileWriter.close();
                file.renameTo(this.logFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.establishWriter(this.logFile.getName());
        }
    }

    public static void main(String[] stringArray) {
        try {
            File file = new File("test.log");
            Log.getInstance().addHandler(new FileHandler(file.getName(), 1));
            int n = 0;
            while (n < 200) {
                Log.log("test", "test message " + n + " to force file over 1k");
                if (file.length() > 1024L) {
                    System.out.println("warning: file exceeded 1K.");
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        try {
            contextURL = new URL("file://" + System.getProperty("user.dir", ".") + "/");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

