/*
 * Decompiled with CFR 0.152.
 */
package grace.log;

import grace.io.FormattedPrintWriter;
import grace.log.Event;
import grace.log.Log;
import grace.util.Properties;
import grace.util.Tokenizer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;

public class EventFormat {
    public static final String rcsid = "$Id: EventFormat.java,v 0.8 2001/08/15 21:19:57 mhucka Exp $";
    private static Properties properties = new Properties();
    private static String defaultRelativeTimeFormat;
    private static DateFormat defaultTimeFormat;
    private static DateFormat defaultObjectTimeFormat;
    private static String defaultExceptionFormat;
    private static String defaultMessageFormat;
    private static String terseJavaFormat;
    private static String prettyJavaFormat;
    private static String lispFormat;
    private static String defaultObjectFormat;
    private static String defaultThreadFormat;
    private static String defaultFormat;
    private static boolean useColors;
    public static final String NO_COLOR = "";
    public static final char ESC = '\u001b';
    public static final String PLAIN = "\u001b[00m";
    public static final String BRIGHT = "\u001b[1m";
    public static final String UNDERLINE = "\u001b[4m";
    public static final String HIGHLIGHT = "\u001b[7m";
    public static final String BLACK = "\u001b[30m";
    public static final String RED = "\u001b[31m";
    public static final String GREEN = "\u001b[32m";
    public static final String YELLOW = "\u001b[33m";
    public static final String BLUE = "\u001b[34m";
    public static final String PURPLE = "\u001b[35m";
    public static final String CYAN = "\u001b[36m";
    public static final String WHITE = "\u001b[37m";
    public static final String BLACK_BACKGROUND = "\u001b[40m";
    public static final String RED_BACKGROUND = "\u001b[41m";
    public static final String GREEN_BACKGROUND = "\u001b[42m";
    public static final String YELLOW_BACKGROUND = "\u001b[43m";
    public static final String BLUE_BACKGROUND = "\u001b[44m";
    public static final String PURPLE_BACKGROUND = "\u001b[45m";
    public static final String CYAN_BACKGROUND = "\u001b[46m";
    public static final String WHITE_BACKGROUND = "\u001b[47m";
    private static Hashtable colorTable;
    private static final Date startTime;
    private static final NumberFormat numberFormat;
    private static final NumberFormat twoDigitFormat;
    private String format;
    private int minBufferSize = 128;
    private DateFormat timeFormat = defaultTimeFormat;
    private String relativeTimeFormat = defaultRelativeTimeFormat;
    private String exceptionFormat = defaultExceptionFormat;
    private String messageFormat = defaultMessageFormat;
    private String objectFormat = defaultObjectFormat;
    private DateFormat objectTimeFormat = defaultObjectTimeFormat;
    private String threadFormat = defaultThreadFormat;
    private String timeColor = "";
    private String relativeTimeColor = "";
    private String exceptionColor = "";
    private String messageColor = "";
    private String objectColor = "";
    private String threadColor = "";
    private String classnameColor = "";
    private String functionColor = "";
    private String resetColor = "";
    private Hashtable eventColors = new Hashtable();
    private Hashtable lineColors = new Hashtable();

    public EventFormat() {
        this(defaultFormat);
    }

    public EventFormat(String string) {
        this.format = string;
        this.useColors(useColors);
    }

    private StringBuffer createBuffer() {
        return this.minBufferSize == 0 ? new StringBuffer() : new StringBuffer(this.minBufferSize);
    }

    public String format(Event event) {
        StringBuffer stringBuffer = this.createBuffer();
        String string = null;
        String string2 = (String)this.lineColors.get(event.type);
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        boolean bl = false;
        int n = 0;
        while (n < this.format.length()) {
            char c = this.format.charAt(n);
            if (bl) {
                if (string2 != null) {
                    stringBuffer.append(string2);
                }
                bl = false;
                switch (c) {
                    case '%': {
                        stringBuffer.append(c);
                        break;
                    }
                    case 't': {
                        this.formatTime(stringBuffer, string, event.time);
                        break;
                    }
                    case 'e': {
                        String string3 = (String)this.eventColors.get(event.type);
                        if (string3 != null) {
                            stringBuffer.append(string3);
                        }
                        stringBuffer.append(event.type);
                        stringBuffer.append(this.resetColor);
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        this.formatRelativeTime(stringBuffer, string, event.time);
                        break;
                    }
                    case 'H': 
                    case 'h': {
                        this.formatThreadName(stringBuffer, string, event.threadNames);
                        break;
                    }
                    case 'n': {
                        stringBuffer.append(event.number);
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        stringBuffer.append(this.classnameColor);
                        stringBuffer.append(event.position.getShortClassname());
                        stringBuffer.append(this.resetColor);
                        break;
                    }
                    case 'F': {
                        stringBuffer.append(event.position.getFilename());
                        break;
                    }
                    case 'f': {
                        stringBuffer.append(this.functionColor);
                        stringBuffer.append(event.position.getFunction());
                        stringBuffer.append(this.resetColor);
                        break;
                    }
                    case 'l': {
                        stringBuffer.append(event.position.getLineNumberString());
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        if (event.message == null || event.objectWasGiven()) break;
                        this.formatMessage(stringBuffer, string, event.message);
                        break;
                    }
                    case 'O': 
                    case 'o': {
                        if (!event.objectWasGiven()) break;
                        this.formatObject(stringBuffer, string, event.message == null ? NO_COLOR : event.message, event.object);
                        break;
                    }
                    case '(': {
                        StringBuffer stringBuffer2 = new StringBuffer();
                        boolean bl2 = false;
                        while (++n < this.format.length()) {
                            char c2 = this.format.charAt(n);
                            if (c2 == '\\') {
                                bl2 = true;
                                continue;
                            }
                            if (c2 == ')' && !bl2) break;
                            stringBuffer2.append(c2);
                            bl2 = false;
                        }
                        string = stringBuffer2.toString();
                        bl = true;
                        break;
                    }
                }
                if (string2 != null) {
                    stringBuffer.append(string2);
                }
            } else if (c == '%') {
                bl = true;
                string = null;
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        if (this.minBufferSize < stringBuffer.length()) {
            this.minBufferSize = stringBuffer.length() + 16;
        }
        stringBuffer.append(this.resetColor);
        return stringBuffer.toString();
    }

    protected void formatException(StringBuffer stringBuffer, Exception exception) {
        String string = this.exceptionFormat;
        stringBuffer.append(this.exceptionColor);
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            block11: {
                char c;
                block10: {
                    c = string.charAt(n);
                    if (!bl) break block10;
                    bl = false;
                    switch (c) {
                        case '%': {
                            stringBuffer.append(c);
                            break;
                        }
                        case 'c': {
                            stringBuffer.append(exception.getClass().getName());
                            break;
                        }
                        case 'm': {
                            if (exception.getMessage() != null) {
                                stringBuffer.append(exception.getMessage());
                                break;
                            }
                            break block11;
                        }
                        case 's': {
                            StringWriter stringWriter = new StringWriter();
                            PrintWriter printWriter = new PrintWriter(stringWriter);
                            exception.printStackTrace(printWriter);
                            stringBuffer.append(this.eliminateEndingNewlines(stringWriter.toString()));
                            printWriter.close();
                            break;
                        }
                    }
                    break block11;
                }
                if (c == '%') {
                    bl = true;
                } else {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        stringBuffer.append(this.resetColor);
    }

    protected String eliminateEndingNewlines(String string) {
        int n = string.length();
        while (n > 0 && string.charAt(n - 1) == '\n') {
            --n;
        }
        return n > 0 ? string.substring(0, n) : string;
    }

    protected void formatMessage(StringBuffer stringBuffer, String string, String string2) {
        if (this.messageFormat == defaultMessageFormat) {
            if (string == null) {
                string = this.messageFormat;
            }
        } else {
            string = this.messageFormat;
        }
        stringBuffer.append(this.messageColor);
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (bl) {
                bl = false;
                switch (c) {
                    case '%': {
                        stringBuffer.append(c);
                        break;
                    }
                    case 'm': {
                        stringBuffer.append(string2);
                        break;
                    }
                }
            } else if (c == '%') {
                bl = true;
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        stringBuffer.append(this.resetColor);
    }

    protected void formatFormattedObject(String string, StringBuffer stringBuffer, String string2, Object object) {
        StringWriter stringWriter = new StringWriter();
        FormattedPrintWriter formattedPrintWriter = new FormattedPrintWriter(stringWriter, false);
        formattedPrintWriter.setDateFormat(this.objectTimeFormat);
        formattedPrintWriter.setFormat(string);
        formattedPrintWriter.print(string2, object);
        formattedPrintWriter.close();
        try {
            stringWriter.close();
        }
        catch (Exception exception) {
            Log.internal(exception);
        }
        stringBuffer.append(stringWriter.toString());
    }

    protected void formatGenericObject(StringBuffer stringBuffer, String string, String string2, Object object) {
        if (this.objectFormat == defaultObjectFormat) {
            if (string == null) {
                string = this.objectFormat;
            }
        } else {
            string = this.objectFormat;
        }
        stringBuffer.append(this.objectColor);
        if (string.equals("java")) {
            this.formatFormattedObject(terseJavaFormat, stringBuffer, string2, object);
        } else if (string.equals("Java")) {
            this.formatFormattedObject(prettyJavaFormat, stringBuffer, string2, object);
        } else if (string.equals("lisp")) {
            this.formatFormattedObject(lispFormat, stringBuffer, string2, object);
        } else if (string.equals("Lisp")) {
            this.formatFormattedObject(lispFormat, stringBuffer, string2, object);
        } else {
            this.formatFormattedObject(string, stringBuffer, string2, object);
        }
        stringBuffer.append(this.resetColor);
    }

    protected void formatObject(StringBuffer stringBuffer, String string, String string2, Object object) {
        if (object instanceof Throwable) {
            this.formatException(stringBuffer, (Exception)object);
        } else {
            this.formatGenericObject(stringBuffer, string, string2, object);
        }
    }

    protected void formatThreadName(StringBuffer stringBuffer, String string, Vector vector) {
        if (this.threadFormat == defaultThreadFormat) {
            if (string == null) {
                string = this.threadFormat;
            }
        } else {
            string = this.threadFormat;
        }
        stringBuffer.append(this.threadColor);
        char c = '.';
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            block17: {
                char c2;
                block16: {
                    c2 = string.charAt(n);
                    if (!bl) break block16;
                    bl = false;
                    switch (c2) {
                        case '%': {
                            stringBuffer.append(c2);
                            break;
                        }
                        case 'n': {
                            if (vector.size() >= 1) {
                                stringBuffer.append((String)vector.elementAt(vector.size() - 1));
                                break;
                            }
                            break block17;
                        }
                        case 'g': {
                            if (vector.size() >= 2) {
                                stringBuffer.append((String)vector.elementAt(vector.size() - 2));
                                break;
                            }
                            break block17;
                        }
                        case 'G': {
                            int n2 = 0;
                            while (n2 < vector.size() - 1) {
                                if (n2 != 0) {
                                    stringBuffer.append(c);
                                }
                                stringBuffer.append((String)vector.elementAt(n2));
                                ++n2;
                            }
                            break block17;
                        }
                        default: {
                            c = c2;
                            break;
                        }
                    }
                    break block17;
                }
                if (c2 == '%') {
                    bl = true;
                } else {
                    stringBuffer.append(c2);
                }
            }
            ++n;
        }
        stringBuffer.append(this.resetColor);
    }

    protected void formatRelativeTime(StringBuffer stringBuffer, String string, Date date) {
        if (this.relativeTimeFormat == defaultRelativeTimeFormat) {
            if (string == null) {
                string = this.relativeTimeFormat;
            }
        } else {
            string = this.relativeTimeFormat;
        }
        stringBuffer.append(this.relativeTimeColor);
        if (string != null && !string.equals(NO_COLOR)) {
            double d = date.getTime() - startTime.getTime();
            if (string.startsWith("clock")) {
                int n = (int)(d / 8.64E7);
                int n2 = (int)(d % 8.64E7 / 3600000.0);
                int n3 = (int)(d % 3600000.0 / 60000.0);
                double d2 = d % 60000.0 / 1000.0;
                if (n > 0) {
                    stringBuffer.append(twoDigitFormat.format(n));
                    stringBuffer.append(":");
                    stringBuffer.append(twoDigitFormat.format(n2));
                    stringBuffer.append(":");
                    stringBuffer.append(twoDigitFormat.format(n3));
                    stringBuffer.append(":");
                    stringBuffer.append(numberFormat.format(d2));
                } else if (n2 > 0) {
                    stringBuffer.append(twoDigitFormat.format(n2));
                    stringBuffer.append(":");
                    stringBuffer.append(twoDigitFormat.format(n3));
                    stringBuffer.append(":");
                    stringBuffer.append(numberFormat.format(d2));
                } else if (n3 > 0) {
                    stringBuffer.append(twoDigitFormat.format(n3));
                    stringBuffer.append(":");
                    stringBuffer.append(numberFormat.format(d2));
                } else {
                    stringBuffer.append(numberFormat.format(d2));
                }
            } else if (string.startsWith("day")) {
                stringBuffer.append(numberFormat.format(d /= 8.64E7));
            } else if (string.startsWith("min")) {
                stringBuffer.append(numberFormat.format(d /= 60000.0));
            } else if (string.startsWith("sec")) {
                stringBuffer.append(numberFormat.format(d /= 1000.0));
            } else {
                stringBuffer.append(numberFormat.format(d /= 3600000.0));
            }
        }
        stringBuffer.append(this.resetColor);
    }

    protected void formatTime(StringBuffer stringBuffer, String string, Date date) {
        DateFormat dateFormat = this.timeFormat;
        if (this.timeFormat == defaultTimeFormat && string != null) {
            dateFormat = EventFormat.getDateFormat(string);
        }
        stringBuffer.append(this.timeColor);
        stringBuffer.append(dateFormat.format(date));
        stringBuffer.append(this.resetColor);
    }

    protected static DateFormat getDateFormat(String string) {
        DateFormat dateFormat = null;
        dateFormat = string.equals("short") ? DateFormat.getDateTimeInstance(3, 3) : (string.equals("medium") ? DateFormat.getDateTimeInstance(2, 2) : (string.equals("long") ? DateFormat.getDateTimeInstance(1, 1) : (string.equals("full") ? DateFormat.getDateTimeInstance(0, 0) : (string.equals("24") ? new SimpleDateFormat("MM/dd/yy HH:mm:ss") : new SimpleDateFormat(string)))));
        return dateFormat;
    }

    protected static String expandSpecialChars(String string) {
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            boolean bl = false;
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (bl) {
                    bl = false;
                    switch (c) {
                        case 'n': {
                            stringBuffer.append('\n');
                            break;
                        }
                        case 't': {
                            stringBuffer.append('\t');
                            break;
                        }
                        default: {
                            stringBuffer.append(c);
                            break;
                        }
                    }
                } else if (c == '\\') {
                    bl = true;
                } else {
                    stringBuffer.append(c);
                }
                ++n;
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public void setObjectFormat(String string) {
        this.objectFormat = string;
    }

    public void setObjectTimeFormat(DateFormat dateFormat) {
        this.objectTimeFormat = dateFormat;
    }

    public void setTimeFormat(DateFormat dateFormat) {
        this.timeFormat = dateFormat;
    }

    public void setRelativeTimeFormat(String string) {
        this.relativeTimeFormat = string;
    }

    public void setExceptionFormat(String string) {
        this.exceptionFormat = string;
    }

    public void setMessageFormat(String string) {
        this.messageFormat = string;
    }

    public void setThreadFormat(String string) {
        this.threadFormat = string;
    }

    public void useColors(boolean bl) {
        if (bl) {
            this.timeColor = BRIGHT;
            this.resetColor = PLAIN;
            this.eventColors.put("error", "\u001b[7m\u001b[31m");
            this.eventColors.put("warning", HIGHLIGHT);
            this.lineColors.put("error", "\u001b[1m\u001b[31m");
            this.lineColors.put("warning", BRIGHT);
        } else {
            this.timeColor = NO_COLOR;
            this.resetColor = NO_COLOR;
            this.eventColors.clear();
        }
    }

    public String colorListToColor(String string) {
        String string2;
        Tokenizer tokenizer = new Tokenizer(string);
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = tokenizer.getToken()) != null) {
            if ((string2 = (String)colorTable.get(string2)) == null) continue;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public void setTimeColor(String string) {
        this.timeColor = string;
        this.resetColor = PLAIN;
    }

    public void setRelativeTimeColor(String string) {
        this.relativeTimeColor = string;
        this.resetColor = PLAIN;
    }

    public void setExceptionColor(String string) {
        this.exceptionColor = string;
        this.resetColor = PLAIN;
    }

    public void setMessageColor(String string) {
        this.messageColor = string;
        this.resetColor = PLAIN;
    }

    public void setObjectColor(String string) {
        this.objectColor = string;
        this.resetColor = PLAIN;
    }

    public void setThreadColor(String string) {
        this.threadColor = string;
        this.resetColor = PLAIN;
    }

    public void setClassnameColor(String string) {
        this.classnameColor = string;
        this.resetColor = PLAIN;
    }

    public void setFunctionColor(String string) {
        this.functionColor = string;
        this.resetColor = PLAIN;
    }

    public void setEventColor(String string, String string2) {
        this.eventColors.put(string, string2);
        this.resetColor = PLAIN;
    }

    public void setLineColor(String string, String string2) {
        this.lineColors.put(string, string2);
        this.resetColor = PLAIN;
    }

    static {
        properties.loadSystem();
        properties.integrateWithSystemProperties();
        defaultRelativeTimeFormat = properties.get("log.time.relative", "clock");
        defaultTimeFormat = EventFormat.getDateFormat(properties.get("log.time.format", "24"));
        defaultTimeFormat.setTimeZone(TimeZone.getTimeZone(properties.get("log.time.zone", "GMT")));
        defaultObjectTimeFormat = EventFormat.getDateFormat(properties.get("log.object.time.format", "24"));
        defaultObjectTimeFormat.setTimeZone(TimeZone.getTimeZone(properties.get("log.object.time.zone", "GMT")));
        defaultExceptionFormat = EventFormat.expandSpecialChars(properties.get("log.exception.format", ": %s"));
        defaultMessageFormat = EventFormat.expandSpecialChars(properties.get("log.message.format", "%m"));
        terseJavaFormat = ":|{| %c %n = %v;| }";
        prettyJavaFormat = ":|{\n|%i%c %n = %v;\n|%i}";
        lispFormat = ":|(%v%z,%z |)";
        defaultObjectFormat = EventFormat.expandSpecialChars(properties.get("log.object.format", "java"));
        defaultThreadFormat = EventFormat.expandSpecialChars(properties.get("log.thread.format", "%G.%n"));
        defaultFormat = EventFormat.expandSpecialChars(properties.get("log.format", "%t(%r):%n: %e: %h: %c.%f:%l%(: %m)m%o\n\n"));
        useColors = properties.get(new String[]{"log.color", "log.colors", "log.colour", "log.colours"}, "false").equals("true");
        colorTable = new Hashtable();
        colorTable.put("plain", PLAIN);
        colorTable.put("bright", BRIGHT);
        colorTable.put("underline", UNDERLINE);
        colorTable.put("highlight", HIGHLIGHT);
        colorTable.put("black", BLACK);
        colorTable.put("red", RED);
        colorTable.put("green", GREEN);
        colorTable.put("yellow", YELLOW);
        colorTable.put("blue", BLUE);
        colorTable.put("purple", PURPLE);
        colorTable.put("cyan", CYAN);
        colorTable.put("white", WHITE);
        colorTable.put("black-bg", BLACK_BACKGROUND);
        colorTable.put("red-bg", RED_BACKGROUND);
        colorTable.put("green-bg", GREEN_BACKGROUND);
        colorTable.put("yellow-bg", YELLOW_BACKGROUND);
        colorTable.put("blue-bg", BLUE_BACKGROUND);
        colorTable.put("purple-bg", PURPLE_BACKGROUND);
        colorTable.put("cyan-bg", CYAN_BACKGROUND);
        colorTable.put("white-bg", WHITE_BACKGROUND);
        startTime = new Date();
        numberFormat = new DecimalFormat(properties.get("log.seconds.format", "#,##0.000"));
        twoDigitFormat = new DecimalFormat("00");
    }
}

