/*
 * Decompiled with CFR 0.152.
 */
package grace.log;

import grace.log.StackTrace;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

public class Event
implements Serializable {
    public static final String rcsid = "$Id: Event.java,v 0.7.3.1 2001/07/04 19:10:16 mhucka Exp $";
    String hostname;
    String virtualMachineName;
    String type;
    Date time;
    long number;
    StackTrace position;
    String message;
    Object object;
    Vector threadNames;
    private boolean objectGiven;
    private static long nextNumber = 1L;

    public Event(String string) {
        this.type = string;
        this.time = new Date();
        this.number = nextNumber++;
        this.threadNames = this.createThreadNames();
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public void setVirtualMachineName(String string) {
        this.virtualMachineName = string;
    }

    public void setPosition(StackTrace stackTrace) {
        this.position = stackTrace;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setObject(Object object) {
        this.object = object;
        this.objectGiven = true;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public String getType() {
        return this.type;
    }

    public Date getTime() {
        return this.time;
    }

    public long getNumber() {
        return this.number;
    }

    public StackTrace getPosition() {
        return this.position;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getObject() {
        return this.object;
    }

    public boolean objectWasGiven() {
        return this.objectGiven;
    }

    protected void appendGroupName(Vector vector, ThreadGroup threadGroup) {
        ThreadGroup threadGroup2 = threadGroup.getParent();
        if (threadGroup2 != null) {
            this.appendGroupName(vector, threadGroup2);
        }
        vector.addElement(threadGroup.getName());
    }

    protected Vector createThreadNames() {
        Vector<String> vector = new Vector<String>();
        Thread thread = Thread.currentThread();
        ThreadGroup threadGroup = thread.getThreadGroup();
        if (threadGroup != null) {
            this.appendGroupName(vector, threadGroup);
        }
        vector.addElement(thread.getName());
        return vector;
    }
}

