/*
 * Decompiled with CFR 0.152.
 */
package grace.io;

import grace.io.PrintHandler;
import grace.io.Value;
import grace.util.NameMap;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;

public abstract class PrintWriter
extends java.io.PrintWriter {
    private boolean autoFlush = false;
    private boolean pretty = true;
    private NameMap printedObjects = new NameMap("{ref-", "}");
    private boolean printObjectsOnlyOnce = true;
    private boolean firstPrint = true;
    protected DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static Hashtable printHandlers = new Hashtable();
    private static Hashtable classFieldAccessors = new Hashtable();
    private static final Class[] printMethodArguments = new Class[]{class$grace$io$PrintWriter == null ? (class$grace$io$PrintWriter = PrintWriter.class$("grace.io.PrintWriter")) : class$grace$io$PrintWriter};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$grace$io$PrintWriter;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$java$util$Enumeration;
    static /* synthetic */ Class class$java$sql$ResultSet;
    static /* synthetic */ Class class$grace$io$PrintWriter$ResultSetRow;

    public PrintWriter(OutputStream outputStream) {
        super(outputStream, false);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.autoFlush = false;
    }

    public PrintWriter(OutputStream outputStream, boolean bl) {
        super(outputStream, bl);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.autoFlush = bl;
    }

    public PrintWriter(Writer writer) {
        super(writer, false);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.autoFlush = false;
    }

    public PrintWriter(Writer writer, boolean bl) {
        super(writer, bl);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.autoFlush = bl;
    }

    public void print(String string, Object object) {
        boolean bl = this.firstPrint;
        Value value = new Value(string, object, !bl);
        if (bl) {
            value.isFirst = true;
            value.isLast = true;
        }
        this.firstPrint = false;
        this.printField(value);
        if (!bl) {
            this.autoFlush();
            this.firstPrint = false;
        }
    }

    public void print(String string, int n) {
        this.print(string, new Integer(n));
    }

    public void print(String string, byte by) {
        this.print(string, new Byte(by));
    }

    public void print(String string, char c) {
        this.print(string, new Character(c));
    }

    public void print(String string, float f) {
        this.print(string, new Float(f));
    }

    public void print(String string, double d) {
        this.print(string, new Double(d));
    }

    public void print(String string, boolean bl) {
        this.print(string, new Boolean(bl));
    }

    protected abstract void printField(Value var1);

    protected void printNullString() {
        this.printNullObject();
    }

    protected void printNullObject() {
        super.print("null");
    }

    protected void printQuoted(String string) {
        if (string == null) {
            this.printNullString();
        } else {
            this.beginString();
            super.print(string);
            this.endString();
        }
    }

    protected void printValue(Value value) {
        if (value.object == null) {
            this.printNullObject();
            return;
        }
        if (value.clazz.isArray()) {
            this.print((Object[])value.object);
        } else if (value.clazz == (class$java$lang$String == null ? (class$java$lang$String = PrintWriter.class$("java.lang.String")) : class$java$lang$String)) {
            this.printQuoted((String)value.object);
        } else if (value.isPrimitive(true)) {
            super.print(value.toString());
        } else if (!this.alreadyPrinted(value.object)) {
            this.rememberPrinted(value.object);
            PrintHandler printHandler = PrintWriter.getPrintHandler(value.clazz);
            if (printHandler != null) {
                printHandler.handle(this, value);
            } else {
                Vector vector = PrintWriter.fieldAccessors(value.clazz);
                if (vector != null) {
                    this.printWithFieldAccessors(value, vector);
                } else {
                    this.printQuoted(value.toString());
                }
            }
        } else {
            this.print(this.referenceNameOf(value.object));
        }
    }

    public void printWithFieldAccessors(Value value, Vector vector) {
        this.beginObject();
        int n = 0;
        while (n < vector.size()) {
            FieldAccessor fieldAccessor = (FieldAccessor)vector.elementAt(n);
            Value value2 = new Value(fieldAccessor.name, fieldAccessor.get(value.object), true);
            if (n == 0) {
                value2.isFirst = true;
            } else if (n == vector.size() - 1) {
                value2.isLast = true;
            }
            this.printField(value2);
            ++n;
        }
        this.endObject();
    }

    public static void addPrintHandler(Class clazz, PrintHandler printHandler) {
        printHandlers.put(clazz, printHandler);
    }

    protected static PrintHandler getPrintHandler(Class clazz) {
        Object object;
        PrintHandler printHandler = null;
        try {
            object = Class.forName("grace.io.handlers." + clazz.getClass().getName());
            printHandler = (PrintHandler)((Class)object).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (printHandler == null && (printHandler = (PrintHandler)printHandlers.get(clazz)) == null) {
            object = printHandlers.keys();
            while (object.hasMoreElements()) {
                Class clazz2 = (Class)object.nextElement();
                if (!clazz2.isAssignableFrom(clazz)) continue;
                return (PrintHandler)printHandlers.get(clazz2);
            }
        }
        if (printHandler == null) {
            printHandler = PrintWriter.getPrintToHandler(clazz);
        }
        return printHandler;
    }

    protected static String shortenedTypeName(Class clazz, boolean bl) {
        String string = clazz.getName();
        string = clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = PrintWriter.class$("java.lang.Integer")) : class$java$lang$Integer) ? "int" : (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = PrintWriter.class$("java.lang.Float")) : class$java$lang$Float) ? "float" : (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = PrintWriter.class$("java.lang.Long")) : class$java$lang$Long) ? "long" : (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = PrintWriter.class$("java.lang.Byte")) : class$java$lang$Byte) ? "byte" : (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = PrintWriter.class$("java.lang.Boolean")) : class$java$lang$Boolean) ? "boolean" : (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = PrintWriter.class$("java.lang.Character")) : class$java$lang$Character) ? "char" : (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = PrintWriter.class$("java.lang.Double")) : class$java$lang$Double) ? "double" : (string.startsWith("java") || bl ? PrintWriter.rightmostName(string) : clazz.getName())))))));
        return string;
    }

    protected static String rightmostName(String string) {
        int n = string.lastIndexOf(46);
        return n != -1 ? string.substring(n + 1) : string;
    }

    protected void printType(Value value, boolean bl, boolean bl2) {
        String string = value.object == null ? "Object" : (value.clazz.isArray() ? PrintWriter.arrayTypeName(value.clazz, bl, bl2) : (bl ? PrintWriter.shortenedTypeName(value.clazz, bl2) : value.clazz.getName()));
        this.print(string);
    }

    protected static String arrayTypeName(Class clazz, boolean bl, boolean bl2) {
        clazz = clazz.getComponentType();
        String string = bl ? PrintWriter.shortenedTypeName(clazz, bl2) : clazz.getName();
        return string + "[]";
    }

    protected void printName(Object object) {
        this.print(object);
    }

    protected static Method getPrintMethod(Class clazz) {
        try {
            return clazz.getDeclaredMethod("printTo", printMethodArguments);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static PrintHandler getPrintToHandler(Class clazz) {
        PrintMethodHandler printMethodHandler = null;
        Method method = PrintWriter.getPrintMethod(clazz);
        if (method != null) {
            printMethodHandler = new PrintMethodHandler(method);
            PrintWriter.addPrintHandler(clazz, printMethodHandler);
        }
        return printMethodHandler;
    }

    protected static Vector fieldAccessors(Class clazz) {
        Vector vector = (Vector)classFieldAccessors.get(clazz);
        if (vector == null) {
            vector = PrintWriter.rememberAccessorsUsingFields(clazz);
        }
        if (vector.size() == 0) {
            vector = PrintWriter.rememberAccessorsUsingGetMethods(clazz);
        }
        return vector;
    }

    protected static Vector rememberAccessorsUsingGetMethods(Class clazz) {
        Vector<MethodFieldAccessor> vector = new Vector<MethodFieldAccessor>();
        classFieldAccessors.put(clazz, vector);
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            String string = methodArray[n].getName();
            String string2 = Character.toLowerCase(string.charAt(3)) + string.substring(4);
            Class<?>[] classArray = methodArray[n].getParameterTypes();
            Class<?> clazz2 = methodArray[n].getReturnType();
            if (string.startsWith("get") && classArray.length == 0 && methodArray[n].getDeclaringClass() != (class$java$lang$Object == null ? PrintWriter.class$("java.lang.Object") : class$java$lang$Object)) {
                vector.addElement(new MethodFieldAccessor(string2, methodArray[n]));
            }
            ++n;
        }
        return vector;
    }

    protected static Vector rememberAccessorsUsingFields(Class clazz) {
        Vector<FieldAccessor> vector = new Vector<FieldAccessor>();
        classFieldAccessors.put(clazz, vector);
        Vector vector2 = new Vector();
        Class clazz2 = clazz;
        while (clazz2 != (class$java$lang$Object == null ? PrintWriter.class$("java.lang.Object") : class$java$lang$Object)) {
            vector2 = PrintWriter.add(clazz2.getDeclaredFields(), vector2);
            clazz2 = clazz2.getSuperclass();
        }
        int n = 0;
        while (n < vector2.size()) {
            Field field = (Field)vector2.elementAt(n);
            if ((field.getModifiers() & 8) == 0) {
                String string = field.getName();
                if ((field.getModifiers() & 1) == 1) {
                    vector.addElement(new DirectFieldAccessor(string, field));
                } else {
                    String string2 = "get" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
                    try {
                        Method method = clazz.getMethod(string2, null);
                        vector.addElement(new MethodFieldAccessor(string, method));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            ++n;
        }
        return vector;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    protected static Vector add(Object[] objectArray, Vector vector) {
        Vector<Object> vector2 = new Vector<Object>(objectArray.length + vector.size());
        int n = 0;
        while (n < objectArray.length) {
            vector2.addElement(objectArray[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            vector2.addElement(vector.elementAt(n2));
            ++n2;
        }
        return vector2;
    }

    public boolean prettyOutput() {
        return this.pretty;
    }

    public void setPrettyOutput(boolean bl) {
        this.pretty = bl;
    }

    public boolean getPrintObjectsOnlyOnce() {
        return this.printObjectsOnlyOnce;
    }

    public void setPrintObjectsOnlyOnce(boolean bl) {
        this.printObjectsOnlyOnce = bl;
    }

    public abstract void beginList();

    public abstract void endList();

    public abstract void beginObject();

    public abstract void endObject();

    protected void beginString() {
        super.print("\"");
    }

    protected void endString() {
        super.print("\"");
    }

    protected void rememberPrinted(Object object) {
        if (this.printObjectsOnlyOnce) {
            this.printedObjects.put(object);
        }
    }

    protected String referenceNameOf(Object object) {
        return this.printedObjects.nameOf(object);
    }

    protected boolean alreadyPrinted(Object object) {
        if (this.printObjectsOnlyOnce) {
            return this.printedObjects.contains(object);
        }
        return false;
    }

    protected void autoFlush() {
        if (this.autoFlush) {
            this.flush();
        }
    }

    protected void printListElementValue(Object object, int n, int n2) {
        Value value = new Value("[" + n + "]", object, true);
        value.isFirst = n == 0;
        value.isLast = n == n2 - 1;
        this.printField(value);
    }

    protected void print(Object[] objectArray) {
        this.beginList();
        int n = 0;
        while (n < objectArray.length) {
            this.printListElementValue(objectArray[n], n, objectArray.length);
            ++n;
        }
        this.endList();
    }

    protected void print(Vector vector) {
        this.beginList();
        boolean bl = false;
        int n = 0;
        while (n < vector.size()) {
            this.printListElementValue(vector.elementAt(n), n, vector.size());
            ++n;
        }
        this.endList();
    }

    protected void print(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        Enumeration enumeration2 = hashtable.elements();
        this.beginList();
        boolean bl = true;
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            Value value = new Value(enumeration.nextElement().toString(), enumeration2.nextElement(), true);
            value.isFirst = bl;
            value.isLast = !enumeration2.hasMoreElements();
            bl = false;
            this.printField(value);
        }
        this.endList();
    }

    protected void print(Enumeration enumeration) {
        this.beginList();
        int n = 0;
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            Value value = new Value("[" + n++ + "]", enumeration.nextElement(), true);
            value.isFirst = bl;
            value.isLast = !enumeration.hasMoreElements();
            bl = false;
            this.printField(value);
        }
        this.endList();
    }

    public void print(ResultSetRow resultSetRow) {
        this.beginList();
        try {
            if (resultSetRow.meta != null) {
                int n = 0;
                while (n < resultSetRow.meta.getColumnCount()) {
                    Value value = new Value(resultSetRow.meta.getColumnName(n + 1), resultSetRow.results.getObject(n + 1), true);
                    value.isFirst = n == 0;
                    value.isLast = n == resultSetRow.meta.getColumnCount() - 1;
                    this.printField(value);
                    ++n;
                }
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.endList();
    }

    protected void print(ResultSet resultSet) {
        this.beginList();
        int n = 0;
        boolean bl = true;
        try {
            boolean bl2 = resultSet.next();
            while (bl2) {
                ResultSetRow resultSetRow = new ResultSetRow(resultSet);
                Value value = new Value("[" + n + "]", resultSetRow, true);
                value.isFirst = bl;
                value.isLast = bl2 = resultSet.next();
                this.printField(value);
                ++n;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.endList();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        PrintWriter.addPrintHandler(class$java$util$Date == null ? (class$java$util$Date = PrintWriter.class$("java.util.Date")) : class$java$util$Date, new PrintHandler(){

            public void handle(PrintWriter printWriter, Value value) {
                printWriter.printQuoted(printWriter.dateFormat.format((Date)value.object));
            }
        });
        PrintWriter.addPrintHandler(class$java$util$Vector == null ? (class$java$util$Vector = PrintWriter.class$("java.util.Vector")) : class$java$util$Vector, new PrintHandler(){

            public void handle(PrintWriter printWriter, Value value) {
                printWriter.print((Vector)value.object);
            }
        });
        PrintWriter.addPrintHandler(class$java$util$Hashtable == null ? (class$java$util$Hashtable = PrintWriter.class$("java.util.Hashtable")) : class$java$util$Hashtable, new PrintHandler(){

            public void handle(PrintWriter printWriter, Value value) {
                printWriter.print((Hashtable)value.object);
            }
        });
        PrintWriter.addPrintHandler(class$java$util$Enumeration == null ? (class$java$util$Enumeration = PrintWriter.class$("java.util.Enumeration")) : class$java$util$Enumeration, new PrintHandler(){

            public void handle(PrintWriter printWriter, Value value) {
                printWriter.print((Enumeration)value.object);
            }
        });
        PrintWriter.addPrintHandler(class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = PrintWriter.class$("java.sql.ResultSet")) : class$java$sql$ResultSet, new PrintHandler(){

            public void handle(PrintWriter printWriter, Value value) {
                printWriter.print((ResultSet)value.object);
            }
        });
        PrintWriter.addPrintHandler(class$grace$io$PrintWriter$ResultSetRow == null ? (class$grace$io$PrintWriter$ResultSetRow = PrintWriter.class$("grace.io.PrintWriter$ResultSetRow")) : class$grace$io$PrintWriter$ResultSetRow, new PrintHandler(){

            public void handle(PrintWriter printWriter, Value value) {
                printWriter.print((ResultSetRow)value.object);
            }
        });
    }

    private class ResultSetRow {
        public ResultSet results;
        public ResultSetMetaData meta;
        public int row = 0;

        public ResultSetRow(ResultSet resultSet) {
            this.results = resultSet;
            try {
                this.meta = this.results.getMetaData();
            }
            catch (Exception exception) {
                this.meta = null;
            }
        }
    }

    private static class MethodFieldAccessor
    extends FieldAccessor {
        Method accessor;

        public MethodFieldAccessor(String string, Method method) {
            super(string);
            this.accessor = method;
        }

        public Object get(Object object) {
            try {
                return this.accessor.invoke(object, null);
            }
            catch (IllegalAccessException illegalAccessException) {
                return "<illegal-access>";
            }
            catch (InvocationTargetException invocationTargetException) {
                return "<illegal-access>";
            }
        }
    }

    private static class DirectFieldAccessor
    extends FieldAccessor {
        Field field;

        public DirectFieldAccessor(String string, Field field) {
            super(string);
            this.field = field;
        }

        public Object get(Object object) {
            try {
                return this.field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                return "<illegal-access>";
            }
        }
    }

    private static abstract class FieldAccessor {
        public String name;

        public FieldAccessor(String string) {
            this.name = string;
        }

        public abstract Object get(Object var1);
    }

    static class PrintMethodHandler
    implements PrintHandler {
        Method printMethod;

        public PrintMethodHandler(Method method) {
            this.printMethod = method;
        }

        public void handle(PrintWriter printWriter, Value value) {
            try {
                this.printMethod.invoke(value.object, printWriter);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }
}

