/*
 * Decompiled with CFR 0.152.
 */
package grace.io;

import grace.io.PrintWriter;
import grace.io.Value;
import java.io.OutputStream;
import java.io.Writer;

public class JavaPrintWriter
extends PrintWriter {
    private int indent = 0;
    private static final String indentString = "    ";

    public JavaPrintWriter(OutputStream outputStream) {
        super(outputStream);
    }

    public JavaPrintWriter(OutputStream outputStream, boolean bl) {
        super(outputStream, bl);
    }

    public JavaPrintWriter(Writer writer) {
        super(writer);
    }

    public JavaPrintWriter(Writer writer, boolean bl) {
        super(writer, bl);
    }

    protected void indent() {
        int n = 0;
        while (n < this.indent) {
            this.print(indentString);
            ++n;
        }
    }

    public void printField(Value value) {
        if (value.object == null) {
            this.printNullObject();
        } else {
            this.printType(value, false, false);
            this.separateTypeAndName();
            this.printName(value.name);
            this.separateNameAndValue();
            this.printValue(value);
            this.print(";");
            this.separateObjectItems();
        }
    }

    protected void newlineAndIndent() {
        this.print("\n");
        this.indent();
    }

    public void beginList() {
        this.print("{");
        ++this.indent;
        if (this.prettyOutput()) {
            this.newlineAndIndent();
        }
    }

    public void endList() {
        if (--this.indent < 0) {
            this.indent = 0;
        }
        if (this.prettyOutput()) {
            this.newlineAndIndent();
        }
        this.print("}");
    }

    public void beginObject() {
        this.beginList();
    }

    public void endObject() {
        this.endList();
    }

    protected void separateObjectItems() {
        if (this.prettyOutput()) {
            this.newlineAndIndent();
        } else {
            this.print(" ");
        }
    }

    protected void separateTypeAndName() {
        this.print(" ");
    }

    protected void separateNameAndValue() {
        if (this.prettyOutput()) {
            this.print(" = ");
        } else {
            this.print("=");
        }
    }

    protected void printNullString() {
        this.print("null;");
    }

    protected void printNullObject() {
        this.print("null;");
    }
}

