/*
 * Decompiled with CFR 0.152.
 */
package grace.io;

import grace.io.PrintWriter;
import grace.io.Value;
import java.io.OutputStream;
import java.io.Writer;

public class FormattedPrintWriter
extends PrintWriter {
    private String headerFormat = "";
    private String beginBlockFormat = "{";
    private String fieldFormat = "%c %n=%v;";
    private String endBlockFormat = " }";
    private boolean firstCall = true;
    private int indent = 0;
    private static final String indentString = "    ";

    public FormattedPrintWriter(OutputStream outputStream) {
        super(outputStream);
    }

    public FormattedPrintWriter(OutputStream outputStream, boolean bl) {
        super(outputStream, bl);
    }

    public FormattedPrintWriter(Writer writer) {
        super(writer);
    }

    public FormattedPrintWriter(Writer writer, boolean bl) {
        super(writer, bl);
    }

    public void setFormat(String string) {
        this.setFieldFormat("invalid");
        this.setBeginBlockFormat("invalid");
        this.setHeaderFormat("invalid");
        int n = string.indexOf(124);
        if (n != -1) {
            this.setHeaderFormat(string.substring(0, n));
            int n2 = n + 1;
            n = string.indexOf(124, n2);
            if (n != -1) {
                this.setBeginBlockFormat(string.substring(n2, n));
                n2 = n + 1;
                n = string.indexOf(124, n2);
                if (n != -1) {
                    this.setFieldFormat(string.substring(n2, n));
                    if (n + 1 < string.length()) {
                        this.setEndBlockFormat(string.substring(n + 1));
                    }
                }
            }
        }
    }

    public void setFormat(String string, String string2, String string3, String string4) {
        this.setHeaderFormat(string);
        this.setBeginBlockFormat(string2);
        this.setFieldFormat(string3);
        this.setEndBlockFormat(string4);
    }

    public void setHeaderFormat(String string) {
        this.headerFormat = string;
    }

    public void setBeginBlockFormat(String string) {
        this.beginBlockFormat = string;
    }

    public void setFieldFormat(String string) {
        this.fieldFormat = string;
    }

    public void setEndBlockFormat(String string) {
        this.endBlockFormat = string;
    }

    protected void printField(Value value) {
        if (this.firstCall) {
            this.firstCall = false;
            this.print(this.headerFormat);
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < this.fieldFormat.length()) {
            char c = this.fieldFormat.charAt(n);
            if (bl) {
                bl = false;
                switch (c) {
                    case '%': {
                        this.print(c);
                        break;
                    }
                    case 'i': {
                        this.indent();
                        break;
                    }
                    case 'C': {
                        this.printType(value, false, false);
                        break;
                    }
                    case 'c': {
                        this.printType(value, true, true);
                        break;
                    }
                    case 't': {
                        this.printType(value, true, false);
                        break;
                    }
                    case 'n': {
                        this.printName(value.name);
                        break;
                    }
                    case 'v': {
                        if (value == null) {
                            this.printNullObject();
                            break;
                        }
                        this.printValue(value);
                        break;
                    }
                    case 'r': {
                        this.print(this.referenceNameOf(value));
                        break;
                    }
                    case 'z': {
                        bl2 = true;
                        break;
                    }
                }
            } else if (c == '%') {
                bl = true;
            } else if (bl2 && value.isLast) {
                bl2 = false;
            } else {
                this.print(c);
            }
            ++n;
        }
    }

    protected void printBlocking(String string) {
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (bl) {
                bl = false;
                switch (c) {
                    case '%': {
                        this.print(c);
                        break;
                    }
                    case 'i': {
                        this.indent();
                        break;
                    }
                }
            } else if (c == '%') {
                bl = true;
            } else {
                this.print(c);
            }
            ++n;
        }
    }

    public void printBeginBlock() {
        this.printBlocking(this.beginBlockFormat);
    }

    public void printEndBlock() {
        this.printBlocking(this.endBlockFormat);
    }

    protected void indent() {
        int n = 0;
        while (n < this.indent) {
            this.print(indentString);
            ++n;
        }
    }

    protected void newlineAndIndent() {
        this.print("\n");
        this.indent();
    }

    public void beginList() {
        this.printBeginBlock();
        ++this.indent;
    }

    public void endList() {
        if (--this.indent < 0) {
            this.indent = 0;
        }
        this.printEndBlock();
    }

    public void beginObject() {
        this.beginList();
    }

    public void endObject() {
        this.endList();
    }

    public void separateListItems() {
    }

    public void separateObjectItems() {
    }

    protected void printNullString() {
        this.print("null");
    }

    protected void printNullObject() {
        this.print("null");
    }
}

