/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.Config;
import edu.caltech.sbw.SBWLog;
import java.io.File;

class VerifiableFile
extends File {
    public VerifiableFile(String string) {
        super(string);
    }

    public VerifiableFile(File file) {
        super(file.getPath());
    }

    public VerifiableFile(String string, String string2) {
        super(string, string2);
    }

    public VerifiableFile(File file, String string) {
        super(file, string);
    }

    public boolean isVerifiedFile() {
        if (this.isDirectory()) {
            SBWLog.trace(this.getPath() + " is a directory.");
            return false;
        }
        if (this.exists() && !this.canRead()) {
            SBWLog.trace("File " + this.getPath() + " exists but is not readable.");
            return false;
        }
        return true;
    }

    public boolean isVerifiedExistingFile() {
        if (this.isDirectory()) {
            SBWLog.trace(this.getPath() + " is a directory.");
            return false;
        }
        if (!this.exists()) {
            SBWLog.trace("File " + this.getPath() + " does not exist.");
            return false;
        }
        if (!this.isFile()) {
            SBWLog.trace(this.getPath() + " is a not a file.");
            return false;
        }
        if (!this.canRead()) {
            SBWLog.trace("File " + this.getPath() + " exists but is not readable.");
            return false;
        }
        return true;
    }

    public boolean isVerifiedDirectory() {
        if (!this.exists()) {
            SBWLog.trace("Directory " + this.getPath() + " does not exist.");
            return false;
        }
        if (!this.isDirectory()) {
            SBWLog.trace(this.getPath() + " is not a directory.");
            return false;
        }
        if (!this.canRead()) {
            SBWLog.trace("Directory " + this.getPath() + " exists but is not readable.");
            return false;
        }
        return true;
    }

    static {
        Config.recordClassVersion(VerifiableFile.class, "$Id: VerifiableFile.java,v 1.3 2007/07/24 23:08:19 fbergmann Exp $");
    }
}

