/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.Config;
import edu.caltech.sbw.SBWLog;
import edu.caltech.sbw.VerifiableFile;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.Date;

public class Sys {
    public static final int OS_WINNT = 1;
    public static final int OS_WIN95 = 2;
    public static final int OS_WIN98 = 4;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_HP = 32;
    public static final int OS_AIX = 64;
    public static final int OS_IRIX = 128;
    public static final int OS_SUNOS = 256;
    public static final int OS_DEC = 512;
    public static final int OS_OS2 = 1024;
    public static final int OS_MAC = 2048;
    public static final int OS_WIN2000 = 4096;
    public static final int OS_WINXP = 8192;
    public static final int OS_DARWIN = 16384;
    public static final int OS_WINVISTA = 32768;
    public static final int OS_OTHER = 65536;
    public static final int OS_WINDOWS_MASK = 45063;
    public static final int OS_UNIX_MASK = 17400;
    private static int operatingSystem = -1;

    public static final boolean OSIsWindows() {
        return (Sys.getOperatingSystem() & 0xB007) != 0;
    }

    public static final boolean OSIsUnix() {
        return (Sys.getOperatingSystem() & 0x43F8) != 0;
    }

    public static final boolean OSIsMac() {
        return (Sys.getOperatingSystem() & 0x800) != 0;
    }

    public static final int getOperatingSystem() {
        if (operatingSystem == -1) {
            String string = System.getProperty("os.name");
            operatingSystem = string.startsWith("Windows NT") ? 1 : ("Windows Vista".equals(string) ? 32768 : ("Windows 95".equals(string) ? 2 : ("Windows 98".equals(string) ? 4 : ("Windows 2000".equals(string) ? 4096 : ("Windows XP".equals(string) ? 8192 : ("Solaris".equals(string) ? 8 : (string.startsWith("SunOS") ? 8 : ("Linux".equals(string) ? 16 : ("HP-UX".equals(string) ? 32 : ("AIX".equals(string) ? 64 : ("Irix".equals(string) ? 128 : ("SunOS".equals(string) ? 256 : ("Digital UNIX".equals(string) ? 512 : ("OS/2".equals(string) ? 1024 : (string.startsWith("Mac OS") ? 2048 : (string.startsWith("Darwin") ? 18432 : (string.startsWith("Windows") ? 45063 : 65536)))))))))))))))));
        }
        return operatingSystem;
    }

    public static final String getHostName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return Sys.fullyQualifiedHostName(inetAddress.getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            SBWLog.notice("This host does not have a host name");
            return null;
        }
        catch (SecurityException securityException) {
            SBWLog.warning("Java security prevents getting local host's name");
            return null;
        }
    }

    public static final String getHostAddress(String string) {
        try {
            return InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            SBWLog.notice("This host does not have a host address");
            return null;
        }
        catch (SecurityException securityException) {
            SBWLog.warning("Java security prevents getting local host address");
            return null;
        }
    }

    public static String getHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            SBWLog.notice("This host does not have a host address");
            return null;
        }
        catch (SecurityException securityException) {
            SBWLog.warning("Java security prevents getting local host address");
            return null;
        }
    }

    public static String getCommandShell() {
        switch (Sys.getOperatingSystem()) {
            case 2: 
            case 4: {
                return Sys.getWindowsSystemDirectory().getPath() + File.separator + "command.com";
            }
            case 1: 
            case 4096: 
            case 8192: {
                return Sys.getWindowsSystemDirectory().getPath() + File.separator + "cmd.exe";
            }
        }
        return "/bin/sh";
    }

    public static String getWindowsRootDriveLetter() {
        String string = System.getProperty("java.home");
        if (string != null) {
            return string.substring(0, 1);
        }
        return null;
    }

    public static VerifiableFile getWindowsSystemDirectory() {
        switch (Sys.getOperatingSystem()) {
            case 2: 
            case 4: {
                return new VerifiableFile(Sys.getWindowsRootDriveLetter() + ":" + File.separator + "Windows");
            }
            case 8192: {
                return new VerifiableFile(Sys.getWindowsRootDriveLetter() + ":" + File.separator + "Windows" + File.separator + "system32");
            }
            case 1: 
            case 4096: {
                return new VerifiableFile(Sys.getWindowsRootDriveLetter() + ":" + File.separator + "WINNT" + File.separator + "system32");
            }
        }
        return null;
    }

    public static final String getTimeStamp() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        return dateFormat.format(new Date());
    }

    public static final void safeSleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static final String getJavaExecutable() {
        return System.getProperty("java.home") + File.separator + "bin" + File.separator + (Sys.OSIsWindows() ? "javaw" : "java");
    }

    public static final int[] getJavaVersion() {
        String string = System.getProperty("java.version");
        int[] nArray = new int[3];
        try {
            int n = 0;
            for (int i = 0; i <= 2; ++i) {
                int n2 = 0;
                int n3 = 0;
                n2 = string.indexOf(46, n);
                if (n2 > 0) {
                    n3 = n2;
                } else {
                    n2 = string.indexOf(95, n);
                    if (n2 > 0) {
                        n3 = n2;
                    } else {
                        if (n >= string.length()) {
                            nArray[i] = 0;
                            break;
                        }
                        n3 = string.length();
                    }
                }
                String string2 = string.substring(n, n3);
                if (i > 1 && string2.length() > 1) {
                    string2 = string2.substring(0, 1);
                }
                nArray[i] = Integer.parseInt(string2);
                n = n3 + 1;
            }
        }
        catch (Exception exception) {
            SBWLog.exception(exception);
        }
        return nArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final File getFileLoadedForClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        String string = "/" + clazz.getName().replace('.', '/') + ".class";
        String string2 = "" + clazz.getResource(string);
        if (string2.startsWith("jar:file:")) {
            int n = (string2 = string2.substring(9)).indexOf(33);
            if (n > 0) {
                String string3 = string2.substring(0, n);
                if (string3 == null || string3.length() <= 0) return null;
                return new File(string3);
            }
            SBWLog.trace("Unable to determine path for class " + clazz.getName());
            return null;
        }
        if (string2.startsWith("file:")) {
            return new File(string2.substring(5));
        }
        SBWLog.trace("What kind of path is this?: '" + string2 + "'");
        return null;
    }

    public static final String getCWD() {
        return System.getProperty("user.dir");
    }

    public static File getPropertyAsDir(String string) {
        VerifiableFile verifiableFile;
        String string2 = System.getProperty(string);
        if (string2 != null && (verifiableFile = new VerifiableFile(string2)).isVerifiedDirectory()) {
            return verifiableFile;
        }
        return null;
    }

    public static File getPropertyAsDir(String string, String string2) {
        String string3 = System.getProperty(string);
        VerifiableFile verifiableFile = string3 != null ? new VerifiableFile(string3) : new VerifiableFile(string2);
        if (verifiableFile.isVerifiedDirectory()) {
            return verifiableFile;
        }
        return null;
    }

    public static File getPropertyAsFile(String string) {
        VerifiableFile verifiableFile;
        String string2 = System.getProperty(string);
        if (string2 != null && (verifiableFile = new VerifiableFile(string2)).isVerifiedFile()) {
            return verifiableFile;
        }
        return null;
    }

    public static File getPropertyAsFile(String string, String string2) {
        String string3 = System.getProperty(string);
        VerifiableFile verifiableFile = string3 != null ? new VerifiableFile(string3) : new VerifiableFile(string2);
        if (verifiableFile.isVerifiedFile()) {
            return verifiableFile;
        }
        return null;
    }

    public static String getPropertyAsString(String string) {
        return System.getProperty(string);
    }

    public static String getPropertyAsString(String string, String string2) {
        return System.getProperty(string, string2);
    }

    public static Integer getPropertyAsInt(String string) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                return new Integer(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                SBWLog.warning("Property value of " + string + " is not an int");
            }
        }
        return null;
    }

    public static int getPropertyAsInt(String string, int n) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                Integer n2 = new Integer(Integer.parseInt(string2));
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                SBWLog.warning("Property value of " + string + " is not an int");
            }
        }
        return n;
    }

    public static String fullyQualifiedHostName(String string) {
        try {
            if (Sys.isAddress(string)) {
                string = InetAddress.getByName(string).getHostName();
            }
            if (string.indexOf(46) > 0) {
                return string;
            }
            String string2 = InetAddress.getLocalHost().getHostAddress();
            String string3 = InetAddress.getByName(string2).getHostName();
            if (string3.indexOf(46) > 0 && !Sys.isAddress(string3)) {
                return string + string3.substring(string3.indexOf(46));
            }
            return string;
        }
        catch (UnknownHostException unknownHostException) {
            return string;
        }
    }

    private static boolean isAddress(String string) {
        int n = 0;
        for (int i = 3; i > 0; --i) {
            ++n;
            if ((n = string.indexOf(46, n)) > 0) continue;
            return false;
        }
        try {
            Integer.parseInt(string.substring(0, string.indexOf(46)));
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean portInUse(int n, boolean bl) {
        try {
            ServerSocket serverSocket = bl ? new ServerSocket(n) : new ServerSocket(n, 50, InetAddress.getByName("localhost"));
            serverSocket.setReuseAddress(true);
            serverSocket.close();
            return false;
        }
        catch (BindException bindException) {
            return true;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public static int findFreePort(int[] nArray, boolean bl) {
        int n = nArray[0];
        int n2 = nArray[1];
        for (int i = n; i <= n2; ++i) {
            if (!Sys.portInUse(i, bl)) {
                return i;
            }
            SBWLog.trace("Port " + i + " appears to be in use");
        }
        return -1;
    }

    private Sys() {
    }

    static {
        Config.recordClassVersion(Sys.class, "$Id: Sys.java,v 1.3 2007/07/24 23:08:23 fbergmann Exp $");
    }
}

