/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.Config;
import edu.caltech.sbw.SBWLog;
import java.util.StringTokenizer;

final class StringUtil {
    private static final String HEX = "0123456789ABCDEF";

    StringUtil() {
    }

    public static boolean empty(String string) {
        return string == null || string.length() == 0;
    }

    public static int[] parseRange(String string) {
        if (string == null) {
            SBWLog.trace("Null range given");
            return new int[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        if (stringTokenizer.countTokens() != 2) {
            SBWLog.trace("Bad range spec: " + string);
            return new int[0];
        }
        int[] nArray = new int[2];
        try {
            nArray[0] = Integer.parseInt(stringTokenizer.nextToken());
            nArray[1] = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            SBWLog.trace("Bad range spec: " + string);
            return new int[0];
        }
        return nArray;
    }

    public static String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            int n = (by & 0xF0) >> 4;
            int n2 = by & 0xF;
            stringBuffer.append("" + HEX.charAt(n) + HEX.charAt(n2));
        }
        return stringBuffer.toString();
    }

    static {
        Config.recordClassVersion(StringUtil.class, "$Id: StringUtil.java,v 1.2 2007/07/24 23:08:19 fbergmann Exp $");
    }
}

