/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.Config;
import edu.caltech.sbw.SignatureElement;

public class SignatureType {
    private int type;
    private SignatureType arrayType;
    private SignatureElement[] listContents;

    public final int getType() {
        return this.type;
    }

    public final SignatureType getArrayInnerType() {
        return this.arrayType;
    }

    public final SignatureElement[] getListContents() {
        return this.listContents;
    }

    public boolean equals(SignatureType signatureType) {
        if (this == signatureType) {
            return true;
        }
        return this.type == signatureType.getType() && (this.arrayType == null && signatureType.arrayType == null || this.arrayMatch(signatureType)) && (this.listContents == null && signatureType.listContents == null || this.listMatch(signatureType));
    }

    public String toString() {
        switch (this.getType()) {
            case 0: {
                return "byte";
            }
            case 1: {
                return "int";
            }
            case 2: {
                return "double";
            }
            case 8: {
                return "complex";
            }
            case 3: {
                return "boolean";
            }
            case 4: {
                return "string";
            }
            case 5: {
                return this.getArrayInnerType().toString() + "[]";
            }
            case 6: {
                String string = "{";
                if (this.listContents != null) {
                    for (int i = 0; i != this.listContents.length; ++i) {
                        SignatureElement signatureElement = this.listContents[i];
                        String string2 = signatureElement.getName();
                        string = string + ' ' + signatureElement.getType().toString();
                        if (string2 != null) {
                            string = string + ' ' + string2;
                        }
                        string = i != this.listContents.length - 1 ? string + ',' : string + ' ';
                    }
                }
                return string + "}";
            }
            case 7: {
                return "void";
            }
        }
        return "unknownType";
    }

    public SignatureType(int n, SignatureType signatureType, SignatureElement[] signatureElementArray) {
        this.type = n;
        this.arrayType = signatureType;
        this.listContents = signatureElementArray;
    }

    private boolean arrayMatch(SignatureType signatureType) {
        return this.arrayType.equals(signatureType.getArrayInnerType());
    }

    private boolean listMatch(SignatureType signatureType) {
        SignatureElement[] signatureElementArray = signatureType.getListContents();
        if (this.listContents.length == 0 || signatureElementArray.length == 0) {
            return true;
        }
        if (this.listContents.length != signatureElementArray.length) {
            return false;
        }
        for (int i = 0; i < this.listContents.length && i < signatureElementArray.length; ++i) {
            if (this.listContents[i].equals(signatureElementArray[i])) continue;
            return false;
        }
        return true;
    }

    static {
        Config.recordClassVersion(SignatureType.class, "$Id: SignatureType.java,v 1.2 2007/07/24 23:08:20 fbergmann Exp $");
    }
}

