/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.Config;
import edu.caltech.sbw.SBWLog;
import edu.caltech.sbw.SBWSignatureSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java_cup.runtime.Scanner;
import java_cup.runtime.Symbol;

class SignatureScanner
implements Scanner {
    private int next_token;
    private StreamTokenizer tokenizer;

    public SignatureScanner(String string) {
        try {
            this.tokenizer = new StreamTokenizer(new StringReader(string));
            this.init();
        }
        catch (IOException iOException) {
            SBWLog.exception("Problem parsing signature string", iOException);
        }
    }

    public SignatureScanner(InputStream inputStream) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            this.tokenizer = new StreamTokenizer(bufferedReader);
            this.init();
        }
        catch (IOException iOException) {
            SBWLog.exception("Problem parsing signature string", iOException);
        }
    }

    public SignatureScanner() {
        this(System.in);
    }

    public Symbol next_token() throws IOException, SBWSignatureSyntaxException {
        switch (this.next_token) {
            case -3: {
                String string = this.tokenizer.sval;
                this.advance();
                if (string.equals("void")) {
                    return new Symbol(3);
                }
                if (string.equals("int")) {
                    return new Symbol(4);
                }
                if (string.equals("double")) {
                    return new Symbol(5);
                }
                if (string.equals("complex")) {
                    return new Symbol(17);
                }
                if (string.equals("string")) {
                    return new Symbol(6);
                }
                if (string.equals("boolean")) {
                    return new Symbol(7);
                }
                if (string.equals("byte")) {
                    return new Symbol(8);
                }
                if (Character.isDigit(string.charAt(0))) {
                    throw new SBWSignatureSyntaxException("Names cannot begin with digits", "Method and variable names must begin with either a letter or an underscore character.");
                }
                if (!SignatureScanner.conformsToSName(string)) {
                    throw new SBWSignatureSyntaxException("Name does not conform to permitted syntax", "Method and variable names must begin with either a letter or an underscore character, followed by one or more letters, digits or underscore characters,  and contain at least one character or digit.");
                }
                return new Symbol(2, string);
            }
            case 46: {
                this.advance();
                if (this.next_token == 46) {
                    this.advance();
                    if (this.next_token == 46) {
                        this.advance();
                        return new Symbol(10);
                    }
                }
                throw new SBWSignatureSyntaxException("Encountered stray '.' character", "The period character '.' is only valid as part of a '...' sequence specification.");
            }
            case 44: {
                this.advance();
                return new Symbol(9);
            }
            case 41: {
                this.advance();
                return new Symbol(16);
            }
            case 40: {
                this.advance();
                return new Symbol(15);
            }
            case 91: {
                this.advance();
                return new Symbol(11);
            }
            case 93: {
                this.advance();
                return new Symbol(12);
            }
            case 123: {
                this.advance();
                return new Symbol(13);
            }
            case 125: {
                this.advance();
                return new Symbol(14);
            }
            case -1: 
            case 10: {
                return new Symbol(0);
            }
        }
        SBWLog.notice("Found unrecognized token in signature: " + this.tokenizer.ttype + " (" + this.tokenizer.sval + ")");
        throw new SBWSignatureSyntaxException("Unrecognized token in signature: " + this.next_token, "The given signature contains a token (" + this.next_token + ") that is not valid in SBW method signature strings");
    }

    void advance() throws IOException {
        this.next_token = this.tokenizer.nextToken();
    }

    void init() throws IOException {
        this.tokenizer.resetSyntax();
        this.tokenizer.slashSlashComments(false);
        this.tokenizer.slashStarComments(false);
        this.tokenizer.eolIsSignificant(false);
        this.tokenizer.lowerCaseMode(false);
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.wordChars(48, 57);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(95, 95);
        this.advance();
    }

    static boolean conformsToSName(String string) {
        if (string == null) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (!Character.isLetter(cArray[0]) && cArray[0] != '_') {
            return false;
        }
        if (cArray[0] == '_' && cArray.length == 1) {
            return false;
        }
        for (int i = 1; i < cArray.length; ++i) {
            if (Character.isLetterOrDigit(cArray[i]) || cArray[i] == '_') continue;
            return false;
        }
        return true;
    }

    static {
        Config.recordClassVersion(SignatureScanner.class, "$Id: SignatureScanner.java,v 1.3 2007/07/24 23:08:19 fbergmann Exp $");
    }
}

