/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.Config;
import edu.caltech.sbw.Module;
import edu.caltech.sbw.SBWComplex;
import edu.caltech.sbw.SBWLog;
import edu.caltech.sbw.SBWSignatureSyntaxException;
import edu.caltech.sbw.SBWUnsupportedObjectTypeException;
import edu.caltech.sbw.SignatureElement;
import edu.caltech.sbw.SignatureParser;
import edu.caltech.sbw.SignatureScanner;
import edu.caltech.sbw.SignatureType;
import java.lang.reflect.Method;
import java.util.Collection;
import java_cup.runtime.Symbol;

public class Signature
extends SignatureParser {
    private String name;
    private SignatureElement[] arguments;
    private SignatureType returnType;

    public final String getName() {
        return this.name;
    }

    public final SignatureElement[] getArguments() {
        return this.arguments;
    }

    public final SignatureType getReturnType() {
        return this.returnType;
    }

    public String toString() {
        String string = this.getReturnType().toString() + " " + this.getName() + "(";
        int n = 0;
        while (n != this.arguments.length) {
            string = string + this.arguments[n].getType().toString();
            if (++n == this.arguments.length) continue;
            string = string + ", ";
        }
        string = string + ")";
        return string;
    }

    static final String typeString(Class clazz) throws SBWUnsupportedObjectTypeException {
        if (clazz.equals(Double.TYPE)) {
            return "double";
        }
        if (clazz.equals(Integer.TYPE)) {
            return "int";
        }
        if (clazz.equals(Boolean.TYPE)) {
            return "boolean";
        }
        if (clazz.equals(SBWComplex.class)) {
            return "complex";
        }
        if (clazz.equals(Byte.TYPE)) {
            return "byte";
        }
        if (clazz.equals(Void.TYPE)) {
            return "void";
        }
        if (clazz.equals(String.class)) {
            return "string";
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return "{}";
        }
        if (clazz.isArray()) {
            return Signature.typeString(clazz.getComponentType()) + "[]";
        }
        throw new SBWUnsupportedObjectTypeException("class " + clazz.getName() + " not supported", "");
    }

    public Signature(String string, SignatureElement[] signatureElementArray, SignatureType signatureType) {
        this.name = string;
        this.arguments = signatureElementArray;
        this.returnType = signatureType;
    }

    Signature(String string) throws SBWSignatureSyntaxException {
        super(new SignatureScanner(string));
        try {
            Symbol symbol = this.parse();
            Signature signature = (Signature)symbol.value;
            this.name = signature.getName();
            this.arguments = signature.getArguments();
            this.returnType = signature.getReturnType();
        }
        catch (Exception exception) {
            SBWLog.exception("Problem parsing signature '" + string + "'", exception);
            throw new SBWSignatureSyntaxException("Unable to parse signature string '" + string + "'", exception.getMessage());
        }
    }

    Signature(Method method) throws SBWUnsupportedObjectTypeException, SBWSignatureSyntaxException {
        this(Signature.methodSignatureString(method));
    }

    static String methodSignatureString(Method method) throws SBWUnsupportedObjectTypeException {
        StringBuffer stringBuffer = new StringBuffer(256);
        Class<?> clazz = method.getReturnType();
        if (clazz.equals(Collection.class)) {
            stringBuffer.append("{}");
        } else {
            stringBuffer.append(Signature.typeString(clazz));
        }
        stringBuffer.append(" " + method.getName() + "(");
        Class<?>[] classArray = method.getParameterTypes();
        int n = 0;
        if (classArray.length != 0 && classArray[0].equals(Module.class)) {
            n = 1;
        }
        if (classArray.length != n && classArray[n].equals(Collection.class)) {
            stringBuffer.append("...");
        } else {
            while (n != classArray.length) {
                stringBuffer.append(Signature.typeString(classArray[n]));
                if (n != classArray.length - 1) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Signature)) {
            return false;
        }
        Signature signature = (Signature)object;
        if (!signature.name.equals(this.name) || signature.arguments.length != this.arguments.length) {
            return false;
        }
        for (int i = 0; i != this.arguments.length; ++i) {
            if (this.arguments[i].equals(signature.arguments[i])) continue;
            return false;
        }
        return this.returnType.equals(signature.returnType);
    }

    static {
        Config.recordClassVersion(Signature.class, "$Id: Signature.java,v 1.3 2007/07/24 23:08:23 fbergmann Exp $");
    }
}

