/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.Config;
import edu.caltech.sbw.SBWLog;
import edu.caltech.sbw.VerifiableFile;
import java.io.FileReader;

class SessionKey {
    private static final int KEY_LENGTH = 256;
    protected static String key;

    SessionKey() {
    }

    static String getKey() {
        if (key == null) {
            SessionKey.loadKey();
        }
        return key;
    }

    static void loadKey() {
        VerifiableFile verifiableFile = Config.getSessionKeyFile();
        if (verifiableFile.isVerifiedExistingFile()) {
            SBWLog.trace("Loading session key from '" + verifiableFile.getPath() + "'");
            try {
                int n;
                FileReader fileReader = new FileReader(verifiableFile);
                StringBuffer stringBuffer = new StringBuffer();
                char[] cArray = new char[512];
                while ((n = fileReader.read(cArray)) > 0) {
                    stringBuffer.append(cArray, 0, n);
                }
                key = stringBuffer.toString();
                return;
            }
            catch (Exception exception) {
                SBWLog.exception(exception);
            }
        }
        SBWLog.warning("Cannot load session key from file '" + verifiableFile.getPath() + "'");
    }

    static {
        Config.recordClassVersion(SessionKey.class, "$Id: SessionKey.java,v 1.3 2007/07/24 23:08:23 fbergmann Exp $");
    }
}

