/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.Config;
import edu.caltech.sbw.DataBlockReader;
import edu.caltech.sbw.DataBlockWriter;
import edu.caltech.sbw.SBWLog;
import edu.caltech.sbw.SBWLowLevel;
import edu.caltech.sbw.SBWMethodAmbiguousException;
import edu.caltech.sbw.SBWMethodNotFoundException;
import edu.caltech.sbw.SBWSignatureSyntaxException;
import edu.caltech.sbw.SBWUnsupportedObjectTypeException;
import edu.caltech.sbw.ServiceImpl;
import edu.caltech.sbw.Signature;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

class ServiceInvocationHandler
implements InvocationHandler {
    private int serviceId;
    private int moduleId;
    private HashMap methodIdMap = new HashMap(10);
    private SBWLowLevel rpc;
    private static Method hashCodeMethod;
    private static Method toStringMethod;
    private static Method equalsMethod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            if (method.equals(hashCodeMethod)) {
                return this.proxyHashCode(object);
            }
            if (method.equals(equalsMethod)) {
                return this.proxyEquals(object, objectArray[0]);
            }
            if (method.equals(toStringMethod)) {
                return this.proxyToString(object);
            }
            throw new SBWMethodNotFoundException("Unexpected Object method dispatched: " + method, "");
        }
        Integer n = (Integer)this.methodIdMap.get(ServiceImpl.getSignatureString(method));
        int n2 = n;
        SBWLog.trace("Invoking method " + n2 + " on service " + this.serviceId + " of module " + this.moduleId);
        DataBlockWriter dataBlockWriter = new DataBlockWriter();
        try {
            DataBlockReader dataBlockReader;
            if (objectArray != null) {
                if (objectArray.length > 0 && objectArray[0] instanceof Collection) {
                    dataBlockWriter.addOutOfCollection((Collection)objectArray[0]);
                } else {
                    for (int i = 0; i < objectArray.length; ++i) {
                        dataBlockWriter.add(objectArray[i]);
                    }
                }
            }
            if ((dataBlockReader = this.rpc.call(this.moduleId, this.serviceId, n2, dataBlockWriter)).getNextType() == -1) {
                Object var8_9 = null;
                return var8_9;
            }
            Object object2 = dataBlockReader.getObject();
            return object2;
        }
        finally {
            dataBlockWriter.release();
        }
    }

    ServiceInvocationHandler(int n, int n2, Class[] classArray, String[] stringArray, SBWLowLevel sBWLowLevel) throws SBWUnsupportedObjectTypeException, SBWMethodNotFoundException, SBWSignatureSyntaxException, SBWMethodAmbiguousException {
        this.moduleId = n2;
        this.serviceId = n;
        this.rpc = sBWLowLevel;
        try {
            int n3;
            Object object;
            ArrayList arrayList = new ArrayList(20);
            for (int i = 0; i < classArray.length; ++i) {
                int n4;
                Class clazz = classArray[i];
                object = clazz.getMethods();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (n4 = 0; n4 < ((Method[])object).length; ++n4) {
                    if (object[n4].getDeclaringClass().equals(Object.class)) continue;
                    arrayList2.add(ServiceImpl.getSignatureString(object[n4]));
                }
                for (n4 = 0; n4 < arrayList2.size(); ++n4) {
                    if (arrayList.contains(arrayList2.get(n4))) {
                        throw new SBWMethodAmbiguousException("Multiple definitions of method '" + arrayList2.get(n4) + "' in the set of interface classes given", "Method '" + arrayList2.get(n4) + "' is defined in more" + " than one of the given interface classes being" + " used for the definition of the proxy service" + " handler.  This probably indicates an error" + " in the calling code.");
                    }
                    arrayList.add(arrayList2.get(n4));
                }
            }
            Signature[] signatureArray = new Signature[stringArray.length];
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                signatureArray[n3] = new Signature(stringArray[n3]);
            }
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                int n5;
                object = new Signature((String)arrayList.get(n3));
                for (n5 = 0; n5 != stringArray.length && !signatureArray[n5].equals(object); ++n5) {
                }
                if (n5 == stringArray.length) {
                    String string = "Methods found:\n";
                    for (int i = 0; i < stringArray.length; ++i) {
                        string = string + "  " + stringArray[i] + '\n';
                    }
                    throw new SBWMethodNotFoundException("Unable to find method " + arrayList.get(n3), string);
                }
                this.methodIdMap.put(arrayList.get(n3), new Integer(n5));
            }
        }
        catch (SBWUnsupportedObjectTypeException sBWUnsupportedObjectTypeException) {
            SBWLog.error("Bad argument type", sBWUnsupportedObjectTypeException);
            throw sBWUnsupportedObjectTypeException;
        }
    }

    private Integer proxyHashCode(Object object) {
        return new Integer(System.identityHashCode(object));
    }

    private Boolean proxyEquals(Object object, Object object2) {
        return object == object2 ? Boolean.TRUE : Boolean.FALSE;
    }

    private String proxyToString(Object object) {
        return object.getClass().getName() + '@' + Integer.toHexString(object.hashCode());
    }

    static {
        try {
            hashCodeMethod = Object.class.getMethod("hashCode", null);
            toStringMethod = Object.class.getMethod("toString", null);
            equalsMethod = Object.class.getMethod("equals", Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            SBWLog.exception("Unable to initialize basic methods", noSuchMethodException);
        }
        Config.recordClassVersion(ServiceInvocationHandler.class, "$Id: ServiceInvocationHandler.java,v 1.3 2007/07/24 23:08:19 fbergmann Exp $");
    }
}

