/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.BrokerInterface;
import edu.caltech.sbw.Config;
import edu.caltech.sbw.DataBlockReader;
import edu.caltech.sbw.DataBlockWriter;
import edu.caltech.sbw.Module;
import edu.caltech.sbw.SBWException;
import edu.caltech.sbw.SBWLog;
import edu.caltech.sbw.SBWMethodNotFoundException;
import edu.caltech.sbw.SBWSignatureSyntaxException;
import edu.caltech.sbw.SBWUnsupportedObjectTypeException;
import edu.caltech.sbw.Signature;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Hashtable;

class ServiceImpl {
    private String uniqueName;
    private String displayName;
    private String category;
    private String helpString;
    private Object implementation;
    private Method[] methods;
    private String moduleName;
    private Hashtable methodHelpStrings;

    public ServiceImpl(String string, String string2, String string3, Object object, String string4, Hashtable hashtable) {
        this.uniqueName = string;
        this.displayName = string2;
        this.category = string3;
        this.implementation = object;
        this.helpString = string4;
        this.methodHelpStrings = hashtable;
        Method[] methodArray = object.getClass().getMethods();
        Method[] methodArray2 = new Method[methodArray.length];
        int n = 0;
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (method.getDeclaringClass().equals(Object.class)) continue;
            try {
                ServiceImpl.getSignatureString(method);
            }
            catch (SBWUnsupportedObjectTypeException sBWUnsupportedObjectTypeException) {
                continue;
            }
            methodArray2[n] = method;
            ++n;
        }
        SBWLog.trace("Creating service implementation for '" + string + "' with " + n + " methods");
        this.methods = new Method[n];
        System.arraycopy(methodArray2, 0, this.methods, 0, n);
    }

    public Object getImplementation() {
        return this.implementation;
    }

    public final String getServiceName() {
        return this.uniqueName;
    }

    public final String getServiceDisplayName() {
        return this.displayName;
    }

    public final String getServiceCategory() {
        return this.category;
    }

    public final String getServiceHelp() {
        return this.helpString;
    }

    public final String[] getSignatureStrings() throws SBWUnsupportedObjectTypeException {
        return ServiceImpl.getSignatureStrings(this.methods);
    }

    public static final String[] getSignatureStrings(Method[] methodArray) throws SBWUnsupportedObjectTypeException {
        String[] stringArray = new String[methodArray.length];
        for (int i = 0; i < methodArray.length; ++i) {
            stringArray[i] = ServiceImpl.getSignature(methodArray[i]).toString();
        }
        return stringArray;
    }

    public static final String getSignatureString(Method method) throws SBWUnsupportedObjectTypeException {
        return ServiceImpl.getSignature(method).toString();
    }

    public static final Signature getSignature(Method method) throws SBWUnsupportedObjectTypeException {
        try {
            return new Signature(method);
        }
        catch (SBWSignatureSyntaxException sBWSignatureSyntaxException) {
            SBWUnsupportedObjectTypeException sBWUnsupportedObjectTypeException = new SBWUnsupportedObjectTypeException("Method definition uses an unsupported object class", sBWSignatureSyntaxException.getMessage());
            sBWUnsupportedObjectTypeException.fillInStackTrace();
            throw sBWUnsupportedObjectTypeException;
        }
    }

    public DataBlockWriter invokeMethod(int n, int n2, DataBlockReader dataBlockReader) throws SBWException {
        int n3;
        if (n2 < 0 || n2 >= this.methods.length) {
            throw new SBWMethodNotFoundException("Method ID out of range: method number " + n2 + " not present on service " + this.getServiceName(), "");
        }
        Method method = this.methods[n2];
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        if (classArray.length != 0 && classArray[0].equals(Module.class)) {
            objectArray[0] = new Module(n);
            n3 = 1;
        } else {
            n3 = 0;
        }
        if (n3 != classArray.length && classArray[n3].equals(Collection.class)) {
            objectArray[n3] = dataBlockReader.getIntoCollection();
        } else {
            while (n3 != classArray.length) {
                objectArray[n3] = dataBlockReader.getObject();
                ++n3;
            }
        }
        DataBlockWriter dataBlockWriter = new DataBlockWriter();
        try {
            Object object = method.invoke(this.implementation, objectArray);
            if (object != null) {
                dataBlockWriter.add(object);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            dataBlockWriter.release();
            throw SBWException.translateException(invocationTargetException.getTargetException());
        }
        catch (Throwable throwable) {
            dataBlockWriter.release();
            throw SBWException.translateException(throwable);
        }
        return dataBlockWriter;
    }

    void registerWithBroker(BrokerInterface brokerInterface, String string) throws SBWException {
        brokerInterface.registerService(string, this.uniqueName, this.displayName, this.category, this.helpString);
    }

    String getMethodHelp(int n) throws SBWMethodNotFoundException {
        if (n < 0 || n >= this.methods.length) {
            throw new SBWMethodNotFoundException("Method ID out of range: method number " + n + " not present on service " + this.getServiceName(), "");
        }
        Method method = this.methods[n];
        SBWLog.trace("help for method " + method.getName() + " = " + this.methodHelpStrings.get(method.getName()));
        return (String)this.methodHelpStrings.get(method.getName());
    }

    static {
        Config.recordClassVersion(ServiceImpl.class, "$Id: ServiceImpl.java,v 1.3 2007/07/24 23:08:23 fbergmann Exp $");
    }
}

