/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.BrokerInterface;
import edu.caltech.sbw.Config;
import edu.caltech.sbw.Module;
import edu.caltech.sbw.ModuleDescriptor;
import edu.caltech.sbw.SBW;
import edu.caltech.sbw.SBWCommunicationException;
import edu.caltech.sbw.SBWException;
import edu.caltech.sbw.SBWLog;
import edu.caltech.sbw.SBWModuleNotFoundException;
import edu.caltech.sbw.SBWModuleStartException;
import edu.caltech.sbw.SBWServiceNotFoundException;
import edu.caltech.sbw.Service;
import java.util.List;

public class ServiceDescriptor {
    private String name;
    private String displayName;
    private String category;
    private String helpString;
    private ModuleDescriptor moduleDescriptor;

    public Service getServiceInModuleInstance() throws SBWCommunicationException, SBWModuleStartException, SBWModuleNotFoundException, SBWServiceNotFoundException, SBWException {
        BrokerInterface brokerInterface = SBW.getBrokerService();
        int n = brokerInterface.getModuleInstance(this.moduleDescriptor.getName());
        Module module = new Module(n);
        Service[] serviceArray = module.getServices();
        for (int i = 0; i < serviceArray.length; ++i) {
            ServiceDescriptor serviceDescriptor = serviceArray[i].getDescriptor();
            if (!serviceDescriptor.getName().equals(this.name)) continue;
            return serviceArray[i];
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCategory() {
        return this.category;
    }

    public ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    public String getHelp() {
        return this.helpString;
    }

    ServiceDescriptor(String string, String string2, String string3, ModuleDescriptor moduleDescriptor, String string4) {
        this.name = string.trim();
        this.displayName = string2.trim();
        this.category = SBW.normalizeCategoryName(string3);
        this.helpString = string4;
        this.moduleDescriptor = moduleDescriptor;
    }

    ServiceDescriptor(List list) {
        this.name = (String)list.get(1);
        this.displayName = (String)list.get(2);
        this.category = (String)list.get(3);
        this.helpString = (String)list.get(4);
        try {
            this.moduleDescriptor = SBW.getModuleDescriptor((String)list.get(0));
        }
        catch (SBWException sBWException) {
            SBWLog.exception("Unable to get module descriptor for '" + list.get(0) + "'", sBWException);
            this.moduleDescriptor = null;
        }
    }

    static {
        Config.recordClassVersion(ServiceDescriptor.class, "$Id: ServiceDescriptor.java,v 1.2 2007/07/24 23:08:20 fbergmann Exp $");
    }
}

