/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.BrokerInterface;
import edu.caltech.sbw.Config;
import edu.caltech.sbw.DataBlockReader;
import edu.caltech.sbw.DataBlockWriter;
import edu.caltech.sbw.Module;
import edu.caltech.sbw.ModuleDescriptor;
import edu.caltech.sbw.SBW;
import edu.caltech.sbw.SBWCommunicationException;
import edu.caltech.sbw.SBWException;
import edu.caltech.sbw.SBWLog;
import edu.caltech.sbw.SBWLowLevel;
import edu.caltech.sbw.SBWMethodAmbiguousException;
import edu.caltech.sbw.SBWMethodNotFoundException;
import edu.caltech.sbw.SBWModuleNotFoundException;
import edu.caltech.sbw.SBWServiceNotFoundException;
import edu.caltech.sbw.SBWSignatureSyntaxException;
import edu.caltech.sbw.SBWUnsupportedObjectTypeException;
import edu.caltech.sbw.ServiceDescriptor;
import edu.caltech.sbw.ServiceInvocationHandler;
import edu.caltech.sbw.ServiceMethod;
import edu.caltech.sbw.Signature;
import edu.caltech.sbw.SignatureElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

public class Service {
    private Object serviceObj;
    private int serviceId;
    private int moduleId;
    private static SBWLowLevel rpc = SBW.getLowLevelAPI();

    public boolean equals(Object object) {
        return object instanceof Service && ((Service)object).moduleId == this.moduleId && ((Service)object).serviceId == this.serviceId;
    }

    public ServiceDescriptor getDescriptor() throws SBWCommunicationException, SBWModuleNotFoundException, SBWServiceNotFoundException, SBWException {
        Module module = new Module(this.moduleId);
        String[] stringArray = SBW.getServiceNamesFromModule(this.moduleId);
        String string = stringArray[this.serviceId];
        BrokerInterface brokerInterface = SBW.getBrokerService();
        List list = brokerInterface.getServiceDescriptor(this.moduleId, string);
        String string2 = (String)list.get(0);
        List list2 = brokerInterface.getModuleDescriptor(string2, true);
        return new ServiceDescriptor((String)list.get(1), (String)list.get(2), (String)list.get(3), new ModuleDescriptor(list2), (String)list.get(4));
    }

    public ServiceMethod[] getMethods() throws SBWCommunicationException {
        String[] stringArray = SBW.getSignatureStringsFromModule(this.moduleId, this.serviceId);
        ServiceMethod[] serviceMethodArray = new ServiceMethod[stringArray.length];
        for (int i = 0; i < serviceMethodArray.length; ++i) {
            DataBlockWriter dataBlockWriter = new DataBlockWriter();
            try {
                dataBlockWriter.add(this.serviceId);
                dataBlockWriter.add(i);
                DataBlockReader dataBlockReader = rpc.call(this.moduleId, -1, 4, dataBlockWriter);
                serviceMethodArray[i] = new ServiceMethod(stringArray[i], dataBlockReader.getString());
                continue;
            }
            catch (SBWSignatureSyntaxException sBWSignatureSyntaxException) {
                SBWLog.error("Bad signature: " + stringArray[i]);
                break;
            }
            catch (SBWException sBWException) {
                String string = "Unable to get method help for method " + i + " on service id " + this.serviceId + " of module instance id " + this.moduleId;
                SBWLog.trace(string, sBWException);
                throw new SBWCommunicationException(string, sBWException.getDetailedMessage());
            }
            finally {
                dataBlockWriter.release();
            }
        }
        return serviceMethodArray;
    }

    public ServiceMethod getMethod(String string) throws SBWCommunicationException, SBWMethodAmbiguousException, SBWSignatureSyntaxException {
        int n;
        Signature signature;
        boolean bl = false;
        if ((string = string.trim()).indexOf(40) == -1) {
            signature = new Signature("void " + string + "()");
        } else {
            bl = true;
            try {
                signature = new Signature(string);
            }
            catch (SBWSignatureSyntaxException sBWSignatureSyntaxException) {
                signature = new Signature("void " + string);
            }
        }
        ServiceMethod[] serviceMethodArray = this.getMethods();
        ArrayList<ServiceMethod> arrayList = new ArrayList<ServiceMethod>();
        for (n = 0; n < serviceMethodArray.length; ++n) {
            if (!signature.getName().equals(serviceMethodArray[n].getName())) continue;
            arrayList.add(serviceMethodArray[n]);
        }
        n = arrayList.size();
        if (n < 1) {
            return null;
        }
        if (!bl) {
            if (n == 1) {
                return (ServiceMethod)arrayList.get(0);
            }
            throw new SBWMethodAmbiguousException("More than one method named '" + signature.getName() + "'", "");
        }
        SignatureElement[] signatureElementArray = signature.getArguments();
        block3: for (int i = 0; i < n; ++i) {
            ServiceMethod serviceMethod = (ServiceMethod)arrayList.get(i);
            SignatureElement[] signatureElementArray2 = serviceMethod.getSignature().getArguments();
            if (signatureElementArray.length != signatureElementArray2.length) continue;
            for (int j = 0; j < signatureElementArray2.length; ++j) {
                if (!signatureElementArray[j].equals(signatureElementArray2[j])) continue block3;
            }
            return serviceMethod;
        }
        return null;
    }

    public Module getModule() {
        return new Module(this.moduleId);
    }

    public Object getServiceObject(Class clazz) throws SBWCommunicationException, SBWServiceNotFoundException, SBWMethodNotFoundException, SBWUnsupportedObjectTypeException {
        try {
            return this.getServiceObject(new Class[]{clazz});
        }
        catch (SBWMethodAmbiguousException sBWMethodAmbiguousException) {
            SBWLog.error("Unexpected exception", sBWMethodAmbiguousException);
            return null;
        }
    }

    public Object getServiceObject(Class[] classArray) throws SBWCommunicationException, SBWServiceNotFoundException, SBWMethodAmbiguousException, SBWMethodNotFoundException, SBWUnsupportedObjectTypeException {
        try {
            String[] stringArray = SBW.getSignatureStringsFromModule(this.moduleId, this.serviceId);
            ServiceInvocationHandler serviceInvocationHandler = new ServiceInvocationHandler(this.serviceId, this.moduleId, classArray, stringArray, rpc);
            return Proxy.newProxyInstance(classArray[0].getClassLoader(), classArray, (InvocationHandler)serviceInvocationHandler);
        }
        catch (SBWSignatureSyntaxException sBWSignatureSyntaxException) {
            SBWLog.error("Unexpected exception", sBWSignatureSyntaxException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SBWLog.error("Unexpected exception", illegalArgumentException);
        }
        catch (NullPointerException nullPointerException) {
            String string = "Interface is null";
            SBWLog.exception(string, nullPointerException);
            throw new SBWServiceNotFoundException(string, nullPointerException.getMessage());
        }
        return null;
    }

    Service(int n, int n2) {
        this.moduleId = n;
        this.serviceId = n2;
    }

    static {
        Config.recordClassVersion(Service.class, "$Id: Service.java,v 1.3 2007/07/24 23:08:23 fbergmann Exp $");
    }
}

