/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.Config;
import edu.caltech.sbw.DataBlockReader;
import edu.caltech.sbw.DataBlockWriter;
import edu.caltech.sbw.DoNothingReceiver;
import edu.caltech.sbw.DynamicByteArray;
import edu.caltech.sbw.Module;
import edu.caltech.sbw.ObjectOrientedReceiver;
import edu.caltech.sbw.RPCInCall;
import edu.caltech.sbw.RPCOutCall;
import edu.caltech.sbw.Receiver;
import edu.caltech.sbw.SBWBrokerStartException;
import edu.caltech.sbw.SBWCommunicationException;
import edu.caltech.sbw.SBWException;
import edu.caltech.sbw.SBWListener;
import edu.caltech.sbw.SBWLog;
import edu.caltech.sbw.SBWMethodNotFoundException;
import edu.caltech.sbw.SBWServiceNotFoundException;
import edu.caltech.sbw.SBWTypeMismatchException;
import java.io.IOException;
import java.util.ArrayList;

abstract class SBWRPC {
    private static ArrayList inCalls = new ArrayList(10);
    private static ArrayList outCalls = new ArrayList(10);
    private static Receiver receiver = new DoNothingReceiver();
    private static ArrayList listeners = new ArrayList();

    SBWRPC() {
    }

    public abstract void connect(String var1) throws SBWCommunicationException, SBWBrokerStartException;

    public abstract void connect(String var1, String var2) throws SBWCommunicationException, SBWBrokerStartException;

    public abstract boolean isConnected();

    public abstract void disconnect();

    public abstract int getModuleId();

    public abstract void transmitExternalOnly(int var1, byte[] var2, int var3) throws SBWCommunicationException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBlockReader call(int n, int n2, int n3, DataBlockWriter dataBlockWriter) throws SBWException {
        int n4 = -1;
        try {
            RPCOutCall rPCOutCall = new RPCOutCall();
            Object object = outCalls;
            synchronized (object) {
                int n5;
                for (n5 = 0; outCalls.size() != n5 && outCalls.get(n5) != null; ++n5) {
                }
                if (outCalls.size() == n5) {
                    outCalls.add(n5, rPCOutCall);
                } else {
                    outCalls.set(n5, rPCOutCall);
                }
                n4 = n5;
            }
            this.doTransmit(n, dataBlockWriter.createCall(n, this.getModuleId(), n4, n2, n3));
            SBWLog.trace("Call sent; waiting for reply from module " + n);
            object = rPCOutCall.waitForReply(n);
            return object;
        }
        catch (Throwable throwable) {
            SBWLog.trace("Propagating exception received in reply");
            throw SBWException.translateException(throwable);
        }
        finally {
            if (n4 != -1) {
                ArrayList arrayList = outCalls;
                synchronized (arrayList) {
                    outCalls.set(n4, null);
                }
            }
        }
    }

    public void send(int n, int n2, int n3, DataBlockWriter dataBlockWriter) throws SBWCommunicationException {
        try {
            this.doTransmit(n, dataBlockWriter.createSend(n, this.getModuleId(), n2, n3));
        }
        catch (SBWCommunicationException sBWCommunicationException) {
            SBWLog.trace("Send to " + n + " failed");
            throw sBWCommunicationException;
        }
        SBWLog.trace("Message sent to module " + n);
    }

    public void registerReceiver(Receiver receiver) {
        SBWRPC.receiver = receiver;
        if (receiver instanceof ObjectOrientedReceiver) {
            ((ObjectOrientedReceiver)receiver).setModuleId(this.getModuleId());
        }
    }

    public void receive(DataBlockReader dataBlockReader) {
        try {
            byte by = dataBlockReader.unpackByteWithoutType();
            switch (by) {
                case 1: {
                    SBWLog.trace("Module " + this.getModuleId() + " receiving 'send' msg");
                    this.receiveCall(dataBlockReader, false);
                    break;
                }
                case 2: {
                    SBWLog.trace("Module " + this.getModuleId() + " receiving 'call' msg");
                    this.receiveCall(dataBlockReader, true);
                    break;
                }
                case 0: {
                    SBWLog.trace("Module " + this.getModuleId() + " receiving 'reply' msg");
                    this.receiveReply(dataBlockReader, false);
                    break;
                }
                case 3: {
                    SBWLog.trace("Module " + this.getModuleId() + " receiving 'exception' msg");
                    this.receiveReply(dataBlockReader, true);
                    break;
                }
                default: {
                    SBWLog.error("Module " + this.getModuleId() + " received corrupted msg: expected type in range " + 1 + "-" + 3 + ", but got " + by + " instead.");
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            SBWLog.exception("While extracting message 'type' byte", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveCall(DataBlockReader dataBlockReader, boolean bl) {
        try {
            RPCInCall rPCInCall;
            ArrayList arrayList = inCalls;
            synchronized (arrayList) {
                int n;
                for (n = 0; inCalls.size() != n && ((RPCInCall)inCalls.get(n)).isActive(); ++n) {
                }
                if (inCalls.size() == n) {
                    rPCInCall = new RPCInCall(this, receiver);
                    inCalls.add(n, rPCInCall);
                } else {
                    rPCInCall = (RPCInCall)inCalls.get(n);
                    SBWLog.trace("Reusing thread " + rPCInCall.getName() + " to handle call");
                }
            }
            rPCInCall.execute(dataBlockReader, bl);
        }
        catch (Throwable throwable) {
            SBWLog.exception("Finding thread to execute incoming message", throwable);
        }
    }

    private void receiveReply(DataBlockReader dataBlockReader, boolean bl) {
        try {
            int n = dataBlockReader.unpackIntegerWithoutType();
            ((RPCOutCall)outCalls.get(n)).processReply(dataBlockReader, bl);
        }
        catch (Throwable throwable) {
            SBWLog.exception("While extracting message id", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void transmit(int n, DynamicByteArray dynamicByteArray) throws SBWCommunicationException, IOException {
        if (n == this.getModuleId()) {
            SBWLog.trace("Module " + this.getModuleId() + " transmitting to self");
            DataBlockReader dataBlockReader = new DataBlockReader(dynamicByteArray);
            dataBlockReader.unpackIntegerWithoutType();
            dataBlockReader.unpackIntegerWithoutType();
            this.receive(dataBlockReader);
        } else {
            try {
                byte[] byArray = dynamicByteArray.getData();
                int n2 = dynamicByteArray.getLength();
                SBWLog.trace("Transmitting message (length = " + n2 + ") to module " + n);
                this.transmitExternalOnly(n, byArray, n2);
            }
            finally {
                dynamicByteArray.release();
            }
        }
    }

    private final void doTransmit(int n, DynamicByteArray dynamicByteArray) throws SBWCommunicationException {
        try {
            this.transmit(n, dynamicByteArray);
        }
        catch (IOException iOException) {
            SBWLog.warning("Transmit to module " + n + " failed");
            throw new SBWCommunicationException("Lost connection; unable to call module " + n, "An underlying communications error has occurred and the SBW connection has been lost.  The call to module " + n + " has failed");
        }
    }

    public int getServiceId(int n, String string) throws SBWException {
        string = string.trim();
        DataBlockWriter dataBlockWriter = new DataBlockWriter();
        try {
            int n2;
            DataBlockReader dataBlockReader = this.call(n, -1, 0, dataBlockWriter);
            String[] stringArray = dataBlockReader.get1DStringArray();
            for (n2 = 0; n2 != stringArray.length && !stringArray[n2].equals(string); ++n2) {
            }
            if (n2 == stringArray.length) {
                SBWLog.notice("Service " + string + " not found on module " + n);
                throw new SBWServiceNotFoundException("Service " + string + " not found on module " + n, "");
            }
            int n3 = n2;
            return n3;
        }
        catch (SBWException sBWException) {
            SBWLog.exception("Getting service id from broker", sBWException);
            throw sBWException;
        }
        finally {
            dataBlockWriter.release();
        }
    }

    public int getMethodId(int n, int n2, String string) throws SBWException {
        DataBlockWriter dataBlockWriter = new DataBlockWriter();
        try {
            int n3;
            dataBlockWriter.add(n2);
            DataBlockReader dataBlockReader = this.call(n, -1, 1, dataBlockWriter);
            String[] stringArray = dataBlockReader.get1DStringArray();
            for (n3 = 0; n3 != stringArray.length && !stringArray[n3].equals(string); ++n3) {
            }
            if (n3 == stringArray.length) {
                SBWLog.notice("Method '" + string + "' not found on module " + n);
                throw new SBWMethodNotFoundException("method " + string + " not found on module " + n, "");
            }
            int n4 = n3;
            return n4;
        }
        catch (SBWException sBWException) {
            SBWLog.exception("Getting method id from broker", sBWException);
            throw sBWException;
        }
        finally {
            dataBlockWriter.release();
        }
    }

    public void addListener(SBWListener sBWListener) {
        listeners.add(sBWListener);
    }

    public void removeListener(SBWListener sBWListener) {
        listeners.remove(sBWListener);
    }

    void onOtherModuleInstanceStartup(DataBlockReader dataBlockReader, int n) {
        try {
            int n2 = dataBlockReader.getInt();
            SBWLog.trace("Notified by " + n + " of module " + n2 + "'s startup");
            for (SBWListener sBWListener : listeners) {
                sBWListener.onModuleStart(new Module(n2));
            }
        }
        catch (SBWTypeMismatchException sBWTypeMismatchException) {
            SBWLog.error("Received badly formatted startup notification", sBWTypeMismatchException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onOtherModuleInstanceShutdown(DataBlockReader dataBlockReader, int n) {
        try {
            int n2 = dataBlockReader.getInt();
            SBWLog.trace("Notified by " + n + " of module " + n2 + "'s shutdown");
            for (SBWListener sBWListener : listeners) {
                sBWListener.onModuleShutdown(new Module(n2));
            }
            ArrayList arrayList = outCalls;
            synchronized (arrayList) {
                for (int i = 0; outCalls.size() != i; ++i) {
                    RPCOutCall rPCOutCall = (RPCOutCall)outCalls.get(i);
                    if (rPCOutCall == null) continue;
                    rPCOutCall.onOtherModuleInstanceShutdown(n2);
                }
            }
        }
        catch (SBWTypeMismatchException sBWTypeMismatchException) {
            SBWLog.error("Received badly formatted shutdown notification", sBWTypeMismatchException);
        }
    }

    void onRegistrationChange(DataBlockReader dataBlockReader, int n) {
        SBWLog.trace("Notified by " + n + " of registration changes");
        for (SBWListener sBWListener : listeners) {
            sBWListener.onRegistrationChange();
        }
    }

    void onShutdown(DataBlockReader dataBlockReader, int n) {
        SBWLog.trace("Shutdown invoked by module " + n + "; exiting.");
        try {
            this.disconnect();
        }
        catch (Exception exception) {
            SBWLog.trace("Unable to disconnect properly during shutdown", exception);
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupPendingCalls() {
        Object object;
        int n;
        SBWLog.trace("Stopping all incoming and outgoing message threads");
        ArrayList arrayList = inCalls;
        synchronized (arrayList) {
            for (n = 0; inCalls.size() != n; ++n) {
                object = (RPCInCall)inCalls.get(n);
                if (object != null) {
                    ((RPCInCall)object).pleaseStop();
                }
                inCalls.set(n, null);
            }
        }
        arrayList = outCalls;
        synchronized (arrayList) {
            for (n = 0; outCalls.size() != n; ++n) {
                object = (RPCOutCall)outCalls.get(n);
                if (object == null) continue;
                ((RPCOutCall)object).onBrokerDisconnection();
            }
        }
    }

    static {
        Config.recordClassVersion(SBWRPC.class, "$Id: SBWRPC.java,v 1.3 2007/07/24 23:08:23 fbergmann Exp $");
    }
}

