/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.Config;
import edu.caltech.sbw.DataBlockReader;
import edu.caltech.sbw.DataBlockWriter;
import edu.caltech.sbw.DynamicByteArray;
import edu.caltech.sbw.RuntimeProperties;
import edu.caltech.sbw.SBWBrokerStartException;
import edu.caltech.sbw.SBWCommunicationException;
import edu.caltech.sbw.SBWLog;
import edu.caltech.sbw.SBWLowLevelInternal;
import edu.caltech.sbw.SBWRPC;
import edu.caltech.sbw.SessionKey;
import edu.caltech.sbw.StringUtil;
import edu.caltech.sbw.Sys;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;

class SBWModuleRPC
extends SBWRPC
implements SBWLowLevelInternal {
    private static Socket socket;
    private static int moduleId;
    private static String moduleName;
    private static boolean connected;
    private static OutputStream outStream;
    private static InputStream inStream;
    private static Thread receiverThread;
    private static boolean waitingForInCall;
    private static String sessionKey;
    private static final int SOCKET_BUFFER_SIZE = 65536;

    SBWModuleRPC() {
    }

    public final int getModuleId() {
        return moduleId;
    }

    public final int getThisModule() {
        return moduleId;
    }

    public void connect(String string) throws SBWCommunicationException, SBWBrokerStartException {
        if (Sys.OSIsMac() || Sys.OSIsUnix()) {
            System.setProperty("java.net.preferIPv4Stack", "true");
            System.setProperty("sbw.broker.allow-remote-modules", "true");
        }
        this.connect(string, "localhost");
    }

    public synchronized void connect(String string, String string2) throws SBWCommunicationException, SBWBrokerStartException {
        if (connected) {
            SBWLog.trace("Tried to connect, but already connected.");
            return;
        }
        if (StringUtil.empty(string2)) {
            string2 = "localhost";
        }
        try {
            moduleName = string;
            connected = this.connectToBroker(string2, true);
            ModuleRPCShutdownHook moduleRPCShutdownHook = new ModuleRPCShutdownHook();
            moduleRPCShutdownHook.setDaemon(true);
            moduleRPCShutdownHook.setName("receiver-thread-shutdown-hook");
            Runtime.getRuntime().addShutdownHook(moduleRPCShutdownHook);
            if (connected) {
                receiverThread = new Thread(new Runnable(){

                    public void run() {
                        SBWModuleRPC.this.runReceiverThread();
                    }
                });
                receiverThread.setName("receiver-thread");
                receiverThread.start();
            }
        }
        catch (SBWCommunicationException sBWCommunicationException) {
            throw sBWCommunicationException;
        }
        catch (Exception exception) {
            throw new SBWCommunicationException("Unable to connect to broker: " + exception.getMessage(), "The SBW client library was unable to connect to the SBW Broker, either because of a problem with communications or because it could not start the Broker.");
        }
    }

    public synchronized boolean isConnected() {
        return connected;
    }

    public synchronized void disconnect() {
        if (!connected) {
            SBWLog.warning("Attempted to disconnect, but we're not connected");
            return;
        }
        SBWLog.trace("Disconnecting from broker");
        try {
            this.transmit(-1, DataBlockWriter.createDisconnectMessage());
        }
        catch (IOException iOException) {
            SBWLog.trace("Cannot notify broker -- already disconnected?", iOException);
        }
        catch (SBWCommunicationException sBWCommunicationException) {
            SBWLog.trace("Cannot notify broker -- communication error", sBWCommunicationException);
        }
        this.disconnectSockets(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmitExternalOnly(int n, byte[] byArray, int n2) throws SBWCommunicationException, IOException {
        if (!connected) {
            SBWLog.error("Attempted to transmit when not connected");
            throw new SBWCommunicationException("Attempted to transmit when not connected", "");
        }
        OutputStream outputStream = outStream;
        synchronized (outputStream) {
            try {
                outStream.write(byArray, 0, n2);
                outStream.flush();
            }
            catch (IOException iOException) {
                SBWLog.trace("Lost connection to SBW -- closing receiver");
                connected = false;
                this.disconnectSockets(false);
                throw iOException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean connectToBroker(String string, boolean bl) throws IOException, SBWCommunicationException, SBWBrokerStartException {
        block10: {
            block11: {
                SBWLog.trace("Attempting to connect to Broker");
                RuntimeProperties runtimeProperties = RuntimeProperties.getRuntimeProperties();
                runtimeProperties.reload();
                boolean bl2 = runtimeProperties.hasValue("sbw.module.port");
                if (!bl2) break block10;
                Integer n = runtimeProperties.getPropertyAsInteger("sbw.module.port");
                if (n == null) break block11;
                SBWLog.trace("Found sbw.module.port in SBW properties file");
                int n2 = n;
                SessionKey.loadKey();
                if (StringUtil.empty(SessionKey.getKey())) {
                    SBWLog.trace("No session key found");
                    break block10;
                } else {
                    boolean bl3 = false;
                    try {
                        bl3 = this.connectSocketToBroker(string, n2);
                    }
                    catch (Exception exception) {
                        SBWLog.trace("could not connect to SBW", exception);
                        bl3 = false;
                    }
                    if (!bl3 && string == "localhost") {
                        try {
                            bl3 = this.connectSocketToBroker("127.0.0.1", n2);
                        }
                        catch (Exception exception) {
                            SBWLog.trace("could not connect to SBW", exception);
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        return true;
                    }
                    SBWLog.warning("Can't connect to broker on sbw.module.port");
                    socket = null;
                    if (bl) {
                        return this.startBrokerAndConnect(string);
                    }
                    throw new SBWCommunicationException("Unable to connect to Broker", "The SBW client library failed to connect to the SBW Broker at port " + n2 + " on host '" + string + "', using the port indicated in the" + " the SBW properties file at '" + RuntimeProperties.propertiesFile.getPath() + "'.  Either there is another Broker or process" + " now using the port, or else another error" + " occurred during communications.  Check if" + " an old Broker process is running and shut" + " it down, then try this client again.");
                }
            }
            SBWLog.trace("Unparseable sbw.module.port in SBW properties file.");
        }
        if (bl) {
            return this.startBrokerAndConnect(string);
        }
        return false;
    }

    private boolean connectSocketToBroker(String string, int n) throws SocketException, IOException, SBWCommunicationException {
        SBWLog.trace("Attempting to connect socket to " + string + ":" + n);
        if (socket == null) {
            try {
                if (string == "localhost") {
                    socket = new Socket(Sys.getHostAddress(), n);
                    socket.setReuseAddress(true);
                } else {
                    socket = new Socket(string, n);
                    socket.setReuseAddress(true);
                }
                socket.setReceiveBufferSize(65536);
                socket.setSendBufferSize(65536);
                return this.connectMessageStreams();
            }
            catch (ConnectException connectException) {
                socket = null;
                SBWLog.trace("couldn't connect to: " + string + ":" + n);
                return false;
            }
        }
        return socket != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectMessageStreams() throws IOException, SBWCommunicationException {
        if (socket != null) {
            if (!StringUtil.empty(moduleName)) {
                SBWLog.trace("Attempting to connect as '" + moduleName + "'");
            } else {
                SBWLog.trace("Attempting to connect anonymously");
            }
            inStream = socket.getInputStream();
            outStream = socket.getOutputStream();
            DynamicByteArray dynamicByteArray = DataBlockWriter.createConnectMessage(SessionKey.getKey(), moduleName);
            try {
                outStream.write(dynamicByteArray.getData(), 0, dynamicByteArray.getLength());
                outStream.flush();
            }
            finally {
                dynamicByteArray.release();
            }
            try {
                moduleId = DataBlockReader.readInteger(inStream);
                SBWLog.trace("Successfully shook hands with Broker");
                return true;
            }
            catch (IOException iOException) {
                throw new SBWCommunicationException("Broker denied connection, or lost contact with Broker", "The initial connection to the SBW Broker failed.  This can happen if the client failed the security check (as may happen if the Broker is running under another user's login); it can also happen if an unexpected communication or network failure occurs.");
            }
        }
        return false;
    }

    private void runReceiverThread() {
        SBWLog.trace("Receiver thread started");
        while (connected) {
            try {
                waitingForInCall = true;
                int n = DataBlockReader.readInteger(inStream);
                waitingForInCall = false;
                int n2 = DataBlockReader.readInteger(inStream);
                byte[] byArray = DataBlockReader.read(inStream, n - 8);
                if (n2 == moduleId) {
                    this.receive(new DataBlockReader(byArray));
                    continue;
                }
                SBWLog.error("Module " + moduleId + " received message" + " destined for module " + n2);
            }
            catch (SBWCommunicationException sBWCommunicationException) {
                if (!connected) {
                    return;
                }
                this.disconnectSockets(false);
            }
            catch (SocketException socketException) {
                if (!connected) {
                    return;
                }
                this.disconnectSockets(false);
            }
            catch (Throwable throwable) {
                SBWLog.exception("Unexpected exception in receiver thread", throwable);
            }
        }
    }

    private synchronized void disconnectSockets(boolean bl) {
        SBWLog.trace("Closing client-side socket connection");
        connected = false;
        try {
            block8: {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException iOException) {
                    if (!bl) break block8;
                    SBWLog.exception("Problem closing socket", iOException);
                }
            }
            this.cleanupPendingCalls();
            try {
                receiverThread.join(500L);
            }
            catch (InterruptedException interruptedException) {
                if (bl) {
                    SBWLog.exception("Interrupted while stopping receiver thread", interruptedException);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        socket = null;
    }

    private boolean startBrokerAndConnect(String string) throws SBWCommunicationException, SBWBrokerStartException {
        Object object;
        Object object2;
        String string2;
        SBWLog.notice("Broker doesn't appear to be running; will try starting it");
        File file = Config.getBrokerStartupScript();
        if (file != null) {
            SBWLog.trace("A Broker startup script appears to exist at " + file.getPath());
            string2 = Sys.getCommandShell();
            if (Sys.OSIsWindows()) {
                try {
                    object2 = new FileInputStream(file);
                    object = new BufferedReader(new InputStreamReader((InputStream)object2));
                    string2 = ((BufferedReader)object).readLine();
                }
                catch (Exception exception) {
                    string2 = string2 + " /c \"";
                    string2 = string2 + file.getPath();
                    string2 = string2 + "\"";
                }
            } else {
                string2 = string2 + " ";
                string2 = string2 + file.getPath();
            }
        } else {
            SBWLog.trace("No Broker startup script; will try executable");
            object2 = Config.getBrokerFile();
            if (object2 == null) {
                SBWLog.error("Cannot find Broker file -- cannot start Broker");
                return false;
            }
            string2 = Sys.getJavaExecutable();
            if (Config.getBrokerOptions() != null) {
                string2 = string2 + " " + Config.getBrokerOptions();
            }
            string2 = string2 + " -jar ";
            if (Sys.OSIsWindows()) {
                string2 = string2 + "\"";
            }
            string2 = string2 + ((File)object2).getPath();
            if (Sys.OSIsWindows()) {
                string2 = string2 + "\"";
            }
        }
        try {
            int n;
            SBWLog.trace("Starting Broker with: " + string2);
            object2 = Runtime.getRuntime().exec(string2);
            SBWLog.trace("Will wait for " + n / 10 + " sec");
            boolean bl = false;
            for (n = Config.getBrokerStartupWait(); n > 0; --n) {
                try {
                    bl = this.connectToBroker(string, false);
                    if (bl) {
                        return true;
                    }
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    return bl;
                }
            }
            if (bl || this.connectToBroker(string, false)) {
                SBWLog.trace("Broker started & connection established");
                return true;
            }
            SBWLog.warning("Broker failed to start");
            return false;
        }
        catch (IOException iOException) {
            object = System.getProperty("line.separator");
            throw new SBWBrokerStartException("Unable to start the SBW Broker: " + iOException.getMessage(), "The SBW Broker does not appear to be running, so the SBW client library attempted (but failed) to start a Broker process using the following command line:" + (String)object + (String)object + string2 + (String)object + (String)object + " You will need to correct whatever problem is causing" + " the command to fail.  Please consult the SBW documentation" + " for help.");
        }
    }

    static {
        connected = false;
        waitingForInCall = false;
        Config.recordClassVersion(SBWModuleRPC.class, "$Id: SBWModuleRPC.java,v 1.4 2007/07/24 23:08:23 fbergmann Exp $");
    }

    private class ModuleRPCShutdownHook
    extends Thread {
        private ModuleRPCShutdownHook() {
        }

        public void run() {
            if (connected) {
                try {
                    SBWModuleRPC.this.disconnect();
                }
                catch (Exception exception) {
                    SBWLog.exception("Problem closing module socket", exception);
                }
            }
        }
    }
}

