/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.Config;
import edu.caltech.sbw.SBWException;
import grace.log.Event;
import grace.log.Log;
import grace.log.StackTrace;

class SBWLog
extends Log {
    private static final String lineSep = System.getProperty("line.separator");

    SBWLog() {
    }

    public static final void trace() {
    }

    public static final void trace(String string) {
    }

    public static final void trace(Object object) {
    }

    public static void exception(Throwable throwable) {
        Log log = Log.getInstance();
        if (log.eventTypeEnabled("error")) {
            Event event = new Event("error");
            event.setObject(throwable);
            event.setPosition(new StackTrace(new Exception(throwable.getMessage())));
            String string = throwable.getMessage();
            if (throwable instanceof SBWException) {
                string = string + lineSep + ((SBWException)throwable).getDetailedMessage();
            }
            event.setMessage(string);
            log.distribute(event);
        }
    }

    public static void exception(String string, Throwable throwable) {
        Log log = Log.getInstance();
        if (log.eventTypeEnabled("error")) {
            Event event = new Event("error");
            event.setObject(throwable);
            event.setPosition(new StackTrace(new Exception(throwable.getMessage())));
            String string2 = string + ": " + throwable.getMessage();
            if (throwable instanceof SBWException) {
                string2 = string2 + lineSep + ((SBWException)throwable).getDetailedMessage();
            }
            event.setMessage(string2);
            log.distribute(event);
        }
    }

    public static void error(String string) {
        Log log = Log.getInstance();
        if (log.eventTypeEnabled("error")) {
            Event event = new Event("error");
            event.setMessage(string);
            event.setPosition(new StackTrace(1 + Config.getStackDepthOffset()));
            log.distribute(event);
        }
    }

    public static void error(String string, Object object) {
        Log log = Log.getInstance();
        if (log.eventTypeEnabled("error")) {
            Event event = new Event("error");
            event.setMessage(string);
            event.setObject(object);
            event.setPosition(new StackTrace(1 + Config.getStackDepthOffset()));
            log.distribute(event);
        }
    }

    public static void error(Exception exception) {
        Log log = Log.getInstance();
        if (log.eventTypeEnabled("error")) {
            Event event = new Event("error");
            event.setObject(exception);
            event.setPosition(new StackTrace(1 + Config.getStackDepthOffset()));
            log.distribute(event);
        }
    }

    public static void error(String string, Exception exception) {
        Log log = Log.getInstance();
        if (log.eventTypeEnabled("error")) {
            Event event = new Event("error");
            event.setObject(exception);
            event.setPosition(new StackTrace(1 + Config.getStackDepthOffset()));
            String string2 = string + ": " + exception.getMessage();
            if (exception instanceof SBWException) {
                string2 = string2 + lineSep + ((SBWException)exception).getDetailedMessage();
            }
            event.setMessage(string2);
            log.distribute(event);
        }
    }

    public static void warning(String string) {
        Log log = Log.getInstance();
        if (log.eventTypeEnabled("warning")) {
            Event event = new Event("warning");
            event.setMessage(string);
            event.setPosition(new StackTrace(1 + Config.getStackDepthOffset()));
            log.distribute(event);
        }
    }

    public static void warning(String string, Object object) {
        Log log = Log.getInstance();
        if (log.eventTypeEnabled("warning")) {
            Event event = new Event("warning");
            event.setMessage(string);
            event.setObject(object);
            event.setPosition(new StackTrace(1 + Config.getStackDepthOffset()));
            log.distribute(event);
        }
    }

    public static void warning(String string, Exception exception) {
        Log log = Log.getInstance();
        if (log.eventTypeEnabled("warning")) {
            Event event = new Event("warning");
            event.setObject(exception);
            event.setPosition(new StackTrace(exception));
            String string2 = string + ": " + exception.getMessage();
            if (exception instanceof SBWException) {
                string2 = string2 + lineSep + ((SBWException)exception).getDetailedMessage();
            }
            event.setMessage(string2);
            log.distribute(event);
        }
    }

    public static void notice(String string) {
        Log log = Log.getInstance();
        if (log.eventTypeEnabled("notice")) {
            Event event = new Event("notice");
            event.setMessage(string);
            event.setPosition(new StackTrace(1 + Config.getStackDepthOffset()));
            log.distribute(event);
        }
    }

    public static void notice(String string, Throwable throwable) {
        Log log = Log.getInstance();
        if (log.eventTypeEnabled("notice")) {
            Event event = new Event("notice");
            event.setPosition(new StackTrace(1 + Config.getStackDepthOffset()));
            String string2 = string + ": " + throwable.getMessage();
            if (throwable instanceof SBWException) {
                string2 = string2 + lineSep + ((SBWException)throwable).getDetailedMessage();
            }
            event.setMessage(string2);
            log.distribute(event);
        }
    }

    public static void notice(String string, Object object) {
        Log log = Log.getInstance();
        if (log.eventTypeEnabled("notice")) {
            Event event = new Event("notice");
            event.setMessage(string);
            event.setObject(object);
            event.setPosition(new StackTrace(1 + Config.getStackDepthOffset()));
            log.distribute(event);
        }
    }

    static {
        Config.recordClassVersion(SBWLog.class, "$Id: SBWLog.java,v 1.3 2007/07/24 23:08:19 fbergmann Exp $");
    }
}

