/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.Config;
import edu.caltech.sbw.OptionPaneUtils;
import edu.caltech.sbw.SBWLog;
import edu.caltech.sbw.SBWRawException;
import edu.caltech.sbw.Sys;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

public abstract class SBWException
extends Exception {
    private String detailedMessage = "";

    public void handleWithDialog() {
        if (Sys.OSIsWindows()) {
            JFrame jFrame = new JFrame();
            jFrame.setSize(1, 1);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = jFrame.getSize();
            if (dimension2.height > dimension.height) {
                dimension2.height = dimension.height;
            }
            if (dimension2.width > dimension.width) {
                dimension2.width = dimension.width;
            }
            jFrame.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
            jFrame.setVisible(true);
            jFrame.setState(1);
            jFrame.setState(0);
            this.handleWithDialog(jFrame);
            jFrame.dispose();
        } else {
            this.handleWithDialog(null);
        }
    }

    public void handleWithDialog(Component component) {
        Object[] objectArray;
        Object object;
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            SBWLog.trace("Unable to set look and feel for dialog", throwable);
        }
        if (this.detailedMessage.length() == 0) {
            object = new String[]{"OK"};
            int n = -1;
            objectArray = object;
        } else {
            object = new String[]{"OK", "Details..."};
            boolean bl = false;
            objectArray = object;
        }
        object = this.getMessage();
        if (object == null || ((String)object).length() == 0) {
            object = "SBW Error";
        }
        JOptionPane jOptionPane = OptionPaneUtils.getNarrowOptionPane(80);
        jOptionPane.setMessage(object);
        jOptionPane.setMessageType(0);
        jOptionPane.setOptions(objectArray);
        jOptionPane.setInitialValue(objectArray[0]);
        JDialog jDialog = jOptionPane.createDialog(component, "SBW Exception");
        jDialog.setDefaultCloseOperation(2);
        jDialog.pack();
        jDialog.setLocationRelativeTo(component);
        this.centerDialog(component, jDialog);
        jOptionPane.requestFocus();
        jDialog.show();
        Object object2 = jOptionPane.getValue();
        if (object2 != null && !((String)objectArray[0]).equals(object2)) {
            int n = Math.min(12, this.countLines(this.detailedMessage));
            int n2 = Math.min(80, this.findLongestLine(this.detailedMessage));
            JTextArea jTextArea = new JTextArea(this.detailedMessage, n, n2);
            jTextArea.setFont(new Font("monospaced", 0, 11));
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            JLabel jLabel = new JLabel();
            JTextArea jTextArea2 = new JTextArea((String)object, 2, 80);
            jTextArea2.setFont(new Font("monospaced", jLabel.getFont().getStyle(), jLabel.getFont().getSize()));
            jTextArea2.setLineWrap(true);
            jTextArea2.setWrapStyleWord(true);
            jTextArea2.setEditable(false);
            jTextArea2.setBackground(jLabel.getBackground());
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add(jTextArea);
            Object[] objectArray2 = new Object[]{"", jTextArea2, "Error Details:", jScrollPane};
            JOptionPane.showMessageDialog(component, objectArray2, "SBW Exception", 1);
        }
    }

    private void centerDialog(Component component, JDialog jDialog) {
        if (component == null) {
            Dimension dimension = jDialog.getToolkit().getScreenSize();
            Rectangle rectangle = jDialog.getBounds();
            jDialog.setLocation((dimension.width - rectangle.width) / 2, (dimension.height - rectangle.height) / 2);
        } else {
            Container container = jDialog.getParent();
            Point point = container.getLocationOnScreen();
            Dimension dimension = container.getSize();
            Dimension dimension2 = jDialog.getSize();
            int n = dimension.width > dimension2.width ? (dimension.width - dimension2.width) / 2 + point.x : point.x;
            int n2 = dimension.height > dimension2.height ? (dimension.height - dimension2.height) / 2 + point.y : point.y;
            jDialog.setLocation(n, n2);
        }
    }

    private int countLines(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n;
        }
        return n;
    }

    private int findLongestLine(String string) {
        int n = 0;
        int n2 = 1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\n') {
                n = Math.max(n, n2);
                n2 = 1;
                continue;
            }
            ++n2;
        }
        return n;
    }

    protected SBWException(String string) {
        super(string);
        this.appendStackTrace();
    }

    protected SBWException(String string, String string2) {
        super(string);
        SBWLog.trace("Creating new exception with message = '" + string + "'");
        SBWLog.trace("detailedMessage = '" + string2 + "'");
        this.detailedMessage = string2;
        this.appendStackTrace();
    }

    private void appendStackTrace() {
        Exception exception = new Exception();
        exception.fillInStackTrace();
        this.detailedMessage = this.detailedMessage + "\ncontext:\n" + SBWException.extractStackTrace(exception);
    }

    protected static String extractStackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        return byteArrayOutputStream.toString();
    }

    public static SBWException translateException(Throwable throwable) {
        if (throwable instanceof SBWException) {
            return (SBWException)throwable;
        }
        return new SBWRawException(throwable);
    }

    public String getDetailedMessage() {
        return this.detailedMessage;
    }

    public abstract byte getCode();

    static {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        Keymap keymap = JTextComponent.getKeymap("default");
        keymap.removeKeyStrokeBinding(keyStroke);
        Config.recordClassVersion(SBWException.class, "$Id: SBWException.java,v 1.3 2007/07/24 23:08:19 fbergmann Exp $");
    }
}

