/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.BrokerInterface;
import edu.caltech.sbw.Config;
import edu.caltech.sbw.DataBlockReader;
import edu.caltech.sbw.DataBlockWriter;
import edu.caltech.sbw.Module;
import edu.caltech.sbw.ModuleDescriptor;
import edu.caltech.sbw.SBWBrokerStartException;
import edu.caltech.sbw.SBWCommunicationException;
import edu.caltech.sbw.SBWException;
import edu.caltech.sbw.SBWIncorrectCategorySyntaxException;
import edu.caltech.sbw.SBWListener;
import edu.caltech.sbw.SBWLog;
import edu.caltech.sbw.SBWLowLevel;
import edu.caltech.sbw.SBWLowLevelInternal;
import edu.caltech.sbw.SBWMethodNotFoundException;
import edu.caltech.sbw.SBWModuleNotFoundException;
import edu.caltech.sbw.SBWModuleRPC;
import edu.caltech.sbw.SBWModuleStartException;
import edu.caltech.sbw.SBWServiceNotFoundException;
import edu.caltech.sbw.SBWUnsupportedObjectTypeException;
import edu.caltech.sbw.Service;
import edu.caltech.sbw.ServiceDescriptor;
import edu.caltech.sbw.StringUtil;
import edu.caltech.sbw.Sys;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SBW {
    private static SBWLowLevelInternal rpc = new SBWModuleRPC();
    private static BrokerInterface broker;

    private SBW() {
    }

    public static void connect() throws SBWCommunicationException, SBWBrokerStartException {
        if (Sys.OSIsMac() || Sys.OSIsUnix()) {
            System.setProperty("java.net.preferIPv4Stack", "true");
            System.setProperty("sbw.broker.allow-remote-modules", "true");
        }
        if (rpc.isConnected()) {
            throw new SBWCommunicationException("Already connected to SBW", "A call to connect to the SBW Broker has been attempted, but this client is already connected.");
        }
        rpc.connect("", "localhost");
        broker = null;
        SBW.getBrokerService();
    }

    public static void connect(String string) throws SBWCommunicationException, SBWBrokerStartException {
        if (rpc.isConnected()) {
            throw new SBWCommunicationException("Already connected to SBW", "A call to connect to the SBW Broker has been attempted, but this client is already connected.");
        }
        rpc.connect("", string);
        broker = null;
        SBW.getBrokerService();
    }

    public static void link(String string) throws SBWBrokerStartException, SBWCommunicationException {
        SBW.checkConnected();
        try {
            broker.linkBroker(string);
        }
        catch (SBWBrokerStartException sBWBrokerStartException) {
            throw sBWBrokerStartException;
        }
        catch (SBWCommunicationException sBWCommunicationException) {
            throw sBWCommunicationException;
        }
        catch (SBWException sBWException) {
            String string2 = "Problem linking to Broker on remote host '" + string + "'";
            SBWLog.trace(string2, sBWException);
            throw new SBWCommunicationException(sBWException.getMessage(), sBWException.getDetailedMessage());
        }
    }

    public static void disconnect() {
        try {
            rpc.disconnect();
        }
        catch (Exception exception) {
            SBWLog.trace("Unable to disconnect properly", exception);
        }
    }

    public static Module getModuleInstance(String string) throws SBWCommunicationException, SBWModuleStartException, SBWModuleNotFoundException {
        if (StringUtil.empty(string)) {
            throw new SBWModuleNotFoundException("Null module name", "'Null' is not a valid module name.");
        }
        SBW.checkConnected();
        string = string.trim();
        try {
            SBWLog.trace("Asking for an instance of module " + string);
            return new Module(broker.getModuleInstance(string));
        }
        catch (SBWModuleNotFoundException sBWModuleNotFoundException) {
            String string2 = "Module '" + string + "' is not known to SBW";
            SBWLog.trace(string2, sBWModuleNotFoundException);
            throw sBWModuleNotFoundException;
        }
        catch (SBWModuleStartException sBWModuleStartException) {
            String string3 = "Unable to start module '" + string + "'";
            SBWLog.trace(string3, sBWModuleStartException);
            throw sBWModuleStartException;
        }
        catch (SBWException sBWException) {
            String string4 = "Problem getting module instance";
            SBWLog.trace(string4, sBWException);
            throw new SBWModuleStartException(string4, sBWException.getDetailedMessage());
        }
    }

    public static Module[] getExistingModuleInstances() throws SBWCommunicationException {
        SBW.checkConnected();
        try {
            int[] nArray = broker.getExistingModuleInstanceIds();
            Module[] moduleArray = new Module[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                moduleArray[i] = new Module(nArray[i]);
            }
            return moduleArray;
        }
        catch (SBWException sBWException) {
            String string = "Problem getting module list from Broker";
            SBWLog.trace(string, sBWException);
            throw new SBWCommunicationException(sBWException.getMessage(), sBWException.getDetailedMessage());
        }
    }

    public static Module[] getExistingModuleInstances(String string) throws SBWCommunicationException {
        SBW.checkConnected();
        string = string.trim();
        try {
            int[] nArray = broker.getExistingModuleInstanceIds();
            ArrayList<Module> arrayList = new ArrayList<Module>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                try {
                    List list = broker.getModuleDescriptor(nArray[i]);
                    String string2 = (String)list.get(0);
                    if (!string2.equals(string)) continue;
                    arrayList.add(new Module(nArray[i]));
                    continue;
                }
                catch (SBWModuleNotFoundException sBWModuleNotFoundException) {
                    // empty catch block
                }
            }
            return arrayList.toArray(new Module[0]);
        }
        catch (SBWException sBWException) {
            String string3 = "Problem getting module list from Broker";
            SBWLog.trace(string3, sBWException);
            throw new SBWCommunicationException(sBWException.getMessage(), sBWException.getDetailedMessage());
        }
    }

    public static ModuleDescriptor[] getModuleDescriptors(boolean bl) throws SBWCommunicationException {
        return SBW.getModuleDescriptors(bl, true);
    }

    public static ModuleDescriptor[] getModuleDescriptors(boolean bl, boolean bl2) throws SBWCommunicationException {
        SBW.checkConnected();
        try {
            List[] listArray = broker.getModuleDescriptors(bl2, bl);
            ModuleDescriptor[] moduleDescriptorArray = new ModuleDescriptor[listArray.length];
            for (int i = 0; i < listArray.length; ++i) {
                moduleDescriptorArray[i] = new ModuleDescriptor(listArray[i]);
            }
            return moduleDescriptorArray;
        }
        catch (SBWException sBWException) {
            String string = "Problem getting module descriptors from Broker";
            SBWLog.trace(string, sBWException);
            throw new SBWCommunicationException(sBWException.getMessage(), sBWException.getDetailedMessage());
        }
    }

    public static ModuleDescriptor getModuleDescriptor(String string) throws SBWModuleNotFoundException, SBWBrokerStartException, SBWCommunicationException {
        SBW.checkConnected();
        try {
            List list = broker.getModuleDescriptor(string, false);
            if (list != null) {
                return new ModuleDescriptor(list);
            }
        }
        catch (SBWModuleNotFoundException sBWModuleNotFoundException) {
            throw sBWModuleNotFoundException;
        }
        catch (SBWBrokerStartException sBWBrokerStartException) {
            throw sBWBrokerStartException;
        }
        catch (SBWException sBWException) {
            String string2 = "Problem getting module descriptors from Broker";
            SBWLog.trace(string2, sBWException);
            throw new SBWCommunicationException(sBWException.getMessage(), sBWException.getDetailedMessage());
        }
        throw new SBWModuleNotFoundException("Cannot find module named '" + string + "'", "The SBW Broker does not have any information about a module named '" + string + "'");
    }

    public static ServiceDescriptor[] findServices(String string, boolean bl) throws SBWCommunicationException, SBWIncorrectCategorySyntaxException {
        SBW.checkConnected();
        string = string.trim();
        try {
            List[] listArray = broker.findServices(string, bl);
            ServiceDescriptor[] serviceDescriptorArray = new ServiceDescriptor[listArray.length];
            ModuleDescriptor[] moduleDescriptorArray = SBW.getModuleDescriptors(true, true);
            for (int i = 0; i < listArray.length; ++i) {
                String string2 = (String)listArray[i].get(0);
                ModuleDescriptor moduleDescriptor = null;
                for (int j = 0; j < moduleDescriptorArray.length; ++j) {
                    if (!moduleDescriptorArray[j].getName().equals(string2)) continue;
                    moduleDescriptor = moduleDescriptorArray[j];
                }
                serviceDescriptorArray[i] = new ServiceDescriptor((String)listArray[i].get(1), (String)listArray[i].get(2), (String)listArray[i].get(3), moduleDescriptor, (String)listArray[i].get(4));
            }
            return serviceDescriptorArray;
        }
        catch (SBWException sBWException) {
            String string3 = "Problem finding services for category " + string;
            SBWLog.trace(string3, sBWException);
            throw new SBWCommunicationException(sBWException.getMessage(), sBWException.getDetailedMessage());
        }
    }

    public static String[] getServiceCategories(String string) throws SBWCommunicationException, SBWIncorrectCategorySyntaxException {
        SBW.checkConnected();
        string = string.trim();
        try {
            return broker.getServiceCategories(string);
        }
        catch (SBWException sBWException) {
            String string2 = "Problem getting service categories from Broker";
            SBWLog.trace(string2, sBWException);
            throw new SBWCommunicationException(sBWException.getMessage(), sBWException.getDetailedMessage());
        }
    }

    public static String getVersion() {
        return Config.getAPIVersion();
    }

    public static String getBrokerVersion() throws SBWCommunicationException {
        try {
            return broker.getVersion();
        }
        catch (SBWException sBWException) {
            String string = "Problem getting version from Broker";
            SBWLog.trace(string, sBWException);
            throw new SBWCommunicationException(sBWException.getMessage(), sBWException.getDetailedMessage());
        }
    }

    public static File getSBWHome() {
        return Config.getSBWHome();
    }

    public static void addListener(SBWListener sBWListener) {
        rpc.addListener(sBWListener);
    }

    public static void removeListener(SBWListener sBWListener) {
        rpc.removeListener(sBWListener);
    }

    public static Module getThisModule() {
        return new Module(rpc.getModuleId());
    }

    public static SBWLowLevel getLowLevelAPI() {
        return rpc;
    }

    static final BrokerInterface getBrokerService() throws SBWCommunicationException {
        if (broker != null) {
            return broker;
        }
        SBWLog.trace("Obtaining instance of Broker interface.");
        Module module = new Module(-1);
        Service service = module.findServiceByName("BROKER");
        try {
            broker = (BrokerInterface)service.getServiceObject(BrokerInterface.class);
            return broker;
        }
        catch (SBWServiceNotFoundException sBWServiceNotFoundException) {
            SBWLog.error("Unable to find \"BROKER\" service on Broker", sBWServiceNotFoundException);
            return null;
        }
        catch (SBWMethodNotFoundException sBWMethodNotFoundException) {
            SBWLog.error("Internal Broker interface definition mismatch", sBWMethodNotFoundException);
            return null;
        }
        catch (SBWUnsupportedObjectTypeException sBWUnsupportedObjectTypeException) {
            SBWLog.error("Unexpected exception", sBWUnsupportedObjectTypeException);
            return null;
        }
    }

    static String[] getServiceNamesFromModule(int n) throws SBWCommunicationException {
        SBWLog.trace("Querying module " + n + " about its services");
        DataBlockWriter dataBlockWriter = new DataBlockWriter();
        try {
            DataBlockReader dataBlockReader = rpc.call(n, -1, 0, dataBlockWriter);
            String[] stringArray = dataBlockReader.get1DStringArray();
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        catch (SBWException sBWException) {
            String string = "Unable to get services list from module " + n;
            SBWLog.trace(string);
            throw new SBWCommunicationException(sBWException.getMessage(), sBWException.getDetailedMessage());
        }
        finally {
            dataBlockWriter.release();
        }
    }

    static String[] getSignatureStringsFromModule(int n, int n2) throws SBWCommunicationException {
        SBWLog.trace("Querying module " + n + " about methods for service " + n2);
        DataBlockWriter dataBlockWriter = new DataBlockWriter();
        try {
            dataBlockWriter.add(n2);
            DataBlockReader dataBlockReader = rpc.call(n, -1, 1, dataBlockWriter);
            String[] stringArray = dataBlockReader.get1DStringArray();
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        catch (SBWException sBWException) {
            String string = "Unable to get methods list from module " + n + " for service id " + n2;
            SBWLog.trace(string, sBWException);
            throw new SBWCommunicationException(string, sBWException.getDetailedMessage());
        }
        finally {
            dataBlockWriter.release();
        }
    }

    static String normalizeCategoryName(String string) {
        if (StringUtil.empty(string)) {
            return "/";
        }
        if ((string = string.trim()).equals("")) {
            return "/";
        }
        try {
            String string2 = "";
            int n = 0;
            int n2 = 0;
            if (string.indexOf(47) == 0) {
                n = 1;
            }
            while ((n2 = string.indexOf(47, n)) >= 0) {
                String string3 = string.substring(n, n2).trim();
                string2 = string2 + "/" + string3;
                n = n2 + 1;
            }
            n2 = string.length();
            string2 = string2 + "/" + string.substring(n, n2).trim();
            return string2;
        }
        catch (Exception exception) {
            return string;
        }
    }

    static SBWLowLevelInternal getInternalAPI() {
        return rpc;
    }

    static void setInternalAPI(SBWLowLevelInternal sBWLowLevelInternal) {
        rpc = sBWLowLevelInternal;
    }

    private static final void checkConnected() throws SBWCommunicationException {
        if (!rpc.isConnected()) {
            throw new SBWCommunicationException("Not connected to SBW Broker", "This module is not currently connected to the SBW Broker. Either SBW.connect() has not been invoked or a communications problem occurred.");
        }
        if (broker == null) {
            SBW.getBrokerService();
        }
    }

    static {
        Config.recordClassVersion(SBW.class, "$Id: SBW.java,v 1.3 2007/07/24 23:08:19 fbergmann Exp $");
    }
}

