/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.Config;
import edu.caltech.sbw.SBWLog;
import edu.caltech.sbw.StringUtil;
import edu.caltech.sbw.Sys;
import edu.caltech.sbw.VerifiableFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

class RuntimeProperties {
    static final File propertiesFile = RuntimeProperties.getPropertiesFile();
    private static final Properties properties = new Properties();
    private static final RuntimeProperties singleton = new RuntimeProperties();

    private RuntimeProperties() {
        this.reload();
    }

    static RuntimeProperties getRuntimeProperties() {
        return singleton;
    }

    void setProperty(String string, int n) {
        properties.setProperty(string, Integer.toString(n));
    }

    void setProperty(String string, String string2) {
        if (string2 != null) {
            properties.setProperty(string, string2);
        } else {
            SBWLog.trace("Property '" + string + "' value is null; ignoring");
        }
    }

    void setProperty(String string, File file) {
        if (file != null) {
            properties.setProperty(string, file.getPath());
        } else {
            SBWLog.trace("Property '" + string + "' value is null; ignoring");
        }
    }

    boolean hasValue(String string) {
        String string2 = properties.getProperty(string);
        return !StringUtil.empty(string2);
    }

    Integer getPropertyAsInteger(String string) {
        String string2 = properties.getProperty(string);
        if (!StringUtil.empty(string2)) {
            try {
                return new Integer(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                SBWLog.warning("Property value of " + string + " is not an int");
            }
        }
        return null;
    }

    String getPropertyAsString(String string) {
        return properties.getProperty(string);
    }

    File getPropertyAsFile(String string) {
        String string2 = properties.getProperty(string);
        if (!StringUtil.empty(string2)) {
            return new File(string2);
        }
        return null;
    }

    void removeProperty(String string) {
        properties.setProperty(string, "");
    }

    void save() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(propertiesFile);
            properties.store(fileOutputStream, "Runtime properties");
            SBWLog.trace("Wrote runtime property file " + propertiesFile.getPath());
        }
        catch (IOException iOException) {
            SBWLog.warning("Unable to save runtime property file " + propertiesFile.getPath());
        }
        catch (ClassCastException classCastException) {
            SBWLog.error("Internal error: bad value in property", classCastException);
        }
    }

    void reload() {
        try {
            FileInputStream fileInputStream = new FileInputStream(propertiesFile);
            properties.load(fileInputStream);
            SBWLog.trace("Read runtime properties from " + propertiesFile.getPath());
        }
        catch (FileNotFoundException fileNotFoundException) {
            SBWLog.notice("Runtime properties file '" + propertiesFile.getPath() + "' does not exist.");
        }
        catch (IOException iOException) {
            SBWLog.warning("I/O problem reading '" + propertiesFile.getPath());
        }
        catch (SecurityException securityException) {
            SBWLog.warning("Security manager prevents access to " + propertiesFile.getPath());
        }
    }

    private static VerifiableFile getPropertiesFile() {
        String string;
        VerifiableFile verifiableFile = Config.getRuntimeFilesDirectory();
        if (verifiableFile == null || !verifiableFile.exists()) {
            SBWLog.notice("Creating missing property files directory " + verifiableFile.getPath());
            if (!verifiableFile.mkdirs()) {
                SBWLog.warning("Runtime property file directory " + verifiableFile.getPath() + " cannot be created");
                return null;
            }
        }
        if (verifiableFile == null || !verifiableFile.isVerifiedDirectory()) {
            SBWLog.warning("Runtime property file directory " + verifiableFile.getPath() + " does not exist or is inaccessible");
            return null;
        }
        try {
            if (Sys.OSIsUnix()) {
                string = "/bin/chmod og-rwx " + verifiableFile.getPath();
                Runtime.getRuntime().exec(string);
            }
        }
        catch (IOException iOException) {
            SBWLog.trace("Unable to set permissions on " + verifiableFile.getPath());
        }
        string = "run.properties";
        return new VerifiableFile(verifiableFile, string);
    }

    static {
        Config.recordClassVersion(RuntimeProperties.class, "$Id: RuntimeProperties.java,v 1.2 2007/07/24 23:08:23 fbergmann Exp $");
    }
}

