/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.sbw;

import edu.caltech.sbw.Config;
import edu.caltech.sbw.DataBlockReader;
import edu.caltech.sbw.SBWApplicationException;
import edu.caltech.sbw.SBWBrokerStartException;
import edu.caltech.sbw.SBWCommunicationException;
import edu.caltech.sbw.SBWException;
import edu.caltech.sbw.SBWIncompatibleMethodSignatureException;
import edu.caltech.sbw.SBWIncorrectCategorySyntaxException;
import edu.caltech.sbw.SBWLog;
import edu.caltech.sbw.SBWMethodAmbiguousException;
import edu.caltech.sbw.SBWMethodNotFoundException;
import edu.caltech.sbw.SBWMethodTypeNotBlockTypeException;
import edu.caltech.sbw.SBWModuleDefinitionException;
import edu.caltech.sbw.SBWModuleIdSyntaxException;
import edu.caltech.sbw.SBWModuleNotFoundException;
import edu.caltech.sbw.SBWModuleStartException;
import edu.caltech.sbw.SBWRawException;
import edu.caltech.sbw.SBWServiceNotFoundException;
import edu.caltech.sbw.SBWSignatureSyntaxException;
import edu.caltech.sbw.SBWTypeMismatchException;
import edu.caltech.sbw.SBWUnsupportedObjectTypeException;

class RPCOutCall {
    private DataBlockReader reader;
    private boolean replyPending = false;
    private int moduleId;
    private int event;
    private static final int NORMAL_REPLY_EVENT = 0;
    private static final int NORMAL_EXCEPTION_EVENT = 1;
    private static final int BROKER_DISCONNECT_EVENT = 2;
    private static final int MODULE_DISCONNECT_EVENT = 3;

    RPCOutCall() {
    }

    public synchronized DataBlockReader waitForReply(int n) throws SBWException {
        this.moduleId = n;
        try {
            if (!this.replyPending) {
                SBWLog.trace("Waiting for reply");
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            SBWLog.exception("Wait interrupted", interruptedException);
        }
        SBWLog.trace("Processing reply event");
        switch (this.event) {
            case 0: {
                SBWLog.trace("Received NORMAL_REPLY_EVENT");
                return this.reader;
            }
            case 2: {
                SBWLog.trace("Received BROKER_DISCONNECT_EVENT");
                throw new SBWCommunicationException("Broker disconnected", "The connection to the SBW Broker has been lost.  This may have been the result of a communications breakdown or the Broker may have been deliberately shut down.  No further communications will be possible unless a new connection is initiated and established.");
            }
            case 3: {
                SBWLog.trace("Received MODULE_DISCONNECT_EVENT");
                throw new SBWCommunicationException("Implementation module disconnected", "module id " + n);
            }
            case 1: {
                SBWLog.trace("Received NORMAL_EXCEPTION_EVENT");
                byte by = this.reader.unpackByteWithoutType();
                String string = this.reader.getString();
                String string2 = this.reader.getString();
                switch (by) {
                    case 0: {
                        SBWLog.trace("Exception code = SBWApplicationException");
                        throw new SBWApplicationException(string, string2);
                    }
                    case 1: {
                        SBWLog.trace("Exception code = SBWRawException");
                        throw new SBWRawException(string, string2);
                    }
                    case 2: {
                        SBWLog.trace("Exception code = SBWCommunicationException");
                        throw new SBWCommunicationException(string, string2);
                    }
                    case 3: {
                        SBWLog.trace("Exception code = SBWModuleStartException");
                        throw new SBWModuleStartException(string, string2);
                    }
                    case 5: {
                        SBWLog.trace("Exception code = SBWIncompatibleMethodSignatureException");
                        throw new SBWIncompatibleMethodSignatureException(string, string2);
                    }
                    case 4: {
                        SBWLog.trace("Exception code = SBWTypeMismatchException");
                        throw new SBWTypeMismatchException(string, string2);
                    }
                    case 6: {
                        SBWLog.trace("Exception code = SBWModuleIdSyntaxException");
                        throw new SBWModuleIdSyntaxException(string, string2);
                    }
                    case 7: {
                        SBWLog.trace("Exception code = SBWIncorrectCategorySyntaxException");
                        throw new SBWIncorrectCategorySyntaxException(string, string2);
                    }
                    case 9: {
                        SBWLog.trace("Exception code = SBWServiceNotFoundException");
                        throw new SBWServiceNotFoundException(string, string2);
                    }
                    case 10: {
                        SBWLog.trace("Exception code = SBWMethodTypeNotBlockTypeException");
                        throw new SBWMethodTypeNotBlockTypeException(string, string2);
                    }
                    case 11: {
                        SBWLog.trace("Exception code = SBWMethodAmbiguousException");
                        throw new SBWMethodAmbiguousException(string, string2);
                    }
                    case 12: {
                        SBWLog.trace("Exception code = SBWUnsupportedObjectTypeException");
                        throw new SBWUnsupportedObjectTypeException(string, string2);
                    }
                    case 13: {
                        SBWLog.trace("Exception code = SBWMethodNotFoundException");
                        throw new SBWMethodNotFoundException(string, string2);
                    }
                    case 14: {
                        SBWLog.trace("Exception code = SBWSignatureSyntaxException");
                        throw new SBWSignatureSyntaxException(string, string2);
                    }
                    case 15: {
                        SBWLog.trace("Exception code = SBWModuleDefinitionException");
                        throw new SBWModuleDefinitionException(string, string2);
                    }
                    case 16: {
                        SBWLog.trace("Exception code = SBWModuleNotFoundException");
                        throw new SBWModuleNotFoundException(string, string2);
                    }
                    case 17: {
                        SBWLog.trace("Exception code = SBWBrokerStartException");
                        throw new SBWBrokerStartException(string, string2);
                    }
                }
                String string3 = "Unknown exception code " + by + ", msg = " + string;
                SBWLog.error(string3 + "\ndetailed msg = " + string2);
                throw new SBWRawException(string3, string2);
            }
        }
        SBWLog.error("Unknown event type " + this.event);
        throw new SBWCommunicationException("Unknown event type in RPCOutCall", "");
    }

    private synchronized void onEvent(int n) {
        this.event = n;
        this.replyPending = true;
        this.notifyAll();
    }

    public void processReply(DataBlockReader dataBlockReader, boolean bl) {
        this.reader = dataBlockReader;
        this.onEvent(bl ? 1 : 0);
    }

    public void onBrokerDisconnection() {
        SBWLog.trace("Lost connection to broker");
        this.onEvent(2);
    }

    public void onOtherModuleInstanceShutdown(int n) {
        SBWLog.trace("Module " + this.moduleId + " notified that module " + n + " is shutting down");
        if (this.moduleId == n) {
            this.onEvent(3);
        }
    }

    static {
        Config.recordClassVersion(RPCOutCall.class, "$Id: RPCOutCall.java,v 1.2 2007/07/24 23:08:21 fbergmann Exp $");
    }
}

